<?php
// If it's going to need the database, then it's 
// probably smart to require it before we start.
require_once('database.php');

class accountschoolFees {
	
	protected static $table_name="acc_school_fees_payments";
	protected static $db_fields = array('discount', 'balance', 'student_id', 'item_name', 'bank_name', 'mop', 'trans_id', 'outstand','teller_no', 'class_name', 'have_paid','sess_id', 'term_id', 'expected_to_pay','recieved_by', 'paid_on', 'status', 'payment_type');
	public $id;
	public $student_id;
	public $item_name;
	public $bank_name;
	public $teller_no;
	public $class_name;
	public $have_paid;
	public $sess_id;
	public $term_id;
	public $discount;
	public $expected_to_pay;
	public $balance;
	public $paid_on;
	public $recieved_by;
	public $status;
	public $mop; // mode of payment
	public $trans_id;
	public $payment_type;
	
	
 

	// Common Database Methods
		public static function find_all($sess_id, $term_id) {
		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE `sess_id`= '{$sess_id}' AND `term_id`='{$term_id}' AND `status`=1 "); // 1 is old student
  }
  public static function find_all_new($sess_id, $term_id) {
		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE `sess_id`= '{$sess_id}' AND `term_id`='{$term_id}' AND `status`=0"); // 0 is new student
  } 

  
  public static function find_by_id($id=0) {
    $result_array = self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE id={$id} LIMIT 1");
		return !empty($result_array) ? array_shift($result_array) : false;
  }
  
  public static function find_by_sql($sql="") {
    global $database;
    $result_set = $database->query($sql);
    $object_array = array();
    while ($row = $database->fetch_array($result_set)) {
      $object_array[] = self::instantiate($row);
    }
    return $object_array;
  }
 public static function find_student_type($type='') {
 	global $database;
		if($type=='=0'){return 'New students';} if($type=='=1'){ return 'Old students';} if($type=='BETWEEN 0 AND 1'){ return 'Old & New students';}
	 }
public static function find_student_total_fees($sess_id, $term_id, $student_id) {
	 global $database;
		$total_fees = $database->query("SELECT SUM(`have_paid`) AS amount_paid FROM ".self::$table_name." WHERE `sess_id`= '{$sess_id}' AND `term_id`='{$term_id}' AND `student_id`='{$student_id}'");
		$total_fees=$database->fetch_array($total_fees);
		$total_fees=$total_fees['amount_paid'];

		//  discounts on students are usually added to students wallets
		
  }
public static function find_student_total_fees_no_balance($sess_id, $term_id, $student_id,$trans_id, $payment_type) {
	 global $database;
		$total_fees = $database->query("SELECT SUM(`have_paid`) AS amount_paid FROM ".self::$table_name." WHERE `sess_id`= '{$sess_id}' AND `term_id`='{$term_id}' AND `student_id`='{$student_id}' AND `payment_type`='{$payment_type}' AND `trans_id`='{$trans_id}'");
		$total_fees=$database->fetch_array($total_fees);
		return $total_fees=$total_fees['amount_paid'];
  }



  
  public static function find_student_total_balance($sess_id, $term_id, $student_id, $trans_id,
  	$payment_type) {
	 global $database;
		$sql = $database->query("SELECT SUM(`balance`) AS balance FROM ".self::$table_name." WHERE `sess_id`= '{$sess_id}' AND `term_id`='{$term_id}' AND `student_id`='{$student_id}' AND `payment_type`='{$payment_type}' AND `trans_id`='{$trans_id}'");
		$balance=$database->fetch_array($sql);
		
		$sql=$database->query("SELECT `discount` FROM `acc_school_fees_payments` WHERE `sess_id`= '{$sess_id}' AND `term_id`='{$term_id}' 
        AND `student_id`='{$student_id}' AND `payment_type`='{$payment_type}' AND `trans_id`='{$trans_id}'");
	$discount=$database->fetch_array($sql); 
if(($balance['balance'] - 	$discount['discount']) < 0){	 return 0;
  }else { 
      return $balance['balance'] - $discount['discount'];
  }
  
}


public static function find_student_total_balance_for_wallet($sess_id, $term_id, $student_id, $trans_id) {
	 global $database;
		$sql = $database->query("SELECT SUM(`balance`) AS balance FROM ".self::$table_name." WHERE `sess_id`= '{$sess_id}' AND `term_id`='{$term_id}' AND `student_id`='{$student_id}' AND `payment_type`=1 AND `trans_id`='{$trans_id}'");
		$balance=$database->fetch_array($sql);
		
		$sql=$database->query("SELECT SUM(DISTINCT `discount`) AS `discount`  FROM ".self::$table_name." WHERE `sess_id`= '{$sess_id}' AND `term_id`='{$term_id}' 
        AND `student_id`='{$student_id}' AND `payment_type`=1");
	$discount=$database->fetch_array($sql); 
      return $balance['balance'] - $discount['discount'];
  }
  




  public static function find_student_total_balance_cummulative($student_id) { // walleting solved this
	 global $database;
		$sql = $database->query("SELECT SUM(`balance`) AS balance FROM ".self::$table_name." WHERE  `student_id`='{$student_id}'  AND  `payment_type` = 1");
		$balance=$database->fetch_array($sql);
		return  format_currency($balance['balance']);		
  }








  public static function find_fees_by_discount($sess_id, $term_id, $class) {
  	global $database;
		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE `sess_id`= '{$sess_id}' AND `term_id`='{$term_id}' AND class_name='{$class}' AND `discount`!=0");
  }
  
  public static function find_student_fees_details($s_id, $sess_id, $term_id) {
  	global $database;
		return self::find_by_sql("SELECT *  FROM ".self::$table_name." WHERE  `student_id`='{$s_id}'  AND `sess_id`='{$sess_id}' AND `term_id`='{$term_id}'");
  }
  
  public static function find_student_fees_by_sess_and_term($s_id) {
  	global $database;
		return self::find_by_sql("SELECT `term_id`, `sess_id` FROM ".self::$table_name." WHERE  `student_id`='{$s_id}'  GROUP BY `term_id`, `sess_id` ");
  }
  
 

   public static function find_fees_all_by_class_and_type($sess_id, $term_id, $class, $type) {
   	global $database;
      if($type=='=0'){
		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE  `sess_id`='{$sess_id}' AND  `term_id`='{$term_id}' AND  `class_name` = '{$class}' AND status=0 GROUP BY `student_id` ");
          
      }
            if($type=='=1'){
		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE  `sess_id`='{$sess_id}' AND  `term_id`='{$term_id}' AND  `class_name` = '{$class}' AND status=1 GROUP BY `student_id`");
          
            }
      if($type=='BETWEEN 0 AND 1'){
		return self::find_by_sql("SELECT id FROM ".self::$table_name."  WHERE `status` BETWEEN 0 AND 1 AND `sess_id`='{$sess_id}' AND  `term_id`='{$term_id}' AND  `class_name` = '{$class}' GROUP BY `student_id`");
          
      }
  }
  
   public static function find_student_count_by_class_and_type($sess_id, $term_id, $class, $type) {
   	global $database;
      if($type=='=0'){
			$sql=$database->num_rows($database->query("SELECT `student_id` FROM ".self::$table_name." WHERE  `sess_id`='{$sess_id}' AND  `term_id`='{$term_id}' AND  `class_name` = '{$class}' AND status=0 GROUP BY `student_id` "));
			return $sql;
          
      }
            if($type=='=1'){
			$sql=$database->num_rows($database->query("SELECT `student_id` FROM ".self::$table_name." WHERE  `sess_id`='{$sess_id}' AND  `term_id`='{$term_id}' AND  `class_name` = '{$class}' AND status=1  GROUP BY `student_id`"));
			return $sql;
            }
            
       if($type=='BETWEEN 0 AND 1'){
			$sql=$database->num_rows($database->query("SELECT `student_id` FROM ".self::$table_name."  WHERE `status` BETWEEN 0 AND 1 AND `sess_id`='{$sess_id}' AND  `term_id`='{$term_id}' AND  `class_name` = '{$class}' GROUP BY `student_id`"));
			return $sql;
          
      }
  }
  

   public static function find_fees_all_daily($sess_id, $term_id, $type) {
     $date=date("Y-m-d");
       
		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE `term_id`='{$term_id}' AND `sess_id`='{$sess_id}' AND `date`=$date AND status=$type");
  }
  
  public static function find_fees_all_by_date_range($from, $to) {
		return self::find_by_sql("SELECT * FROM ".self::$table_name." WHERE  `date` BETWEEN '$from' AND '$to'");
  }
  
   
   public static function find_total_school_fees_per_term($sess_id, $term_id, $class, $type) {
   	global $database;
         if($type=='=0'){
       
			$sql=$database->fetch_array($database->query("SELECT sum(have_paid) AS amount FROM ".self::$table_name ."  WHERE  `sess_id`='{$sess_id}' AND  `term_id`='{$term_id}' AND  `class_name` = '{$class}' AND status=0  AND  `payment_type` = 1"));
			return $sql['amount'];
         }
         if($type=='=1'){
       
			$sql=$database->fetch_array($database->query("SELECT sum(have_paid) AS amount FROM ".self::$table_name ."  WHERE  `sess_id`='{$sess_id}' AND  `term_id`='{$term_id}' AND  `class_name` = '{$class}' AND status=1  AND  `payment_type` = 1"));
		return $sql['amount'];
         }
         if($type=='BETWEEN 0 AND 1'){
       
			$sql=$database->fetch_array($database->query("SELECT sum(have_paid) AS amount FROM ".self::$table_name ."  WHERE `status` BETWEEN 0 AND 1 AND `sess_id`='{$sess_id}' AND  `term_id`='{$term_id}' AND  `class_name` = '{$class}'  AND  `payment_type` = 1"));
		return $sql['amount'];
         }
    }
	   
	    public static function find_status($type='') {
		if($type==0){return 'New students';} if($type==1){ return 'Old students';} if($type==2){ return 'Old & New students';}
	 }
	   
	   
    public static function find_total_number_of_payments($sess_id, $term_id) {
			$sql=$database->num_rows($database->query("SELECT `id` FROM ".self::$table_name ." WHERE `term_id`='{$term_id}' AND `sess_id`= '{$sess_id}' "));
			return $sql;
	 }


 
	private static function instantiate($record) {
		// Could check that $record exists and is an array
    $object = new self;
		// Simple, long-form approach:
		// $object->id 				= $record['id'];
		// $object->username 	= $record['username'];
		// $object->password 	= $record['password'];
		// $object->first_name = $record['first_name'];
		// $object->last_name 	= $record['last_name'];
		
		// More dynamic, short-form approach:
		foreach($record as $attribute=>$value){
		  
		    $object->$attribute = $value;
		  
		}
		return $object;
	}
	
	

	protected function attributes() { 
		// return an array of attribute names and their values
	  $attributes = array();
	  foreach(self::$db_fields as $field) {
	    
	      $attributes[$field] = $this->$field;
	    
	  }
	  return $attributes;
	}
	
	protected function sanitized_attributes() {
	  global $database;
	  $clean_attributes = array();
	  // sanitize the values before submitting
	  // Note: does not alter the actual value of each attribute
	  foreach($this->attributes() as $key => $value){
	    $clean_attributes[$key] = $database->escape_value($value);
	  }
	  return $clean_attributes;
	}
	
	public function save() {
	  // A new record won't have an id yet.
	  return isset($this->id) ? $this->update() : $this->create();
	}
	
	public function create() {
		global $database;
	
		$attributes = $this->sanitized_attributes();
	  $sql = "INSERT INTO ".self::$table_name." (";
		$sql .= join(", ", array_keys($attributes));
	  $sql .= ") VALUES ('";
		$sql .= join("', '", array_values($attributes));
		$sql .= "')";
	  if($database->query($sql)) {
	    $this->id = $database->insert_id();
	    return true;
	  } else {
	    return false;
	  }
	}

	public function update() {
	  global $database;
		$attributes = $this->sanitized_attributes();
		$attribute_pairs = array();
		foreach($attributes as $key => $value) {
		  $attribute_pairs[] = "{$key}='{$value}'";
		}
		$sql = "UPDATE ".self::$table_name." SET ";
		$sql .= join(", ", $attribute_pairs);
		$sql .= " WHERE sec_id=". $database->escape_value($this->sec_id);
	  $database->query($sql);
	  return ($database->affected_rows() == 1) ? true : false;
	}

	public function delete() {
		global $database;
	  $sql = "DELETE FROM ".self::$table_name;
	  $sql .= " WHERE id=". $database->escape_value($this->id);
	  $sql .= " LIMIT 1";
	  $database->query($sql);
	  return ($database->affected_rows() == 1) ? true : false;
	}

}

?>