!function(e,n){if("object"==typeof exports&&"object"==typeof module)module.exports=n();else if("function"==typeof define&&define.amd)define([],n);else{var t=n();for(var r in t)("object"==typeof exports?exports:e)[r]=t[r]}}(self,(function(){return function(){var __webpack_modules__={"./libs/quill/quill.js":function(__unused_webpack_module,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Quill: function() { return /* reexport safe */ quill__WEBPACK_IMPORTED_MODULE_0__["default"]; }\n/* harmony export */ });\n/* harmony import */ var quill__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill */ "./node_modules/quill/quill.js");\n\ntry {\n  window.Quill = quill__WEBPACK_IMPORTED_MODULE_0__["default"];\n} catch (e) {}\n\n\n//# sourceURL=webpack://Vuexy/./libs/quill/quill.js?')},"./node_modules/eventemitter3/index.js":function(module){"use strict";eval("\n\nvar has = Object.prototype.hasOwnProperty\n  , prefix = '~';\n\n/**\n * Constructor to create a storage for our `EE` objects.\n * An `Events` instance is a plain object whose properties are event names.\n *\n * @constructor\n * @private\n */\nfunction Events() {}\n\n//\n// We try to not inherit from `Object.prototype`. In some engines creating an\n// instance in this way is faster than calling `Object.create(null)` directly.\n// If `Object.create(null)` is not supported we prefix the event names with a\n// character to make sure that the built-in object properties are not\n// overridden or used as an attack vector.\n//\nif (Object.create) {\n  Events.prototype = Object.create(null);\n\n  //\n  // This hack is needed because the `__proto__` property is still inherited in\n  // some old browsers like Android 4, iPhone 5.1, Opera 11 and Safari 5.\n  //\n  if (!new Events().__proto__) prefix = false;\n}\n\n/**\n * Representation of a single event listener.\n *\n * @param {Function} fn The listener function.\n * @param {*} context The context to invoke the listener with.\n * @param {Boolean} [once=false] Specify if the listener is a one-time listener.\n * @constructor\n * @private\n */\nfunction EE(fn, context, once) {\n  this.fn = fn;\n  this.context = context;\n  this.once = once || false;\n}\n\n/**\n * Add a listener for a given event.\n *\n * @param {EventEmitter} emitter Reference to the `EventEmitter` instance.\n * @param {(String|Symbol)} event The event name.\n * @param {Function} fn The listener function.\n * @param {*} context The context to invoke the listener with.\n * @param {Boolean} once Specify if the listener is a one-time listener.\n * @returns {EventEmitter}\n * @private\n */\nfunction addListener(emitter, event, fn, context, once) {\n  if (typeof fn !== 'function') {\n    throw new TypeError('The listener must be a function');\n  }\n\n  var listener = new EE(fn, context || emitter, once)\n    , evt = prefix ? prefix + event : event;\n\n  if (!emitter._events[evt]) emitter._events[evt] = listener, emitter._eventsCount++;\n  else if (!emitter._events[evt].fn) emitter._events[evt].push(listener);\n  else emitter._events[evt] = [emitter._events[evt], listener];\n\n  return emitter;\n}\n\n/**\n * Clear event by name.\n *\n * @param {EventEmitter} emitter Reference to the `EventEmitter` instance.\n * @param {(String|Symbol)} evt The Event name.\n * @private\n */\nfunction clearEvent(emitter, evt) {\n  if (--emitter._eventsCount === 0) emitter._events = new Events();\n  else delete emitter._events[evt];\n}\n\n/**\n * Minimal `EventEmitter` interface that is molded against the Node.js\n * `EventEmitter` interface.\n *\n * @constructor\n * @public\n */\nfunction EventEmitter() {\n  this._events = new Events();\n  this._eventsCount = 0;\n}\n\n/**\n * Return an array listing the events for which the emitter has registered\n * listeners.\n *\n * @returns {Array}\n * @public\n */\nEventEmitter.prototype.eventNames = function eventNames() {\n  var names = []\n    , events\n    , name;\n\n  if (this._eventsCount === 0) return names;\n\n  for (name in (events = this._events)) {\n    if (has.call(events, name)) names.push(prefix ? name.slice(1) : name);\n  }\n\n  if (Object.getOwnPropertySymbols) {\n    return names.concat(Object.getOwnPropertySymbols(events));\n  }\n\n  return names;\n};\n\n/**\n * Return the listeners registered for a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @returns {Array} The registered listeners.\n * @public\n */\nEventEmitter.prototype.listeners = function listeners(event) {\n  var evt = prefix ? prefix + event : event\n    , handlers = this._events[evt];\n\n  if (!handlers) return [];\n  if (handlers.fn) return [handlers.fn];\n\n  for (var i = 0, l = handlers.length, ee = new Array(l); i < l; i++) {\n    ee[i] = handlers[i].fn;\n  }\n\n  return ee;\n};\n\n/**\n * Return the number of listeners listening to a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @returns {Number} The number of listeners.\n * @public\n */\nEventEmitter.prototype.listenerCount = function listenerCount(event) {\n  var evt = prefix ? prefix + event : event\n    , listeners = this._events[evt];\n\n  if (!listeners) return 0;\n  if (listeners.fn) return 1;\n  return listeners.length;\n};\n\n/**\n * Calls each of the listeners registered for a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @returns {Boolean} `true` if the event had listeners, else `false`.\n * @public\n */\nEventEmitter.prototype.emit = function emit(event, a1, a2, a3, a4, a5) {\n  var evt = prefix ? prefix + event : event;\n\n  if (!this._events[evt]) return false;\n\n  var listeners = this._events[evt]\n    , len = arguments.length\n    , args\n    , i;\n\n  if (listeners.fn) {\n    if (listeners.once) this.removeListener(event, listeners.fn, undefined, true);\n\n    switch (len) {\n      case 1: return listeners.fn.call(listeners.context), true;\n      case 2: return listeners.fn.call(listeners.context, a1), true;\n      case 3: return listeners.fn.call(listeners.context, a1, a2), true;\n      case 4: return listeners.fn.call(listeners.context, a1, a2, a3), true;\n      case 5: return listeners.fn.call(listeners.context, a1, a2, a3, a4), true;\n      case 6: return listeners.fn.call(listeners.context, a1, a2, a3, a4, a5), true;\n    }\n\n    for (i = 1, args = new Array(len -1); i < len; i++) {\n      args[i - 1] = arguments[i];\n    }\n\n    listeners.fn.apply(listeners.context, args);\n  } else {\n    var length = listeners.length\n      , j;\n\n    for (i = 0; i < length; i++) {\n      if (listeners[i].once) this.removeListener(event, listeners[i].fn, undefined, true);\n\n      switch (len) {\n        case 1: listeners[i].fn.call(listeners[i].context); break;\n        case 2: listeners[i].fn.call(listeners[i].context, a1); break;\n        case 3: listeners[i].fn.call(listeners[i].context, a1, a2); break;\n        case 4: listeners[i].fn.call(listeners[i].context, a1, a2, a3); break;\n        default:\n          if (!args) for (j = 1, args = new Array(len -1); j < len; j++) {\n            args[j - 1] = arguments[j];\n          }\n\n          listeners[i].fn.apply(listeners[i].context, args);\n      }\n    }\n  }\n\n  return true;\n};\n\n/**\n * Add a listener for a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @param {Function} fn The listener function.\n * @param {*} [context=this] The context to invoke the listener with.\n * @returns {EventEmitter} `this`.\n * @public\n */\nEventEmitter.prototype.on = function on(event, fn, context) {\n  return addListener(this, event, fn, context, false);\n};\n\n/**\n * Add a one-time listener for a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @param {Function} fn The listener function.\n * @param {*} [context=this] The context to invoke the listener with.\n * @returns {EventEmitter} `this`.\n * @public\n */\nEventEmitter.prototype.once = function once(event, fn, context) {\n  return addListener(this, event, fn, context, true);\n};\n\n/**\n * Remove the listeners of a given event.\n *\n * @param {(String|Symbol)} event The event name.\n * @param {Function} fn Only remove the listeners that match this function.\n * @param {*} context Only remove the listeners that have this context.\n * @param {Boolean} once Only remove one-time listeners.\n * @returns {EventEmitter} `this`.\n * @public\n */\nEventEmitter.prototype.removeListener = function removeListener(event, fn, context, once) {\n  var evt = prefix ? prefix + event : event;\n\n  if (!this._events[evt]) return this;\n  if (!fn) {\n    clearEvent(this, evt);\n    return this;\n  }\n\n  var listeners = this._events[evt];\n\n  if (listeners.fn) {\n    if (\n      listeners.fn === fn &&\n      (!once || listeners.once) &&\n      (!context || listeners.context === context)\n    ) {\n      clearEvent(this, evt);\n    }\n  } else {\n    for (var i = 0, events = [], length = listeners.length; i < length; i++) {\n      if (\n        listeners[i].fn !== fn ||\n        (once && !listeners[i].once) ||\n        (context && listeners[i].context !== context)\n      ) {\n        events.push(listeners[i]);\n      }\n    }\n\n    //\n    // Reset the array, or remove it completely if we have no more listeners.\n    //\n    if (events.length) this._events[evt] = events.length === 1 ? events[0] : events;\n    else clearEvent(this, evt);\n  }\n\n  return this;\n};\n\n/**\n * Remove all listeners, or those of the specified event.\n *\n * @param {(String|Symbol)} [event] The event name.\n * @returns {EventEmitter} `this`.\n * @public\n */\nEventEmitter.prototype.removeAllListeners = function removeAllListeners(event) {\n  var evt;\n\n  if (event) {\n    evt = prefix ? prefix + event : event;\n    if (this._events[evt]) clearEvent(this, evt);\n  } else {\n    this._events = new Events();\n    this._eventsCount = 0;\n  }\n\n  return this;\n};\n\n//\n// Alias methods names because people roll like that.\n//\nEventEmitter.prototype.off = EventEmitter.prototype.removeListener;\nEventEmitter.prototype.addListener = EventEmitter.prototype.on;\n\n//\n// Expose the prefix.\n//\nEventEmitter.prefixed = prefix;\n\n//\n// Allow `EventEmitter` to be imported as module namespace.\n//\nEventEmitter.EventEmitter = EventEmitter;\n\n//\n// Expose the module.\n//\nif (true) {\n  module.exports = EventEmitter;\n}\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/eventemitter3/index.js?")},"./node_modules/fast-diff/diff.js":function(module){eval("/**\n * This library modifies the diff-patch-match library by Neil Fraser\n * by removing the patch and match functionality and certain advanced\n * options in the diff function. The original license is as follows:\n *\n * ===\n *\n * Diff Match and Patch\n *\n * Copyright 2006 Google Inc.\n * http://code.google.com/p/google-diff-match-patch/\n *\n * Licensed under the Apache License, Version 2.0 (the \"License\");\n * you may not use this file except in compliance with the License.\n * You may obtain a copy of the License at\n *\n *   http://www.apache.org/licenses/LICENSE-2.0\n *\n * Unless required by applicable law or agreed to in writing, software\n * distributed under the License is distributed on an \"AS IS\" BASIS,\n * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n * See the License for the specific language governing permissions and\n * limitations under the License.\n */\n\n/**\n * The data structure representing a diff is an array of tuples:\n * [[DIFF_DELETE, 'Hello'], [DIFF_INSERT, 'Goodbye'], [DIFF_EQUAL, ' world.']]\n * which means: delete 'Hello', add 'Goodbye' and keep ' world.'\n */\nvar DIFF_DELETE = -1;\nvar DIFF_INSERT = 1;\nvar DIFF_EQUAL = 0;\n\n/**\n * Find the differences between two texts.  Simplifies the problem by stripping\n * any common prefix or suffix off the texts before diffing.\n * @param {string} text1 Old string to be diffed.\n * @param {string} text2 New string to be diffed.\n * @param {Int|Object} [cursor_pos] Edit position in text1 or object with more info\n * @param {boolean} [cleanup] Apply semantic cleanup before returning.\n * @return {Array} Array of diff tuples.\n */\nfunction diff_main(text1, text2, cursor_pos, cleanup, _fix_unicode) {\n  // Check for equality\n  if (text1 === text2) {\n    if (text1) {\n      return [[DIFF_EQUAL, text1]];\n    }\n    return [];\n  }\n\n  if (cursor_pos != null) {\n    var editdiff = find_cursor_edit_diff(text1, text2, cursor_pos);\n    if (editdiff) {\n      return editdiff;\n    }\n  }\n\n  // Trim off common prefix (speedup).\n  var commonlength = diff_commonPrefix(text1, text2);\n  var commonprefix = text1.substring(0, commonlength);\n  text1 = text1.substring(commonlength);\n  text2 = text2.substring(commonlength);\n\n  // Trim off common suffix (speedup).\n  commonlength = diff_commonSuffix(text1, text2);\n  var commonsuffix = text1.substring(text1.length - commonlength);\n  text1 = text1.substring(0, text1.length - commonlength);\n  text2 = text2.substring(0, text2.length - commonlength);\n\n  // Compute the diff on the middle block.\n  var diffs = diff_compute_(text1, text2);\n\n  // Restore the prefix and suffix.\n  if (commonprefix) {\n    diffs.unshift([DIFF_EQUAL, commonprefix]);\n  }\n  if (commonsuffix) {\n    diffs.push([DIFF_EQUAL, commonsuffix]);\n  }\n  diff_cleanupMerge(diffs, _fix_unicode);\n  if (cleanup) {\n    diff_cleanupSemantic(diffs);\n  }\n  return diffs;\n}\n\n/**\n * Find the differences between two texts.  Assumes that the texts do not\n * have any common prefix or suffix.\n * @param {string} text1 Old string to be diffed.\n * @param {string} text2 New string to be diffed.\n * @return {Array} Array of diff tuples.\n */\nfunction diff_compute_(text1, text2) {\n  var diffs;\n\n  if (!text1) {\n    // Just add some text (speedup).\n    return [[DIFF_INSERT, text2]];\n  }\n\n  if (!text2) {\n    // Just delete some text (speedup).\n    return [[DIFF_DELETE, text1]];\n  }\n\n  var longtext = text1.length > text2.length ? text1 : text2;\n  var shorttext = text1.length > text2.length ? text2 : text1;\n  var i = longtext.indexOf(shorttext);\n  if (i !== -1) {\n    // Shorter text is inside the longer text (speedup).\n    diffs = [\n      [DIFF_INSERT, longtext.substring(0, i)],\n      [DIFF_EQUAL, shorttext],\n      [DIFF_INSERT, longtext.substring(i + shorttext.length)],\n    ];\n    // Swap insertions for deletions if diff is reversed.\n    if (text1.length > text2.length) {\n      diffs[0][0] = diffs[2][0] = DIFF_DELETE;\n    }\n    return diffs;\n  }\n\n  if (shorttext.length === 1) {\n    // Single character string.\n    // After the previous speedup, the character can't be an equality.\n    return [\n      [DIFF_DELETE, text1],\n      [DIFF_INSERT, text2],\n    ];\n  }\n\n  // Check to see if the problem can be split in two.\n  var hm = diff_halfMatch_(text1, text2);\n  if (hm) {\n    // A half-match was found, sort out the return data.\n    var text1_a = hm[0];\n    var text1_b = hm[1];\n    var text2_a = hm[2];\n    var text2_b = hm[3];\n    var mid_common = hm[4];\n    // Send both pairs off for separate processing.\n    var diffs_a = diff_main(text1_a, text2_a);\n    var diffs_b = diff_main(text1_b, text2_b);\n    // Merge the results.\n    return diffs_a.concat([[DIFF_EQUAL, mid_common]], diffs_b);\n  }\n\n  return diff_bisect_(text1, text2);\n}\n\n/**\n * Find the 'middle snake' of a diff, split the problem in two\n * and return the recursively constructed diff.\n * See Myers 1986 paper: An O(ND) Difference Algorithm and Its Variations.\n * @param {string} text1 Old string to be diffed.\n * @param {string} text2 New string to be diffed.\n * @return {Array} Array of diff tuples.\n * @private\n */\nfunction diff_bisect_(text1, text2) {\n  // Cache the text lengths to prevent multiple calls.\n  var text1_length = text1.length;\n  var text2_length = text2.length;\n  var max_d = Math.ceil((text1_length + text2_length) / 2);\n  var v_offset = max_d;\n  var v_length = 2 * max_d;\n  var v1 = new Array(v_length);\n  var v2 = new Array(v_length);\n  // Setting all elements to -1 is faster in Chrome & Firefox than mixing\n  // integers and undefined.\n  for (var x = 0; x < v_length; x++) {\n    v1[x] = -1;\n    v2[x] = -1;\n  }\n  v1[v_offset + 1] = 0;\n  v2[v_offset + 1] = 0;\n  var delta = text1_length - text2_length;\n  // If the total number of characters is odd, then the front path will collide\n  // with the reverse path.\n  var front = delta % 2 !== 0;\n  // Offsets for start and end of k loop.\n  // Prevents mapping of space beyond the grid.\n  var k1start = 0;\n  var k1end = 0;\n  var k2start = 0;\n  var k2end = 0;\n  for (var d = 0; d < max_d; d++) {\n    // Walk the front path one step.\n    for (var k1 = -d + k1start; k1 <= d - k1end; k1 += 2) {\n      var k1_offset = v_offset + k1;\n      var x1;\n      if (k1 === -d || (k1 !== d && v1[k1_offset - 1] < v1[k1_offset + 1])) {\n        x1 = v1[k1_offset + 1];\n      } else {\n        x1 = v1[k1_offset - 1] + 1;\n      }\n      var y1 = x1 - k1;\n      while (\n        x1 < text1_length &&\n        y1 < text2_length &&\n        text1.charAt(x1) === text2.charAt(y1)\n      ) {\n        x1++;\n        y1++;\n      }\n      v1[k1_offset] = x1;\n      if (x1 > text1_length) {\n        // Ran off the right of the graph.\n        k1end += 2;\n      } else if (y1 > text2_length) {\n        // Ran off the bottom of the graph.\n        k1start += 2;\n      } else if (front) {\n        var k2_offset = v_offset + delta - k1;\n        if (k2_offset >= 0 && k2_offset < v_length && v2[k2_offset] !== -1) {\n          // Mirror x2 onto top-left coordinate system.\n          var x2 = text1_length - v2[k2_offset];\n          if (x1 >= x2) {\n            // Overlap detected.\n            return diff_bisectSplit_(text1, text2, x1, y1);\n          }\n        }\n      }\n    }\n\n    // Walk the reverse path one step.\n    for (var k2 = -d + k2start; k2 <= d - k2end; k2 += 2) {\n      var k2_offset = v_offset + k2;\n      var x2;\n      if (k2 === -d || (k2 !== d && v2[k2_offset - 1] < v2[k2_offset + 1])) {\n        x2 = v2[k2_offset + 1];\n      } else {\n        x2 = v2[k2_offset - 1] + 1;\n      }\n      var y2 = x2 - k2;\n      while (\n        x2 < text1_length &&\n        y2 < text2_length &&\n        text1.charAt(text1_length - x2 - 1) ===\n          text2.charAt(text2_length - y2 - 1)\n      ) {\n        x2++;\n        y2++;\n      }\n      v2[k2_offset] = x2;\n      if (x2 > text1_length) {\n        // Ran off the left of the graph.\n        k2end += 2;\n      } else if (y2 > text2_length) {\n        // Ran off the top of the graph.\n        k2start += 2;\n      } else if (!front) {\n        var k1_offset = v_offset + delta - k2;\n        if (k1_offset >= 0 && k1_offset < v_length && v1[k1_offset] !== -1) {\n          var x1 = v1[k1_offset];\n          var y1 = v_offset + x1 - k1_offset;\n          // Mirror x2 onto top-left coordinate system.\n          x2 = text1_length - x2;\n          if (x1 >= x2) {\n            // Overlap detected.\n            return diff_bisectSplit_(text1, text2, x1, y1);\n          }\n        }\n      }\n    }\n  }\n  // Diff took too long and hit the deadline or\n  // number of diffs equals number of characters, no commonality at all.\n  return [\n    [DIFF_DELETE, text1],\n    [DIFF_INSERT, text2],\n  ];\n}\n\n/**\n * Given the location of the 'middle snake', split the diff in two parts\n * and recurse.\n * @param {string} text1 Old string to be diffed.\n * @param {string} text2 New string to be diffed.\n * @param {number} x Index of split point in text1.\n * @param {number} y Index of split point in text2.\n * @return {Array} Array of diff tuples.\n */\nfunction diff_bisectSplit_(text1, text2, x, y) {\n  var text1a = text1.substring(0, x);\n  var text2a = text2.substring(0, y);\n  var text1b = text1.substring(x);\n  var text2b = text2.substring(y);\n\n  // Compute both diffs serially.\n  var diffs = diff_main(text1a, text2a);\n  var diffsb = diff_main(text1b, text2b);\n\n  return diffs.concat(diffsb);\n}\n\n/**\n * Determine the common prefix of two strings.\n * @param {string} text1 First string.\n * @param {string} text2 Second string.\n * @return {number} The number of characters common to the start of each\n *     string.\n */\nfunction diff_commonPrefix(text1, text2) {\n  // Quick check for common null cases.\n  if (!text1 || !text2 || text1.charAt(0) !== text2.charAt(0)) {\n    return 0;\n  }\n  // Binary search.\n  // Performance analysis: http://neil.fraser.name/news/2007/10/09/\n  var pointermin = 0;\n  var pointermax = Math.min(text1.length, text2.length);\n  var pointermid = pointermax;\n  var pointerstart = 0;\n  while (pointermin < pointermid) {\n    if (\n      text1.substring(pointerstart, pointermid) ==\n      text2.substring(pointerstart, pointermid)\n    ) {\n      pointermin = pointermid;\n      pointerstart = pointermin;\n    } else {\n      pointermax = pointermid;\n    }\n    pointermid = Math.floor((pointermax - pointermin) / 2 + pointermin);\n  }\n\n  if (is_surrogate_pair_start(text1.charCodeAt(pointermid - 1))) {\n    pointermid--;\n  }\n\n  return pointermid;\n}\n\n/**\n * Determine if the suffix of one string is the prefix of another.\n * @param {string} text1 First string.\n * @param {string} text2 Second string.\n * @return {number} The number of characters common to the end of the first\n *     string and the start of the second string.\n * @private\n */\nfunction diff_commonOverlap_(text1, text2) {\n  // Cache the text lengths to prevent multiple calls.\n  var text1_length = text1.length;\n  var text2_length = text2.length;\n  // Eliminate the null case.\n  if (text1_length == 0 || text2_length == 0) {\n    return 0;\n  }\n  // Truncate the longer string.\n  if (text1_length > text2_length) {\n    text1 = text1.substring(text1_length - text2_length);\n  } else if (text1_length < text2_length) {\n    text2 = text2.substring(0, text1_length);\n  }\n  var text_length = Math.min(text1_length, text2_length);\n  // Quick check for the worst case.\n  if (text1 == text2) {\n    return text_length;\n  }\n\n  // Start by looking for a single character match\n  // and increase length until no match is found.\n  // Performance analysis: http://neil.fraser.name/news/2010/11/04/\n  var best = 0;\n  var length = 1;\n  while (true) {\n    var pattern = text1.substring(text_length - length);\n    var found = text2.indexOf(pattern);\n    if (found == -1) {\n      return best;\n    }\n    length += found;\n    if (\n      found == 0 ||\n      text1.substring(text_length - length) == text2.substring(0, length)\n    ) {\n      best = length;\n      length++;\n    }\n  }\n}\n\n/**\n * Determine the common suffix of two strings.\n * @param {string} text1 First string.\n * @param {string} text2 Second string.\n * @return {number} The number of characters common to the end of each string.\n */\nfunction diff_commonSuffix(text1, text2) {\n  // Quick check for common null cases.\n  if (!text1 || !text2 || text1.slice(-1) !== text2.slice(-1)) {\n    return 0;\n  }\n  // Binary search.\n  // Performance analysis: http://neil.fraser.name/news/2007/10/09/\n  var pointermin = 0;\n  var pointermax = Math.min(text1.length, text2.length);\n  var pointermid = pointermax;\n  var pointerend = 0;\n  while (pointermin < pointermid) {\n    if (\n      text1.substring(text1.length - pointermid, text1.length - pointerend) ==\n      text2.substring(text2.length - pointermid, text2.length - pointerend)\n    ) {\n      pointermin = pointermid;\n      pointerend = pointermin;\n    } else {\n      pointermax = pointermid;\n    }\n    pointermid = Math.floor((pointermax - pointermin) / 2 + pointermin);\n  }\n\n  if (is_surrogate_pair_end(text1.charCodeAt(text1.length - pointermid))) {\n    pointermid--;\n  }\n\n  return pointermid;\n}\n\n/**\n * Do the two texts share a substring which is at least half the length of the\n * longer text?\n * This speedup can produce non-minimal diffs.\n * @param {string} text1 First string.\n * @param {string} text2 Second string.\n * @return {Array.<string>} Five element Array, containing the prefix of\n *     text1, the suffix of text1, the prefix of text2, the suffix of\n *     text2 and the common middle.  Or null if there was no match.\n */\nfunction diff_halfMatch_(text1, text2) {\n  var longtext = text1.length > text2.length ? text1 : text2;\n  var shorttext = text1.length > text2.length ? text2 : text1;\n  if (longtext.length < 4 || shorttext.length * 2 < longtext.length) {\n    return null; // Pointless.\n  }\n\n  /**\n   * Does a substring of shorttext exist within longtext such that the substring\n   * is at least half the length of longtext?\n   * Closure, but does not reference any external variables.\n   * @param {string} longtext Longer string.\n   * @param {string} shorttext Shorter string.\n   * @param {number} i Start index of quarter length substring within longtext.\n   * @return {Array.<string>} Five element Array, containing the prefix of\n   *     longtext, the suffix of longtext, the prefix of shorttext, the suffix\n   *     of shorttext and the common middle.  Or null if there was no match.\n   * @private\n   */\n  function diff_halfMatchI_(longtext, shorttext, i) {\n    // Start with a 1/4 length substring at position i as a seed.\n    var seed = longtext.substring(i, i + Math.floor(longtext.length / 4));\n    var j = -1;\n    var best_common = \"\";\n    var best_longtext_a, best_longtext_b, best_shorttext_a, best_shorttext_b;\n    while ((j = shorttext.indexOf(seed, j + 1)) !== -1) {\n      var prefixLength = diff_commonPrefix(\n        longtext.substring(i),\n        shorttext.substring(j)\n      );\n      var suffixLength = diff_commonSuffix(\n        longtext.substring(0, i),\n        shorttext.substring(0, j)\n      );\n      if (best_common.length < suffixLength + prefixLength) {\n        best_common =\n          shorttext.substring(j - suffixLength, j) +\n          shorttext.substring(j, j + prefixLength);\n        best_longtext_a = longtext.substring(0, i - suffixLength);\n        best_longtext_b = longtext.substring(i + prefixLength);\n        best_shorttext_a = shorttext.substring(0, j - suffixLength);\n        best_shorttext_b = shorttext.substring(j + prefixLength);\n      }\n    }\n    if (best_common.length * 2 >= longtext.length) {\n      return [\n        best_longtext_a,\n        best_longtext_b,\n        best_shorttext_a,\n        best_shorttext_b,\n        best_common,\n      ];\n    } else {\n      return null;\n    }\n  }\n\n  // First check if the second quarter is the seed for a half-match.\n  var hm1 = diff_halfMatchI_(\n    longtext,\n    shorttext,\n    Math.ceil(longtext.length / 4)\n  );\n  // Check again based on the third quarter.\n  var hm2 = diff_halfMatchI_(\n    longtext,\n    shorttext,\n    Math.ceil(longtext.length / 2)\n  );\n  var hm;\n  if (!hm1 && !hm2) {\n    return null;\n  } else if (!hm2) {\n    hm = hm1;\n  } else if (!hm1) {\n    hm = hm2;\n  } else {\n    // Both matched.  Select the longest.\n    hm = hm1[4].length > hm2[4].length ? hm1 : hm2;\n  }\n\n  // A half-match was found, sort out the return data.\n  var text1_a, text1_b, text2_a, text2_b;\n  if (text1.length > text2.length) {\n    text1_a = hm[0];\n    text1_b = hm[1];\n    text2_a = hm[2];\n    text2_b = hm[3];\n  } else {\n    text2_a = hm[0];\n    text2_b = hm[1];\n    text1_a = hm[2];\n    text1_b = hm[3];\n  }\n  var mid_common = hm[4];\n  return [text1_a, text1_b, text2_a, text2_b, mid_common];\n}\n\n/**\n * Reduce the number of edits by eliminating semantically trivial equalities.\n * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.\n */\nfunction diff_cleanupSemantic(diffs) {\n  var changes = false;\n  var equalities = []; // Stack of indices where equalities are found.\n  var equalitiesLength = 0; // Keeping our own length var is faster in JS.\n  /** @type {?string} */\n  var lastequality = null;\n  // Always equal to diffs[equalities[equalitiesLength - 1]][1]\n  var pointer = 0; // Index of current position.\n  // Number of characters that changed prior to the equality.\n  var length_insertions1 = 0;\n  var length_deletions1 = 0;\n  // Number of characters that changed after the equality.\n  var length_insertions2 = 0;\n  var length_deletions2 = 0;\n  while (pointer < diffs.length) {\n    if (diffs[pointer][0] == DIFF_EQUAL) {\n      // Equality found.\n      equalities[equalitiesLength++] = pointer;\n      length_insertions1 = length_insertions2;\n      length_deletions1 = length_deletions2;\n      length_insertions2 = 0;\n      length_deletions2 = 0;\n      lastequality = diffs[pointer][1];\n    } else {\n      // An insertion or deletion.\n      if (diffs[pointer][0] == DIFF_INSERT) {\n        length_insertions2 += diffs[pointer][1].length;\n      } else {\n        length_deletions2 += diffs[pointer][1].length;\n      }\n      // Eliminate an equality that is smaller or equal to the edits on both\n      // sides of it.\n      if (\n        lastequality &&\n        lastequality.length <=\n          Math.max(length_insertions1, length_deletions1) &&\n        lastequality.length <= Math.max(length_insertions2, length_deletions2)\n      ) {\n        // Duplicate record.\n        diffs.splice(equalities[equalitiesLength - 1], 0, [\n          DIFF_DELETE,\n          lastequality,\n        ]);\n        // Change second copy to insert.\n        diffs[equalities[equalitiesLength - 1] + 1][0] = DIFF_INSERT;\n        // Throw away the equality we just deleted.\n        equalitiesLength--;\n        // Throw away the previous equality (it needs to be reevaluated).\n        equalitiesLength--;\n        pointer = equalitiesLength > 0 ? equalities[equalitiesLength - 1] : -1;\n        length_insertions1 = 0; // Reset the counters.\n        length_deletions1 = 0;\n        length_insertions2 = 0;\n        length_deletions2 = 0;\n        lastequality = null;\n        changes = true;\n      }\n    }\n    pointer++;\n  }\n\n  // Normalize the diff.\n  if (changes) {\n    diff_cleanupMerge(diffs);\n  }\n  diff_cleanupSemanticLossless(diffs);\n\n  // Find any overlaps between deletions and insertions.\n  // e.g: <del>abcxxx</del><ins>xxxdef</ins>\n  //   -> <del>abc</del>xxx<ins>def</ins>\n  // e.g: <del>xxxabc</del><ins>defxxx</ins>\n  //   -> <ins>def</ins>xxx<del>abc</del>\n  // Only extract an overlap if it is as big as the edit ahead or behind it.\n  pointer = 1;\n  while (pointer < diffs.length) {\n    if (\n      diffs[pointer - 1][0] == DIFF_DELETE &&\n      diffs[pointer][0] == DIFF_INSERT\n    ) {\n      var deletion = diffs[pointer - 1][1];\n      var insertion = diffs[pointer][1];\n      var overlap_length1 = diff_commonOverlap_(deletion, insertion);\n      var overlap_length2 = diff_commonOverlap_(insertion, deletion);\n      if (overlap_length1 >= overlap_length2) {\n        if (\n          overlap_length1 >= deletion.length / 2 ||\n          overlap_length1 >= insertion.length / 2\n        ) {\n          // Overlap found.  Insert an equality and trim the surrounding edits.\n          diffs.splice(pointer, 0, [\n            DIFF_EQUAL,\n            insertion.substring(0, overlap_length1),\n          ]);\n          diffs[pointer - 1][1] = deletion.substring(\n            0,\n            deletion.length - overlap_length1\n          );\n          diffs[pointer + 1][1] = insertion.substring(overlap_length1);\n          pointer++;\n        }\n      } else {\n        if (\n          overlap_length2 >= deletion.length / 2 ||\n          overlap_length2 >= insertion.length / 2\n        ) {\n          // Reverse overlap found.\n          // Insert an equality and swap and trim the surrounding edits.\n          diffs.splice(pointer, 0, [\n            DIFF_EQUAL,\n            deletion.substring(0, overlap_length2),\n          ]);\n          diffs[pointer - 1][0] = DIFF_INSERT;\n          diffs[pointer - 1][1] = insertion.substring(\n            0,\n            insertion.length - overlap_length2\n          );\n          diffs[pointer + 1][0] = DIFF_DELETE;\n          diffs[pointer + 1][1] = deletion.substring(overlap_length2);\n          pointer++;\n        }\n      }\n      pointer++;\n    }\n    pointer++;\n  }\n}\n\nvar nonAlphaNumericRegex_ = /[^a-zA-Z0-9]/;\nvar whitespaceRegex_ = /\\s/;\nvar linebreakRegex_ = /[\\r\\n]/;\nvar blanklineEndRegex_ = /\\n\\r?\\n$/;\nvar blanklineStartRegex_ = /^\\r?\\n\\r?\\n/;\n\n/**\n * Look for single edits surrounded on both sides by equalities\n * which can be shifted sideways to align the edit to a word boundary.\n * e.g: The c<ins>at c</ins>ame. -> The <ins>cat </ins>came.\n * @param {!Array.<!diff_match_patch.Diff>} diffs Array of diff tuples.\n */\nfunction diff_cleanupSemanticLossless(diffs) {\n  /**\n   * Given two strings, compute a score representing whether the internal\n   * boundary falls on logical boundaries.\n   * Scores range from 6 (best) to 0 (worst).\n   * Closure, but does not reference any external variables.\n   * @param {string} one First string.\n   * @param {string} two Second string.\n   * @return {number} The score.\n   * @private\n   */\n  function diff_cleanupSemanticScore_(one, two) {\n    if (!one || !two) {\n      // Edges are the best.\n      return 6;\n    }\n\n    // Each port of this function behaves slightly differently due to\n    // subtle differences in each language's definition of things like\n    // 'whitespace'.  Since this function's purpose is largely cosmetic,\n    // the choice has been made to use each language's native features\n    // rather than force total conformity.\n    var char1 = one.charAt(one.length - 1);\n    var char2 = two.charAt(0);\n    var nonAlphaNumeric1 = char1.match(nonAlphaNumericRegex_);\n    var nonAlphaNumeric2 = char2.match(nonAlphaNumericRegex_);\n    var whitespace1 = nonAlphaNumeric1 && char1.match(whitespaceRegex_);\n    var whitespace2 = nonAlphaNumeric2 && char2.match(whitespaceRegex_);\n    var lineBreak1 = whitespace1 && char1.match(linebreakRegex_);\n    var lineBreak2 = whitespace2 && char2.match(linebreakRegex_);\n    var blankLine1 = lineBreak1 && one.match(blanklineEndRegex_);\n    var blankLine2 = lineBreak2 && two.match(blanklineStartRegex_);\n\n    if (blankLine1 || blankLine2) {\n      // Five points for blank lines.\n      return 5;\n    } else if (lineBreak1 || lineBreak2) {\n      // Four points for line breaks.\n      return 4;\n    } else if (nonAlphaNumeric1 && !whitespace1 && whitespace2) {\n      // Three points for end of sentences.\n      return 3;\n    } else if (whitespace1 || whitespace2) {\n      // Two points for whitespace.\n      return 2;\n    } else if (nonAlphaNumeric1 || nonAlphaNumeric2) {\n      // One point for non-alphanumeric.\n      return 1;\n    }\n    return 0;\n  }\n\n  var pointer = 1;\n  // Intentionally ignore the first and last element (don't need checking).\n  while (pointer < diffs.length - 1) {\n    if (\n      diffs[pointer - 1][0] == DIFF_EQUAL &&\n      diffs[pointer + 1][0] == DIFF_EQUAL\n    ) {\n      // This is a single edit surrounded by equalities.\n      var equality1 = diffs[pointer - 1][1];\n      var edit = diffs[pointer][1];\n      var equality2 = diffs[pointer + 1][1];\n\n      // First, shift the edit as far left as possible.\n      var commonOffset = diff_commonSuffix(equality1, edit);\n      if (commonOffset) {\n        var commonString = edit.substring(edit.length - commonOffset);\n        equality1 = equality1.substring(0, equality1.length - commonOffset);\n        edit = commonString + edit.substring(0, edit.length - commonOffset);\n        equality2 = commonString + equality2;\n      }\n\n      // Second, step character by character right, looking for the best fit.\n      var bestEquality1 = equality1;\n      var bestEdit = edit;\n      var bestEquality2 = equality2;\n      var bestScore =\n        diff_cleanupSemanticScore_(equality1, edit) +\n        diff_cleanupSemanticScore_(edit, equality2);\n      while (edit.charAt(0) === equality2.charAt(0)) {\n        equality1 += edit.charAt(0);\n        edit = edit.substring(1) + equality2.charAt(0);\n        equality2 = equality2.substring(1);\n        var score =\n          diff_cleanupSemanticScore_(equality1, edit) +\n          diff_cleanupSemanticScore_(edit, equality2);\n        // The >= encourages trailing rather than leading whitespace on edits.\n        if (score >= bestScore) {\n          bestScore = score;\n          bestEquality1 = equality1;\n          bestEdit = edit;\n          bestEquality2 = equality2;\n        }\n      }\n\n      if (diffs[pointer - 1][1] != bestEquality1) {\n        // We have an improvement, save it back to the diff.\n        if (bestEquality1) {\n          diffs[pointer - 1][1] = bestEquality1;\n        } else {\n          diffs.splice(pointer - 1, 1);\n          pointer--;\n        }\n        diffs[pointer][1] = bestEdit;\n        if (bestEquality2) {\n          diffs[pointer + 1][1] = bestEquality2;\n        } else {\n          diffs.splice(pointer + 1, 1);\n          pointer--;\n        }\n      }\n    }\n    pointer++;\n  }\n}\n\n/**\n * Reorder and merge like edit sections.  Merge equalities.\n * Any edit section can move as long as it doesn't cross an equality.\n * @param {Array} diffs Array of diff tuples.\n * @param {boolean} fix_unicode Whether to normalize to a unicode-correct diff\n */\nfunction diff_cleanupMerge(diffs, fix_unicode) {\n  diffs.push([DIFF_EQUAL, \"\"]); // Add a dummy entry at the end.\n  var pointer = 0;\n  var count_delete = 0;\n  var count_insert = 0;\n  var text_delete = \"\";\n  var text_insert = \"\";\n  var commonlength;\n  while (pointer < diffs.length) {\n    if (pointer < diffs.length - 1 && !diffs[pointer][1]) {\n      diffs.splice(pointer, 1);\n      continue;\n    }\n    switch (diffs[pointer][0]) {\n      case DIFF_INSERT:\n        count_insert++;\n        text_insert += diffs[pointer][1];\n        pointer++;\n        break;\n      case DIFF_DELETE:\n        count_delete++;\n        text_delete += diffs[pointer][1];\n        pointer++;\n        break;\n      case DIFF_EQUAL:\n        var previous_equality = pointer - count_insert - count_delete - 1;\n        if (fix_unicode) {\n          // prevent splitting of unicode surrogate pairs.  when fix_unicode is true,\n          // we assume that the old and new text in the diff are complete and correct\n          // unicode-encoded JS strings, but the tuple boundaries may fall between\n          // surrogate pairs.  we fix this by shaving off stray surrogates from the end\n          // of the previous equality and the beginning of this equality.  this may create\n          // empty equalities or a common prefix or suffix.  for example, if AB and AC are\n          // emojis, `[[0, 'A'], [-1, 'BA'], [0, 'C']]` would turn into deleting 'ABAC' and\n          // inserting 'AC', and then the common suffix 'AC' will be eliminated.  in this\n          // particular case, both equalities go away, we absorb any previous inequalities,\n          // and we keep scanning for the next equality before rewriting the tuples.\n          if (\n            previous_equality >= 0 &&\n            ends_with_pair_start(diffs[previous_equality][1])\n          ) {\n            var stray = diffs[previous_equality][1].slice(-1);\n            diffs[previous_equality][1] = diffs[previous_equality][1].slice(\n              0,\n              -1\n            );\n            text_delete = stray + text_delete;\n            text_insert = stray + text_insert;\n            if (!diffs[previous_equality][1]) {\n              // emptied out previous equality, so delete it and include previous delete/insert\n              diffs.splice(previous_equality, 1);\n              pointer--;\n              var k = previous_equality - 1;\n              if (diffs[k] && diffs[k][0] === DIFF_INSERT) {\n                count_insert++;\n                text_insert = diffs[k][1] + text_insert;\n                k--;\n              }\n              if (diffs[k] && diffs[k][0] === DIFF_DELETE) {\n                count_delete++;\n                text_delete = diffs[k][1] + text_delete;\n                k--;\n              }\n              previous_equality = k;\n            }\n          }\n          if (starts_with_pair_end(diffs[pointer][1])) {\n            var stray = diffs[pointer][1].charAt(0);\n            diffs[pointer][1] = diffs[pointer][1].slice(1);\n            text_delete += stray;\n            text_insert += stray;\n          }\n        }\n        if (pointer < diffs.length - 1 && !diffs[pointer][1]) {\n          // for empty equality not at end, wait for next equality\n          diffs.splice(pointer, 1);\n          break;\n        }\n        if (text_delete.length > 0 || text_insert.length > 0) {\n          // note that diff_commonPrefix and diff_commonSuffix are unicode-aware\n          if (text_delete.length > 0 && text_insert.length > 0) {\n            // Factor out any common prefixes.\n            commonlength = diff_commonPrefix(text_insert, text_delete);\n            if (commonlength !== 0) {\n              if (previous_equality >= 0) {\n                diffs[previous_equality][1] += text_insert.substring(\n                  0,\n                  commonlength\n                );\n              } else {\n                diffs.splice(0, 0, [\n                  DIFF_EQUAL,\n                  text_insert.substring(0, commonlength),\n                ]);\n                pointer++;\n              }\n              text_insert = text_insert.substring(commonlength);\n              text_delete = text_delete.substring(commonlength);\n            }\n            // Factor out any common suffixes.\n            commonlength = diff_commonSuffix(text_insert, text_delete);\n            if (commonlength !== 0) {\n              diffs[pointer][1] =\n                text_insert.substring(text_insert.length - commonlength) +\n                diffs[pointer][1];\n              text_insert = text_insert.substring(\n                0,\n                text_insert.length - commonlength\n              );\n              text_delete = text_delete.substring(\n                0,\n                text_delete.length - commonlength\n              );\n            }\n          }\n          // Delete the offending records and add the merged ones.\n          var n = count_insert + count_delete;\n          if (text_delete.length === 0 && text_insert.length === 0) {\n            diffs.splice(pointer - n, n);\n            pointer = pointer - n;\n          } else if (text_delete.length === 0) {\n            diffs.splice(pointer - n, n, [DIFF_INSERT, text_insert]);\n            pointer = pointer - n + 1;\n          } else if (text_insert.length === 0) {\n            diffs.splice(pointer - n, n, [DIFF_DELETE, text_delete]);\n            pointer = pointer - n + 1;\n          } else {\n            diffs.splice(\n              pointer - n,\n              n,\n              [DIFF_DELETE, text_delete],\n              [DIFF_INSERT, text_insert]\n            );\n            pointer = pointer - n + 2;\n          }\n        }\n        if (pointer !== 0 && diffs[pointer - 1][0] === DIFF_EQUAL) {\n          // Merge this equality with the previous one.\n          diffs[pointer - 1][1] += diffs[pointer][1];\n          diffs.splice(pointer, 1);\n        } else {\n          pointer++;\n        }\n        count_insert = 0;\n        count_delete = 0;\n        text_delete = \"\";\n        text_insert = \"\";\n        break;\n    }\n  }\n  if (diffs[diffs.length - 1][1] === \"\") {\n    diffs.pop(); // Remove the dummy entry at the end.\n  }\n\n  // Second pass: look for single edits surrounded on both sides by equalities\n  // which can be shifted sideways to eliminate an equality.\n  // e.g: A<ins>BA</ins>C -> <ins>AB</ins>AC\n  var changes = false;\n  pointer = 1;\n  // Intentionally ignore the first and last element (don't need checking).\n  while (pointer < diffs.length - 1) {\n    if (\n      diffs[pointer - 1][0] === DIFF_EQUAL &&\n      diffs[pointer + 1][0] === DIFF_EQUAL\n    ) {\n      // This is a single edit surrounded by equalities.\n      if (\n        diffs[pointer][1].substring(\n          diffs[pointer][1].length - diffs[pointer - 1][1].length\n        ) === diffs[pointer - 1][1]\n      ) {\n        // Shift the edit over the previous equality.\n        diffs[pointer][1] =\n          diffs[pointer - 1][1] +\n          diffs[pointer][1].substring(\n            0,\n            diffs[pointer][1].length - diffs[pointer - 1][1].length\n          );\n        diffs[pointer + 1][1] = diffs[pointer - 1][1] + diffs[pointer + 1][1];\n        diffs.splice(pointer - 1, 1);\n        changes = true;\n      } else if (\n        diffs[pointer][1].substring(0, diffs[pointer + 1][1].length) ==\n        diffs[pointer + 1][1]\n      ) {\n        // Shift the edit over the next equality.\n        diffs[pointer - 1][1] += diffs[pointer + 1][1];\n        diffs[pointer][1] =\n          diffs[pointer][1].substring(diffs[pointer + 1][1].length) +\n          diffs[pointer + 1][1];\n        diffs.splice(pointer + 1, 1);\n        changes = true;\n      }\n    }\n    pointer++;\n  }\n  // If shifts were made, the diff needs reordering and another shift sweep.\n  if (changes) {\n    diff_cleanupMerge(diffs, fix_unicode);\n  }\n}\n\nfunction is_surrogate_pair_start(charCode) {\n  return charCode >= 0xd800 && charCode <= 0xdbff;\n}\n\nfunction is_surrogate_pair_end(charCode) {\n  return charCode >= 0xdc00 && charCode <= 0xdfff;\n}\n\nfunction starts_with_pair_end(str) {\n  return is_surrogate_pair_end(str.charCodeAt(0));\n}\n\nfunction ends_with_pair_start(str) {\n  return is_surrogate_pair_start(str.charCodeAt(str.length - 1));\n}\n\nfunction remove_empty_tuples(tuples) {\n  var ret = [];\n  for (var i = 0; i < tuples.length; i++) {\n    if (tuples[i][1].length > 0) {\n      ret.push(tuples[i]);\n    }\n  }\n  return ret;\n}\n\nfunction make_edit_splice(before, oldMiddle, newMiddle, after) {\n  if (ends_with_pair_start(before) || starts_with_pair_end(after)) {\n    return null;\n  }\n  return remove_empty_tuples([\n    [DIFF_EQUAL, before],\n    [DIFF_DELETE, oldMiddle],\n    [DIFF_INSERT, newMiddle],\n    [DIFF_EQUAL, after],\n  ]);\n}\n\nfunction find_cursor_edit_diff(oldText, newText, cursor_pos) {\n  // note: this runs after equality check has ruled out exact equality\n  var oldRange =\n    typeof cursor_pos === \"number\"\n      ? { index: cursor_pos, length: 0 }\n      : cursor_pos.oldRange;\n  var newRange = typeof cursor_pos === \"number\" ? null : cursor_pos.newRange;\n  // take into account the old and new selection to generate the best diff\n  // possible for a text edit.  for example, a text change from \"xxx\" to \"xx\"\n  // could be a delete or forwards-delete of any one of the x's, or the\n  // result of selecting two of the x's and typing \"x\".\n  var oldLength = oldText.length;\n  var newLength = newText.length;\n  if (oldRange.length === 0 && (newRange === null || newRange.length === 0)) {\n    // see if we have an insert or delete before or after cursor\n    var oldCursor = oldRange.index;\n    var oldBefore = oldText.slice(0, oldCursor);\n    var oldAfter = oldText.slice(oldCursor);\n    var maybeNewCursor = newRange ? newRange.index : null;\n    editBefore: {\n      // is this an insert or delete right before oldCursor?\n      var newCursor = oldCursor + newLength - oldLength;\n      if (maybeNewCursor !== null && maybeNewCursor !== newCursor) {\n        break editBefore;\n      }\n      if (newCursor < 0 || newCursor > newLength) {\n        break editBefore;\n      }\n      var newBefore = newText.slice(0, newCursor);\n      var newAfter = newText.slice(newCursor);\n      if (newAfter !== oldAfter) {\n        break editBefore;\n      }\n      var prefixLength = Math.min(oldCursor, newCursor);\n      var oldPrefix = oldBefore.slice(0, prefixLength);\n      var newPrefix = newBefore.slice(0, prefixLength);\n      if (oldPrefix !== newPrefix) {\n        break editBefore;\n      }\n      var oldMiddle = oldBefore.slice(prefixLength);\n      var newMiddle = newBefore.slice(prefixLength);\n      return make_edit_splice(oldPrefix, oldMiddle, newMiddle, oldAfter);\n    }\n    editAfter: {\n      // is this an insert or delete right after oldCursor?\n      if (maybeNewCursor !== null && maybeNewCursor !== oldCursor) {\n        break editAfter;\n      }\n      var cursor = oldCursor;\n      var newBefore = newText.slice(0, cursor);\n      var newAfter = newText.slice(cursor);\n      if (newBefore !== oldBefore) {\n        break editAfter;\n      }\n      var suffixLength = Math.min(oldLength - cursor, newLength - cursor);\n      var oldSuffix = oldAfter.slice(oldAfter.length - suffixLength);\n      var newSuffix = newAfter.slice(newAfter.length - suffixLength);\n      if (oldSuffix !== newSuffix) {\n        break editAfter;\n      }\n      var oldMiddle = oldAfter.slice(0, oldAfter.length - suffixLength);\n      var newMiddle = newAfter.slice(0, newAfter.length - suffixLength);\n      return make_edit_splice(oldBefore, oldMiddle, newMiddle, oldSuffix);\n    }\n  }\n  if (oldRange.length > 0 && newRange && newRange.length === 0) {\n    replaceRange: {\n      // see if diff could be a splice of the old selection range\n      var oldPrefix = oldText.slice(0, oldRange.index);\n      var oldSuffix = oldText.slice(oldRange.index + oldRange.length);\n      var prefixLength = oldPrefix.length;\n      var suffixLength = oldSuffix.length;\n      if (newLength < prefixLength + suffixLength) {\n        break replaceRange;\n      }\n      var newPrefix = newText.slice(0, prefixLength);\n      var newSuffix = newText.slice(newLength - suffixLength);\n      if (oldPrefix !== newPrefix || oldSuffix !== newSuffix) {\n        break replaceRange;\n      }\n      var oldMiddle = oldText.slice(prefixLength, oldLength - suffixLength);\n      var newMiddle = newText.slice(prefixLength, newLength - suffixLength);\n      return make_edit_splice(oldPrefix, oldMiddle, newMiddle, oldSuffix);\n    }\n  }\n\n  return null;\n}\n\nfunction diff(text1, text2, cursor_pos, cleanup) {\n  // only pass fix_unicode=true at the top level, not when diff_main is\n  // recursively invoked\n  return diff_main(text1, text2, cursor_pos, cleanup, true);\n}\n\ndiff.INSERT = DIFF_INSERT;\ndiff.DELETE = DIFF_DELETE;\ndiff.EQUAL = DIFF_EQUAL;\n\nmodule.exports = diff;\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/fast-diff/diff.js?")},"./node_modules/lodash.clonedeep/index.js":function(module,exports,__webpack_require__){eval("/* module decorator */ module = __webpack_require__.nmd(module);\n/**\n * lodash (Custom Build) <https://lodash.com/>\n * Build: `lodash modularize exports=\"npm\" -o ./`\n * Copyright jQuery Foundation and other contributors <https://jquery.org/>\n * Released under MIT license <https://lodash.com/license>\n * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>\n * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors\n */\n\n/** Used as the size to enable large array optimizations. */\nvar LARGE_ARRAY_SIZE = 200;\n\n/** Used to stand-in for `undefined` hash values. */\nvar HASH_UNDEFINED = '__lodash_hash_undefined__';\n\n/** Used as references for various `Number` constants. */\nvar MAX_SAFE_INTEGER = 9007199254740991;\n\n/** `Object#toString` result references. */\nvar argsTag = '[object Arguments]',\n    arrayTag = '[object Array]',\n    boolTag = '[object Boolean]',\n    dateTag = '[object Date]',\n    errorTag = '[object Error]',\n    funcTag = '[object Function]',\n    genTag = '[object GeneratorFunction]',\n    mapTag = '[object Map]',\n    numberTag = '[object Number]',\n    objectTag = '[object Object]',\n    promiseTag = '[object Promise]',\n    regexpTag = '[object RegExp]',\n    setTag = '[object Set]',\n    stringTag = '[object String]',\n    symbolTag = '[object Symbol]',\n    weakMapTag = '[object WeakMap]';\n\nvar arrayBufferTag = '[object ArrayBuffer]',\n    dataViewTag = '[object DataView]',\n    float32Tag = '[object Float32Array]',\n    float64Tag = '[object Float64Array]',\n    int8Tag = '[object Int8Array]',\n    int16Tag = '[object Int16Array]',\n    int32Tag = '[object Int32Array]',\n    uint8Tag = '[object Uint8Array]',\n    uint8ClampedTag = '[object Uint8ClampedArray]',\n    uint16Tag = '[object Uint16Array]',\n    uint32Tag = '[object Uint32Array]';\n\n/**\n * Used to match `RegExp`\n * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).\n */\nvar reRegExpChar = /[\\\\^$.*+?()[\\]{}|]/g;\n\n/** Used to match `RegExp` flags from their coerced string values. */\nvar reFlags = /\\w*$/;\n\n/** Used to detect host constructors (Safari). */\nvar reIsHostCtor = /^\\[object .+?Constructor\\]$/;\n\n/** Used to detect unsigned integer values. */\nvar reIsUint = /^(?:0|[1-9]\\d*)$/;\n\n/** Used to identify `toStringTag` values supported by `_.clone`. */\nvar cloneableTags = {};\ncloneableTags[argsTag] = cloneableTags[arrayTag] =\ncloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =\ncloneableTags[boolTag] = cloneableTags[dateTag] =\ncloneableTags[float32Tag] = cloneableTags[float64Tag] =\ncloneableTags[int8Tag] = cloneableTags[int16Tag] =\ncloneableTags[int32Tag] = cloneableTags[mapTag] =\ncloneableTags[numberTag] = cloneableTags[objectTag] =\ncloneableTags[regexpTag] = cloneableTags[setTag] =\ncloneableTags[stringTag] = cloneableTags[symbolTag] =\ncloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =\ncloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;\ncloneableTags[errorTag] = cloneableTags[funcTag] =\ncloneableTags[weakMapTag] = false;\n\n/** Detect free variable `global` from Node.js. */\nvar freeGlobal = typeof __webpack_require__.g == 'object' && __webpack_require__.g && __webpack_require__.g.Object === Object && __webpack_require__.g;\n\n/** Detect free variable `self`. */\nvar freeSelf = typeof self == 'object' && self && self.Object === Object && self;\n\n/** Used as a reference to the global object. */\nvar root = freeGlobal || freeSelf || Function('return this')();\n\n/** Detect free variable `exports`. */\nvar freeExports =  true && exports && !exports.nodeType && exports;\n\n/** Detect free variable `module`. */\nvar freeModule = freeExports && \"object\" == 'object' && module && !module.nodeType && module;\n\n/** Detect the popular CommonJS extension `module.exports`. */\nvar moduleExports = freeModule && freeModule.exports === freeExports;\n\n/**\n * Adds the key-value `pair` to `map`.\n *\n * @private\n * @param {Object} map The map to modify.\n * @param {Array} pair The key-value pair to add.\n * @returns {Object} Returns `map`.\n */\nfunction addMapEntry(map, pair) {\n  // Don't return `map.set` because it's not chainable in IE 11.\n  map.set(pair[0], pair[1]);\n  return map;\n}\n\n/**\n * Adds `value` to `set`.\n *\n * @private\n * @param {Object} set The set to modify.\n * @param {*} value The value to add.\n * @returns {Object} Returns `set`.\n */\nfunction addSetEntry(set, value) {\n  // Don't return `set.add` because it's not chainable in IE 11.\n  set.add(value);\n  return set;\n}\n\n/**\n * A specialized version of `_.forEach` for arrays without support for\n * iteratee shorthands.\n *\n * @private\n * @param {Array} [array] The array to iterate over.\n * @param {Function} iteratee The function invoked per iteration.\n * @returns {Array} Returns `array`.\n */\nfunction arrayEach(array, iteratee) {\n  var index = -1,\n      length = array ? array.length : 0;\n\n  while (++index < length) {\n    if (iteratee(array[index], index, array) === false) {\n      break;\n    }\n  }\n  return array;\n}\n\n/**\n * Appends the elements of `values` to `array`.\n *\n * @private\n * @param {Array} array The array to modify.\n * @param {Array} values The values to append.\n * @returns {Array} Returns `array`.\n */\nfunction arrayPush(array, values) {\n  var index = -1,\n      length = values.length,\n      offset = array.length;\n\n  while (++index < length) {\n    array[offset + index] = values[index];\n  }\n  return array;\n}\n\n/**\n * A specialized version of `_.reduce` for arrays without support for\n * iteratee shorthands.\n *\n * @private\n * @param {Array} [array] The array to iterate over.\n * @param {Function} iteratee The function invoked per iteration.\n * @param {*} [accumulator] The initial value.\n * @param {boolean} [initAccum] Specify using the first element of `array` as\n *  the initial value.\n * @returns {*} Returns the accumulated value.\n */\nfunction arrayReduce(array, iteratee, accumulator, initAccum) {\n  var index = -1,\n      length = array ? array.length : 0;\n\n  if (initAccum && length) {\n    accumulator = array[++index];\n  }\n  while (++index < length) {\n    accumulator = iteratee(accumulator, array[index], index, array);\n  }\n  return accumulator;\n}\n\n/**\n * The base implementation of `_.times` without support for iteratee shorthands\n * or max array length checks.\n *\n * @private\n * @param {number} n The number of times to invoke `iteratee`.\n * @param {Function} iteratee The function invoked per iteration.\n * @returns {Array} Returns the array of results.\n */\nfunction baseTimes(n, iteratee) {\n  var index = -1,\n      result = Array(n);\n\n  while (++index < n) {\n    result[index] = iteratee(index);\n  }\n  return result;\n}\n\n/**\n * Gets the value at `key` of `object`.\n *\n * @private\n * @param {Object} [object] The object to query.\n * @param {string} key The key of the property to get.\n * @returns {*} Returns the property value.\n */\nfunction getValue(object, key) {\n  return object == null ? undefined : object[key];\n}\n\n/**\n * Checks if `value` is a host object in IE < 9.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a host object, else `false`.\n */\nfunction isHostObject(value) {\n  // Many host objects are `Object` objects that can coerce to strings\n  // despite having improperly defined `toString` methods.\n  var result = false;\n  if (value != null && typeof value.toString != 'function') {\n    try {\n      result = !!(value + '');\n    } catch (e) {}\n  }\n  return result;\n}\n\n/**\n * Converts `map` to its key-value pairs.\n *\n * @private\n * @param {Object} map The map to convert.\n * @returns {Array} Returns the key-value pairs.\n */\nfunction mapToArray(map) {\n  var index = -1,\n      result = Array(map.size);\n\n  map.forEach(function(value, key) {\n    result[++index] = [key, value];\n  });\n  return result;\n}\n\n/**\n * Creates a unary function that invokes `func` with its argument transformed.\n *\n * @private\n * @param {Function} func The function to wrap.\n * @param {Function} transform The argument transform.\n * @returns {Function} Returns the new function.\n */\nfunction overArg(func, transform) {\n  return function(arg) {\n    return func(transform(arg));\n  };\n}\n\n/**\n * Converts `set` to an array of its values.\n *\n * @private\n * @param {Object} set The set to convert.\n * @returns {Array} Returns the values.\n */\nfunction setToArray(set) {\n  var index = -1,\n      result = Array(set.size);\n\n  set.forEach(function(value) {\n    result[++index] = value;\n  });\n  return result;\n}\n\n/** Used for built-in method references. */\nvar arrayProto = Array.prototype,\n    funcProto = Function.prototype,\n    objectProto = Object.prototype;\n\n/** Used to detect overreaching core-js shims. */\nvar coreJsData = root['__core-js_shared__'];\n\n/** Used to detect methods masquerading as native. */\nvar maskSrcKey = (function() {\n  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');\n  return uid ? ('Symbol(src)_1.' + uid) : '';\n}());\n\n/** Used to resolve the decompiled source of functions. */\nvar funcToString = funcProto.toString;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * Used to resolve the\n * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)\n * of values.\n */\nvar objectToString = objectProto.toString;\n\n/** Used to detect if a method is native. */\nvar reIsNative = RegExp('^' +\n  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\\\$&')\n  .replace(/hasOwnProperty|(function).*?(?=\\\\\\()| for .+?(?=\\\\\\])/g, '$1.*?') + '$'\n);\n\n/** Built-in value references. */\nvar Buffer = moduleExports ? root.Buffer : undefined,\n    Symbol = root.Symbol,\n    Uint8Array = root.Uint8Array,\n    getPrototype = overArg(Object.getPrototypeOf, Object),\n    objectCreate = Object.create,\n    propertyIsEnumerable = objectProto.propertyIsEnumerable,\n    splice = arrayProto.splice;\n\n/* Built-in method references for those with the same name as other `lodash` methods. */\nvar nativeGetSymbols = Object.getOwnPropertySymbols,\n    nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,\n    nativeKeys = overArg(Object.keys, Object);\n\n/* Built-in method references that are verified to be native. */\nvar DataView = getNative(root, 'DataView'),\n    Map = getNative(root, 'Map'),\n    Promise = getNative(root, 'Promise'),\n    Set = getNative(root, 'Set'),\n    WeakMap = getNative(root, 'WeakMap'),\n    nativeCreate = getNative(Object, 'create');\n\n/** Used to detect maps, sets, and weakmaps. */\nvar dataViewCtorString = toSource(DataView),\n    mapCtorString = toSource(Map),\n    promiseCtorString = toSource(Promise),\n    setCtorString = toSource(Set),\n    weakMapCtorString = toSource(WeakMap);\n\n/** Used to convert symbols to primitives and strings. */\nvar symbolProto = Symbol ? Symbol.prototype : undefined,\n    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;\n\n/**\n * Creates a hash object.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction Hash(entries) {\n  var index = -1,\n      length = entries ? entries.length : 0;\n\n  this.clear();\n  while (++index < length) {\n    var entry = entries[index];\n    this.set(entry[0], entry[1]);\n  }\n}\n\n/**\n * Removes all key-value entries from the hash.\n *\n * @private\n * @name clear\n * @memberOf Hash\n */\nfunction hashClear() {\n  this.__data__ = nativeCreate ? nativeCreate(null) : {};\n}\n\n/**\n * Removes `key` and its value from the hash.\n *\n * @private\n * @name delete\n * @memberOf Hash\n * @param {Object} hash The hash to modify.\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction hashDelete(key) {\n  return this.has(key) && delete this.__data__[key];\n}\n\n/**\n * Gets the hash value for `key`.\n *\n * @private\n * @name get\n * @memberOf Hash\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction hashGet(key) {\n  var data = this.__data__;\n  if (nativeCreate) {\n    var result = data[key];\n    return result === HASH_UNDEFINED ? undefined : result;\n  }\n  return hasOwnProperty.call(data, key) ? data[key] : undefined;\n}\n\n/**\n * Checks if a hash value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf Hash\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction hashHas(key) {\n  var data = this.__data__;\n  return nativeCreate ? data[key] !== undefined : hasOwnProperty.call(data, key);\n}\n\n/**\n * Sets the hash `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf Hash\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the hash instance.\n */\nfunction hashSet(key, value) {\n  var data = this.__data__;\n  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;\n  return this;\n}\n\n// Add methods to `Hash`.\nHash.prototype.clear = hashClear;\nHash.prototype['delete'] = hashDelete;\nHash.prototype.get = hashGet;\nHash.prototype.has = hashHas;\nHash.prototype.set = hashSet;\n\n/**\n * Creates an list cache object.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction ListCache(entries) {\n  var index = -1,\n      length = entries ? entries.length : 0;\n\n  this.clear();\n  while (++index < length) {\n    var entry = entries[index];\n    this.set(entry[0], entry[1]);\n  }\n}\n\n/**\n * Removes all key-value entries from the list cache.\n *\n * @private\n * @name clear\n * @memberOf ListCache\n */\nfunction listCacheClear() {\n  this.__data__ = [];\n}\n\n/**\n * Removes `key` and its value from the list cache.\n *\n * @private\n * @name delete\n * @memberOf ListCache\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction listCacheDelete(key) {\n  var data = this.__data__,\n      index = assocIndexOf(data, key);\n\n  if (index < 0) {\n    return false;\n  }\n  var lastIndex = data.length - 1;\n  if (index == lastIndex) {\n    data.pop();\n  } else {\n    splice.call(data, index, 1);\n  }\n  return true;\n}\n\n/**\n * Gets the list cache value for `key`.\n *\n * @private\n * @name get\n * @memberOf ListCache\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction listCacheGet(key) {\n  var data = this.__data__,\n      index = assocIndexOf(data, key);\n\n  return index < 0 ? undefined : data[index][1];\n}\n\n/**\n * Checks if a list cache value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf ListCache\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction listCacheHas(key) {\n  return assocIndexOf(this.__data__, key) > -1;\n}\n\n/**\n * Sets the list cache `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf ListCache\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the list cache instance.\n */\nfunction listCacheSet(key, value) {\n  var data = this.__data__,\n      index = assocIndexOf(data, key);\n\n  if (index < 0) {\n    data.push([key, value]);\n  } else {\n    data[index][1] = value;\n  }\n  return this;\n}\n\n// Add methods to `ListCache`.\nListCache.prototype.clear = listCacheClear;\nListCache.prototype['delete'] = listCacheDelete;\nListCache.prototype.get = listCacheGet;\nListCache.prototype.has = listCacheHas;\nListCache.prototype.set = listCacheSet;\n\n/**\n * Creates a map cache object to store key-value pairs.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction MapCache(entries) {\n  var index = -1,\n      length = entries ? entries.length : 0;\n\n  this.clear();\n  while (++index < length) {\n    var entry = entries[index];\n    this.set(entry[0], entry[1]);\n  }\n}\n\n/**\n * Removes all key-value entries from the map.\n *\n * @private\n * @name clear\n * @memberOf MapCache\n */\nfunction mapCacheClear() {\n  this.__data__ = {\n    'hash': new Hash,\n    'map': new (Map || ListCache),\n    'string': new Hash\n  };\n}\n\n/**\n * Removes `key` and its value from the map.\n *\n * @private\n * @name delete\n * @memberOf MapCache\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction mapCacheDelete(key) {\n  return getMapData(this, key)['delete'](key);\n}\n\n/**\n * Gets the map value for `key`.\n *\n * @private\n * @name get\n * @memberOf MapCache\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction mapCacheGet(key) {\n  return getMapData(this, key).get(key);\n}\n\n/**\n * Checks if a map value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf MapCache\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction mapCacheHas(key) {\n  return getMapData(this, key).has(key);\n}\n\n/**\n * Sets the map `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf MapCache\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the map cache instance.\n */\nfunction mapCacheSet(key, value) {\n  getMapData(this, key).set(key, value);\n  return this;\n}\n\n// Add methods to `MapCache`.\nMapCache.prototype.clear = mapCacheClear;\nMapCache.prototype['delete'] = mapCacheDelete;\nMapCache.prototype.get = mapCacheGet;\nMapCache.prototype.has = mapCacheHas;\nMapCache.prototype.set = mapCacheSet;\n\n/**\n * Creates a stack cache object to store key-value pairs.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction Stack(entries) {\n  this.__data__ = new ListCache(entries);\n}\n\n/**\n * Removes all key-value entries from the stack.\n *\n * @private\n * @name clear\n * @memberOf Stack\n */\nfunction stackClear() {\n  this.__data__ = new ListCache;\n}\n\n/**\n * Removes `key` and its value from the stack.\n *\n * @private\n * @name delete\n * @memberOf Stack\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction stackDelete(key) {\n  return this.__data__['delete'](key);\n}\n\n/**\n * Gets the stack value for `key`.\n *\n * @private\n * @name get\n * @memberOf Stack\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction stackGet(key) {\n  return this.__data__.get(key);\n}\n\n/**\n * Checks if a stack value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf Stack\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction stackHas(key) {\n  return this.__data__.has(key);\n}\n\n/**\n * Sets the stack `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf Stack\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the stack cache instance.\n */\nfunction stackSet(key, value) {\n  var cache = this.__data__;\n  if (cache instanceof ListCache) {\n    var pairs = cache.__data__;\n    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {\n      pairs.push([key, value]);\n      return this;\n    }\n    cache = this.__data__ = new MapCache(pairs);\n  }\n  cache.set(key, value);\n  return this;\n}\n\n// Add methods to `Stack`.\nStack.prototype.clear = stackClear;\nStack.prototype['delete'] = stackDelete;\nStack.prototype.get = stackGet;\nStack.prototype.has = stackHas;\nStack.prototype.set = stackSet;\n\n/**\n * Creates an array of the enumerable property names of the array-like `value`.\n *\n * @private\n * @param {*} value The value to query.\n * @param {boolean} inherited Specify returning inherited property names.\n * @returns {Array} Returns the array of property names.\n */\nfunction arrayLikeKeys(value, inherited) {\n  // Safari 8.1 makes `arguments.callee` enumerable in strict mode.\n  // Safari 9 makes `arguments.length` enumerable in strict mode.\n  var result = (isArray(value) || isArguments(value))\n    ? baseTimes(value.length, String)\n    : [];\n\n  var length = result.length,\n      skipIndexes = !!length;\n\n  for (var key in value) {\n    if ((inherited || hasOwnProperty.call(value, key)) &&\n        !(skipIndexes && (key == 'length' || isIndex(key, length)))) {\n      result.push(key);\n    }\n  }\n  return result;\n}\n\n/**\n * Assigns `value` to `key` of `object` if the existing value is not equivalent\n * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)\n * for equality comparisons.\n *\n * @private\n * @param {Object} object The object to modify.\n * @param {string} key The key of the property to assign.\n * @param {*} value The value to assign.\n */\nfunction assignValue(object, key, value) {\n  var objValue = object[key];\n  if (!(hasOwnProperty.call(object, key) && eq(objValue, value)) ||\n      (value === undefined && !(key in object))) {\n    object[key] = value;\n  }\n}\n\n/**\n * Gets the index at which the `key` is found in `array` of key-value pairs.\n *\n * @private\n * @param {Array} array The array to inspect.\n * @param {*} key The key to search for.\n * @returns {number} Returns the index of the matched value, else `-1`.\n */\nfunction assocIndexOf(array, key) {\n  var length = array.length;\n  while (length--) {\n    if (eq(array[length][0], key)) {\n      return length;\n    }\n  }\n  return -1;\n}\n\n/**\n * The base implementation of `_.assign` without support for multiple sources\n * or `customizer` functions.\n *\n * @private\n * @param {Object} object The destination object.\n * @param {Object} source The source object.\n * @returns {Object} Returns `object`.\n */\nfunction baseAssign(object, source) {\n  return object && copyObject(source, keys(source), object);\n}\n\n/**\n * The base implementation of `_.clone` and `_.cloneDeep` which tracks\n * traversed objects.\n *\n * @private\n * @param {*} value The value to clone.\n * @param {boolean} [isDeep] Specify a deep clone.\n * @param {boolean} [isFull] Specify a clone including symbols.\n * @param {Function} [customizer] The function to customize cloning.\n * @param {string} [key] The key of `value`.\n * @param {Object} [object] The parent object of `value`.\n * @param {Object} [stack] Tracks traversed objects and their clone counterparts.\n * @returns {*} Returns the cloned value.\n */\nfunction baseClone(value, isDeep, isFull, customizer, key, object, stack) {\n  var result;\n  if (customizer) {\n    result = object ? customizer(value, key, object, stack) : customizer(value);\n  }\n  if (result !== undefined) {\n    return result;\n  }\n  if (!isObject(value)) {\n    return value;\n  }\n  var isArr = isArray(value);\n  if (isArr) {\n    result = initCloneArray(value);\n    if (!isDeep) {\n      return copyArray(value, result);\n    }\n  } else {\n    var tag = getTag(value),\n        isFunc = tag == funcTag || tag == genTag;\n\n    if (isBuffer(value)) {\n      return cloneBuffer(value, isDeep);\n    }\n    if (tag == objectTag || tag == argsTag || (isFunc && !object)) {\n      if (isHostObject(value)) {\n        return object ? value : {};\n      }\n      result = initCloneObject(isFunc ? {} : value);\n      if (!isDeep) {\n        return copySymbols(value, baseAssign(result, value));\n      }\n    } else {\n      if (!cloneableTags[tag]) {\n        return object ? value : {};\n      }\n      result = initCloneByTag(value, tag, baseClone, isDeep);\n    }\n  }\n  // Check for circular references and return its corresponding clone.\n  stack || (stack = new Stack);\n  var stacked = stack.get(value);\n  if (stacked) {\n    return stacked;\n  }\n  stack.set(value, result);\n\n  if (!isArr) {\n    var props = isFull ? getAllKeys(value) : keys(value);\n  }\n  arrayEach(props || value, function(subValue, key) {\n    if (props) {\n      key = subValue;\n      subValue = value[key];\n    }\n    // Recursively populate clone (susceptible to call stack limits).\n    assignValue(result, key, baseClone(subValue, isDeep, isFull, customizer, key, value, stack));\n  });\n  return result;\n}\n\n/**\n * The base implementation of `_.create` without support for assigning\n * properties to the created object.\n *\n * @private\n * @param {Object} prototype The object to inherit from.\n * @returns {Object} Returns the new object.\n */\nfunction baseCreate(proto) {\n  return isObject(proto) ? objectCreate(proto) : {};\n}\n\n/**\n * The base implementation of `getAllKeys` and `getAllKeysIn` which uses\n * `keysFunc` and `symbolsFunc` to get the enumerable property names and\n * symbols of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @param {Function} keysFunc The function to get the keys of `object`.\n * @param {Function} symbolsFunc The function to get the symbols of `object`.\n * @returns {Array} Returns the array of property names and symbols.\n */\nfunction baseGetAllKeys(object, keysFunc, symbolsFunc) {\n  var result = keysFunc(object);\n  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));\n}\n\n/**\n * The base implementation of `getTag`.\n *\n * @private\n * @param {*} value The value to query.\n * @returns {string} Returns the `toStringTag`.\n */\nfunction baseGetTag(value) {\n  return objectToString.call(value);\n}\n\n/**\n * The base implementation of `_.isNative` without bad shim checks.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a native function,\n *  else `false`.\n */\nfunction baseIsNative(value) {\n  if (!isObject(value) || isMasked(value)) {\n    return false;\n  }\n  var pattern = (isFunction(value) || isHostObject(value)) ? reIsNative : reIsHostCtor;\n  return pattern.test(toSource(value));\n}\n\n/**\n * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names.\n */\nfunction baseKeys(object) {\n  if (!isPrototype(object)) {\n    return nativeKeys(object);\n  }\n  var result = [];\n  for (var key in Object(object)) {\n    if (hasOwnProperty.call(object, key) && key != 'constructor') {\n      result.push(key);\n    }\n  }\n  return result;\n}\n\n/**\n * Creates a clone of  `buffer`.\n *\n * @private\n * @param {Buffer} buffer The buffer to clone.\n * @param {boolean} [isDeep] Specify a deep clone.\n * @returns {Buffer} Returns the cloned buffer.\n */\nfunction cloneBuffer(buffer, isDeep) {\n  if (isDeep) {\n    return buffer.slice();\n  }\n  var result = new buffer.constructor(buffer.length);\n  buffer.copy(result);\n  return result;\n}\n\n/**\n * Creates a clone of `arrayBuffer`.\n *\n * @private\n * @param {ArrayBuffer} arrayBuffer The array buffer to clone.\n * @returns {ArrayBuffer} Returns the cloned array buffer.\n */\nfunction cloneArrayBuffer(arrayBuffer) {\n  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);\n  new Uint8Array(result).set(new Uint8Array(arrayBuffer));\n  return result;\n}\n\n/**\n * Creates a clone of `dataView`.\n *\n * @private\n * @param {Object} dataView The data view to clone.\n * @param {boolean} [isDeep] Specify a deep clone.\n * @returns {Object} Returns the cloned data view.\n */\nfunction cloneDataView(dataView, isDeep) {\n  var buffer = isDeep ? cloneArrayBuffer(dataView.buffer) : dataView.buffer;\n  return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);\n}\n\n/**\n * Creates a clone of `map`.\n *\n * @private\n * @param {Object} map The map to clone.\n * @param {Function} cloneFunc The function to clone values.\n * @param {boolean} [isDeep] Specify a deep clone.\n * @returns {Object} Returns the cloned map.\n */\nfunction cloneMap(map, isDeep, cloneFunc) {\n  var array = isDeep ? cloneFunc(mapToArray(map), true) : mapToArray(map);\n  return arrayReduce(array, addMapEntry, new map.constructor);\n}\n\n/**\n * Creates a clone of `regexp`.\n *\n * @private\n * @param {Object} regexp The regexp to clone.\n * @returns {Object} Returns the cloned regexp.\n */\nfunction cloneRegExp(regexp) {\n  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));\n  result.lastIndex = regexp.lastIndex;\n  return result;\n}\n\n/**\n * Creates a clone of `set`.\n *\n * @private\n * @param {Object} set The set to clone.\n * @param {Function} cloneFunc The function to clone values.\n * @param {boolean} [isDeep] Specify a deep clone.\n * @returns {Object} Returns the cloned set.\n */\nfunction cloneSet(set, isDeep, cloneFunc) {\n  var array = isDeep ? cloneFunc(setToArray(set), true) : setToArray(set);\n  return arrayReduce(array, addSetEntry, new set.constructor);\n}\n\n/**\n * Creates a clone of the `symbol` object.\n *\n * @private\n * @param {Object} symbol The symbol object to clone.\n * @returns {Object} Returns the cloned symbol object.\n */\nfunction cloneSymbol(symbol) {\n  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};\n}\n\n/**\n * Creates a clone of `typedArray`.\n *\n * @private\n * @param {Object} typedArray The typed array to clone.\n * @param {boolean} [isDeep] Specify a deep clone.\n * @returns {Object} Returns the cloned typed array.\n */\nfunction cloneTypedArray(typedArray, isDeep) {\n  var buffer = isDeep ? cloneArrayBuffer(typedArray.buffer) : typedArray.buffer;\n  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);\n}\n\n/**\n * Copies the values of `source` to `array`.\n *\n * @private\n * @param {Array} source The array to copy values from.\n * @param {Array} [array=[]] The array to copy values to.\n * @returns {Array} Returns `array`.\n */\nfunction copyArray(source, array) {\n  var index = -1,\n      length = source.length;\n\n  array || (array = Array(length));\n  while (++index < length) {\n    array[index] = source[index];\n  }\n  return array;\n}\n\n/**\n * Copies properties of `source` to `object`.\n *\n * @private\n * @param {Object} source The object to copy properties from.\n * @param {Array} props The property identifiers to copy.\n * @param {Object} [object={}] The object to copy properties to.\n * @param {Function} [customizer] The function to customize copied values.\n * @returns {Object} Returns `object`.\n */\nfunction copyObject(source, props, object, customizer) {\n  object || (object = {});\n\n  var index = -1,\n      length = props.length;\n\n  while (++index < length) {\n    var key = props[index];\n\n    var newValue = customizer\n      ? customizer(object[key], source[key], key, object, source)\n      : undefined;\n\n    assignValue(object, key, newValue === undefined ? source[key] : newValue);\n  }\n  return object;\n}\n\n/**\n * Copies own symbol properties of `source` to `object`.\n *\n * @private\n * @param {Object} source The object to copy symbols from.\n * @param {Object} [object={}] The object to copy symbols to.\n * @returns {Object} Returns `object`.\n */\nfunction copySymbols(source, object) {\n  return copyObject(source, getSymbols(source), object);\n}\n\n/**\n * Creates an array of own enumerable property names and symbols of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names and symbols.\n */\nfunction getAllKeys(object) {\n  return baseGetAllKeys(object, keys, getSymbols);\n}\n\n/**\n * Gets the data for `map`.\n *\n * @private\n * @param {Object} map The map to query.\n * @param {string} key The reference key.\n * @returns {*} Returns the map data.\n */\nfunction getMapData(map, key) {\n  var data = map.__data__;\n  return isKeyable(key)\n    ? data[typeof key == 'string' ? 'string' : 'hash']\n    : data.map;\n}\n\n/**\n * Gets the native function at `key` of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @param {string} key The key of the method to get.\n * @returns {*} Returns the function if it's native, else `undefined`.\n */\nfunction getNative(object, key) {\n  var value = getValue(object, key);\n  return baseIsNative(value) ? value : undefined;\n}\n\n/**\n * Creates an array of the own enumerable symbol properties of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of symbols.\n */\nvar getSymbols = nativeGetSymbols ? overArg(nativeGetSymbols, Object) : stubArray;\n\n/**\n * Gets the `toStringTag` of `value`.\n *\n * @private\n * @param {*} value The value to query.\n * @returns {string} Returns the `toStringTag`.\n */\nvar getTag = baseGetTag;\n\n// Fallback for data views, maps, sets, and weak maps in IE 11,\n// for data views in Edge < 14, and promises in Node.js.\nif ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||\n    (Map && getTag(new Map) != mapTag) ||\n    (Promise && getTag(Promise.resolve()) != promiseTag) ||\n    (Set && getTag(new Set) != setTag) ||\n    (WeakMap && getTag(new WeakMap) != weakMapTag)) {\n  getTag = function(value) {\n    var result = objectToString.call(value),\n        Ctor = result == objectTag ? value.constructor : undefined,\n        ctorString = Ctor ? toSource(Ctor) : undefined;\n\n    if (ctorString) {\n      switch (ctorString) {\n        case dataViewCtorString: return dataViewTag;\n        case mapCtorString: return mapTag;\n        case promiseCtorString: return promiseTag;\n        case setCtorString: return setTag;\n        case weakMapCtorString: return weakMapTag;\n      }\n    }\n    return result;\n  };\n}\n\n/**\n * Initializes an array clone.\n *\n * @private\n * @param {Array} array The array to clone.\n * @returns {Array} Returns the initialized clone.\n */\nfunction initCloneArray(array) {\n  var length = array.length,\n      result = array.constructor(length);\n\n  // Add properties assigned by `RegExp#exec`.\n  if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {\n    result.index = array.index;\n    result.input = array.input;\n  }\n  return result;\n}\n\n/**\n * Initializes an object clone.\n *\n * @private\n * @param {Object} object The object to clone.\n * @returns {Object} Returns the initialized clone.\n */\nfunction initCloneObject(object) {\n  return (typeof object.constructor == 'function' && !isPrototype(object))\n    ? baseCreate(getPrototype(object))\n    : {};\n}\n\n/**\n * Initializes an object clone based on its `toStringTag`.\n *\n * **Note:** This function only supports cloning values with tags of\n * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.\n *\n * @private\n * @param {Object} object The object to clone.\n * @param {string} tag The `toStringTag` of the object to clone.\n * @param {Function} cloneFunc The function to clone values.\n * @param {boolean} [isDeep] Specify a deep clone.\n * @returns {Object} Returns the initialized clone.\n */\nfunction initCloneByTag(object, tag, cloneFunc, isDeep) {\n  var Ctor = object.constructor;\n  switch (tag) {\n    case arrayBufferTag:\n      return cloneArrayBuffer(object);\n\n    case boolTag:\n    case dateTag:\n      return new Ctor(+object);\n\n    case dataViewTag:\n      return cloneDataView(object, isDeep);\n\n    case float32Tag: case float64Tag:\n    case int8Tag: case int16Tag: case int32Tag:\n    case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:\n      return cloneTypedArray(object, isDeep);\n\n    case mapTag:\n      return cloneMap(object, isDeep, cloneFunc);\n\n    case numberTag:\n    case stringTag:\n      return new Ctor(object);\n\n    case regexpTag:\n      return cloneRegExp(object);\n\n    case setTag:\n      return cloneSet(object, isDeep, cloneFunc);\n\n    case symbolTag:\n      return cloneSymbol(object);\n  }\n}\n\n/**\n * Checks if `value` is a valid array-like index.\n *\n * @private\n * @param {*} value The value to check.\n * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.\n * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.\n */\nfunction isIndex(value, length) {\n  length = length == null ? MAX_SAFE_INTEGER : length;\n  return !!length &&\n    (typeof value == 'number' || reIsUint.test(value)) &&\n    (value > -1 && value % 1 == 0 && value < length);\n}\n\n/**\n * Checks if `value` is suitable for use as unique object key.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is suitable, else `false`.\n */\nfunction isKeyable(value) {\n  var type = typeof value;\n  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')\n    ? (value !== '__proto__')\n    : (value === null);\n}\n\n/**\n * Checks if `func` has its source masked.\n *\n * @private\n * @param {Function} func The function to check.\n * @returns {boolean} Returns `true` if `func` is masked, else `false`.\n */\nfunction isMasked(func) {\n  return !!maskSrcKey && (maskSrcKey in func);\n}\n\n/**\n * Checks if `value` is likely a prototype object.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.\n */\nfunction isPrototype(value) {\n  var Ctor = value && value.constructor,\n      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;\n\n  return value === proto;\n}\n\n/**\n * Converts `func` to its source code.\n *\n * @private\n * @param {Function} func The function to process.\n * @returns {string} Returns the source code.\n */\nfunction toSource(func) {\n  if (func != null) {\n    try {\n      return funcToString.call(func);\n    } catch (e) {}\n    try {\n      return (func + '');\n    } catch (e) {}\n  }\n  return '';\n}\n\n/**\n * This method is like `_.clone` except that it recursively clones `value`.\n *\n * @static\n * @memberOf _\n * @since 1.0.0\n * @category Lang\n * @param {*} value The value to recursively clone.\n * @returns {*} Returns the deep cloned value.\n * @see _.clone\n * @example\n *\n * var objects = [{ 'a': 1 }, { 'b': 2 }];\n *\n * var deep = _.cloneDeep(objects);\n * console.log(deep[0] === objects[0]);\n * // => false\n */\nfunction cloneDeep(value) {\n  return baseClone(value, true, true);\n}\n\n/**\n * Performs a\n * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)\n * comparison between two values to determine if they are equivalent.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to compare.\n * @param {*} other The other value to compare.\n * @returns {boolean} Returns `true` if the values are equivalent, else `false`.\n * @example\n *\n * var object = { 'a': 1 };\n * var other = { 'a': 1 };\n *\n * _.eq(object, object);\n * // => true\n *\n * _.eq(object, other);\n * // => false\n *\n * _.eq('a', 'a');\n * // => true\n *\n * _.eq('a', Object('a'));\n * // => false\n *\n * _.eq(NaN, NaN);\n * // => true\n */\nfunction eq(value, other) {\n  return value === other || (value !== value && other !== other);\n}\n\n/**\n * Checks if `value` is likely an `arguments` object.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an `arguments` object,\n *  else `false`.\n * @example\n *\n * _.isArguments(function() { return arguments; }());\n * // => true\n *\n * _.isArguments([1, 2, 3]);\n * // => false\n */\nfunction isArguments(value) {\n  // Safari 8.1 makes `arguments.callee` enumerable in strict mode.\n  return isArrayLikeObject(value) && hasOwnProperty.call(value, 'callee') &&\n    (!propertyIsEnumerable.call(value, 'callee') || objectToString.call(value) == argsTag);\n}\n\n/**\n * Checks if `value` is classified as an `Array` object.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an array, else `false`.\n * @example\n *\n * _.isArray([1, 2, 3]);\n * // => true\n *\n * _.isArray(document.body.children);\n * // => false\n *\n * _.isArray('abc');\n * // => false\n *\n * _.isArray(_.noop);\n * // => false\n */\nvar isArray = Array.isArray;\n\n/**\n * Checks if `value` is array-like. A value is considered array-like if it's\n * not a function and has a `value.length` that's an integer greater than or\n * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is array-like, else `false`.\n * @example\n *\n * _.isArrayLike([1, 2, 3]);\n * // => true\n *\n * _.isArrayLike(document.body.children);\n * // => true\n *\n * _.isArrayLike('abc');\n * // => true\n *\n * _.isArrayLike(_.noop);\n * // => false\n */\nfunction isArrayLike(value) {\n  return value != null && isLength(value.length) && !isFunction(value);\n}\n\n/**\n * This method is like `_.isArrayLike` except that it also checks if `value`\n * is an object.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an array-like object,\n *  else `false`.\n * @example\n *\n * _.isArrayLikeObject([1, 2, 3]);\n * // => true\n *\n * _.isArrayLikeObject(document.body.children);\n * // => true\n *\n * _.isArrayLikeObject('abc');\n * // => false\n *\n * _.isArrayLikeObject(_.noop);\n * // => false\n */\nfunction isArrayLikeObject(value) {\n  return isObjectLike(value) && isArrayLike(value);\n}\n\n/**\n * Checks if `value` is a buffer.\n *\n * @static\n * @memberOf _\n * @since 4.3.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.\n * @example\n *\n * _.isBuffer(new Buffer(2));\n * // => true\n *\n * _.isBuffer(new Uint8Array(2));\n * // => false\n */\nvar isBuffer = nativeIsBuffer || stubFalse;\n\n/**\n * Checks if `value` is classified as a `Function` object.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a function, else `false`.\n * @example\n *\n * _.isFunction(_);\n * // => true\n *\n * _.isFunction(/abc/);\n * // => false\n */\nfunction isFunction(value) {\n  // The use of `Object#toString` avoids issues with the `typeof` operator\n  // in Safari 8-9 which returns 'object' for typed array and other constructors.\n  var tag = isObject(value) ? objectToString.call(value) : '';\n  return tag == funcTag || tag == genTag;\n}\n\n/**\n * Checks if `value` is a valid array-like length.\n *\n * **Note:** This method is loosely based on\n * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.\n * @example\n *\n * _.isLength(3);\n * // => true\n *\n * _.isLength(Number.MIN_VALUE);\n * // => false\n *\n * _.isLength(Infinity);\n * // => false\n *\n * _.isLength('3');\n * // => false\n */\nfunction isLength(value) {\n  return typeof value == 'number' &&\n    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;\n}\n\n/**\n * Checks if `value` is the\n * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)\n * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an object, else `false`.\n * @example\n *\n * _.isObject({});\n * // => true\n *\n * _.isObject([1, 2, 3]);\n * // => true\n *\n * _.isObject(_.noop);\n * // => true\n *\n * _.isObject(null);\n * // => false\n */\nfunction isObject(value) {\n  var type = typeof value;\n  return !!value && (type == 'object' || type == 'function');\n}\n\n/**\n * Checks if `value` is object-like. A value is object-like if it's not `null`\n * and has a `typeof` result of \"object\".\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is object-like, else `false`.\n * @example\n *\n * _.isObjectLike({});\n * // => true\n *\n * _.isObjectLike([1, 2, 3]);\n * // => true\n *\n * _.isObjectLike(_.noop);\n * // => false\n *\n * _.isObjectLike(null);\n * // => false\n */\nfunction isObjectLike(value) {\n  return !!value && typeof value == 'object';\n}\n\n/**\n * Creates an array of the own enumerable property names of `object`.\n *\n * **Note:** Non-object values are coerced to objects. See the\n * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)\n * for more details.\n *\n * @static\n * @since 0.1.0\n * @memberOf _\n * @category Object\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names.\n * @example\n *\n * function Foo() {\n *   this.a = 1;\n *   this.b = 2;\n * }\n *\n * Foo.prototype.c = 3;\n *\n * _.keys(new Foo);\n * // => ['a', 'b'] (iteration order is not guaranteed)\n *\n * _.keys('hi');\n * // => ['0', '1']\n */\nfunction keys(object) {\n  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);\n}\n\n/**\n * This method returns a new empty array.\n *\n * @static\n * @memberOf _\n * @since 4.13.0\n * @category Util\n * @returns {Array} Returns the new empty array.\n * @example\n *\n * var arrays = _.times(2, _.stubArray);\n *\n * console.log(arrays);\n * // => [[], []]\n *\n * console.log(arrays[0] === arrays[1]);\n * // => false\n */\nfunction stubArray() {\n  return [];\n}\n\n/**\n * This method returns `false`.\n *\n * @static\n * @memberOf _\n * @since 4.13.0\n * @category Util\n * @returns {boolean} Returns `false`.\n * @example\n *\n * _.times(2, _.stubFalse);\n * // => [false, false]\n */\nfunction stubFalse() {\n  return false;\n}\n\nmodule.exports = cloneDeep;\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash.clonedeep/index.js?")},"./node_modules/lodash.isequal/index.js":function(module,exports,__webpack_require__){eval("/* module decorator */ module = __webpack_require__.nmd(module);\n/**\n * Lodash (Custom Build) <https://lodash.com/>\n * Build: `lodash modularize exports=\"npm\" -o ./`\n * Copyright JS Foundation and other contributors <https://js.foundation/>\n * Released under MIT license <https://lodash.com/license>\n * Based on Underscore.js 1.8.3 <http://underscorejs.org/LICENSE>\n * Copyright Jeremy Ashkenas, DocumentCloud and Investigative Reporters & Editors\n */\n\n/** Used as the size to enable large array optimizations. */\nvar LARGE_ARRAY_SIZE = 200;\n\n/** Used to stand-in for `undefined` hash values. */\nvar HASH_UNDEFINED = '__lodash_hash_undefined__';\n\n/** Used to compose bitmasks for value comparisons. */\nvar COMPARE_PARTIAL_FLAG = 1,\n    COMPARE_UNORDERED_FLAG = 2;\n\n/** Used as references for various `Number` constants. */\nvar MAX_SAFE_INTEGER = 9007199254740991;\n\n/** `Object#toString` result references. */\nvar argsTag = '[object Arguments]',\n    arrayTag = '[object Array]',\n    asyncTag = '[object AsyncFunction]',\n    boolTag = '[object Boolean]',\n    dateTag = '[object Date]',\n    errorTag = '[object Error]',\n    funcTag = '[object Function]',\n    genTag = '[object GeneratorFunction]',\n    mapTag = '[object Map]',\n    numberTag = '[object Number]',\n    nullTag = '[object Null]',\n    objectTag = '[object Object]',\n    promiseTag = '[object Promise]',\n    proxyTag = '[object Proxy]',\n    regexpTag = '[object RegExp]',\n    setTag = '[object Set]',\n    stringTag = '[object String]',\n    symbolTag = '[object Symbol]',\n    undefinedTag = '[object Undefined]',\n    weakMapTag = '[object WeakMap]';\n\nvar arrayBufferTag = '[object ArrayBuffer]',\n    dataViewTag = '[object DataView]',\n    float32Tag = '[object Float32Array]',\n    float64Tag = '[object Float64Array]',\n    int8Tag = '[object Int8Array]',\n    int16Tag = '[object Int16Array]',\n    int32Tag = '[object Int32Array]',\n    uint8Tag = '[object Uint8Array]',\n    uint8ClampedTag = '[object Uint8ClampedArray]',\n    uint16Tag = '[object Uint16Array]',\n    uint32Tag = '[object Uint32Array]';\n\n/**\n * Used to match `RegExp`\n * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).\n */\nvar reRegExpChar = /[\\\\^$.*+?()[\\]{}|]/g;\n\n/** Used to detect host constructors (Safari). */\nvar reIsHostCtor = /^\\[object .+?Constructor\\]$/;\n\n/** Used to detect unsigned integer values. */\nvar reIsUint = /^(?:0|[1-9]\\d*)$/;\n\n/** Used to identify `toStringTag` values of typed arrays. */\nvar typedArrayTags = {};\ntypedArrayTags[float32Tag] = typedArrayTags[float64Tag] =\ntypedArrayTags[int8Tag] = typedArrayTags[int16Tag] =\ntypedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =\ntypedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =\ntypedArrayTags[uint32Tag] = true;\ntypedArrayTags[argsTag] = typedArrayTags[arrayTag] =\ntypedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =\ntypedArrayTags[dataViewTag] = typedArrayTags[dateTag] =\ntypedArrayTags[errorTag] = typedArrayTags[funcTag] =\ntypedArrayTags[mapTag] = typedArrayTags[numberTag] =\ntypedArrayTags[objectTag] = typedArrayTags[regexpTag] =\ntypedArrayTags[setTag] = typedArrayTags[stringTag] =\ntypedArrayTags[weakMapTag] = false;\n\n/** Detect free variable `global` from Node.js. */\nvar freeGlobal = typeof __webpack_require__.g == 'object' && __webpack_require__.g && __webpack_require__.g.Object === Object && __webpack_require__.g;\n\n/** Detect free variable `self`. */\nvar freeSelf = typeof self == 'object' && self && self.Object === Object && self;\n\n/** Used as a reference to the global object. */\nvar root = freeGlobal || freeSelf || Function('return this')();\n\n/** Detect free variable `exports`. */\nvar freeExports =  true && exports && !exports.nodeType && exports;\n\n/** Detect free variable `module`. */\nvar freeModule = freeExports && \"object\" == 'object' && module && !module.nodeType && module;\n\n/** Detect the popular CommonJS extension `module.exports`. */\nvar moduleExports = freeModule && freeModule.exports === freeExports;\n\n/** Detect free variable `process` from Node.js. */\nvar freeProcess = moduleExports && freeGlobal.process;\n\n/** Used to access faster Node.js helpers. */\nvar nodeUtil = (function() {\n  try {\n    return freeProcess && freeProcess.binding && freeProcess.binding('util');\n  } catch (e) {}\n}());\n\n/* Node.js helper references. */\nvar nodeIsTypedArray = nodeUtil && nodeUtil.isTypedArray;\n\n/**\n * A specialized version of `_.filter` for arrays without support for\n * iteratee shorthands.\n *\n * @private\n * @param {Array} [array] The array to iterate over.\n * @param {Function} predicate The function invoked per iteration.\n * @returns {Array} Returns the new filtered array.\n */\nfunction arrayFilter(array, predicate) {\n  var index = -1,\n      length = array == null ? 0 : array.length,\n      resIndex = 0,\n      result = [];\n\n  while (++index < length) {\n    var value = array[index];\n    if (predicate(value, index, array)) {\n      result[resIndex++] = value;\n    }\n  }\n  return result;\n}\n\n/**\n * Appends the elements of `values` to `array`.\n *\n * @private\n * @param {Array} array The array to modify.\n * @param {Array} values The values to append.\n * @returns {Array} Returns `array`.\n */\nfunction arrayPush(array, values) {\n  var index = -1,\n      length = values.length,\n      offset = array.length;\n\n  while (++index < length) {\n    array[offset + index] = values[index];\n  }\n  return array;\n}\n\n/**\n * A specialized version of `_.some` for arrays without support for iteratee\n * shorthands.\n *\n * @private\n * @param {Array} [array] The array to iterate over.\n * @param {Function} predicate The function invoked per iteration.\n * @returns {boolean} Returns `true` if any element passes the predicate check,\n *  else `false`.\n */\nfunction arraySome(array, predicate) {\n  var index = -1,\n      length = array == null ? 0 : array.length;\n\n  while (++index < length) {\n    if (predicate(array[index], index, array)) {\n      return true;\n    }\n  }\n  return false;\n}\n\n/**\n * The base implementation of `_.times` without support for iteratee shorthands\n * or max array length checks.\n *\n * @private\n * @param {number} n The number of times to invoke `iteratee`.\n * @param {Function} iteratee The function invoked per iteration.\n * @returns {Array} Returns the array of results.\n */\nfunction baseTimes(n, iteratee) {\n  var index = -1,\n      result = Array(n);\n\n  while (++index < n) {\n    result[index] = iteratee(index);\n  }\n  return result;\n}\n\n/**\n * The base implementation of `_.unary` without support for storing metadata.\n *\n * @private\n * @param {Function} func The function to cap arguments for.\n * @returns {Function} Returns the new capped function.\n */\nfunction baseUnary(func) {\n  return function(value) {\n    return func(value);\n  };\n}\n\n/**\n * Checks if a `cache` value for `key` exists.\n *\n * @private\n * @param {Object} cache The cache to query.\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction cacheHas(cache, key) {\n  return cache.has(key);\n}\n\n/**\n * Gets the value at `key` of `object`.\n *\n * @private\n * @param {Object} [object] The object to query.\n * @param {string} key The key of the property to get.\n * @returns {*} Returns the property value.\n */\nfunction getValue(object, key) {\n  return object == null ? undefined : object[key];\n}\n\n/**\n * Converts `map` to its key-value pairs.\n *\n * @private\n * @param {Object} map The map to convert.\n * @returns {Array} Returns the key-value pairs.\n */\nfunction mapToArray(map) {\n  var index = -1,\n      result = Array(map.size);\n\n  map.forEach(function(value, key) {\n    result[++index] = [key, value];\n  });\n  return result;\n}\n\n/**\n * Creates a unary function that invokes `func` with its argument transformed.\n *\n * @private\n * @param {Function} func The function to wrap.\n * @param {Function} transform The argument transform.\n * @returns {Function} Returns the new function.\n */\nfunction overArg(func, transform) {\n  return function(arg) {\n    return func(transform(arg));\n  };\n}\n\n/**\n * Converts `set` to an array of its values.\n *\n * @private\n * @param {Object} set The set to convert.\n * @returns {Array} Returns the values.\n */\nfunction setToArray(set) {\n  var index = -1,\n      result = Array(set.size);\n\n  set.forEach(function(value) {\n    result[++index] = value;\n  });\n  return result;\n}\n\n/** Used for built-in method references. */\nvar arrayProto = Array.prototype,\n    funcProto = Function.prototype,\n    objectProto = Object.prototype;\n\n/** Used to detect overreaching core-js shims. */\nvar coreJsData = root['__core-js_shared__'];\n\n/** Used to resolve the decompiled source of functions. */\nvar funcToString = funcProto.toString;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/** Used to detect methods masquerading as native. */\nvar maskSrcKey = (function() {\n  var uid = /[^.]+$/.exec(coreJsData && coreJsData.keys && coreJsData.keys.IE_PROTO || '');\n  return uid ? ('Symbol(src)_1.' + uid) : '';\n}());\n\n/**\n * Used to resolve the\n * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)\n * of values.\n */\nvar nativeObjectToString = objectProto.toString;\n\n/** Used to detect if a method is native. */\nvar reIsNative = RegExp('^' +\n  funcToString.call(hasOwnProperty).replace(reRegExpChar, '\\\\$&')\n  .replace(/hasOwnProperty|(function).*?(?=\\\\\\()| for .+?(?=\\\\\\])/g, '$1.*?') + '$'\n);\n\n/** Built-in value references. */\nvar Buffer = moduleExports ? root.Buffer : undefined,\n    Symbol = root.Symbol,\n    Uint8Array = root.Uint8Array,\n    propertyIsEnumerable = objectProto.propertyIsEnumerable,\n    splice = arrayProto.splice,\n    symToStringTag = Symbol ? Symbol.toStringTag : undefined;\n\n/* Built-in method references for those with the same name as other `lodash` methods. */\nvar nativeGetSymbols = Object.getOwnPropertySymbols,\n    nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined,\n    nativeKeys = overArg(Object.keys, Object);\n\n/* Built-in method references that are verified to be native. */\nvar DataView = getNative(root, 'DataView'),\n    Map = getNative(root, 'Map'),\n    Promise = getNative(root, 'Promise'),\n    Set = getNative(root, 'Set'),\n    WeakMap = getNative(root, 'WeakMap'),\n    nativeCreate = getNative(Object, 'create');\n\n/** Used to detect maps, sets, and weakmaps. */\nvar dataViewCtorString = toSource(DataView),\n    mapCtorString = toSource(Map),\n    promiseCtorString = toSource(Promise),\n    setCtorString = toSource(Set),\n    weakMapCtorString = toSource(WeakMap);\n\n/** Used to convert symbols to primitives and strings. */\nvar symbolProto = Symbol ? Symbol.prototype : undefined,\n    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;\n\n/**\n * Creates a hash object.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction Hash(entries) {\n  var index = -1,\n      length = entries == null ? 0 : entries.length;\n\n  this.clear();\n  while (++index < length) {\n    var entry = entries[index];\n    this.set(entry[0], entry[1]);\n  }\n}\n\n/**\n * Removes all key-value entries from the hash.\n *\n * @private\n * @name clear\n * @memberOf Hash\n */\nfunction hashClear() {\n  this.__data__ = nativeCreate ? nativeCreate(null) : {};\n  this.size = 0;\n}\n\n/**\n * Removes `key` and its value from the hash.\n *\n * @private\n * @name delete\n * @memberOf Hash\n * @param {Object} hash The hash to modify.\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction hashDelete(key) {\n  var result = this.has(key) && delete this.__data__[key];\n  this.size -= result ? 1 : 0;\n  return result;\n}\n\n/**\n * Gets the hash value for `key`.\n *\n * @private\n * @name get\n * @memberOf Hash\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction hashGet(key) {\n  var data = this.__data__;\n  if (nativeCreate) {\n    var result = data[key];\n    return result === HASH_UNDEFINED ? undefined : result;\n  }\n  return hasOwnProperty.call(data, key) ? data[key] : undefined;\n}\n\n/**\n * Checks if a hash value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf Hash\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction hashHas(key) {\n  var data = this.__data__;\n  return nativeCreate ? (data[key] !== undefined) : hasOwnProperty.call(data, key);\n}\n\n/**\n * Sets the hash `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf Hash\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the hash instance.\n */\nfunction hashSet(key, value) {\n  var data = this.__data__;\n  this.size += this.has(key) ? 0 : 1;\n  data[key] = (nativeCreate && value === undefined) ? HASH_UNDEFINED : value;\n  return this;\n}\n\n// Add methods to `Hash`.\nHash.prototype.clear = hashClear;\nHash.prototype['delete'] = hashDelete;\nHash.prototype.get = hashGet;\nHash.prototype.has = hashHas;\nHash.prototype.set = hashSet;\n\n/**\n * Creates an list cache object.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction ListCache(entries) {\n  var index = -1,\n      length = entries == null ? 0 : entries.length;\n\n  this.clear();\n  while (++index < length) {\n    var entry = entries[index];\n    this.set(entry[0], entry[1]);\n  }\n}\n\n/**\n * Removes all key-value entries from the list cache.\n *\n * @private\n * @name clear\n * @memberOf ListCache\n */\nfunction listCacheClear() {\n  this.__data__ = [];\n  this.size = 0;\n}\n\n/**\n * Removes `key` and its value from the list cache.\n *\n * @private\n * @name delete\n * @memberOf ListCache\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction listCacheDelete(key) {\n  var data = this.__data__,\n      index = assocIndexOf(data, key);\n\n  if (index < 0) {\n    return false;\n  }\n  var lastIndex = data.length - 1;\n  if (index == lastIndex) {\n    data.pop();\n  } else {\n    splice.call(data, index, 1);\n  }\n  --this.size;\n  return true;\n}\n\n/**\n * Gets the list cache value for `key`.\n *\n * @private\n * @name get\n * @memberOf ListCache\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction listCacheGet(key) {\n  var data = this.__data__,\n      index = assocIndexOf(data, key);\n\n  return index < 0 ? undefined : data[index][1];\n}\n\n/**\n * Checks if a list cache value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf ListCache\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction listCacheHas(key) {\n  return assocIndexOf(this.__data__, key) > -1;\n}\n\n/**\n * Sets the list cache `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf ListCache\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the list cache instance.\n */\nfunction listCacheSet(key, value) {\n  var data = this.__data__,\n      index = assocIndexOf(data, key);\n\n  if (index < 0) {\n    ++this.size;\n    data.push([key, value]);\n  } else {\n    data[index][1] = value;\n  }\n  return this;\n}\n\n// Add methods to `ListCache`.\nListCache.prototype.clear = listCacheClear;\nListCache.prototype['delete'] = listCacheDelete;\nListCache.prototype.get = listCacheGet;\nListCache.prototype.has = listCacheHas;\nListCache.prototype.set = listCacheSet;\n\n/**\n * Creates a map cache object to store key-value pairs.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction MapCache(entries) {\n  var index = -1,\n      length = entries == null ? 0 : entries.length;\n\n  this.clear();\n  while (++index < length) {\n    var entry = entries[index];\n    this.set(entry[0], entry[1]);\n  }\n}\n\n/**\n * Removes all key-value entries from the map.\n *\n * @private\n * @name clear\n * @memberOf MapCache\n */\nfunction mapCacheClear() {\n  this.size = 0;\n  this.__data__ = {\n    'hash': new Hash,\n    'map': new (Map || ListCache),\n    'string': new Hash\n  };\n}\n\n/**\n * Removes `key` and its value from the map.\n *\n * @private\n * @name delete\n * @memberOf MapCache\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction mapCacheDelete(key) {\n  var result = getMapData(this, key)['delete'](key);\n  this.size -= result ? 1 : 0;\n  return result;\n}\n\n/**\n * Gets the map value for `key`.\n *\n * @private\n * @name get\n * @memberOf MapCache\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction mapCacheGet(key) {\n  return getMapData(this, key).get(key);\n}\n\n/**\n * Checks if a map value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf MapCache\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction mapCacheHas(key) {\n  return getMapData(this, key).has(key);\n}\n\n/**\n * Sets the map `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf MapCache\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the map cache instance.\n */\nfunction mapCacheSet(key, value) {\n  var data = getMapData(this, key),\n      size = data.size;\n\n  data.set(key, value);\n  this.size += data.size == size ? 0 : 1;\n  return this;\n}\n\n// Add methods to `MapCache`.\nMapCache.prototype.clear = mapCacheClear;\nMapCache.prototype['delete'] = mapCacheDelete;\nMapCache.prototype.get = mapCacheGet;\nMapCache.prototype.has = mapCacheHas;\nMapCache.prototype.set = mapCacheSet;\n\n/**\n *\n * Creates an array cache object to store unique values.\n *\n * @private\n * @constructor\n * @param {Array} [values] The values to cache.\n */\nfunction SetCache(values) {\n  var index = -1,\n      length = values == null ? 0 : values.length;\n\n  this.__data__ = new MapCache;\n  while (++index < length) {\n    this.add(values[index]);\n  }\n}\n\n/**\n * Adds `value` to the array cache.\n *\n * @private\n * @name add\n * @memberOf SetCache\n * @alias push\n * @param {*} value The value to cache.\n * @returns {Object} Returns the cache instance.\n */\nfunction setCacheAdd(value) {\n  this.__data__.set(value, HASH_UNDEFINED);\n  return this;\n}\n\n/**\n * Checks if `value` is in the array cache.\n *\n * @private\n * @name has\n * @memberOf SetCache\n * @param {*} value The value to search for.\n * @returns {number} Returns `true` if `value` is found, else `false`.\n */\nfunction setCacheHas(value) {\n  return this.__data__.has(value);\n}\n\n// Add methods to `SetCache`.\nSetCache.prototype.add = SetCache.prototype.push = setCacheAdd;\nSetCache.prototype.has = setCacheHas;\n\n/**\n * Creates a stack cache object to store key-value pairs.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction Stack(entries) {\n  var data = this.__data__ = new ListCache(entries);\n  this.size = data.size;\n}\n\n/**\n * Removes all key-value entries from the stack.\n *\n * @private\n * @name clear\n * @memberOf Stack\n */\nfunction stackClear() {\n  this.__data__ = new ListCache;\n  this.size = 0;\n}\n\n/**\n * Removes `key` and its value from the stack.\n *\n * @private\n * @name delete\n * @memberOf Stack\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction stackDelete(key) {\n  var data = this.__data__,\n      result = data['delete'](key);\n\n  this.size = data.size;\n  return result;\n}\n\n/**\n * Gets the stack value for `key`.\n *\n * @private\n * @name get\n * @memberOf Stack\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction stackGet(key) {\n  return this.__data__.get(key);\n}\n\n/**\n * Checks if a stack value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf Stack\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction stackHas(key) {\n  return this.__data__.has(key);\n}\n\n/**\n * Sets the stack `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf Stack\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the stack cache instance.\n */\nfunction stackSet(key, value) {\n  var data = this.__data__;\n  if (data instanceof ListCache) {\n    var pairs = data.__data__;\n    if (!Map || (pairs.length < LARGE_ARRAY_SIZE - 1)) {\n      pairs.push([key, value]);\n      this.size = ++data.size;\n      return this;\n    }\n    data = this.__data__ = new MapCache(pairs);\n  }\n  data.set(key, value);\n  this.size = data.size;\n  return this;\n}\n\n// Add methods to `Stack`.\nStack.prototype.clear = stackClear;\nStack.prototype['delete'] = stackDelete;\nStack.prototype.get = stackGet;\nStack.prototype.has = stackHas;\nStack.prototype.set = stackSet;\n\n/**\n * Creates an array of the enumerable property names of the array-like `value`.\n *\n * @private\n * @param {*} value The value to query.\n * @param {boolean} inherited Specify returning inherited property names.\n * @returns {Array} Returns the array of property names.\n */\nfunction arrayLikeKeys(value, inherited) {\n  var isArr = isArray(value),\n      isArg = !isArr && isArguments(value),\n      isBuff = !isArr && !isArg && isBuffer(value),\n      isType = !isArr && !isArg && !isBuff && isTypedArray(value),\n      skipIndexes = isArr || isArg || isBuff || isType,\n      result = skipIndexes ? baseTimes(value.length, String) : [],\n      length = result.length;\n\n  for (var key in value) {\n    if ((inherited || hasOwnProperty.call(value, key)) &&\n        !(skipIndexes && (\n           // Safari 9 has enumerable `arguments.length` in strict mode.\n           key == 'length' ||\n           // Node.js 0.10 has enumerable non-index properties on buffers.\n           (isBuff && (key == 'offset' || key == 'parent')) ||\n           // PhantomJS 2 has enumerable non-index properties on typed arrays.\n           (isType && (key == 'buffer' || key == 'byteLength' || key == 'byteOffset')) ||\n           // Skip index properties.\n           isIndex(key, length)\n        ))) {\n      result.push(key);\n    }\n  }\n  return result;\n}\n\n/**\n * Gets the index at which the `key` is found in `array` of key-value pairs.\n *\n * @private\n * @param {Array} array The array to inspect.\n * @param {*} key The key to search for.\n * @returns {number} Returns the index of the matched value, else `-1`.\n */\nfunction assocIndexOf(array, key) {\n  var length = array.length;\n  while (length--) {\n    if (eq(array[length][0], key)) {\n      return length;\n    }\n  }\n  return -1;\n}\n\n/**\n * The base implementation of `getAllKeys` and `getAllKeysIn` which uses\n * `keysFunc` and `symbolsFunc` to get the enumerable property names and\n * symbols of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @param {Function} keysFunc The function to get the keys of `object`.\n * @param {Function} symbolsFunc The function to get the symbols of `object`.\n * @returns {Array} Returns the array of property names and symbols.\n */\nfunction baseGetAllKeys(object, keysFunc, symbolsFunc) {\n  var result = keysFunc(object);\n  return isArray(object) ? result : arrayPush(result, symbolsFunc(object));\n}\n\n/**\n * The base implementation of `getTag` without fallbacks for buggy environments.\n *\n * @private\n * @param {*} value The value to query.\n * @returns {string} Returns the `toStringTag`.\n */\nfunction baseGetTag(value) {\n  if (value == null) {\n    return value === undefined ? undefinedTag : nullTag;\n  }\n  return (symToStringTag && symToStringTag in Object(value))\n    ? getRawTag(value)\n    : objectToString(value);\n}\n\n/**\n * The base implementation of `_.isArguments`.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an `arguments` object,\n */\nfunction baseIsArguments(value) {\n  return isObjectLike(value) && baseGetTag(value) == argsTag;\n}\n\n/**\n * The base implementation of `_.isEqual` which supports partial comparisons\n * and tracks traversed objects.\n *\n * @private\n * @param {*} value The value to compare.\n * @param {*} other The other value to compare.\n * @param {boolean} bitmask The bitmask flags.\n *  1 - Unordered comparison\n *  2 - Partial comparison\n * @param {Function} [customizer] The function to customize comparisons.\n * @param {Object} [stack] Tracks traversed `value` and `other` objects.\n * @returns {boolean} Returns `true` if the values are equivalent, else `false`.\n */\nfunction baseIsEqual(value, other, bitmask, customizer, stack) {\n  if (value === other) {\n    return true;\n  }\n  if (value == null || other == null || (!isObjectLike(value) && !isObjectLike(other))) {\n    return value !== value && other !== other;\n  }\n  return baseIsEqualDeep(value, other, bitmask, customizer, baseIsEqual, stack);\n}\n\n/**\n * A specialized version of `baseIsEqual` for arrays and objects which performs\n * deep comparisons and tracks traversed objects enabling objects with circular\n * references to be compared.\n *\n * @private\n * @param {Object} object The object to compare.\n * @param {Object} other The other object to compare.\n * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.\n * @param {Function} customizer The function to customize comparisons.\n * @param {Function} equalFunc The function to determine equivalents of values.\n * @param {Object} [stack] Tracks traversed `object` and `other` objects.\n * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.\n */\nfunction baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {\n  var objIsArr = isArray(object),\n      othIsArr = isArray(other),\n      objTag = objIsArr ? arrayTag : getTag(object),\n      othTag = othIsArr ? arrayTag : getTag(other);\n\n  objTag = objTag == argsTag ? objectTag : objTag;\n  othTag = othTag == argsTag ? objectTag : othTag;\n\n  var objIsObj = objTag == objectTag,\n      othIsObj = othTag == objectTag,\n      isSameTag = objTag == othTag;\n\n  if (isSameTag && isBuffer(object)) {\n    if (!isBuffer(other)) {\n      return false;\n    }\n    objIsArr = true;\n    objIsObj = false;\n  }\n  if (isSameTag && !objIsObj) {\n    stack || (stack = new Stack);\n    return (objIsArr || isTypedArray(object))\n      ? equalArrays(object, other, bitmask, customizer, equalFunc, stack)\n      : equalByTag(object, other, objTag, bitmask, customizer, equalFunc, stack);\n  }\n  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {\n    var objIsWrapped = objIsObj && hasOwnProperty.call(object, '__wrapped__'),\n        othIsWrapped = othIsObj && hasOwnProperty.call(other, '__wrapped__');\n\n    if (objIsWrapped || othIsWrapped) {\n      var objUnwrapped = objIsWrapped ? object.value() : object,\n          othUnwrapped = othIsWrapped ? other.value() : other;\n\n      stack || (stack = new Stack);\n      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);\n    }\n  }\n  if (!isSameTag) {\n    return false;\n  }\n  stack || (stack = new Stack);\n  return equalObjects(object, other, bitmask, customizer, equalFunc, stack);\n}\n\n/**\n * The base implementation of `_.isNative` without bad shim checks.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a native function,\n *  else `false`.\n */\nfunction baseIsNative(value) {\n  if (!isObject(value) || isMasked(value)) {\n    return false;\n  }\n  var pattern = isFunction(value) ? reIsNative : reIsHostCtor;\n  return pattern.test(toSource(value));\n}\n\n/**\n * The base implementation of `_.isTypedArray` without Node.js optimizations.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.\n */\nfunction baseIsTypedArray(value) {\n  return isObjectLike(value) &&\n    isLength(value.length) && !!typedArrayTags[baseGetTag(value)];\n}\n\n/**\n * The base implementation of `_.keys` which doesn't treat sparse arrays as dense.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names.\n */\nfunction baseKeys(object) {\n  if (!isPrototype(object)) {\n    return nativeKeys(object);\n  }\n  var result = [];\n  for (var key in Object(object)) {\n    if (hasOwnProperty.call(object, key) && key != 'constructor') {\n      result.push(key);\n    }\n  }\n  return result;\n}\n\n/**\n * A specialized version of `baseIsEqualDeep` for arrays with support for\n * partial deep comparisons.\n *\n * @private\n * @param {Array} array The array to compare.\n * @param {Array} other The other array to compare.\n * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.\n * @param {Function} customizer The function to customize comparisons.\n * @param {Function} equalFunc The function to determine equivalents of values.\n * @param {Object} stack Tracks traversed `array` and `other` objects.\n * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.\n */\nfunction equalArrays(array, other, bitmask, customizer, equalFunc, stack) {\n  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,\n      arrLength = array.length,\n      othLength = other.length;\n\n  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {\n    return false;\n  }\n  // Assume cyclic values are equal.\n  var stacked = stack.get(array);\n  if (stacked && stack.get(other)) {\n    return stacked == other;\n  }\n  var index = -1,\n      result = true,\n      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new SetCache : undefined;\n\n  stack.set(array, other);\n  stack.set(other, array);\n\n  // Ignore non-index properties.\n  while (++index < arrLength) {\n    var arrValue = array[index],\n        othValue = other[index];\n\n    if (customizer) {\n      var compared = isPartial\n        ? customizer(othValue, arrValue, index, other, array, stack)\n        : customizer(arrValue, othValue, index, array, other, stack);\n    }\n    if (compared !== undefined) {\n      if (compared) {\n        continue;\n      }\n      result = false;\n      break;\n    }\n    // Recursively compare arrays (susceptible to call stack limits).\n    if (seen) {\n      if (!arraySome(other, function(othValue, othIndex) {\n            if (!cacheHas(seen, othIndex) &&\n                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {\n              return seen.push(othIndex);\n            }\n          })) {\n        result = false;\n        break;\n      }\n    } else if (!(\n          arrValue === othValue ||\n            equalFunc(arrValue, othValue, bitmask, customizer, stack)\n        )) {\n      result = false;\n      break;\n    }\n  }\n  stack['delete'](array);\n  stack['delete'](other);\n  return result;\n}\n\n/**\n * A specialized version of `baseIsEqualDeep` for comparing objects of\n * the same `toStringTag`.\n *\n * **Note:** This function only supports comparing values with tags of\n * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.\n *\n * @private\n * @param {Object} object The object to compare.\n * @param {Object} other The other object to compare.\n * @param {string} tag The `toStringTag` of the objects to compare.\n * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.\n * @param {Function} customizer The function to customize comparisons.\n * @param {Function} equalFunc The function to determine equivalents of values.\n * @param {Object} stack Tracks traversed `object` and `other` objects.\n * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.\n */\nfunction equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {\n  switch (tag) {\n    case dataViewTag:\n      if ((object.byteLength != other.byteLength) ||\n          (object.byteOffset != other.byteOffset)) {\n        return false;\n      }\n      object = object.buffer;\n      other = other.buffer;\n\n    case arrayBufferTag:\n      if ((object.byteLength != other.byteLength) ||\n          !equalFunc(new Uint8Array(object), new Uint8Array(other))) {\n        return false;\n      }\n      return true;\n\n    case boolTag:\n    case dateTag:\n    case numberTag:\n      // Coerce booleans to `1` or `0` and dates to milliseconds.\n      // Invalid dates are coerced to `NaN`.\n      return eq(+object, +other);\n\n    case errorTag:\n      return object.name == other.name && object.message == other.message;\n\n    case regexpTag:\n    case stringTag:\n      // Coerce regexes to strings and treat strings, primitives and objects,\n      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring\n      // for more details.\n      return object == (other + '');\n\n    case mapTag:\n      var convert = mapToArray;\n\n    case setTag:\n      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;\n      convert || (convert = setToArray);\n\n      if (object.size != other.size && !isPartial) {\n        return false;\n      }\n      // Assume cyclic values are equal.\n      var stacked = stack.get(object);\n      if (stacked) {\n        return stacked == other;\n      }\n      bitmask |= COMPARE_UNORDERED_FLAG;\n\n      // Recursively compare objects (susceptible to call stack limits).\n      stack.set(object, other);\n      var result = equalArrays(convert(object), convert(other), bitmask, customizer, equalFunc, stack);\n      stack['delete'](object);\n      return result;\n\n    case symbolTag:\n      if (symbolValueOf) {\n        return symbolValueOf.call(object) == symbolValueOf.call(other);\n      }\n  }\n  return false;\n}\n\n/**\n * A specialized version of `baseIsEqualDeep` for objects with support for\n * partial deep comparisons.\n *\n * @private\n * @param {Object} object The object to compare.\n * @param {Object} other The other object to compare.\n * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.\n * @param {Function} customizer The function to customize comparisons.\n * @param {Function} equalFunc The function to determine equivalents of values.\n * @param {Object} stack Tracks traversed `object` and `other` objects.\n * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.\n */\nfunction equalObjects(object, other, bitmask, customizer, equalFunc, stack) {\n  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,\n      objProps = getAllKeys(object),\n      objLength = objProps.length,\n      othProps = getAllKeys(other),\n      othLength = othProps.length;\n\n  if (objLength != othLength && !isPartial) {\n    return false;\n  }\n  var index = objLength;\n  while (index--) {\n    var key = objProps[index];\n    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {\n      return false;\n    }\n  }\n  // Assume cyclic values are equal.\n  var stacked = stack.get(object);\n  if (stacked && stack.get(other)) {\n    return stacked == other;\n  }\n  var result = true;\n  stack.set(object, other);\n  stack.set(other, object);\n\n  var skipCtor = isPartial;\n  while (++index < objLength) {\n    key = objProps[index];\n    var objValue = object[key],\n        othValue = other[key];\n\n    if (customizer) {\n      var compared = isPartial\n        ? customizer(othValue, objValue, key, other, object, stack)\n        : customizer(objValue, othValue, key, object, other, stack);\n    }\n    // Recursively compare objects (susceptible to call stack limits).\n    if (!(compared === undefined\n          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))\n          : compared\n        )) {\n      result = false;\n      break;\n    }\n    skipCtor || (skipCtor = key == 'constructor');\n  }\n  if (result && !skipCtor) {\n    var objCtor = object.constructor,\n        othCtor = other.constructor;\n\n    // Non `Object` object instances with different constructors are not equal.\n    if (objCtor != othCtor &&\n        ('constructor' in object && 'constructor' in other) &&\n        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&\n          typeof othCtor == 'function' && othCtor instanceof othCtor)) {\n      result = false;\n    }\n  }\n  stack['delete'](object);\n  stack['delete'](other);\n  return result;\n}\n\n/**\n * Creates an array of own enumerable property names and symbols of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names and symbols.\n */\nfunction getAllKeys(object) {\n  return baseGetAllKeys(object, keys, getSymbols);\n}\n\n/**\n * Gets the data for `map`.\n *\n * @private\n * @param {Object} map The map to query.\n * @param {string} key The reference key.\n * @returns {*} Returns the map data.\n */\nfunction getMapData(map, key) {\n  var data = map.__data__;\n  return isKeyable(key)\n    ? data[typeof key == 'string' ? 'string' : 'hash']\n    : data.map;\n}\n\n/**\n * Gets the native function at `key` of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @param {string} key The key of the method to get.\n * @returns {*} Returns the function if it's native, else `undefined`.\n */\nfunction getNative(object, key) {\n  var value = getValue(object, key);\n  return baseIsNative(value) ? value : undefined;\n}\n\n/**\n * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.\n *\n * @private\n * @param {*} value The value to query.\n * @returns {string} Returns the raw `toStringTag`.\n */\nfunction getRawTag(value) {\n  var isOwn = hasOwnProperty.call(value, symToStringTag),\n      tag = value[symToStringTag];\n\n  try {\n    value[symToStringTag] = undefined;\n    var unmasked = true;\n  } catch (e) {}\n\n  var result = nativeObjectToString.call(value);\n  if (unmasked) {\n    if (isOwn) {\n      value[symToStringTag] = tag;\n    } else {\n      delete value[symToStringTag];\n    }\n  }\n  return result;\n}\n\n/**\n * Creates an array of the own enumerable symbols of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of symbols.\n */\nvar getSymbols = !nativeGetSymbols ? stubArray : function(object) {\n  if (object == null) {\n    return [];\n  }\n  object = Object(object);\n  return arrayFilter(nativeGetSymbols(object), function(symbol) {\n    return propertyIsEnumerable.call(object, symbol);\n  });\n};\n\n/**\n * Gets the `toStringTag` of `value`.\n *\n * @private\n * @param {*} value The value to query.\n * @returns {string} Returns the `toStringTag`.\n */\nvar getTag = baseGetTag;\n\n// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.\nif ((DataView && getTag(new DataView(new ArrayBuffer(1))) != dataViewTag) ||\n    (Map && getTag(new Map) != mapTag) ||\n    (Promise && getTag(Promise.resolve()) != promiseTag) ||\n    (Set && getTag(new Set) != setTag) ||\n    (WeakMap && getTag(new WeakMap) != weakMapTag)) {\n  getTag = function(value) {\n    var result = baseGetTag(value),\n        Ctor = result == objectTag ? value.constructor : undefined,\n        ctorString = Ctor ? toSource(Ctor) : '';\n\n    if (ctorString) {\n      switch (ctorString) {\n        case dataViewCtorString: return dataViewTag;\n        case mapCtorString: return mapTag;\n        case promiseCtorString: return promiseTag;\n        case setCtorString: return setTag;\n        case weakMapCtorString: return weakMapTag;\n      }\n    }\n    return result;\n  };\n}\n\n/**\n * Checks if `value` is a valid array-like index.\n *\n * @private\n * @param {*} value The value to check.\n * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.\n * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.\n */\nfunction isIndex(value, length) {\n  length = length == null ? MAX_SAFE_INTEGER : length;\n  return !!length &&\n    (typeof value == 'number' || reIsUint.test(value)) &&\n    (value > -1 && value % 1 == 0 && value < length);\n}\n\n/**\n * Checks if `value` is suitable for use as unique object key.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is suitable, else `false`.\n */\nfunction isKeyable(value) {\n  var type = typeof value;\n  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')\n    ? (value !== '__proto__')\n    : (value === null);\n}\n\n/**\n * Checks if `func` has its source masked.\n *\n * @private\n * @param {Function} func The function to check.\n * @returns {boolean} Returns `true` if `func` is masked, else `false`.\n */\nfunction isMasked(func) {\n  return !!maskSrcKey && (maskSrcKey in func);\n}\n\n/**\n * Checks if `value` is likely a prototype object.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.\n */\nfunction isPrototype(value) {\n  var Ctor = value && value.constructor,\n      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;\n\n  return value === proto;\n}\n\n/**\n * Converts `value` to a string using `Object.prototype.toString`.\n *\n * @private\n * @param {*} value The value to convert.\n * @returns {string} Returns the converted string.\n */\nfunction objectToString(value) {\n  return nativeObjectToString.call(value);\n}\n\n/**\n * Converts `func` to its source code.\n *\n * @private\n * @param {Function} func The function to convert.\n * @returns {string} Returns the source code.\n */\nfunction toSource(func) {\n  if (func != null) {\n    try {\n      return funcToString.call(func);\n    } catch (e) {}\n    try {\n      return (func + '');\n    } catch (e) {}\n  }\n  return '';\n}\n\n/**\n * Performs a\n * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)\n * comparison between two values to determine if they are equivalent.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to compare.\n * @param {*} other The other value to compare.\n * @returns {boolean} Returns `true` if the values are equivalent, else `false`.\n * @example\n *\n * var object = { 'a': 1 };\n * var other = { 'a': 1 };\n *\n * _.eq(object, object);\n * // => true\n *\n * _.eq(object, other);\n * // => false\n *\n * _.eq('a', 'a');\n * // => true\n *\n * _.eq('a', Object('a'));\n * // => false\n *\n * _.eq(NaN, NaN);\n * // => true\n */\nfunction eq(value, other) {\n  return value === other || (value !== value && other !== other);\n}\n\n/**\n * Checks if `value` is likely an `arguments` object.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an `arguments` object,\n *  else `false`.\n * @example\n *\n * _.isArguments(function() { return arguments; }());\n * // => true\n *\n * _.isArguments([1, 2, 3]);\n * // => false\n */\nvar isArguments = baseIsArguments(function() { return arguments; }()) ? baseIsArguments : function(value) {\n  return isObjectLike(value) && hasOwnProperty.call(value, 'callee') &&\n    !propertyIsEnumerable.call(value, 'callee');\n};\n\n/**\n * Checks if `value` is classified as an `Array` object.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an array, else `false`.\n * @example\n *\n * _.isArray([1, 2, 3]);\n * // => true\n *\n * _.isArray(document.body.children);\n * // => false\n *\n * _.isArray('abc');\n * // => false\n *\n * _.isArray(_.noop);\n * // => false\n */\nvar isArray = Array.isArray;\n\n/**\n * Checks if `value` is array-like. A value is considered array-like if it's\n * not a function and has a `value.length` that's an integer greater than or\n * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is array-like, else `false`.\n * @example\n *\n * _.isArrayLike([1, 2, 3]);\n * // => true\n *\n * _.isArrayLike(document.body.children);\n * // => true\n *\n * _.isArrayLike('abc');\n * // => true\n *\n * _.isArrayLike(_.noop);\n * // => false\n */\nfunction isArrayLike(value) {\n  return value != null && isLength(value.length) && !isFunction(value);\n}\n\n/**\n * Checks if `value` is a buffer.\n *\n * @static\n * @memberOf _\n * @since 4.3.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.\n * @example\n *\n * _.isBuffer(new Buffer(2));\n * // => true\n *\n * _.isBuffer(new Uint8Array(2));\n * // => false\n */\nvar isBuffer = nativeIsBuffer || stubFalse;\n\n/**\n * Performs a deep comparison between two values to determine if they are\n * equivalent.\n *\n * **Note:** This method supports comparing arrays, array buffers, booleans,\n * date objects, error objects, maps, numbers, `Object` objects, regexes,\n * sets, strings, symbols, and typed arrays. `Object` objects are compared\n * by their own, not inherited, enumerable properties. Functions and DOM\n * nodes are compared by strict equality, i.e. `===`.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to compare.\n * @param {*} other The other value to compare.\n * @returns {boolean} Returns `true` if the values are equivalent, else `false`.\n * @example\n *\n * var object = { 'a': 1 };\n * var other = { 'a': 1 };\n *\n * _.isEqual(object, other);\n * // => true\n *\n * object === other;\n * // => false\n */\nfunction isEqual(value, other) {\n  return baseIsEqual(value, other);\n}\n\n/**\n * Checks if `value` is classified as a `Function` object.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a function, else `false`.\n * @example\n *\n * _.isFunction(_);\n * // => true\n *\n * _.isFunction(/abc/);\n * // => false\n */\nfunction isFunction(value) {\n  if (!isObject(value)) {\n    return false;\n  }\n  // The use of `Object#toString` avoids issues with the `typeof` operator\n  // in Safari 9 which returns 'object' for typed arrays and other constructors.\n  var tag = baseGetTag(value);\n  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;\n}\n\n/**\n * Checks if `value` is a valid array-like length.\n *\n * **Note:** This method is loosely based on\n * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.\n * @example\n *\n * _.isLength(3);\n * // => true\n *\n * _.isLength(Number.MIN_VALUE);\n * // => false\n *\n * _.isLength(Infinity);\n * // => false\n *\n * _.isLength('3');\n * // => false\n */\nfunction isLength(value) {\n  return typeof value == 'number' &&\n    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;\n}\n\n/**\n * Checks if `value` is the\n * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)\n * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an object, else `false`.\n * @example\n *\n * _.isObject({});\n * // => true\n *\n * _.isObject([1, 2, 3]);\n * // => true\n *\n * _.isObject(_.noop);\n * // => true\n *\n * _.isObject(null);\n * // => false\n */\nfunction isObject(value) {\n  var type = typeof value;\n  return value != null && (type == 'object' || type == 'function');\n}\n\n/**\n * Checks if `value` is object-like. A value is object-like if it's not `null`\n * and has a `typeof` result of \"object\".\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is object-like, else `false`.\n * @example\n *\n * _.isObjectLike({});\n * // => true\n *\n * _.isObjectLike([1, 2, 3]);\n * // => true\n *\n * _.isObjectLike(_.noop);\n * // => false\n *\n * _.isObjectLike(null);\n * // => false\n */\nfunction isObjectLike(value) {\n  return value != null && typeof value == 'object';\n}\n\n/**\n * Checks if `value` is classified as a typed array.\n *\n * @static\n * @memberOf _\n * @since 3.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.\n * @example\n *\n * _.isTypedArray(new Uint8Array);\n * // => true\n *\n * _.isTypedArray([]);\n * // => false\n */\nvar isTypedArray = nodeIsTypedArray ? baseUnary(nodeIsTypedArray) : baseIsTypedArray;\n\n/**\n * Creates an array of the own enumerable property names of `object`.\n *\n * **Note:** Non-object values are coerced to objects. See the\n * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)\n * for more details.\n *\n * @static\n * @since 0.1.0\n * @memberOf _\n * @category Object\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names.\n * @example\n *\n * function Foo() {\n *   this.a = 1;\n *   this.b = 2;\n * }\n *\n * Foo.prototype.c = 3;\n *\n * _.keys(new Foo);\n * // => ['a', 'b'] (iteration order is not guaranteed)\n *\n * _.keys('hi');\n * // => ['0', '1']\n */\nfunction keys(object) {\n  return isArrayLike(object) ? arrayLikeKeys(object) : baseKeys(object);\n}\n\n/**\n * This method returns a new empty array.\n *\n * @static\n * @memberOf _\n * @since 4.13.0\n * @category Util\n * @returns {Array} Returns the new empty array.\n * @example\n *\n * var arrays = _.times(2, _.stubArray);\n *\n * console.log(arrays);\n * // => [[], []]\n *\n * console.log(arrays[0] === arrays[1]);\n * // => false\n */\nfunction stubArray() {\n  return [];\n}\n\n/**\n * This method returns `false`.\n *\n * @static\n * @memberOf _\n * @since 4.13.0\n * @category Util\n * @returns {boolean} Returns `false`.\n * @example\n *\n * _.times(2, _.stubFalse);\n * // => [false, false]\n */\nfunction stubFalse() {\n  return false;\n}\n\nmodule.exports = isEqual;\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash.isequal/index.js?")},"./node_modules/quill-delta/dist/AttributeMap.js":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst cloneDeep = __webpack_require__(/*! lodash.clonedeep */ \"./node_modules/lodash.clonedeep/index.js\");\nconst isEqual = __webpack_require__(/*! lodash.isequal */ \"./node_modules/lodash.isequal/index.js\");\nvar AttributeMap;\n(function (AttributeMap) {\n    function compose(a = {}, b = {}, keepNull = false) {\n        if (typeof a !== 'object') {\n            a = {};\n        }\n        if (typeof b !== 'object') {\n            b = {};\n        }\n        let attributes = cloneDeep(b);\n        if (!keepNull) {\n            attributes = Object.keys(attributes).reduce((copy, key) => {\n                if (attributes[key] != null) {\n                    copy[key] = attributes[key];\n                }\n                return copy;\n            }, {});\n        }\n        for (const key in a) {\n            if (a[key] !== undefined && b[key] === undefined) {\n                attributes[key] = a[key];\n            }\n        }\n        return Object.keys(attributes).length > 0 ? attributes : undefined;\n    }\n    AttributeMap.compose = compose;\n    function diff(a = {}, b = {}) {\n        if (typeof a !== 'object') {\n            a = {};\n        }\n        if (typeof b !== 'object') {\n            b = {};\n        }\n        const attributes = Object.keys(a)\n            .concat(Object.keys(b))\n            .reduce((attrs, key) => {\n            if (!isEqual(a[key], b[key])) {\n                attrs[key] = b[key] === undefined ? null : b[key];\n            }\n            return attrs;\n        }, {});\n        return Object.keys(attributes).length > 0 ? attributes : undefined;\n    }\n    AttributeMap.diff = diff;\n    function invert(attr = {}, base = {}) {\n        attr = attr || {};\n        const baseInverted = Object.keys(base).reduce((memo, key) => {\n            if (base[key] !== attr[key] && attr[key] !== undefined) {\n                memo[key] = base[key];\n            }\n            return memo;\n        }, {});\n        return Object.keys(attr).reduce((memo, key) => {\n            if (attr[key] !== base[key] && base[key] === undefined) {\n                memo[key] = null;\n            }\n            return memo;\n        }, baseInverted);\n    }\n    AttributeMap.invert = invert;\n    function transform(a, b, priority = false) {\n        if (typeof a !== 'object') {\n            return b;\n        }\n        if (typeof b !== 'object') {\n            return undefined;\n        }\n        if (!priority) {\n            return b; // b simply overwrites us without priority\n        }\n        const attributes = Object.keys(b).reduce((attrs, key) => {\n            if (a[key] === undefined) {\n                attrs[key] = b[key]; // null is a valid value\n            }\n            return attrs;\n        }, {});\n        return Object.keys(attributes).length > 0 ? attributes : undefined;\n    }\n    AttributeMap.transform = transform;\n})(AttributeMap || (AttributeMap = {}));\nexports[\"default\"] = AttributeMap;\n//# sourceMappingURL=AttributeMap.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill-delta/dist/AttributeMap.js?")},"./node_modules/quill-delta/dist/Delta.js":function(module,exports,__webpack_require__){"use strict";eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nexports.AttributeMap = exports.OpIterator = exports.Op = void 0;\nconst diff = __webpack_require__(/*! fast-diff */ \"./node_modules/fast-diff/diff.js\");\nconst cloneDeep = __webpack_require__(/*! lodash.clonedeep */ \"./node_modules/lodash.clonedeep/index.js\");\nconst isEqual = __webpack_require__(/*! lodash.isequal */ \"./node_modules/lodash.isequal/index.js\");\nconst AttributeMap_1 = __webpack_require__(/*! ./AttributeMap */ \"./node_modules/quill-delta/dist/AttributeMap.js\");\nexports.AttributeMap = AttributeMap_1.default;\nconst Op_1 = __webpack_require__(/*! ./Op */ \"./node_modules/quill-delta/dist/Op.js\");\nexports.Op = Op_1.default;\nconst OpIterator_1 = __webpack_require__(/*! ./OpIterator */ \"./node_modules/quill-delta/dist/OpIterator.js\");\nexports.OpIterator = OpIterator_1.default;\nconst NULL_CHARACTER = String.fromCharCode(0); // Placeholder char for embed in diff()\nconst getEmbedTypeAndData = (a, b) => {\n    if (typeof a !== 'object' || a === null) {\n        throw new Error(`cannot retain a ${typeof a}`);\n    }\n    if (typeof b !== 'object' || b === null) {\n        throw new Error(`cannot retain a ${typeof b}`);\n    }\n    const embedType = Object.keys(a)[0];\n    if (!embedType || embedType !== Object.keys(b)[0]) {\n        throw new Error(`embed types not matched: ${embedType} != ${Object.keys(b)[0]}`);\n    }\n    return [embedType, a[embedType], b[embedType]];\n};\nclass Delta {\n    constructor(ops) {\n        // Assume we are given a well formed ops\n        if (Array.isArray(ops)) {\n            this.ops = ops;\n        }\n        else if (ops != null && Array.isArray(ops.ops)) {\n            this.ops = ops.ops;\n        }\n        else {\n            this.ops = [];\n        }\n    }\n    static registerEmbed(embedType, handler) {\n        this.handlers[embedType] = handler;\n    }\n    static unregisterEmbed(embedType) {\n        delete this.handlers[embedType];\n    }\n    static getHandler(embedType) {\n        const handler = this.handlers[embedType];\n        if (!handler) {\n            throw new Error(`no handlers for embed type \"${embedType}\"`);\n        }\n        return handler;\n    }\n    insert(arg, attributes) {\n        const newOp = {};\n        if (typeof arg === 'string' && arg.length === 0) {\n            return this;\n        }\n        newOp.insert = arg;\n        if (attributes != null &&\n            typeof attributes === 'object' &&\n            Object.keys(attributes).length > 0) {\n            newOp.attributes = attributes;\n        }\n        return this.push(newOp);\n    }\n    delete(length) {\n        if (length <= 0) {\n            return this;\n        }\n        return this.push({ delete: length });\n    }\n    retain(length, attributes) {\n        if (typeof length === 'number' && length <= 0) {\n            return this;\n        }\n        const newOp = { retain: length };\n        if (attributes != null &&\n            typeof attributes === 'object' &&\n            Object.keys(attributes).length > 0) {\n            newOp.attributes = attributes;\n        }\n        return this.push(newOp);\n    }\n    push(newOp) {\n        let index = this.ops.length;\n        let lastOp = this.ops[index - 1];\n        newOp = cloneDeep(newOp);\n        if (typeof lastOp === 'object') {\n            if (typeof newOp.delete === 'number' &&\n                typeof lastOp.delete === 'number') {\n                this.ops[index - 1] = { delete: lastOp.delete + newOp.delete };\n                return this;\n            }\n            // Since it does not matter if we insert before or after deleting at the same index,\n            // always prefer to insert first\n            if (typeof lastOp.delete === 'number' && newOp.insert != null) {\n                index -= 1;\n                lastOp = this.ops[index - 1];\n                if (typeof lastOp !== 'object') {\n                    this.ops.unshift(newOp);\n                    return this;\n                }\n            }\n            if (isEqual(newOp.attributes, lastOp.attributes)) {\n                if (typeof newOp.insert === 'string' &&\n                    typeof lastOp.insert === 'string') {\n                    this.ops[index - 1] = { insert: lastOp.insert + newOp.insert };\n                    if (typeof newOp.attributes === 'object') {\n                        this.ops[index - 1].attributes = newOp.attributes;\n                    }\n                    return this;\n                }\n                else if (typeof newOp.retain === 'number' &&\n                    typeof lastOp.retain === 'number') {\n                    this.ops[index - 1] = { retain: lastOp.retain + newOp.retain };\n                    if (typeof newOp.attributes === 'object') {\n                        this.ops[index - 1].attributes = newOp.attributes;\n                    }\n                    return this;\n                }\n            }\n        }\n        if (index === this.ops.length) {\n            this.ops.push(newOp);\n        }\n        else {\n            this.ops.splice(index, 0, newOp);\n        }\n        return this;\n    }\n    chop() {\n        const lastOp = this.ops[this.ops.length - 1];\n        if (lastOp && typeof lastOp.retain === 'number' && !lastOp.attributes) {\n            this.ops.pop();\n        }\n        return this;\n    }\n    filter(predicate) {\n        return this.ops.filter(predicate);\n    }\n    forEach(predicate) {\n        this.ops.forEach(predicate);\n    }\n    map(predicate) {\n        return this.ops.map(predicate);\n    }\n    partition(predicate) {\n        const passed = [];\n        const failed = [];\n        this.forEach((op) => {\n            const target = predicate(op) ? passed : failed;\n            target.push(op);\n        });\n        return [passed, failed];\n    }\n    reduce(predicate, initialValue) {\n        return this.ops.reduce(predicate, initialValue);\n    }\n    changeLength() {\n        return this.reduce((length, elem) => {\n            if (elem.insert) {\n                return length + Op_1.default.length(elem);\n            }\n            else if (elem.delete) {\n                return length - elem.delete;\n            }\n            return length;\n        }, 0);\n    }\n    length() {\n        return this.reduce((length, elem) => {\n            return length + Op_1.default.length(elem);\n        }, 0);\n    }\n    slice(start = 0, end = Infinity) {\n        const ops = [];\n        const iter = new OpIterator_1.default(this.ops);\n        let index = 0;\n        while (index < end && iter.hasNext()) {\n            let nextOp;\n            if (index < start) {\n                nextOp = iter.next(start - index);\n            }\n            else {\n                nextOp = iter.next(end - index);\n                ops.push(nextOp);\n            }\n            index += Op_1.default.length(nextOp);\n        }\n        return new Delta(ops);\n    }\n    compose(other) {\n        const thisIter = new OpIterator_1.default(this.ops);\n        const otherIter = new OpIterator_1.default(other.ops);\n        const ops = [];\n        const firstOther = otherIter.peek();\n        if (firstOther != null &&\n            typeof firstOther.retain === 'number' &&\n            firstOther.attributes == null) {\n            let firstLeft = firstOther.retain;\n            while (thisIter.peekType() === 'insert' &&\n                thisIter.peekLength() <= firstLeft) {\n                firstLeft -= thisIter.peekLength();\n                ops.push(thisIter.next());\n            }\n            if (firstOther.retain - firstLeft > 0) {\n                otherIter.next(firstOther.retain - firstLeft);\n            }\n        }\n        const delta = new Delta(ops);\n        while (thisIter.hasNext() || otherIter.hasNext()) {\n            if (otherIter.peekType() === 'insert') {\n                delta.push(otherIter.next());\n            }\n            else if (thisIter.peekType() === 'delete') {\n                delta.push(thisIter.next());\n            }\n            else {\n                const length = Math.min(thisIter.peekLength(), otherIter.peekLength());\n                const thisOp = thisIter.next(length);\n                const otherOp = otherIter.next(length);\n                if (otherOp.retain) {\n                    const newOp = {};\n                    if (typeof thisOp.retain === 'number') {\n                        newOp.retain =\n                            typeof otherOp.retain === 'number' ? length : otherOp.retain;\n                    }\n                    else {\n                        if (typeof otherOp.retain === 'number') {\n                            if (thisOp.retain == null) {\n                                newOp.insert = thisOp.insert;\n                            }\n                            else {\n                                newOp.retain = thisOp.retain;\n                            }\n                        }\n                        else {\n                            const action = thisOp.retain == null ? 'insert' : 'retain';\n                            const [embedType, thisData, otherData] = getEmbedTypeAndData(thisOp[action], otherOp.retain);\n                            const handler = Delta.getHandler(embedType);\n                            newOp[action] = {\n                                [embedType]: handler.compose(thisData, otherData, action === 'retain'),\n                            };\n                        }\n                    }\n                    // Preserve null when composing with a retain, otherwise remove it for inserts\n                    const attributes = AttributeMap_1.default.compose(thisOp.attributes, otherOp.attributes, typeof thisOp.retain === 'number');\n                    if (attributes) {\n                        newOp.attributes = attributes;\n                    }\n                    delta.push(newOp);\n                    // Optimization if rest of other is just retain\n                    if (!otherIter.hasNext() &&\n                        isEqual(delta.ops[delta.ops.length - 1], newOp)) {\n                        const rest = new Delta(thisIter.rest());\n                        return delta.concat(rest).chop();\n                    }\n                    // Other op should be delete, we could be an insert or retain\n                    // Insert + delete cancels out\n                }\n                else if (typeof otherOp.delete === 'number' &&\n                    (typeof thisOp.retain === 'number' ||\n                        (typeof thisOp.retain === 'object' && thisOp.retain !== null))) {\n                    delta.push(otherOp);\n                }\n            }\n        }\n        return delta.chop();\n    }\n    concat(other) {\n        const delta = new Delta(this.ops.slice());\n        if (other.ops.length > 0) {\n            delta.push(other.ops[0]);\n            delta.ops = delta.ops.concat(other.ops.slice(1));\n        }\n        return delta;\n    }\n    diff(other, cursor) {\n        if (this.ops === other.ops) {\n            return new Delta();\n        }\n        const strings = [this, other].map((delta) => {\n            return delta\n                .map((op) => {\n                if (op.insert != null) {\n                    return typeof op.insert === 'string' ? op.insert : NULL_CHARACTER;\n                }\n                const prep = delta === other ? 'on' : 'with';\n                throw new Error('diff() called ' + prep + ' non-document');\n            })\n                .join('');\n        });\n        const retDelta = new Delta();\n        const diffResult = diff(strings[0], strings[1], cursor, true);\n        const thisIter = new OpIterator_1.default(this.ops);\n        const otherIter = new OpIterator_1.default(other.ops);\n        diffResult.forEach((component) => {\n            let length = component[1].length;\n            while (length > 0) {\n                let opLength = 0;\n                switch (component[0]) {\n                    case diff.INSERT:\n                        opLength = Math.min(otherIter.peekLength(), length);\n                        retDelta.push(otherIter.next(opLength));\n                        break;\n                    case diff.DELETE:\n                        opLength = Math.min(length, thisIter.peekLength());\n                        thisIter.next(opLength);\n                        retDelta.delete(opLength);\n                        break;\n                    case diff.EQUAL:\n                        opLength = Math.min(thisIter.peekLength(), otherIter.peekLength(), length);\n                        const thisOp = thisIter.next(opLength);\n                        const otherOp = otherIter.next(opLength);\n                        if (isEqual(thisOp.insert, otherOp.insert)) {\n                            retDelta.retain(opLength, AttributeMap_1.default.diff(thisOp.attributes, otherOp.attributes));\n                        }\n                        else {\n                            retDelta.push(otherOp).delete(opLength);\n                        }\n                        break;\n                }\n                length -= opLength;\n            }\n        });\n        return retDelta.chop();\n    }\n    eachLine(predicate, newline = '\\n') {\n        const iter = new OpIterator_1.default(this.ops);\n        let line = new Delta();\n        let i = 0;\n        while (iter.hasNext()) {\n            if (iter.peekType() !== 'insert') {\n                return;\n            }\n            const thisOp = iter.peek();\n            const start = Op_1.default.length(thisOp) - iter.peekLength();\n            const index = typeof thisOp.insert === 'string'\n                ? thisOp.insert.indexOf(newline, start) - start\n                : -1;\n            if (index < 0) {\n                line.push(iter.next());\n            }\n            else if (index > 0) {\n                line.push(iter.next(index));\n            }\n            else {\n                if (predicate(line, iter.next(1).attributes || {}, i) === false) {\n                    return;\n                }\n                i += 1;\n                line = new Delta();\n            }\n        }\n        if (line.length() > 0) {\n            predicate(line, {}, i);\n        }\n    }\n    invert(base) {\n        const inverted = new Delta();\n        this.reduce((baseIndex, op) => {\n            if (op.insert) {\n                inverted.delete(Op_1.default.length(op));\n            }\n            else if (typeof op.retain === 'number' && op.attributes == null) {\n                inverted.retain(op.retain);\n                return baseIndex + op.retain;\n            }\n            else if (op.delete || typeof op.retain === 'number') {\n                const length = (op.delete || op.retain);\n                const slice = base.slice(baseIndex, baseIndex + length);\n                slice.forEach((baseOp) => {\n                    if (op.delete) {\n                        inverted.push(baseOp);\n                    }\n                    else if (op.retain && op.attributes) {\n                        inverted.retain(Op_1.default.length(baseOp), AttributeMap_1.default.invert(op.attributes, baseOp.attributes));\n                    }\n                });\n                return baseIndex + length;\n            }\n            else if (typeof op.retain === 'object' && op.retain !== null) {\n                const slice = base.slice(baseIndex, baseIndex + 1);\n                const baseOp = new OpIterator_1.default(slice.ops).next();\n                const [embedType, opData, baseOpData] = getEmbedTypeAndData(op.retain, baseOp.insert);\n                const handler = Delta.getHandler(embedType);\n                inverted.retain({ [embedType]: handler.invert(opData, baseOpData) }, AttributeMap_1.default.invert(op.attributes, baseOp.attributes));\n                return baseIndex + 1;\n            }\n            return baseIndex;\n        }, 0);\n        return inverted.chop();\n    }\n    transform(arg, priority = false) {\n        priority = !!priority;\n        if (typeof arg === 'number') {\n            return this.transformPosition(arg, priority);\n        }\n        const other = arg;\n        const thisIter = new OpIterator_1.default(this.ops);\n        const otherIter = new OpIterator_1.default(other.ops);\n        const delta = new Delta();\n        while (thisIter.hasNext() || otherIter.hasNext()) {\n            if (thisIter.peekType() === 'insert' &&\n                (priority || otherIter.peekType() !== 'insert')) {\n                delta.retain(Op_1.default.length(thisIter.next()));\n            }\n            else if (otherIter.peekType() === 'insert') {\n                delta.push(otherIter.next());\n            }\n            else {\n                const length = Math.min(thisIter.peekLength(), otherIter.peekLength());\n                const thisOp = thisIter.next(length);\n                const otherOp = otherIter.next(length);\n                if (thisOp.delete) {\n                    // Our delete either makes their delete redundant or removes their retain\n                    continue;\n                }\n                else if (otherOp.delete) {\n                    delta.push(otherOp);\n                }\n                else {\n                    const thisData = thisOp.retain;\n                    const otherData = otherOp.retain;\n                    let transformedData = typeof otherData === 'object' && otherData !== null\n                        ? otherData\n                        : length;\n                    if (typeof thisData === 'object' &&\n                        thisData !== null &&\n                        typeof otherData === 'object' &&\n                        otherData !== null) {\n                        const embedType = Object.keys(thisData)[0];\n                        if (embedType === Object.keys(otherData)[0]) {\n                            const handler = Delta.getHandler(embedType);\n                            if (handler) {\n                                transformedData = {\n                                    [embedType]: handler.transform(thisData[embedType], otherData[embedType], priority),\n                                };\n                            }\n                        }\n                    }\n                    // We retain either their retain or insert\n                    delta.retain(transformedData, AttributeMap_1.default.transform(thisOp.attributes, otherOp.attributes, priority));\n                }\n            }\n        }\n        return delta.chop();\n    }\n    transformPosition(index, priority = false) {\n        priority = !!priority;\n        const thisIter = new OpIterator_1.default(this.ops);\n        let offset = 0;\n        while (thisIter.hasNext() && offset <= index) {\n            const length = thisIter.peekLength();\n            const nextType = thisIter.peekType();\n            thisIter.next();\n            if (nextType === 'delete') {\n                index -= Math.min(length, index - offset);\n                continue;\n            }\n            else if (nextType === 'insert' && (offset < index || !priority)) {\n                index += length;\n            }\n            offset += length;\n        }\n        return index;\n    }\n}\nDelta.Op = Op_1.default;\nDelta.OpIterator = OpIterator_1.default;\nDelta.AttributeMap = AttributeMap_1.default;\nDelta.handlers = {};\nexports[\"default\"] = Delta;\nif (true) {\n    module.exports = Delta;\n    module.exports[\"default\"] = Delta;\n}\n//# sourceMappingURL=Delta.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill-delta/dist/Delta.js?")},"./node_modules/quill-delta/dist/Op.js":function(__unused_webpack_module,exports){"use strict";eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nvar Op;\n(function (Op) {\n    function length(op) {\n        if (typeof op.delete === 'number') {\n            return op.delete;\n        }\n        else if (typeof op.retain === 'number') {\n            return op.retain;\n        }\n        else if (typeof op.retain === 'object' && op.retain !== null) {\n            return 1;\n        }\n        else {\n            return typeof op.insert === 'string' ? op.insert.length : 1;\n        }\n    }\n    Op.length = length;\n})(Op || (Op = {}));\nexports[\"default\"] = Op;\n//# sourceMappingURL=Op.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill-delta/dist/Op.js?")},"./node_modules/quill-delta/dist/OpIterator.js":function(__unused_webpack_module,exports,__webpack_require__){"use strict";eval("\nObject.defineProperty(exports, \"__esModule\", ({ value: true }));\nconst Op_1 = __webpack_require__(/*! ./Op */ \"./node_modules/quill-delta/dist/Op.js\");\nclass Iterator {\n    constructor(ops) {\n        this.ops = ops;\n        this.index = 0;\n        this.offset = 0;\n    }\n    hasNext() {\n        return this.peekLength() < Infinity;\n    }\n    next(length) {\n        if (!length) {\n            length = Infinity;\n        }\n        const nextOp = this.ops[this.index];\n        if (nextOp) {\n            const offset = this.offset;\n            const opLength = Op_1.default.length(nextOp);\n            if (length >= opLength - offset) {\n                length = opLength - offset;\n                this.index += 1;\n                this.offset = 0;\n            }\n            else {\n                this.offset += length;\n            }\n            if (typeof nextOp.delete === 'number') {\n                return { delete: length };\n            }\n            else {\n                const retOp = {};\n                if (nextOp.attributes) {\n                    retOp.attributes = nextOp.attributes;\n                }\n                if (typeof nextOp.retain === 'number') {\n                    retOp.retain = length;\n                }\n                else if (typeof nextOp.retain === 'object' &&\n                    nextOp.retain !== null) {\n                    // offset should === 0, length should === 1\n                    retOp.retain = nextOp.retain;\n                }\n                else if (typeof nextOp.insert === 'string') {\n                    retOp.insert = nextOp.insert.substr(offset, length);\n                }\n                else {\n                    // offset should === 0, length should === 1\n                    retOp.insert = nextOp.insert;\n                }\n                return retOp;\n            }\n        }\n        else {\n            return { retain: Infinity };\n        }\n    }\n    peek() {\n        return this.ops[this.index];\n    }\n    peekLength() {\n        if (this.ops[this.index]) {\n            // Should never return 0 if our index is being managed correctly\n            return Op_1.default.length(this.ops[this.index]) - this.offset;\n        }\n        else {\n            return Infinity;\n        }\n    }\n    peekType() {\n        const op = this.ops[this.index];\n        if (op) {\n            if (typeof op.delete === 'number') {\n                return 'delete';\n            }\n            else if (typeof op.retain === 'number' ||\n                (typeof op.retain === 'object' && op.retain !== null)) {\n                return 'retain';\n            }\n            else {\n                return 'insert';\n            }\n        }\n        return 'retain';\n    }\n    rest() {\n        if (!this.hasNext()) {\n            return [];\n        }\n        else if (this.offset === 0) {\n            return this.ops.slice(this.index);\n        }\n        else {\n            const offset = this.offset;\n            const index = this.index;\n            const next = this.next();\n            const rest = this.ops.slice(this.index);\n            this.offset = offset;\n            this.index = index;\n            return [next].concat(rest);\n        }\n    }\n}\nexports[\"default\"] = Iterator;\n//# sourceMappingURL=OpIterator.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill-delta/dist/OpIterator.js?")},"./node_modules/eventemitter3/index.mjs":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   EventEmitter: function() { return /* reexport default export from named module */ _index_js__WEBPACK_IMPORTED_MODULE_0__; }\n/* harmony export */ });\n/* harmony import */ var _index_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./index.js */ "./node_modules/eventemitter3/index.js");\n\n\n\n/* harmony default export */ __webpack_exports__["default"] = (_index_js__WEBPACK_IMPORTED_MODULE_0__);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/eventemitter3/index.mjs?')},"./node_modules/lodash-es/_DataView.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getNative_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getNative.js */ "./node_modules/lodash-es/_getNative.js");\n/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");\n\n\n\n/* Built-in method references that are verified to be native. */\nvar DataView = (0,_getNative_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_root_js__WEBPACK_IMPORTED_MODULE_1__["default"], \'DataView\');\n\n/* harmony default export */ __webpack_exports__["default"] = (DataView);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_DataView.js?')},"./node_modules/lodash-es/_Hash.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _hashClear_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_hashClear.js */ "./node_modules/lodash-es/_hashClear.js");\n/* harmony import */ var _hashDelete_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_hashDelete.js */ "./node_modules/lodash-es/_hashDelete.js");\n/* harmony import */ var _hashGet_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_hashGet.js */ "./node_modules/lodash-es/_hashGet.js");\n/* harmony import */ var _hashHas_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_hashHas.js */ "./node_modules/lodash-es/_hashHas.js");\n/* harmony import */ var _hashSet_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_hashSet.js */ "./node_modules/lodash-es/_hashSet.js");\n\n\n\n\n\n\n/**\n * Creates a hash object.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction Hash(entries) {\n  var index = -1,\n      length = entries == null ? 0 : entries.length;\n\n  this.clear();\n  while (++index < length) {\n    var entry = entries[index];\n    this.set(entry[0], entry[1]);\n  }\n}\n\n// Add methods to `Hash`.\nHash.prototype.clear = _hashClear_js__WEBPACK_IMPORTED_MODULE_0__["default"];\nHash.prototype[\'delete\'] = _hashDelete_js__WEBPACK_IMPORTED_MODULE_1__["default"];\nHash.prototype.get = _hashGet_js__WEBPACK_IMPORTED_MODULE_2__["default"];\nHash.prototype.has = _hashHas_js__WEBPACK_IMPORTED_MODULE_3__["default"];\nHash.prototype.set = _hashSet_js__WEBPACK_IMPORTED_MODULE_4__["default"];\n\n/* harmony default export */ __webpack_exports__["default"] = (Hash);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_Hash.js?')},"./node_modules/lodash-es/_ListCache.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _listCacheClear_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_listCacheClear.js */ "./node_modules/lodash-es/_listCacheClear.js");\n/* harmony import */ var _listCacheDelete_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_listCacheDelete.js */ "./node_modules/lodash-es/_listCacheDelete.js");\n/* harmony import */ var _listCacheGet_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_listCacheGet.js */ "./node_modules/lodash-es/_listCacheGet.js");\n/* harmony import */ var _listCacheHas_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_listCacheHas.js */ "./node_modules/lodash-es/_listCacheHas.js");\n/* harmony import */ var _listCacheSet_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_listCacheSet.js */ "./node_modules/lodash-es/_listCacheSet.js");\n\n\n\n\n\n\n/**\n * Creates an list cache object.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction ListCache(entries) {\n  var index = -1,\n      length = entries == null ? 0 : entries.length;\n\n  this.clear();\n  while (++index < length) {\n    var entry = entries[index];\n    this.set(entry[0], entry[1]);\n  }\n}\n\n// Add methods to `ListCache`.\nListCache.prototype.clear = _listCacheClear_js__WEBPACK_IMPORTED_MODULE_0__["default"];\nListCache.prototype[\'delete\'] = _listCacheDelete_js__WEBPACK_IMPORTED_MODULE_1__["default"];\nListCache.prototype.get = _listCacheGet_js__WEBPACK_IMPORTED_MODULE_2__["default"];\nListCache.prototype.has = _listCacheHas_js__WEBPACK_IMPORTED_MODULE_3__["default"];\nListCache.prototype.set = _listCacheSet_js__WEBPACK_IMPORTED_MODULE_4__["default"];\n\n/* harmony default export */ __webpack_exports__["default"] = (ListCache);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_ListCache.js?')},"./node_modules/lodash-es/_Map.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getNative_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getNative.js */ "./node_modules/lodash-es/_getNative.js");\n/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");\n\n\n\n/* Built-in method references that are verified to be native. */\nvar Map = (0,_getNative_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_root_js__WEBPACK_IMPORTED_MODULE_1__["default"], \'Map\');\n\n/* harmony default export */ __webpack_exports__["default"] = (Map);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_Map.js?')},"./node_modules/lodash-es/_MapCache.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _mapCacheClear_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_mapCacheClear.js */ "./node_modules/lodash-es/_mapCacheClear.js");\n/* harmony import */ var _mapCacheDelete_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_mapCacheDelete.js */ "./node_modules/lodash-es/_mapCacheDelete.js");\n/* harmony import */ var _mapCacheGet_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_mapCacheGet.js */ "./node_modules/lodash-es/_mapCacheGet.js");\n/* harmony import */ var _mapCacheHas_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_mapCacheHas.js */ "./node_modules/lodash-es/_mapCacheHas.js");\n/* harmony import */ var _mapCacheSet_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_mapCacheSet.js */ "./node_modules/lodash-es/_mapCacheSet.js");\n\n\n\n\n\n\n/**\n * Creates a map cache object to store key-value pairs.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction MapCache(entries) {\n  var index = -1,\n      length = entries == null ? 0 : entries.length;\n\n  this.clear();\n  while (++index < length) {\n    var entry = entries[index];\n    this.set(entry[0], entry[1]);\n  }\n}\n\n// Add methods to `MapCache`.\nMapCache.prototype.clear = _mapCacheClear_js__WEBPACK_IMPORTED_MODULE_0__["default"];\nMapCache.prototype[\'delete\'] = _mapCacheDelete_js__WEBPACK_IMPORTED_MODULE_1__["default"];\nMapCache.prototype.get = _mapCacheGet_js__WEBPACK_IMPORTED_MODULE_2__["default"];\nMapCache.prototype.has = _mapCacheHas_js__WEBPACK_IMPORTED_MODULE_3__["default"];\nMapCache.prototype.set = _mapCacheSet_js__WEBPACK_IMPORTED_MODULE_4__["default"];\n\n/* harmony default export */ __webpack_exports__["default"] = (MapCache);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_MapCache.js?')},"./node_modules/lodash-es/_Promise.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getNative_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getNative.js */ "./node_modules/lodash-es/_getNative.js");\n/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");\n\n\n\n/* Built-in method references that are verified to be native. */\nvar Promise = (0,_getNative_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_root_js__WEBPACK_IMPORTED_MODULE_1__["default"], \'Promise\');\n\n/* harmony default export */ __webpack_exports__["default"] = (Promise);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_Promise.js?')},"./node_modules/lodash-es/_Set.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getNative_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getNative.js */ "./node_modules/lodash-es/_getNative.js");\n/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");\n\n\n\n/* Built-in method references that are verified to be native. */\nvar Set = (0,_getNative_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_root_js__WEBPACK_IMPORTED_MODULE_1__["default"], \'Set\');\n\n/* harmony default export */ __webpack_exports__["default"] = (Set);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_Set.js?')},"./node_modules/lodash-es/_SetCache.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _MapCache_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_MapCache.js */ "./node_modules/lodash-es/_MapCache.js");\n/* harmony import */ var _setCacheAdd_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_setCacheAdd.js */ "./node_modules/lodash-es/_setCacheAdd.js");\n/* harmony import */ var _setCacheHas_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_setCacheHas.js */ "./node_modules/lodash-es/_setCacheHas.js");\n\n\n\n\n/**\n *\n * Creates an array cache object to store unique values.\n *\n * @private\n * @constructor\n * @param {Array} [values] The values to cache.\n */\nfunction SetCache(values) {\n  var index = -1,\n      length = values == null ? 0 : values.length;\n\n  this.__data__ = new _MapCache_js__WEBPACK_IMPORTED_MODULE_0__["default"];\n  while (++index < length) {\n    this.add(values[index]);\n  }\n}\n\n// Add methods to `SetCache`.\nSetCache.prototype.add = SetCache.prototype.push = _setCacheAdd_js__WEBPACK_IMPORTED_MODULE_1__["default"];\nSetCache.prototype.has = _setCacheHas_js__WEBPACK_IMPORTED_MODULE_2__["default"];\n\n/* harmony default export */ __webpack_exports__["default"] = (SetCache);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_SetCache.js?')},"./node_modules/lodash-es/_Stack.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ListCache_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_ListCache.js */ "./node_modules/lodash-es/_ListCache.js");\n/* harmony import */ var _stackClear_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_stackClear.js */ "./node_modules/lodash-es/_stackClear.js");\n/* harmony import */ var _stackDelete_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_stackDelete.js */ "./node_modules/lodash-es/_stackDelete.js");\n/* harmony import */ var _stackGet_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_stackGet.js */ "./node_modules/lodash-es/_stackGet.js");\n/* harmony import */ var _stackHas_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_stackHas.js */ "./node_modules/lodash-es/_stackHas.js");\n/* harmony import */ var _stackSet_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_stackSet.js */ "./node_modules/lodash-es/_stackSet.js");\n\n\n\n\n\n\n\n/**\n * Creates a stack cache object to store key-value pairs.\n *\n * @private\n * @constructor\n * @param {Array} [entries] The key-value pairs to cache.\n */\nfunction Stack(entries) {\n  var data = this.__data__ = new _ListCache_js__WEBPACK_IMPORTED_MODULE_0__["default"](entries);\n  this.size = data.size;\n}\n\n// Add methods to `Stack`.\nStack.prototype.clear = _stackClear_js__WEBPACK_IMPORTED_MODULE_1__["default"];\nStack.prototype[\'delete\'] = _stackDelete_js__WEBPACK_IMPORTED_MODULE_2__["default"];\nStack.prototype.get = _stackGet_js__WEBPACK_IMPORTED_MODULE_3__["default"];\nStack.prototype.has = _stackHas_js__WEBPACK_IMPORTED_MODULE_4__["default"];\nStack.prototype.set = _stackSet_js__WEBPACK_IMPORTED_MODULE_5__["default"];\n\n/* harmony default export */ __webpack_exports__["default"] = (Stack);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_Stack.js?')},"./node_modules/lodash-es/_Symbol.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");\n\n\n/** Built-in value references. */\nvar Symbol = _root_js__WEBPACK_IMPORTED_MODULE_0__["default"].Symbol;\n\n/* harmony default export */ __webpack_exports__["default"] = (Symbol);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_Symbol.js?')},"./node_modules/lodash-es/_Uint8Array.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");\n\n\n/** Built-in value references. */\nvar Uint8Array = _root_js__WEBPACK_IMPORTED_MODULE_0__["default"].Uint8Array;\n\n/* harmony default export */ __webpack_exports__["default"] = (Uint8Array);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_Uint8Array.js?')},"./node_modules/lodash-es/_WeakMap.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getNative_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getNative.js */ "./node_modules/lodash-es/_getNative.js");\n/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");\n\n\n\n/* Built-in method references that are verified to be native. */\nvar WeakMap = (0,_getNative_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_root_js__WEBPACK_IMPORTED_MODULE_1__["default"], \'WeakMap\');\n\n/* harmony default export */ __webpack_exports__["default"] = (WeakMap);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_WeakMap.js?')},"./node_modules/lodash-es/_apply.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * A faster alternative to `Function#apply`, this function invokes `func`\n * with the `this` binding of `thisArg` and the arguments of `args`.\n *\n * @private\n * @param {Function} func The function to invoke.\n * @param {*} thisArg The `this` binding of `func`.\n * @param {Array} args The arguments to invoke `func` with.\n * @returns {*} Returns the result of `func`.\n */\nfunction apply(func, thisArg, args) {\n  switch (args.length) {\n    case 0: return func.call(thisArg);\n    case 1: return func.call(thisArg, args[0]);\n    case 2: return func.call(thisArg, args[0], args[1]);\n    case 3: return func.call(thisArg, args[0], args[1], args[2]);\n  }\n  return func.apply(thisArg, args);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (apply);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_apply.js?')},"./node_modules/lodash-es/_arrayEach.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * A specialized version of `_.forEach` for arrays without support for\n * iteratee shorthands.\n *\n * @private\n * @param {Array} [array] The array to iterate over.\n * @param {Function} iteratee The function invoked per iteration.\n * @returns {Array} Returns `array`.\n */\nfunction arrayEach(array, iteratee) {\n  var index = -1,\n      length = array == null ? 0 : array.length;\n\n  while (++index < length) {\n    if (iteratee(array[index], index, array) === false) {\n      break;\n    }\n  }\n  return array;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (arrayEach);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_arrayEach.js?')},"./node_modules/lodash-es/_arrayFilter.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * A specialized version of `_.filter` for arrays without support for\n * iteratee shorthands.\n *\n * @private\n * @param {Array} [array] The array to iterate over.\n * @param {Function} predicate The function invoked per iteration.\n * @returns {Array} Returns the new filtered array.\n */\nfunction arrayFilter(array, predicate) {\n  var index = -1,\n      length = array == null ? 0 : array.length,\n      resIndex = 0,\n      result = [];\n\n  while (++index < length) {\n    var value = array[index];\n    if (predicate(value, index, array)) {\n      result[resIndex++] = value;\n    }\n  }\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (arrayFilter);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_arrayFilter.js?')},"./node_modules/lodash-es/_arrayLikeKeys.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseTimes_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_baseTimes.js */ "./node_modules/lodash-es/_baseTimes.js");\n/* harmony import */ var _isArguments_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isArguments.js */ "./node_modules/lodash-es/isArguments.js");\n/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");\n/* harmony import */ var _isBuffer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isBuffer.js */ "./node_modules/lodash-es/isBuffer.js");\n/* harmony import */ var _isIndex_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_isIndex.js */ "./node_modules/lodash-es/_isIndex.js");\n/* harmony import */ var _isTypedArray_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./isTypedArray.js */ "./node_modules/lodash-es/isTypedArray.js");\n\n\n\n\n\n\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * Creates an array of the enumerable property names of the array-like `value`.\n *\n * @private\n * @param {*} value The value to query.\n * @param {boolean} inherited Specify returning inherited property names.\n * @returns {Array} Returns the array of property names.\n */\nfunction arrayLikeKeys(value, inherited) {\n  var isArr = (0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value),\n      isArg = !isArr && (0,_isArguments_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value),\n      isBuff = !isArr && !isArg && (0,_isBuffer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(value),\n      isType = !isArr && !isArg && !isBuff && (0,_isTypedArray_js__WEBPACK_IMPORTED_MODULE_3__["default"])(value),\n      skipIndexes = isArr || isArg || isBuff || isType,\n      result = skipIndexes ? (0,_baseTimes_js__WEBPACK_IMPORTED_MODULE_4__["default"])(value.length, String) : [],\n      length = result.length;\n\n  for (var key in value) {\n    if ((inherited || hasOwnProperty.call(value, key)) &&\n        !(skipIndexes && (\n           // Safari 9 has enumerable `arguments.length` in strict mode.\n           key == \'length\' ||\n           // Node.js 0.10 has enumerable non-index properties on buffers.\n           (isBuff && (key == \'offset\' || key == \'parent\')) ||\n           // PhantomJS 2 has enumerable non-index properties on typed arrays.\n           (isType && (key == \'buffer\' || key == \'byteLength\' || key == \'byteOffset\')) ||\n           // Skip index properties.\n           (0,_isIndex_js__WEBPACK_IMPORTED_MODULE_5__["default"])(key, length)\n        ))) {\n      result.push(key);\n    }\n  }\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (arrayLikeKeys);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_arrayLikeKeys.js?')},"./node_modules/lodash-es/_arrayPush.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Appends the elements of `values` to `array`.\n *\n * @private\n * @param {Array} array The array to modify.\n * @param {Array} values The values to append.\n * @returns {Array} Returns `array`.\n */\nfunction arrayPush(array, values) {\n  var index = -1,\n      length = values.length,\n      offset = array.length;\n\n  while (++index < length) {\n    array[offset + index] = values[index];\n  }\n  return array;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (arrayPush);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_arrayPush.js?')},"./node_modules/lodash-es/_arraySome.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * A specialized version of `_.some` for arrays without support for iteratee\n * shorthands.\n *\n * @private\n * @param {Array} [array] The array to iterate over.\n * @param {Function} predicate The function invoked per iteration.\n * @returns {boolean} Returns `true` if any element passes the predicate check,\n *  else `false`.\n */\nfunction arraySome(array, predicate) {\n  var index = -1,\n      length = array == null ? 0 : array.length;\n\n  while (++index < length) {\n    if (predicate(array[index], index, array)) {\n      return true;\n    }\n  }\n  return false;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (arraySome);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_arraySome.js?')},"./node_modules/lodash-es/_assignMergeValue.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseAssignValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseAssignValue.js */ "./node_modules/lodash-es/_baseAssignValue.js");\n/* harmony import */ var _eq_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./eq.js */ "./node_modules/lodash-es/eq.js");\n\n\n\n/**\n * This function is like `assignValue` except that it doesn\'t assign\n * `undefined` values.\n *\n * @private\n * @param {Object} object The object to modify.\n * @param {string} key The key of the property to assign.\n * @param {*} value The value to assign.\n */\nfunction assignMergeValue(object, key, value) {\n  if ((value !== undefined && !(0,_eq_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object[key], value)) ||\n      (value === undefined && !(key in object))) {\n    (0,_baseAssignValue_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object, key, value);\n  }\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (assignMergeValue);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_assignMergeValue.js?')},"./node_modules/lodash-es/_assignValue.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseAssignValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseAssignValue.js */ "./node_modules/lodash-es/_baseAssignValue.js");\n/* harmony import */ var _eq_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./eq.js */ "./node_modules/lodash-es/eq.js");\n\n\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * Assigns `value` to `key` of `object` if the existing value is not equivalent\n * using [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)\n * for equality comparisons.\n *\n * @private\n * @param {Object} object The object to modify.\n * @param {string} key The key of the property to assign.\n * @param {*} value The value to assign.\n */\nfunction assignValue(object, key, value) {\n  var objValue = object[key];\n  if (!(hasOwnProperty.call(object, key) && (0,_eq_js__WEBPACK_IMPORTED_MODULE_0__["default"])(objValue, value)) ||\n      (value === undefined && !(key in object))) {\n    (0,_baseAssignValue_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object, key, value);\n  }\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (assignValue);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_assignValue.js?')},"./node_modules/lodash-es/_assocIndexOf.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _eq_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./eq.js */ "./node_modules/lodash-es/eq.js");\n\n\n/**\n * Gets the index at which the `key` is found in `array` of key-value pairs.\n *\n * @private\n * @param {Array} array The array to inspect.\n * @param {*} key The key to search for.\n * @returns {number} Returns the index of the matched value, else `-1`.\n */\nfunction assocIndexOf(array, key) {\n  var length = array.length;\n  while (length--) {\n    if ((0,_eq_js__WEBPACK_IMPORTED_MODULE_0__["default"])(array[length][0], key)) {\n      return length;\n    }\n  }\n  return -1;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (assocIndexOf);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_assocIndexOf.js?')},"./node_modules/lodash-es/_baseAssign.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _copyObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_copyObject.js */ "./node_modules/lodash-es/_copyObject.js");\n/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./keys.js */ "./node_modules/lodash-es/keys.js");\n\n\n\n/**\n * The base implementation of `_.assign` without support for multiple sources\n * or `customizer` functions.\n *\n * @private\n * @param {Object} object The destination object.\n * @param {Object} source The source object.\n * @returns {Object} Returns `object`.\n */\nfunction baseAssign(object, source) {\n  return object && (0,_copyObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(source, (0,_keys_js__WEBPACK_IMPORTED_MODULE_1__["default"])(source), object);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseAssign);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseAssign.js?')},"./node_modules/lodash-es/_baseAssignIn.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _copyObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_copyObject.js */ "./node_modules/lodash-es/_copyObject.js");\n/* harmony import */ var _keysIn_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./keysIn.js */ "./node_modules/lodash-es/keysIn.js");\n\n\n\n/**\n * The base implementation of `_.assignIn` without support for multiple sources\n * or `customizer` functions.\n *\n * @private\n * @param {Object} object The destination object.\n * @param {Object} source The source object.\n * @returns {Object} Returns `object`.\n */\nfunction baseAssignIn(object, source) {\n  return object && (0,_copyObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(source, (0,_keysIn_js__WEBPACK_IMPORTED_MODULE_1__["default"])(source), object);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseAssignIn);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseAssignIn.js?')},"./node_modules/lodash-es/_baseAssignValue.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _defineProperty_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_defineProperty.js */ \"./node_modules/lodash-es/_defineProperty.js\");\n\n\n/**\n * The base implementation of `assignValue` and `assignMergeValue` without\n * value checks.\n *\n * @private\n * @param {Object} object The object to modify.\n * @param {string} key The key of the property to assign.\n * @param {*} value The value to assign.\n */\nfunction baseAssignValue(object, key, value) {\n  if (key == '__proto__' && _defineProperty_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]) {\n    (0,_defineProperty_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(object, key, {\n      'configurable': true,\n      'enumerable': true,\n      'value': value,\n      'writable': true\n    });\n  } else {\n    object[key] = value;\n  }\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (baseAssignValue);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseAssignValue.js?")},"./node_modules/lodash-es/_baseClone.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _Stack_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./_Stack.js */ "./node_modules/lodash-es/_Stack.js");\n/* harmony import */ var _arrayEach_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./_arrayEach.js */ "./node_modules/lodash-es/_arrayEach.js");\n/* harmony import */ var _assignValue_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./_assignValue.js */ "./node_modules/lodash-es/_assignValue.js");\n/* harmony import */ var _baseAssign_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./_baseAssign.js */ "./node_modules/lodash-es/_baseAssign.js");\n/* harmony import */ var _baseAssignIn_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./_baseAssignIn.js */ "./node_modules/lodash-es/_baseAssignIn.js");\n/* harmony import */ var _cloneBuffer_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_cloneBuffer.js */ "./node_modules/lodash-es/_cloneBuffer.js");\n/* harmony import */ var _copyArray_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_copyArray.js */ "./node_modules/lodash-es/_copyArray.js");\n/* harmony import */ var _copySymbols_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./_copySymbols.js */ "./node_modules/lodash-es/_copySymbols.js");\n/* harmony import */ var _copySymbolsIn_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./_copySymbolsIn.js */ "./node_modules/lodash-es/_copySymbolsIn.js");\n/* harmony import */ var _getAllKeys_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./_getAllKeys.js */ "./node_modules/lodash-es/_getAllKeys.js");\n/* harmony import */ var _getAllKeysIn_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./_getAllKeysIn.js */ "./node_modules/lodash-es/_getAllKeysIn.js");\n/* harmony import */ var _getTag_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_getTag.js */ "./node_modules/lodash-es/_getTag.js");\n/* harmony import */ var _initCloneArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_initCloneArray.js */ "./node_modules/lodash-es/_initCloneArray.js");\n/* harmony import */ var _initCloneByTag_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./_initCloneByTag.js */ "./node_modules/lodash-es/_initCloneByTag.js");\n/* harmony import */ var _initCloneObject_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./_initCloneObject.js */ "./node_modules/lodash-es/_initCloneObject.js");\n/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");\n/* harmony import */ var _isBuffer_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isBuffer.js */ "./node_modules/lodash-es/isBuffer.js");\n/* harmony import */ var _isMap_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./isMap.js */ "./node_modules/lodash-es/isMap.js");\n/* harmony import */ var _isObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject.js */ "./node_modules/lodash-es/isObject.js");\n/* harmony import */ var _isSet_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./isSet.js */ "./node_modules/lodash-es/isSet.js");\n/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./keys.js */ "./node_modules/lodash-es/keys.js");\n/* harmony import */ var _keysIn_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./keysIn.js */ "./node_modules/lodash-es/keysIn.js");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/** Used to compose bitmasks for cloning. */\nvar CLONE_DEEP_FLAG = 1,\n    CLONE_FLAT_FLAG = 2,\n    CLONE_SYMBOLS_FLAG = 4;\n\n/** `Object#toString` result references. */\nvar argsTag = \'[object Arguments]\',\n    arrayTag = \'[object Array]\',\n    boolTag = \'[object Boolean]\',\n    dateTag = \'[object Date]\',\n    errorTag = \'[object Error]\',\n    funcTag = \'[object Function]\',\n    genTag = \'[object GeneratorFunction]\',\n    mapTag = \'[object Map]\',\n    numberTag = \'[object Number]\',\n    objectTag = \'[object Object]\',\n    regexpTag = \'[object RegExp]\',\n    setTag = \'[object Set]\',\n    stringTag = \'[object String]\',\n    symbolTag = \'[object Symbol]\',\n    weakMapTag = \'[object WeakMap]\';\n\nvar arrayBufferTag = \'[object ArrayBuffer]\',\n    dataViewTag = \'[object DataView]\',\n    float32Tag = \'[object Float32Array]\',\n    float64Tag = \'[object Float64Array]\',\n    int8Tag = \'[object Int8Array]\',\n    int16Tag = \'[object Int16Array]\',\n    int32Tag = \'[object Int32Array]\',\n    uint8Tag = \'[object Uint8Array]\',\n    uint8ClampedTag = \'[object Uint8ClampedArray]\',\n    uint16Tag = \'[object Uint16Array]\',\n    uint32Tag = \'[object Uint32Array]\';\n\n/** Used to identify `toStringTag` values supported by `_.clone`. */\nvar cloneableTags = {};\ncloneableTags[argsTag] = cloneableTags[arrayTag] =\ncloneableTags[arrayBufferTag] = cloneableTags[dataViewTag] =\ncloneableTags[boolTag] = cloneableTags[dateTag] =\ncloneableTags[float32Tag] = cloneableTags[float64Tag] =\ncloneableTags[int8Tag] = cloneableTags[int16Tag] =\ncloneableTags[int32Tag] = cloneableTags[mapTag] =\ncloneableTags[numberTag] = cloneableTags[objectTag] =\ncloneableTags[regexpTag] = cloneableTags[setTag] =\ncloneableTags[stringTag] = cloneableTags[symbolTag] =\ncloneableTags[uint8Tag] = cloneableTags[uint8ClampedTag] =\ncloneableTags[uint16Tag] = cloneableTags[uint32Tag] = true;\ncloneableTags[errorTag] = cloneableTags[funcTag] =\ncloneableTags[weakMapTag] = false;\n\n/**\n * The base implementation of `_.clone` and `_.cloneDeep` which tracks\n * traversed objects.\n *\n * @private\n * @param {*} value The value to clone.\n * @param {boolean} bitmask The bitmask flags.\n *  1 - Deep clone\n *  2 - Flatten inherited properties\n *  4 - Clone symbols\n * @param {Function} [customizer] The function to customize cloning.\n * @param {string} [key] The key of `value`.\n * @param {Object} [object] The parent object of `value`.\n * @param {Object} [stack] Tracks traversed objects and their clone counterparts.\n * @returns {*} Returns the cloned value.\n */\nfunction baseClone(value, bitmask, customizer, key, object, stack) {\n  var result,\n      isDeep = bitmask & CLONE_DEEP_FLAG,\n      isFlat = bitmask & CLONE_FLAT_FLAG,\n      isFull = bitmask & CLONE_SYMBOLS_FLAG;\n\n  if (customizer) {\n    result = object ? customizer(value, key, object, stack) : customizer(value);\n  }\n  if (result !== undefined) {\n    return result;\n  }\n  if (!(0,_isObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value)) {\n    return value;\n  }\n  var isArr = (0,_isArray_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value);\n  if (isArr) {\n    result = (0,_initCloneArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(value);\n    if (!isDeep) {\n      return (0,_copyArray_js__WEBPACK_IMPORTED_MODULE_3__["default"])(value, result);\n    }\n  } else {\n    var tag = (0,_getTag_js__WEBPACK_IMPORTED_MODULE_4__["default"])(value),\n        isFunc = tag == funcTag || tag == genTag;\n\n    if ((0,_isBuffer_js__WEBPACK_IMPORTED_MODULE_5__["default"])(value)) {\n      return (0,_cloneBuffer_js__WEBPACK_IMPORTED_MODULE_6__["default"])(value, isDeep);\n    }\n    if (tag == objectTag || tag == argsTag || (isFunc && !object)) {\n      result = (isFlat || isFunc) ? {} : (0,_initCloneObject_js__WEBPACK_IMPORTED_MODULE_7__["default"])(value);\n      if (!isDeep) {\n        return isFlat\n          ? (0,_copySymbolsIn_js__WEBPACK_IMPORTED_MODULE_8__["default"])(value, (0,_baseAssignIn_js__WEBPACK_IMPORTED_MODULE_9__["default"])(result, value))\n          : (0,_copySymbols_js__WEBPACK_IMPORTED_MODULE_10__["default"])(value, (0,_baseAssign_js__WEBPACK_IMPORTED_MODULE_11__["default"])(result, value));\n      }\n    } else {\n      if (!cloneableTags[tag]) {\n        return object ? value : {};\n      }\n      result = (0,_initCloneByTag_js__WEBPACK_IMPORTED_MODULE_12__["default"])(value, tag, isDeep);\n    }\n  }\n  // Check for circular references and return its corresponding clone.\n  stack || (stack = new _Stack_js__WEBPACK_IMPORTED_MODULE_13__["default"]);\n  var stacked = stack.get(value);\n  if (stacked) {\n    return stacked;\n  }\n  stack.set(value, result);\n\n  if ((0,_isSet_js__WEBPACK_IMPORTED_MODULE_14__["default"])(value)) {\n    value.forEach(function(subValue) {\n      result.add(baseClone(subValue, bitmask, customizer, subValue, value, stack));\n    });\n  } else if ((0,_isMap_js__WEBPACK_IMPORTED_MODULE_15__["default"])(value)) {\n    value.forEach(function(subValue, key) {\n      result.set(key, baseClone(subValue, bitmask, customizer, key, value, stack));\n    });\n  }\n\n  var keysFunc = isFull\n    ? (isFlat ? _getAllKeysIn_js__WEBPACK_IMPORTED_MODULE_16__["default"] : _getAllKeys_js__WEBPACK_IMPORTED_MODULE_17__["default"])\n    : (isFlat ? _keysIn_js__WEBPACK_IMPORTED_MODULE_18__["default"] : _keys_js__WEBPACK_IMPORTED_MODULE_19__["default"]);\n\n  var props = isArr ? undefined : keysFunc(value);\n  (0,_arrayEach_js__WEBPACK_IMPORTED_MODULE_20__["default"])(props || value, function(subValue, key) {\n    if (props) {\n      key = subValue;\n      subValue = value[key];\n    }\n    // Recursively populate clone (susceptible to call stack limits).\n    (0,_assignValue_js__WEBPACK_IMPORTED_MODULE_21__["default"])(result, key, baseClone(subValue, bitmask, customizer, key, value, stack));\n  });\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseClone);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseClone.js?')},"./node_modules/lodash-es/_baseCreate.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _isObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject.js */ "./node_modules/lodash-es/isObject.js");\n\n\n/** Built-in value references. */\nvar objectCreate = Object.create;\n\n/**\n * The base implementation of `_.create` without support for assigning\n * properties to the created object.\n *\n * @private\n * @param {Object} proto The object to inherit from.\n * @returns {Object} Returns the new object.\n */\nvar baseCreate = (function() {\n  function object() {}\n  return function(proto) {\n    if (!(0,_isObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(proto)) {\n      return {};\n    }\n    if (objectCreate) {\n      return objectCreate(proto);\n    }\n    object.prototype = proto;\n    var result = new object;\n    object.prototype = undefined;\n    return result;\n  };\n}());\n\n/* harmony default export */ __webpack_exports__["default"] = (baseCreate);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseCreate.js?')},"./node_modules/lodash-es/_baseFor.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _createBaseFor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_createBaseFor.js */ "./node_modules/lodash-es/_createBaseFor.js");\n\n\n/**\n * The base implementation of `baseForOwn` which iterates over `object`\n * properties returned by `keysFunc` and invokes `iteratee` for each property.\n * Iteratee functions may exit iteration early by explicitly returning `false`.\n *\n * @private\n * @param {Object} object The object to iterate over.\n * @param {Function} iteratee The function invoked per iteration.\n * @param {Function} keysFunc The function to get the keys of `object`.\n * @returns {Object} Returns `object`.\n */\nvar baseFor = (0,_createBaseFor_js__WEBPACK_IMPORTED_MODULE_0__["default"])();\n\n/* harmony default export */ __webpack_exports__["default"] = (baseFor);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseFor.js?')},"./node_modules/lodash-es/_baseGetAllKeys.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _arrayPush_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arrayPush.js */ "./node_modules/lodash-es/_arrayPush.js");\n/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");\n\n\n\n/**\n * The base implementation of `getAllKeys` and `getAllKeysIn` which uses\n * `keysFunc` and `symbolsFunc` to get the enumerable property names and\n * symbols of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @param {Function} keysFunc The function to get the keys of `object`.\n * @param {Function} symbolsFunc The function to get the symbols of `object`.\n * @returns {Array} Returns the array of property names and symbols.\n */\nfunction baseGetAllKeys(object, keysFunc, symbolsFunc) {\n  var result = keysFunc(object);\n  return (0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object) ? result : (0,_arrayPush_js__WEBPACK_IMPORTED_MODULE_1__["default"])(result, symbolsFunc(object));\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseGetAllKeys);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseGetAllKeys.js?')},"./node_modules/lodash-es/_baseGetTag.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _Symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_Symbol.js */ "./node_modules/lodash-es/_Symbol.js");\n/* harmony import */ var _getRawTag_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_getRawTag.js */ "./node_modules/lodash-es/_getRawTag.js");\n/* harmony import */ var _objectToString_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_objectToString.js */ "./node_modules/lodash-es/_objectToString.js");\n\n\n\n\n/** `Object#toString` result references. */\nvar nullTag = \'[object Null]\',\n    undefinedTag = \'[object Undefined]\';\n\n/** Built-in value references. */\nvar symToStringTag = _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"].toStringTag : undefined;\n\n/**\n * The base implementation of `getTag` without fallbacks for buggy environments.\n *\n * @private\n * @param {*} value The value to query.\n * @returns {string} Returns the `toStringTag`.\n */\nfunction baseGetTag(value) {\n  if (value == null) {\n    return value === undefined ? undefinedTag : nullTag;\n  }\n  return (symToStringTag && symToStringTag in Object(value))\n    ? (0,_getRawTag_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value)\n    : (0,_objectToString_js__WEBPACK_IMPORTED_MODULE_2__["default"])(value);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseGetTag);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseGetTag.js?')},"./node_modules/lodash-es/_baseIsArguments.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseGetTag_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseGetTag.js */ "./node_modules/lodash-es/_baseGetTag.js");\n/* harmony import */ var _isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObjectLike.js */ "./node_modules/lodash-es/isObjectLike.js");\n\n\n\n/** `Object#toString` result references. */\nvar argsTag = \'[object Arguments]\';\n\n/**\n * The base implementation of `_.isArguments`.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an `arguments` object,\n */\nfunction baseIsArguments(value) {\n  return (0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value) && (0,_baseGetTag_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value) == argsTag;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseIsArguments);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseIsArguments.js?')},"./node_modules/lodash-es/_baseIsEqual.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseIsEqualDeep_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseIsEqualDeep.js */ "./node_modules/lodash-es/_baseIsEqualDeep.js");\n/* harmony import */ var _isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObjectLike.js */ "./node_modules/lodash-es/isObjectLike.js");\n\n\n\n/**\n * The base implementation of `_.isEqual` which supports partial comparisons\n * and tracks traversed objects.\n *\n * @private\n * @param {*} value The value to compare.\n * @param {*} other The other value to compare.\n * @param {boolean} bitmask The bitmask flags.\n *  1 - Unordered comparison\n *  2 - Partial comparison\n * @param {Function} [customizer] The function to customize comparisons.\n * @param {Object} [stack] Tracks traversed `value` and `other` objects.\n * @returns {boolean} Returns `true` if the values are equivalent, else `false`.\n */\nfunction baseIsEqual(value, other, bitmask, customizer, stack) {\n  if (value === other) {\n    return true;\n  }\n  if (value == null || other == null || (!(0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value) && !(0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(other))) {\n    return value !== value && other !== other;\n  }\n  return (0,_baseIsEqualDeep_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value, other, bitmask, customizer, baseIsEqual, stack);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseIsEqual);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseIsEqual.js?')},"./node_modules/lodash-es/_baseIsEqualDeep.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _Stack_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_Stack.js */ "./node_modules/lodash-es/_Stack.js");\n/* harmony import */ var _equalArrays_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_equalArrays.js */ "./node_modules/lodash-es/_equalArrays.js");\n/* harmony import */ var _equalByTag_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_equalByTag.js */ "./node_modules/lodash-es/_equalByTag.js");\n/* harmony import */ var _equalObjects_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./_equalObjects.js */ "./node_modules/lodash-es/_equalObjects.js");\n/* harmony import */ var _getTag_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_getTag.js */ "./node_modules/lodash-es/_getTag.js");\n/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");\n/* harmony import */ var _isBuffer_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isBuffer.js */ "./node_modules/lodash-es/isBuffer.js");\n/* harmony import */ var _isTypedArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./isTypedArray.js */ "./node_modules/lodash-es/isTypedArray.js");\n\n\n\n\n\n\n\n\n\n/** Used to compose bitmasks for value comparisons. */\nvar COMPARE_PARTIAL_FLAG = 1;\n\n/** `Object#toString` result references. */\nvar argsTag = \'[object Arguments]\',\n    arrayTag = \'[object Array]\',\n    objectTag = \'[object Object]\';\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * A specialized version of `baseIsEqual` for arrays and objects which performs\n * deep comparisons and tracks traversed objects enabling objects with circular\n * references to be compared.\n *\n * @private\n * @param {Object} object The object to compare.\n * @param {Object} other The other object to compare.\n * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.\n * @param {Function} customizer The function to customize comparisons.\n * @param {Function} equalFunc The function to determine equivalents of values.\n * @param {Object} [stack] Tracks traversed `object` and `other` objects.\n * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.\n */\nfunction baseIsEqualDeep(object, other, bitmask, customizer, equalFunc, stack) {\n  var objIsArr = (0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object),\n      othIsArr = (0,_isArray_js__WEBPACK_IMPORTED_MODULE_0__["default"])(other),\n      objTag = objIsArr ? arrayTag : (0,_getTag_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object),\n      othTag = othIsArr ? arrayTag : (0,_getTag_js__WEBPACK_IMPORTED_MODULE_1__["default"])(other);\n\n  objTag = objTag == argsTag ? objectTag : objTag;\n  othTag = othTag == argsTag ? objectTag : othTag;\n\n  var objIsObj = objTag == objectTag,\n      othIsObj = othTag == objectTag,\n      isSameTag = objTag == othTag;\n\n  if (isSameTag && (0,_isBuffer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(object)) {\n    if (!(0,_isBuffer_js__WEBPACK_IMPORTED_MODULE_2__["default"])(other)) {\n      return false;\n    }\n    objIsArr = true;\n    objIsObj = false;\n  }\n  if (isSameTag && !objIsObj) {\n    stack || (stack = new _Stack_js__WEBPACK_IMPORTED_MODULE_3__["default"]);\n    return (objIsArr || (0,_isTypedArray_js__WEBPACK_IMPORTED_MODULE_4__["default"])(object))\n      ? (0,_equalArrays_js__WEBPACK_IMPORTED_MODULE_5__["default"])(object, other, bitmask, customizer, equalFunc, stack)\n      : (0,_equalByTag_js__WEBPACK_IMPORTED_MODULE_6__["default"])(object, other, objTag, bitmask, customizer, equalFunc, stack);\n  }\n  if (!(bitmask & COMPARE_PARTIAL_FLAG)) {\n    var objIsWrapped = objIsObj && hasOwnProperty.call(object, \'__wrapped__\'),\n        othIsWrapped = othIsObj && hasOwnProperty.call(other, \'__wrapped__\');\n\n    if (objIsWrapped || othIsWrapped) {\n      var objUnwrapped = objIsWrapped ? object.value() : object,\n          othUnwrapped = othIsWrapped ? other.value() : other;\n\n      stack || (stack = new _Stack_js__WEBPACK_IMPORTED_MODULE_3__["default"]);\n      return equalFunc(objUnwrapped, othUnwrapped, bitmask, customizer, stack);\n    }\n  }\n  if (!isSameTag) {\n    return false;\n  }\n  stack || (stack = new _Stack_js__WEBPACK_IMPORTED_MODULE_3__["default"]);\n  return (0,_equalObjects_js__WEBPACK_IMPORTED_MODULE_7__["default"])(object, other, bitmask, customizer, equalFunc, stack);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseIsEqualDeep);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseIsEqualDeep.js?')},"./node_modules/lodash-es/_baseIsMap.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getTag_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_getTag.js */ "./node_modules/lodash-es/_getTag.js");\n/* harmony import */ var _isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObjectLike.js */ "./node_modules/lodash-es/isObjectLike.js");\n\n\n\n/** `Object#toString` result references. */\nvar mapTag = \'[object Map]\';\n\n/**\n * The base implementation of `_.isMap` without Node.js optimizations.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a map, else `false`.\n */\nfunction baseIsMap(value) {\n  return (0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value) && (0,_getTag_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value) == mapTag;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseIsMap);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseIsMap.js?')},"./node_modules/lodash-es/_baseIsNative.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _isFunction_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isFunction.js */ "./node_modules/lodash-es/isFunction.js");\n/* harmony import */ var _isMasked_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_isMasked.js */ "./node_modules/lodash-es/_isMasked.js");\n/* harmony import */ var _isObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject.js */ "./node_modules/lodash-es/isObject.js");\n/* harmony import */ var _toSource_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_toSource.js */ "./node_modules/lodash-es/_toSource.js");\n\n\n\n\n\n/**\n * Used to match `RegExp`\n * [syntax characters](http://ecma-international.org/ecma-262/7.0/#sec-patterns).\n */\nvar reRegExpChar = /[\\\\^$.*+?()[\\]{}|]/g;\n\n/** Used to detect host constructors (Safari). */\nvar reIsHostCtor = /^\\[object .+?Constructor\\]$/;\n\n/** Used for built-in method references. */\nvar funcProto = Function.prototype,\n    objectProto = Object.prototype;\n\n/** Used to resolve the decompiled source of functions. */\nvar funcToString = funcProto.toString;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/** Used to detect if a method is native. */\nvar reIsNative = RegExp(\'^\' +\n  funcToString.call(hasOwnProperty).replace(reRegExpChar, \'\\\\$&\')\n  .replace(/hasOwnProperty|(function).*?(?=\\\\\\()| for .+?(?=\\\\\\])/g, \'$1.*?\') + \'$\'\n);\n\n/**\n * The base implementation of `_.isNative` without bad shim checks.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a native function,\n *  else `false`.\n */\nfunction baseIsNative(value) {\n  if (!(0,_isObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value) || (0,_isMasked_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value)) {\n    return false;\n  }\n  var pattern = (0,_isFunction_js__WEBPACK_IMPORTED_MODULE_2__["default"])(value) ? reIsNative : reIsHostCtor;\n  return pattern.test((0,_toSource_js__WEBPACK_IMPORTED_MODULE_3__["default"])(value));\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseIsNative);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseIsNative.js?')},"./node_modules/lodash-es/_baseIsSet.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getTag_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_getTag.js */ "./node_modules/lodash-es/_getTag.js");\n/* harmony import */ var _isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObjectLike.js */ "./node_modules/lodash-es/isObjectLike.js");\n\n\n\n/** `Object#toString` result references. */\nvar setTag = \'[object Set]\';\n\n/**\n * The base implementation of `_.isSet` without Node.js optimizations.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a set, else `false`.\n */\nfunction baseIsSet(value) {\n  return (0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value) && (0,_getTag_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value) == setTag;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseIsSet);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseIsSet.js?')},"./node_modules/lodash-es/_baseIsTypedArray.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseGetTag_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_baseGetTag.js */ \"./node_modules/lodash-es/_baseGetTag.js\");\n/* harmony import */ var _isLength_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isLength.js */ \"./node_modules/lodash-es/isLength.js\");\n/* harmony import */ var _isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObjectLike.js */ \"./node_modules/lodash-es/isObjectLike.js\");\n\n\n\n\n/** `Object#toString` result references. */\nvar argsTag = '[object Arguments]',\n    arrayTag = '[object Array]',\n    boolTag = '[object Boolean]',\n    dateTag = '[object Date]',\n    errorTag = '[object Error]',\n    funcTag = '[object Function]',\n    mapTag = '[object Map]',\n    numberTag = '[object Number]',\n    objectTag = '[object Object]',\n    regexpTag = '[object RegExp]',\n    setTag = '[object Set]',\n    stringTag = '[object String]',\n    weakMapTag = '[object WeakMap]';\n\nvar arrayBufferTag = '[object ArrayBuffer]',\n    dataViewTag = '[object DataView]',\n    float32Tag = '[object Float32Array]',\n    float64Tag = '[object Float64Array]',\n    int8Tag = '[object Int8Array]',\n    int16Tag = '[object Int16Array]',\n    int32Tag = '[object Int32Array]',\n    uint8Tag = '[object Uint8Array]',\n    uint8ClampedTag = '[object Uint8ClampedArray]',\n    uint16Tag = '[object Uint16Array]',\n    uint32Tag = '[object Uint32Array]';\n\n/** Used to identify `toStringTag` values of typed arrays. */\nvar typedArrayTags = {};\ntypedArrayTags[float32Tag] = typedArrayTags[float64Tag] =\ntypedArrayTags[int8Tag] = typedArrayTags[int16Tag] =\ntypedArrayTags[int32Tag] = typedArrayTags[uint8Tag] =\ntypedArrayTags[uint8ClampedTag] = typedArrayTags[uint16Tag] =\ntypedArrayTags[uint32Tag] = true;\ntypedArrayTags[argsTag] = typedArrayTags[arrayTag] =\ntypedArrayTags[arrayBufferTag] = typedArrayTags[boolTag] =\ntypedArrayTags[dataViewTag] = typedArrayTags[dateTag] =\ntypedArrayTags[errorTag] = typedArrayTags[funcTag] =\ntypedArrayTags[mapTag] = typedArrayTags[numberTag] =\ntypedArrayTags[objectTag] = typedArrayTags[regexpTag] =\ntypedArrayTags[setTag] = typedArrayTags[stringTag] =\ntypedArrayTags[weakMapTag] = false;\n\n/**\n * The base implementation of `_.isTypedArray` without Node.js optimizations.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.\n */\nfunction baseIsTypedArray(value) {\n  return (0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(value) &&\n    (0,_isLength_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(value.length) && !!typedArrayTags[(0,_baseGetTag_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(value)];\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (baseIsTypedArray);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseIsTypedArray.js?")},"./node_modules/lodash-es/_baseKeys.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _isPrototype_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isPrototype.js */ "./node_modules/lodash-es/_isPrototype.js");\n/* harmony import */ var _nativeKeys_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_nativeKeys.js */ "./node_modules/lodash-es/_nativeKeys.js");\n\n\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * The base implementation of `_.keys` which doesn\'t treat sparse arrays as dense.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names.\n */\nfunction baseKeys(object) {\n  if (!(0,_isPrototype_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object)) {\n    return (0,_nativeKeys_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object);\n  }\n  var result = [];\n  for (var key in Object(object)) {\n    if (hasOwnProperty.call(object, key) && key != \'constructor\') {\n      result.push(key);\n    }\n  }\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseKeys);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseKeys.js?')},"./node_modules/lodash-es/_baseKeysIn.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _isObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject.js */ "./node_modules/lodash-es/isObject.js");\n/* harmony import */ var _isPrototype_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_isPrototype.js */ "./node_modules/lodash-es/_isPrototype.js");\n/* harmony import */ var _nativeKeysIn_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_nativeKeysIn.js */ "./node_modules/lodash-es/_nativeKeysIn.js");\n\n\n\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * The base implementation of `_.keysIn` which doesn\'t treat sparse arrays as dense.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names.\n */\nfunction baseKeysIn(object) {\n  if (!(0,_isObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object)) {\n    return (0,_nativeKeysIn_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object);\n  }\n  var isProto = (0,_isPrototype_js__WEBPACK_IMPORTED_MODULE_2__["default"])(object),\n      result = [];\n\n  for (var key in object) {\n    if (!(key == \'constructor\' && (isProto || !hasOwnProperty.call(object, key)))) {\n      result.push(key);\n    }\n  }\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseKeysIn);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseKeysIn.js?')},"./node_modules/lodash-es/_baseMerge.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _Stack_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_Stack.js */ "./node_modules/lodash-es/_Stack.js");\n/* harmony import */ var _assignMergeValue_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_assignMergeValue.js */ "./node_modules/lodash-es/_assignMergeValue.js");\n/* harmony import */ var _baseFor_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseFor.js */ "./node_modules/lodash-es/_baseFor.js");\n/* harmony import */ var _baseMergeDeep_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_baseMergeDeep.js */ "./node_modules/lodash-es/_baseMergeDeep.js");\n/* harmony import */ var _isObject_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isObject.js */ "./node_modules/lodash-es/isObject.js");\n/* harmony import */ var _keysIn_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./keysIn.js */ "./node_modules/lodash-es/keysIn.js");\n/* harmony import */ var _safeGet_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_safeGet.js */ "./node_modules/lodash-es/_safeGet.js");\n\n\n\n\n\n\n\n\n/**\n * The base implementation of `_.merge` without support for multiple sources.\n *\n * @private\n * @param {Object} object The destination object.\n * @param {Object} source The source object.\n * @param {number} srcIndex The index of `source`.\n * @param {Function} [customizer] The function to customize merged values.\n * @param {Object} [stack] Tracks traversed source values and their merged\n *  counterparts.\n */\nfunction baseMerge(object, source, srcIndex, customizer, stack) {\n  if (object === source) {\n    return;\n  }\n  (0,_baseFor_js__WEBPACK_IMPORTED_MODULE_0__["default"])(source, function(srcValue, key) {\n    stack || (stack = new _Stack_js__WEBPACK_IMPORTED_MODULE_1__["default"]);\n    if ((0,_isObject_js__WEBPACK_IMPORTED_MODULE_2__["default"])(srcValue)) {\n      (0,_baseMergeDeep_js__WEBPACK_IMPORTED_MODULE_3__["default"])(object, source, key, srcIndex, baseMerge, customizer, stack);\n    }\n    else {\n      var newValue = customizer\n        ? customizer((0,_safeGet_js__WEBPACK_IMPORTED_MODULE_4__["default"])(object, key), srcValue, (key + \'\'), object, source, stack)\n        : undefined;\n\n      if (newValue === undefined) {\n        newValue = srcValue;\n      }\n      (0,_assignMergeValue_js__WEBPACK_IMPORTED_MODULE_5__["default"])(object, key, newValue);\n    }\n  }, _keysIn_js__WEBPACK_IMPORTED_MODULE_6__["default"]);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseMerge);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseMerge.js?')},"./node_modules/lodash-es/_baseMergeDeep.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _assignMergeValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_assignMergeValue.js */ "./node_modules/lodash-es/_assignMergeValue.js");\n/* harmony import */ var _cloneBuffer_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./_cloneBuffer.js */ "./node_modules/lodash-es/_cloneBuffer.js");\n/* harmony import */ var _cloneTypedArray_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./_cloneTypedArray.js */ "./node_modules/lodash-es/_cloneTypedArray.js");\n/* harmony import */ var _copyArray_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_copyArray.js */ "./node_modules/lodash-es/_copyArray.js");\n/* harmony import */ var _initCloneObject_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./_initCloneObject.js */ "./node_modules/lodash-es/_initCloneObject.js");\n/* harmony import */ var _isArguments_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./isArguments.js */ "./node_modules/lodash-es/isArguments.js");\n/* harmony import */ var _isArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./isArray.js */ "./node_modules/lodash-es/isArray.js");\n/* harmony import */ var _isArrayLikeObject_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./isArrayLikeObject.js */ "./node_modules/lodash-es/isArrayLikeObject.js");\n/* harmony import */ var _isBuffer_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./isBuffer.js */ "./node_modules/lodash-es/isBuffer.js");\n/* harmony import */ var _isFunction_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./isFunction.js */ "./node_modules/lodash-es/isFunction.js");\n/* harmony import */ var _isObject_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./isObject.js */ "./node_modules/lodash-es/isObject.js");\n/* harmony import */ var _isPlainObject_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./isPlainObject.js */ "./node_modules/lodash-es/isPlainObject.js");\n/* harmony import */ var _isTypedArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./isTypedArray.js */ "./node_modules/lodash-es/isTypedArray.js");\n/* harmony import */ var _safeGet_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_safeGet.js */ "./node_modules/lodash-es/_safeGet.js");\n/* harmony import */ var _toPlainObject_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./toPlainObject.js */ "./node_modules/lodash-es/toPlainObject.js");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n/**\n * A specialized version of `baseMerge` for arrays and objects which performs\n * deep merges and tracks traversed objects enabling objects with circular\n * references to be merged.\n *\n * @private\n * @param {Object} object The destination object.\n * @param {Object} source The source object.\n * @param {string} key The key of the value to merge.\n * @param {number} srcIndex The index of `source`.\n * @param {Function} mergeFunc The function to merge values.\n * @param {Function} [customizer] The function to customize assigned values.\n * @param {Object} [stack] Tracks traversed source values and their merged\n *  counterparts.\n */\nfunction baseMergeDeep(object, source, key, srcIndex, mergeFunc, customizer, stack) {\n  var objValue = (0,_safeGet_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object, key),\n      srcValue = (0,_safeGet_js__WEBPACK_IMPORTED_MODULE_0__["default"])(source, key),\n      stacked = stack.get(srcValue);\n\n  if (stacked) {\n    (0,_assignMergeValue_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object, key, stacked);\n    return;\n  }\n  var newValue = customizer\n    ? customizer(objValue, srcValue, (key + \'\'), object, source, stack)\n    : undefined;\n\n  var isCommon = newValue === undefined;\n\n  if (isCommon) {\n    var isArr = (0,_isArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(srcValue),\n        isBuff = !isArr && (0,_isBuffer_js__WEBPACK_IMPORTED_MODULE_3__["default"])(srcValue),\n        isTyped = !isArr && !isBuff && (0,_isTypedArray_js__WEBPACK_IMPORTED_MODULE_4__["default"])(srcValue);\n\n    newValue = srcValue;\n    if (isArr || isBuff || isTyped) {\n      if ((0,_isArray_js__WEBPACK_IMPORTED_MODULE_2__["default"])(objValue)) {\n        newValue = objValue;\n      }\n      else if ((0,_isArrayLikeObject_js__WEBPACK_IMPORTED_MODULE_5__["default"])(objValue)) {\n        newValue = (0,_copyArray_js__WEBPACK_IMPORTED_MODULE_6__["default"])(objValue);\n      }\n      else if (isBuff) {\n        isCommon = false;\n        newValue = (0,_cloneBuffer_js__WEBPACK_IMPORTED_MODULE_7__["default"])(srcValue, true);\n      }\n      else if (isTyped) {\n        isCommon = false;\n        newValue = (0,_cloneTypedArray_js__WEBPACK_IMPORTED_MODULE_8__["default"])(srcValue, true);\n      }\n      else {\n        newValue = [];\n      }\n    }\n    else if ((0,_isPlainObject_js__WEBPACK_IMPORTED_MODULE_9__["default"])(srcValue) || (0,_isArguments_js__WEBPACK_IMPORTED_MODULE_10__["default"])(srcValue)) {\n      newValue = objValue;\n      if ((0,_isArguments_js__WEBPACK_IMPORTED_MODULE_10__["default"])(objValue)) {\n        newValue = (0,_toPlainObject_js__WEBPACK_IMPORTED_MODULE_11__["default"])(objValue);\n      }\n      else if (!(0,_isObject_js__WEBPACK_IMPORTED_MODULE_12__["default"])(objValue) || (0,_isFunction_js__WEBPACK_IMPORTED_MODULE_13__["default"])(objValue)) {\n        newValue = (0,_initCloneObject_js__WEBPACK_IMPORTED_MODULE_14__["default"])(srcValue);\n      }\n    }\n    else {\n      isCommon = false;\n    }\n  }\n  if (isCommon) {\n    // Recursively merge objects and arrays (susceptible to call stack limits).\n    stack.set(srcValue, newValue);\n    mergeFunc(newValue, srcValue, srcIndex, customizer, stack);\n    stack[\'delete\'](srcValue);\n  }\n  (0,_assignMergeValue_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object, key, newValue);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseMergeDeep);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseMergeDeep.js?')},"./node_modules/lodash-es/_baseRest.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _identity_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./identity.js */ "./node_modules/lodash-es/identity.js");\n/* harmony import */ var _overRest_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_overRest.js */ "./node_modules/lodash-es/_overRest.js");\n/* harmony import */ var _setToString_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_setToString.js */ "./node_modules/lodash-es/_setToString.js");\n\n\n\n\n/**\n * The base implementation of `_.rest` which doesn\'t validate or coerce arguments.\n *\n * @private\n * @param {Function} func The function to apply a rest parameter to.\n * @param {number} [start=func.length-1] The start position of the rest parameter.\n * @returns {Function} Returns the new function.\n */\nfunction baseRest(func, start) {\n  return (0,_setToString_js__WEBPACK_IMPORTED_MODULE_0__["default"])((0,_overRest_js__WEBPACK_IMPORTED_MODULE_1__["default"])(func, start, _identity_js__WEBPACK_IMPORTED_MODULE_2__["default"]), func + \'\');\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseRest);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseRest.js?')},"./node_modules/lodash-es/_baseSetToString.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _constant_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./constant.js */ "./node_modules/lodash-es/constant.js");\n/* harmony import */ var _defineProperty_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_defineProperty.js */ "./node_modules/lodash-es/_defineProperty.js");\n/* harmony import */ var _identity_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./identity.js */ "./node_modules/lodash-es/identity.js");\n\n\n\n\n/**\n * The base implementation of `setToString` without support for hot loop shorting.\n *\n * @private\n * @param {Function} func The function to modify.\n * @param {Function} string The `toString` result.\n * @returns {Function} Returns `func`.\n */\nvar baseSetToString = !_defineProperty_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? _identity_js__WEBPACK_IMPORTED_MODULE_1__["default"] : function(func, string) {\n  return (0,_defineProperty_js__WEBPACK_IMPORTED_MODULE_0__["default"])(func, \'toString\', {\n    \'configurable\': true,\n    \'enumerable\': false,\n    \'value\': (0,_constant_js__WEBPACK_IMPORTED_MODULE_2__["default"])(string),\n    \'writable\': true\n  });\n};\n\n/* harmony default export */ __webpack_exports__["default"] = (baseSetToString);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseSetToString.js?')},"./node_modules/lodash-es/_baseTimes.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * The base implementation of `_.times` without support for iteratee shorthands\n * or max array length checks.\n *\n * @private\n * @param {number} n The number of times to invoke `iteratee`.\n * @param {Function} iteratee The function invoked per iteration.\n * @returns {Array} Returns the array of results.\n */\nfunction baseTimes(n, iteratee) {\n  var index = -1,\n      result = Array(n);\n\n  while (++index < n) {\n    result[index] = iteratee(index);\n  }\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseTimes);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseTimes.js?')},"./node_modules/lodash-es/_baseUnary.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * The base implementation of `_.unary` without support for storing metadata.\n *\n * @private\n * @param {Function} func The function to cap arguments for.\n * @returns {Function} Returns the new capped function.\n */\nfunction baseUnary(func) {\n  return function(value) {\n    return func(value);\n  };\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (baseUnary);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_baseUnary.js?')},"./node_modules/lodash-es/_cacheHas.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Checks if a `cache` value for `key` exists.\n *\n * @private\n * @param {Object} cache The cache to query.\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction cacheHas(cache, key) {\n  return cache.has(key);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (cacheHas);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_cacheHas.js?')},"./node_modules/lodash-es/_cloneArrayBuffer.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _Uint8Array_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_Uint8Array.js */ "./node_modules/lodash-es/_Uint8Array.js");\n\n\n/**\n * Creates a clone of `arrayBuffer`.\n *\n * @private\n * @param {ArrayBuffer} arrayBuffer The array buffer to clone.\n * @returns {ArrayBuffer} Returns the cloned array buffer.\n */\nfunction cloneArrayBuffer(arrayBuffer) {\n  var result = new arrayBuffer.constructor(arrayBuffer.byteLength);\n  new _Uint8Array_js__WEBPACK_IMPORTED_MODULE_0__["default"](result).set(new _Uint8Array_js__WEBPACK_IMPORTED_MODULE_0__["default"](arrayBuffer));\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (cloneArrayBuffer);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_cloneArrayBuffer.js?')},"./node_modules/lodash-es/_cloneBuffer.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");\n\n\n/** Detect free variable `exports`. */\nvar freeExports = typeof exports == \'object\' && exports && !exports.nodeType && exports;\n\n/** Detect free variable `module`. */\nvar freeModule = freeExports && typeof module == \'object\' && module && !module.nodeType && module;\n\n/** Detect the popular CommonJS extension `module.exports`. */\nvar moduleExports = freeModule && freeModule.exports === freeExports;\n\n/** Built-in value references. */\nvar Buffer = moduleExports ? _root_js__WEBPACK_IMPORTED_MODULE_0__["default"].Buffer : undefined,\n    allocUnsafe = Buffer ? Buffer.allocUnsafe : undefined;\n\n/**\n * Creates a clone of  `buffer`.\n *\n * @private\n * @param {Buffer} buffer The buffer to clone.\n * @param {boolean} [isDeep] Specify a deep clone.\n * @returns {Buffer} Returns the cloned buffer.\n */\nfunction cloneBuffer(buffer, isDeep) {\n  if (isDeep) {\n    return buffer.slice();\n  }\n  var length = buffer.length,\n      result = allocUnsafe ? allocUnsafe(length) : new buffer.constructor(length);\n\n  buffer.copy(result);\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (cloneBuffer);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_cloneBuffer.js?')},"./node_modules/lodash-es/_cloneDataView.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _cloneArrayBuffer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_cloneArrayBuffer.js */ "./node_modules/lodash-es/_cloneArrayBuffer.js");\n\n\n/**\n * Creates a clone of `dataView`.\n *\n * @private\n * @param {Object} dataView The data view to clone.\n * @param {boolean} [isDeep] Specify a deep clone.\n * @returns {Object} Returns the cloned data view.\n */\nfunction cloneDataView(dataView, isDeep) {\n  var buffer = isDeep ? (0,_cloneArrayBuffer_js__WEBPACK_IMPORTED_MODULE_0__["default"])(dataView.buffer) : dataView.buffer;\n  return new dataView.constructor(buffer, dataView.byteOffset, dataView.byteLength);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (cloneDataView);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_cloneDataView.js?')},"./node_modules/lodash-es/_cloneRegExp.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/** Used to match `RegExp` flags from their coerced string values. */\nvar reFlags = /\\w*$/;\n\n/**\n * Creates a clone of `regexp`.\n *\n * @private\n * @param {Object} regexp The regexp to clone.\n * @returns {Object} Returns the cloned regexp.\n */\nfunction cloneRegExp(regexp) {\n  var result = new regexp.constructor(regexp.source, reFlags.exec(regexp));\n  result.lastIndex = regexp.lastIndex;\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (cloneRegExp);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_cloneRegExp.js?')},"./node_modules/lodash-es/_cloneSymbol.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _Symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_Symbol.js */ "./node_modules/lodash-es/_Symbol.js");\n\n\n/** Used to convert symbols to primitives and strings. */\nvar symbolProto = _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"].prototype : undefined,\n    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;\n\n/**\n * Creates a clone of the `symbol` object.\n *\n * @private\n * @param {Object} symbol The symbol object to clone.\n * @returns {Object} Returns the cloned symbol object.\n */\nfunction cloneSymbol(symbol) {\n  return symbolValueOf ? Object(symbolValueOf.call(symbol)) : {};\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (cloneSymbol);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_cloneSymbol.js?')},"./node_modules/lodash-es/_cloneTypedArray.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _cloneArrayBuffer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_cloneArrayBuffer.js */ "./node_modules/lodash-es/_cloneArrayBuffer.js");\n\n\n/**\n * Creates a clone of `typedArray`.\n *\n * @private\n * @param {Object} typedArray The typed array to clone.\n * @param {boolean} [isDeep] Specify a deep clone.\n * @returns {Object} Returns the cloned typed array.\n */\nfunction cloneTypedArray(typedArray, isDeep) {\n  var buffer = isDeep ? (0,_cloneArrayBuffer_js__WEBPACK_IMPORTED_MODULE_0__["default"])(typedArray.buffer) : typedArray.buffer;\n  return new typedArray.constructor(buffer, typedArray.byteOffset, typedArray.length);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (cloneTypedArray);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_cloneTypedArray.js?')},"./node_modules/lodash-es/_copyArray.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Copies the values of `source` to `array`.\n *\n * @private\n * @param {Array} source The array to copy values from.\n * @param {Array} [array=[]] The array to copy values to.\n * @returns {Array} Returns `array`.\n */\nfunction copyArray(source, array) {\n  var index = -1,\n      length = source.length;\n\n  array || (array = Array(length));\n  while (++index < length) {\n    array[index] = source[index];\n  }\n  return array;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (copyArray);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_copyArray.js?')},"./node_modules/lodash-es/_copyObject.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _assignValue_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_assignValue.js */ "./node_modules/lodash-es/_assignValue.js");\n/* harmony import */ var _baseAssignValue_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseAssignValue.js */ "./node_modules/lodash-es/_baseAssignValue.js");\n\n\n\n/**\n * Copies properties of `source` to `object`.\n *\n * @private\n * @param {Object} source The object to copy properties from.\n * @param {Array} props The property identifiers to copy.\n * @param {Object} [object={}] The object to copy properties to.\n * @param {Function} [customizer] The function to customize copied values.\n * @returns {Object} Returns `object`.\n */\nfunction copyObject(source, props, object, customizer) {\n  var isNew = !object;\n  object || (object = {});\n\n  var index = -1,\n      length = props.length;\n\n  while (++index < length) {\n    var key = props[index];\n\n    var newValue = customizer\n      ? customizer(object[key], source[key], key, object, source)\n      : undefined;\n\n    if (newValue === undefined) {\n      newValue = source[key];\n    }\n    if (isNew) {\n      (0,_baseAssignValue_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object, key, newValue);\n    } else {\n      (0,_assignValue_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object, key, newValue);\n    }\n  }\n  return object;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (copyObject);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_copyObject.js?')},"./node_modules/lodash-es/_copySymbols.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _copyObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_copyObject.js */ "./node_modules/lodash-es/_copyObject.js");\n/* harmony import */ var _getSymbols_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_getSymbols.js */ "./node_modules/lodash-es/_getSymbols.js");\n\n\n\n/**\n * Copies own symbols of `source` to `object`.\n *\n * @private\n * @param {Object} source The object to copy symbols from.\n * @param {Object} [object={}] The object to copy symbols to.\n * @returns {Object} Returns `object`.\n */\nfunction copySymbols(source, object) {\n  return (0,_copyObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(source, (0,_getSymbols_js__WEBPACK_IMPORTED_MODULE_1__["default"])(source), object);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (copySymbols);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_copySymbols.js?')},"./node_modules/lodash-es/_copySymbolsIn.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _copyObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_copyObject.js */ "./node_modules/lodash-es/_copyObject.js");\n/* harmony import */ var _getSymbolsIn_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_getSymbolsIn.js */ "./node_modules/lodash-es/_getSymbolsIn.js");\n\n\n\n/**\n * Copies own and inherited symbols of `source` to `object`.\n *\n * @private\n * @param {Object} source The object to copy symbols from.\n * @param {Object} [object={}] The object to copy symbols to.\n * @returns {Object} Returns `object`.\n */\nfunction copySymbolsIn(source, object) {\n  return (0,_copyObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(source, (0,_getSymbolsIn_js__WEBPACK_IMPORTED_MODULE_1__["default"])(source), object);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (copySymbolsIn);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_copySymbolsIn.js?')},"./node_modules/lodash-es/_coreJsData.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");\n\n\n/** Used to detect overreaching core-js shims. */\nvar coreJsData = _root_js__WEBPACK_IMPORTED_MODULE_0__["default"][\'__core-js_shared__\'];\n\n/* harmony default export */ __webpack_exports__["default"] = (coreJsData);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_coreJsData.js?')},"./node_modules/lodash-es/_createAssigner.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseRest_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseRest.js */ "./node_modules/lodash-es/_baseRest.js");\n/* harmony import */ var _isIterateeCall_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_isIterateeCall.js */ "./node_modules/lodash-es/_isIterateeCall.js");\n\n\n\n/**\n * Creates a function like `_.assign`.\n *\n * @private\n * @param {Function} assigner The function to assign values.\n * @returns {Function} Returns the new assigner function.\n */\nfunction createAssigner(assigner) {\n  return (0,_baseRest_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function(object, sources) {\n    var index = -1,\n        length = sources.length,\n        customizer = length > 1 ? sources[length - 1] : undefined,\n        guard = length > 2 ? sources[2] : undefined;\n\n    customizer = (assigner.length > 3 && typeof customizer == \'function\')\n      ? (length--, customizer)\n      : undefined;\n\n    if (guard && (0,_isIterateeCall_js__WEBPACK_IMPORTED_MODULE_1__["default"])(sources[0], sources[1], guard)) {\n      customizer = length < 3 ? undefined : customizer;\n      length = 1;\n    }\n    object = Object(object);\n    while (++index < length) {\n      var source = sources[index];\n      if (source) {\n        assigner(object, source, index, customizer);\n      }\n    }\n    return object;\n  });\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (createAssigner);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_createAssigner.js?')},"./node_modules/lodash-es/_createBaseFor.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Creates a base function for methods like `_.forIn` and `_.forOwn`.\n *\n * @private\n * @param {boolean} [fromRight] Specify iterating from right to left.\n * @returns {Function} Returns the new base function.\n */\nfunction createBaseFor(fromRight) {\n  return function(object, iteratee, keysFunc) {\n    var index = -1,\n        iterable = Object(object),\n        props = keysFunc(object),\n        length = props.length;\n\n    while (length--) {\n      var key = props[fromRight ? length : ++index];\n      if (iteratee(iterable[key], key, iterable) === false) {\n        break;\n      }\n    }\n    return object;\n  };\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (createBaseFor);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_createBaseFor.js?')},"./node_modules/lodash-es/_defineProperty.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getNative_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getNative.js */ "./node_modules/lodash-es/_getNative.js");\n\n\nvar defineProperty = (function() {\n  try {\n    var func = (0,_getNative_js__WEBPACK_IMPORTED_MODULE_0__["default"])(Object, \'defineProperty\');\n    func({}, \'\', {});\n    return func;\n  } catch (e) {}\n}());\n\n/* harmony default export */ __webpack_exports__["default"] = (defineProperty);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_defineProperty.js?')},"./node_modules/lodash-es/_equalArrays.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _SetCache_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_SetCache.js */ "./node_modules/lodash-es/_SetCache.js");\n/* harmony import */ var _arraySome_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arraySome.js */ "./node_modules/lodash-es/_arraySome.js");\n/* harmony import */ var _cacheHas_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_cacheHas.js */ "./node_modules/lodash-es/_cacheHas.js");\n\n\n\n\n/** Used to compose bitmasks for value comparisons. */\nvar COMPARE_PARTIAL_FLAG = 1,\n    COMPARE_UNORDERED_FLAG = 2;\n\n/**\n * A specialized version of `baseIsEqualDeep` for arrays with support for\n * partial deep comparisons.\n *\n * @private\n * @param {Array} array The array to compare.\n * @param {Array} other The other array to compare.\n * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.\n * @param {Function} customizer The function to customize comparisons.\n * @param {Function} equalFunc The function to determine equivalents of values.\n * @param {Object} stack Tracks traversed `array` and `other` objects.\n * @returns {boolean} Returns `true` if the arrays are equivalent, else `false`.\n */\nfunction equalArrays(array, other, bitmask, customizer, equalFunc, stack) {\n  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,\n      arrLength = array.length,\n      othLength = other.length;\n\n  if (arrLength != othLength && !(isPartial && othLength > arrLength)) {\n    return false;\n  }\n  // Check that cyclic values are equal.\n  var arrStacked = stack.get(array);\n  var othStacked = stack.get(other);\n  if (arrStacked && othStacked) {\n    return arrStacked == other && othStacked == array;\n  }\n  var index = -1,\n      result = true,\n      seen = (bitmask & COMPARE_UNORDERED_FLAG) ? new _SetCache_js__WEBPACK_IMPORTED_MODULE_0__["default"] : undefined;\n\n  stack.set(array, other);\n  stack.set(other, array);\n\n  // Ignore non-index properties.\n  while (++index < arrLength) {\n    var arrValue = array[index],\n        othValue = other[index];\n\n    if (customizer) {\n      var compared = isPartial\n        ? customizer(othValue, arrValue, index, other, array, stack)\n        : customizer(arrValue, othValue, index, array, other, stack);\n    }\n    if (compared !== undefined) {\n      if (compared) {\n        continue;\n      }\n      result = false;\n      break;\n    }\n    // Recursively compare arrays (susceptible to call stack limits).\n    if (seen) {\n      if (!(0,_arraySome_js__WEBPACK_IMPORTED_MODULE_1__["default"])(other, function(othValue, othIndex) {\n            if (!(0,_cacheHas_js__WEBPACK_IMPORTED_MODULE_2__["default"])(seen, othIndex) &&\n                (arrValue === othValue || equalFunc(arrValue, othValue, bitmask, customizer, stack))) {\n              return seen.push(othIndex);\n            }\n          })) {\n        result = false;\n        break;\n      }\n    } else if (!(\n          arrValue === othValue ||\n            equalFunc(arrValue, othValue, bitmask, customizer, stack)\n        )) {\n      result = false;\n      break;\n    }\n  }\n  stack[\'delete\'](array);\n  stack[\'delete\'](other);\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (equalArrays);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_equalArrays.js?')},"./node_modules/lodash-es/_equalByTag.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _Symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_Symbol.js */ "./node_modules/lodash-es/_Symbol.js");\n/* harmony import */ var _Uint8Array_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_Uint8Array.js */ "./node_modules/lodash-es/_Uint8Array.js");\n/* harmony import */ var _eq_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./eq.js */ "./node_modules/lodash-es/eq.js");\n/* harmony import */ var _equalArrays_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_equalArrays.js */ "./node_modules/lodash-es/_equalArrays.js");\n/* harmony import */ var _mapToArray_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_mapToArray.js */ "./node_modules/lodash-es/_mapToArray.js");\n/* harmony import */ var _setToArray_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_setToArray.js */ "./node_modules/lodash-es/_setToArray.js");\n\n\n\n\n\n\n\n/** Used to compose bitmasks for value comparisons. */\nvar COMPARE_PARTIAL_FLAG = 1,\n    COMPARE_UNORDERED_FLAG = 2;\n\n/** `Object#toString` result references. */\nvar boolTag = \'[object Boolean]\',\n    dateTag = \'[object Date]\',\n    errorTag = \'[object Error]\',\n    mapTag = \'[object Map]\',\n    numberTag = \'[object Number]\',\n    regexpTag = \'[object RegExp]\',\n    setTag = \'[object Set]\',\n    stringTag = \'[object String]\',\n    symbolTag = \'[object Symbol]\';\n\nvar arrayBufferTag = \'[object ArrayBuffer]\',\n    dataViewTag = \'[object DataView]\';\n\n/** Used to convert symbols to primitives and strings. */\nvar symbolProto = _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"].prototype : undefined,\n    symbolValueOf = symbolProto ? symbolProto.valueOf : undefined;\n\n/**\n * A specialized version of `baseIsEqualDeep` for comparing objects of\n * the same `toStringTag`.\n *\n * **Note:** This function only supports comparing values with tags of\n * `Boolean`, `Date`, `Error`, `Number`, `RegExp`, or `String`.\n *\n * @private\n * @param {Object} object The object to compare.\n * @param {Object} other The other object to compare.\n * @param {string} tag The `toStringTag` of the objects to compare.\n * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.\n * @param {Function} customizer The function to customize comparisons.\n * @param {Function} equalFunc The function to determine equivalents of values.\n * @param {Object} stack Tracks traversed `object` and `other` objects.\n * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.\n */\nfunction equalByTag(object, other, tag, bitmask, customizer, equalFunc, stack) {\n  switch (tag) {\n    case dataViewTag:\n      if ((object.byteLength != other.byteLength) ||\n          (object.byteOffset != other.byteOffset)) {\n        return false;\n      }\n      object = object.buffer;\n      other = other.buffer;\n\n    case arrayBufferTag:\n      if ((object.byteLength != other.byteLength) ||\n          !equalFunc(new _Uint8Array_js__WEBPACK_IMPORTED_MODULE_1__["default"](object), new _Uint8Array_js__WEBPACK_IMPORTED_MODULE_1__["default"](other))) {\n        return false;\n      }\n      return true;\n\n    case boolTag:\n    case dateTag:\n    case numberTag:\n      // Coerce booleans to `1` or `0` and dates to milliseconds.\n      // Invalid dates are coerced to `NaN`.\n      return (0,_eq_js__WEBPACK_IMPORTED_MODULE_2__["default"])(+object, +other);\n\n    case errorTag:\n      return object.name == other.name && object.message == other.message;\n\n    case regexpTag:\n    case stringTag:\n      // Coerce regexes to strings and treat strings, primitives and objects,\n      // as equal. See http://www.ecma-international.org/ecma-262/7.0/#sec-regexp.prototype.tostring\n      // for more details.\n      return object == (other + \'\');\n\n    case mapTag:\n      var convert = _mapToArray_js__WEBPACK_IMPORTED_MODULE_3__["default"];\n\n    case setTag:\n      var isPartial = bitmask & COMPARE_PARTIAL_FLAG;\n      convert || (convert = _setToArray_js__WEBPACK_IMPORTED_MODULE_4__["default"]);\n\n      if (object.size != other.size && !isPartial) {\n        return false;\n      }\n      // Assume cyclic values are equal.\n      var stacked = stack.get(object);\n      if (stacked) {\n        return stacked == other;\n      }\n      bitmask |= COMPARE_UNORDERED_FLAG;\n\n      // Recursively compare objects (susceptible to call stack limits).\n      stack.set(object, other);\n      var result = (0,_equalArrays_js__WEBPACK_IMPORTED_MODULE_5__["default"])(convert(object), convert(other), bitmask, customizer, equalFunc, stack);\n      stack[\'delete\'](object);\n      return result;\n\n    case symbolTag:\n      if (symbolValueOf) {\n        return symbolValueOf.call(object) == symbolValueOf.call(other);\n      }\n  }\n  return false;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (equalByTag);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_equalByTag.js?')},"./node_modules/lodash-es/_equalObjects.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getAllKeys_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getAllKeys.js */ \"./node_modules/lodash-es/_getAllKeys.js\");\n\n\n/** Used to compose bitmasks for value comparisons. */\nvar COMPARE_PARTIAL_FLAG = 1;\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * A specialized version of `baseIsEqualDeep` for objects with support for\n * partial deep comparisons.\n *\n * @private\n * @param {Object} object The object to compare.\n * @param {Object} other The other object to compare.\n * @param {number} bitmask The bitmask flags. See `baseIsEqual` for more details.\n * @param {Function} customizer The function to customize comparisons.\n * @param {Function} equalFunc The function to determine equivalents of values.\n * @param {Object} stack Tracks traversed `object` and `other` objects.\n * @returns {boolean} Returns `true` if the objects are equivalent, else `false`.\n */\nfunction equalObjects(object, other, bitmask, customizer, equalFunc, stack) {\n  var isPartial = bitmask & COMPARE_PARTIAL_FLAG,\n      objProps = (0,_getAllKeys_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(object),\n      objLength = objProps.length,\n      othProps = (0,_getAllKeys_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(other),\n      othLength = othProps.length;\n\n  if (objLength != othLength && !isPartial) {\n    return false;\n  }\n  var index = objLength;\n  while (index--) {\n    var key = objProps[index];\n    if (!(isPartial ? key in other : hasOwnProperty.call(other, key))) {\n      return false;\n    }\n  }\n  // Check that cyclic values are equal.\n  var objStacked = stack.get(object);\n  var othStacked = stack.get(other);\n  if (objStacked && othStacked) {\n    return objStacked == other && othStacked == object;\n  }\n  var result = true;\n  stack.set(object, other);\n  stack.set(other, object);\n\n  var skipCtor = isPartial;\n  while (++index < objLength) {\n    key = objProps[index];\n    var objValue = object[key],\n        othValue = other[key];\n\n    if (customizer) {\n      var compared = isPartial\n        ? customizer(othValue, objValue, key, other, object, stack)\n        : customizer(objValue, othValue, key, object, other, stack);\n    }\n    // Recursively compare objects (susceptible to call stack limits).\n    if (!(compared === undefined\n          ? (objValue === othValue || equalFunc(objValue, othValue, bitmask, customizer, stack))\n          : compared\n        )) {\n      result = false;\n      break;\n    }\n    skipCtor || (skipCtor = key == 'constructor');\n  }\n  if (result && !skipCtor) {\n    var objCtor = object.constructor,\n        othCtor = other.constructor;\n\n    // Non `Object` object instances with different constructors are not equal.\n    if (objCtor != othCtor &&\n        ('constructor' in object && 'constructor' in other) &&\n        !(typeof objCtor == 'function' && objCtor instanceof objCtor &&\n          typeof othCtor == 'function' && othCtor instanceof othCtor)) {\n      result = false;\n    }\n  }\n  stack['delete'](object);\n  stack['delete'](other);\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (equalObjects);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_equalObjects.js?")},"./node_modules/lodash-es/_freeGlobal.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/** Detect free variable `global` from Node.js. */\nvar freeGlobal = typeof global == 'object' && global && global.Object === Object && global;\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (freeGlobal);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_freeGlobal.js?")},"./node_modules/lodash-es/_getAllKeys.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseGetAllKeys_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseGetAllKeys.js */ "./node_modules/lodash-es/_baseGetAllKeys.js");\n/* harmony import */ var _getSymbols_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_getSymbols.js */ "./node_modules/lodash-es/_getSymbols.js");\n/* harmony import */ var _keys_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./keys.js */ "./node_modules/lodash-es/keys.js");\n\n\n\n\n/**\n * Creates an array of own enumerable property names and symbols of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names and symbols.\n */\nfunction getAllKeys(object) {\n  return (0,_baseGetAllKeys_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object, _keys_js__WEBPACK_IMPORTED_MODULE_1__["default"], _getSymbols_js__WEBPACK_IMPORTED_MODULE_2__["default"]);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (getAllKeys);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_getAllKeys.js?')},"./node_modules/lodash-es/_getAllKeysIn.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseGetAllKeys_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseGetAllKeys.js */ "./node_modules/lodash-es/_baseGetAllKeys.js");\n/* harmony import */ var _getSymbolsIn_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_getSymbolsIn.js */ "./node_modules/lodash-es/_getSymbolsIn.js");\n/* harmony import */ var _keysIn_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./keysIn.js */ "./node_modules/lodash-es/keysIn.js");\n\n\n\n\n/**\n * Creates an array of own and inherited enumerable property names and\n * symbols of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names and symbols.\n */\nfunction getAllKeysIn(object) {\n  return (0,_baseGetAllKeys_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object, _keysIn_js__WEBPACK_IMPORTED_MODULE_1__["default"], _getSymbolsIn_js__WEBPACK_IMPORTED_MODULE_2__["default"]);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (getAllKeysIn);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_getAllKeysIn.js?')},"./node_modules/lodash-es/_getMapData.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _isKeyable_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isKeyable.js */ \"./node_modules/lodash-es/_isKeyable.js\");\n\n\n/**\n * Gets the data for `map`.\n *\n * @private\n * @param {Object} map The map to query.\n * @param {string} key The reference key.\n * @returns {*} Returns the map data.\n */\nfunction getMapData(map, key) {\n  var data = map.__data__;\n  return (0,_isKeyable_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(key)\n    ? data[typeof key == 'string' ? 'string' : 'hash']\n    : data.map;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (getMapData);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_getMapData.js?")},"./node_modules/lodash-es/_getNative.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseIsNative_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseIsNative.js */ "./node_modules/lodash-es/_baseIsNative.js");\n/* harmony import */ var _getValue_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getValue.js */ "./node_modules/lodash-es/_getValue.js");\n\n\n\n/**\n * Gets the native function at `key` of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @param {string} key The key of the method to get.\n * @returns {*} Returns the function if it\'s native, else `undefined`.\n */\nfunction getNative(object, key) {\n  var value = (0,_getValue_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object, key);\n  return (0,_baseIsNative_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value) ? value : undefined;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (getNative);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_getNative.js?')},"./node_modules/lodash-es/_getPrototype.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _overArg_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_overArg.js */ "./node_modules/lodash-es/_overArg.js");\n\n\n/** Built-in value references. */\nvar getPrototype = (0,_overArg_js__WEBPACK_IMPORTED_MODULE_0__["default"])(Object.getPrototypeOf, Object);\n\n/* harmony default export */ __webpack_exports__["default"] = (getPrototype);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_getPrototype.js?')},"./node_modules/lodash-es/_getRawTag.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _Symbol_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_Symbol.js */ "./node_modules/lodash-es/_Symbol.js");\n\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * Used to resolve the\n * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)\n * of values.\n */\nvar nativeObjectToString = objectProto.toString;\n\n/** Built-in value references. */\nvar symToStringTag = _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? _Symbol_js__WEBPACK_IMPORTED_MODULE_0__["default"].toStringTag : undefined;\n\n/**\n * A specialized version of `baseGetTag` which ignores `Symbol.toStringTag` values.\n *\n * @private\n * @param {*} value The value to query.\n * @returns {string} Returns the raw `toStringTag`.\n */\nfunction getRawTag(value) {\n  var isOwn = hasOwnProperty.call(value, symToStringTag),\n      tag = value[symToStringTag];\n\n  try {\n    value[symToStringTag] = undefined;\n    var unmasked = true;\n  } catch (e) {}\n\n  var result = nativeObjectToString.call(value);\n  if (unmasked) {\n    if (isOwn) {\n      value[symToStringTag] = tag;\n    } else {\n      delete value[symToStringTag];\n    }\n  }\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (getRawTag);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_getRawTag.js?')},"./node_modules/lodash-es/_getSymbols.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _arrayFilter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arrayFilter.js */ "./node_modules/lodash-es/_arrayFilter.js");\n/* harmony import */ var _stubArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./stubArray.js */ "./node_modules/lodash-es/stubArray.js");\n\n\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Built-in value references. */\nvar propertyIsEnumerable = objectProto.propertyIsEnumerable;\n\n/* Built-in method references for those with the same name as other `lodash` methods. */\nvar nativeGetSymbols = Object.getOwnPropertySymbols;\n\n/**\n * Creates an array of the own enumerable symbols of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of symbols.\n */\nvar getSymbols = !nativeGetSymbols ? _stubArray_js__WEBPACK_IMPORTED_MODULE_0__["default"] : function(object) {\n  if (object == null) {\n    return [];\n  }\n  object = Object(object);\n  return (0,_arrayFilter_js__WEBPACK_IMPORTED_MODULE_1__["default"])(nativeGetSymbols(object), function(symbol) {\n    return propertyIsEnumerable.call(object, symbol);\n  });\n};\n\n/* harmony default export */ __webpack_exports__["default"] = (getSymbols);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_getSymbols.js?')},"./node_modules/lodash-es/_getSymbolsIn.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _arrayPush_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arrayPush.js */ "./node_modules/lodash-es/_arrayPush.js");\n/* harmony import */ var _getPrototype_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_getPrototype.js */ "./node_modules/lodash-es/_getPrototype.js");\n/* harmony import */ var _getSymbols_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_getSymbols.js */ "./node_modules/lodash-es/_getSymbols.js");\n/* harmony import */ var _stubArray_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./stubArray.js */ "./node_modules/lodash-es/stubArray.js");\n\n\n\n\n\n/* Built-in method references for those with the same name as other `lodash` methods. */\nvar nativeGetSymbols = Object.getOwnPropertySymbols;\n\n/**\n * Creates an array of the own and inherited enumerable symbols of `object`.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of symbols.\n */\nvar getSymbolsIn = !nativeGetSymbols ? _stubArray_js__WEBPACK_IMPORTED_MODULE_0__["default"] : function(object) {\n  var result = [];\n  while (object) {\n    (0,_arrayPush_js__WEBPACK_IMPORTED_MODULE_1__["default"])(result, (0,_getSymbols_js__WEBPACK_IMPORTED_MODULE_2__["default"])(object));\n    object = (0,_getPrototype_js__WEBPACK_IMPORTED_MODULE_3__["default"])(object);\n  }\n  return result;\n};\n\n/* harmony default export */ __webpack_exports__["default"] = (getSymbolsIn);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_getSymbolsIn.js?')},"./node_modules/lodash-es/_getTag.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _DataView_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_DataView.js */ "./node_modules/lodash-es/_DataView.js");\n/* harmony import */ var _Map_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_Map.js */ "./node_modules/lodash-es/_Map.js");\n/* harmony import */ var _Promise_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_Promise.js */ "./node_modules/lodash-es/_Promise.js");\n/* harmony import */ var _Set_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_Set.js */ "./node_modules/lodash-es/_Set.js");\n/* harmony import */ var _WeakMap_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./_WeakMap.js */ "./node_modules/lodash-es/_WeakMap.js");\n/* harmony import */ var _baseGetTag_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./_baseGetTag.js */ "./node_modules/lodash-es/_baseGetTag.js");\n/* harmony import */ var _toSource_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_toSource.js */ "./node_modules/lodash-es/_toSource.js");\n\n\n\n\n\n\n\n\n/** `Object#toString` result references. */\nvar mapTag = \'[object Map]\',\n    objectTag = \'[object Object]\',\n    promiseTag = \'[object Promise]\',\n    setTag = \'[object Set]\',\n    weakMapTag = \'[object WeakMap]\';\n\nvar dataViewTag = \'[object DataView]\';\n\n/** Used to detect maps, sets, and weakmaps. */\nvar dataViewCtorString = (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_DataView_js__WEBPACK_IMPORTED_MODULE_1__["default"]),\n    mapCtorString = (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_Map_js__WEBPACK_IMPORTED_MODULE_2__["default"]),\n    promiseCtorString = (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_Promise_js__WEBPACK_IMPORTED_MODULE_3__["default"]),\n    setCtorString = (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_Set_js__WEBPACK_IMPORTED_MODULE_4__["default"]),\n    weakMapCtorString = (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_WeakMap_js__WEBPACK_IMPORTED_MODULE_5__["default"]);\n\n/**\n * Gets the `toStringTag` of `value`.\n *\n * @private\n * @param {*} value The value to query.\n * @returns {string} Returns the `toStringTag`.\n */\nvar getTag = _baseGetTag_js__WEBPACK_IMPORTED_MODULE_6__["default"];\n\n// Fallback for data views, maps, sets, and weak maps in IE 11 and promises in Node.js < 6.\nif ((_DataView_js__WEBPACK_IMPORTED_MODULE_1__["default"] && getTag(new _DataView_js__WEBPACK_IMPORTED_MODULE_1__["default"](new ArrayBuffer(1))) != dataViewTag) ||\n    (_Map_js__WEBPACK_IMPORTED_MODULE_2__["default"] && getTag(new _Map_js__WEBPACK_IMPORTED_MODULE_2__["default"]) != mapTag) ||\n    (_Promise_js__WEBPACK_IMPORTED_MODULE_3__["default"] && getTag(_Promise_js__WEBPACK_IMPORTED_MODULE_3__["default"].resolve()) != promiseTag) ||\n    (_Set_js__WEBPACK_IMPORTED_MODULE_4__["default"] && getTag(new _Set_js__WEBPACK_IMPORTED_MODULE_4__["default"]) != setTag) ||\n    (_WeakMap_js__WEBPACK_IMPORTED_MODULE_5__["default"] && getTag(new _WeakMap_js__WEBPACK_IMPORTED_MODULE_5__["default"]) != weakMapTag)) {\n  getTag = function(value) {\n    var result = (0,_baseGetTag_js__WEBPACK_IMPORTED_MODULE_6__["default"])(value),\n        Ctor = result == objectTag ? value.constructor : undefined,\n        ctorString = Ctor ? (0,_toSource_js__WEBPACK_IMPORTED_MODULE_0__["default"])(Ctor) : \'\';\n\n    if (ctorString) {\n      switch (ctorString) {\n        case dataViewCtorString: return dataViewTag;\n        case mapCtorString: return mapTag;\n        case promiseCtorString: return promiseTag;\n        case setCtorString: return setTag;\n        case weakMapCtorString: return weakMapTag;\n      }\n    }\n    return result;\n  };\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (getTag);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_getTag.js?')},"./node_modules/lodash-es/_getValue.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Gets the value at `key` of `object`.\n *\n * @private\n * @param {Object} [object] The object to query.\n * @param {string} key The key of the property to get.\n * @returns {*} Returns the property value.\n */\nfunction getValue(object, key) {\n  return object == null ? undefined : object[key];\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (getValue);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_getValue.js?')},"./node_modules/lodash-es/_hashClear.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _nativeCreate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_nativeCreate.js */ "./node_modules/lodash-es/_nativeCreate.js");\n\n\n/**\n * Removes all key-value entries from the hash.\n *\n * @private\n * @name clear\n * @memberOf Hash\n */\nfunction hashClear() {\n  this.__data__ = _nativeCreate_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? (0,_nativeCreate_js__WEBPACK_IMPORTED_MODULE_0__["default"])(null) : {};\n  this.size = 0;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (hashClear);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_hashClear.js?')},"./node_modules/lodash-es/_hashDelete.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Removes `key` and its value from the hash.\n *\n * @private\n * @name delete\n * @memberOf Hash\n * @param {Object} hash The hash to modify.\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction hashDelete(key) {\n  var result = this.has(key) && delete this.__data__[key];\n  this.size -= result ? 1 : 0;\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (hashDelete);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_hashDelete.js?')},"./node_modules/lodash-es/_hashGet.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _nativeCreate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_nativeCreate.js */ "./node_modules/lodash-es/_nativeCreate.js");\n\n\n/** Used to stand-in for `undefined` hash values. */\nvar HASH_UNDEFINED = \'__lodash_hash_undefined__\';\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * Gets the hash value for `key`.\n *\n * @private\n * @name get\n * @memberOf Hash\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction hashGet(key) {\n  var data = this.__data__;\n  if (_nativeCreate_js__WEBPACK_IMPORTED_MODULE_0__["default"]) {\n    var result = data[key];\n    return result === HASH_UNDEFINED ? undefined : result;\n  }\n  return hasOwnProperty.call(data, key) ? data[key] : undefined;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (hashGet);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_hashGet.js?')},"./node_modules/lodash-es/_hashHas.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _nativeCreate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_nativeCreate.js */ "./node_modules/lodash-es/_nativeCreate.js");\n\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * Checks if a hash value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf Hash\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction hashHas(key) {\n  var data = this.__data__;\n  return _nativeCreate_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? (data[key] !== undefined) : hasOwnProperty.call(data, key);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (hashHas);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_hashHas.js?')},"./node_modules/lodash-es/_hashSet.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _nativeCreate_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_nativeCreate.js */ "./node_modules/lodash-es/_nativeCreate.js");\n\n\n/** Used to stand-in for `undefined` hash values. */\nvar HASH_UNDEFINED = \'__lodash_hash_undefined__\';\n\n/**\n * Sets the hash `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf Hash\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the hash instance.\n */\nfunction hashSet(key, value) {\n  var data = this.__data__;\n  this.size += this.has(key) ? 0 : 1;\n  data[key] = (_nativeCreate_js__WEBPACK_IMPORTED_MODULE_0__["default"] && value === undefined) ? HASH_UNDEFINED : value;\n  return this;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (hashSet);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_hashSet.js?')},"./node_modules/lodash-es/_initCloneArray.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/**\n * Initializes an array clone.\n *\n * @private\n * @param {Array} array The array to clone.\n * @returns {Array} Returns the initialized clone.\n */\nfunction initCloneArray(array) {\n  var length = array.length,\n      result = new array.constructor(length);\n\n  // Add properties assigned by `RegExp#exec`.\n  if (length && typeof array[0] == 'string' && hasOwnProperty.call(array, 'index')) {\n    result.index = array.index;\n    result.input = array.input;\n  }\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (initCloneArray);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_initCloneArray.js?")},"./node_modules/lodash-es/_initCloneByTag.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _cloneArrayBuffer_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_cloneArrayBuffer.js */ \"./node_modules/lodash-es/_cloneArrayBuffer.js\");\n/* harmony import */ var _cloneDataView_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_cloneDataView.js */ \"./node_modules/lodash-es/_cloneDataView.js\");\n/* harmony import */ var _cloneRegExp_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./_cloneRegExp.js */ \"./node_modules/lodash-es/_cloneRegExp.js\");\n/* harmony import */ var _cloneSymbol_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./_cloneSymbol.js */ \"./node_modules/lodash-es/_cloneSymbol.js\");\n/* harmony import */ var _cloneTypedArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_cloneTypedArray.js */ \"./node_modules/lodash-es/_cloneTypedArray.js\");\n\n\n\n\n\n\n/** `Object#toString` result references. */\nvar boolTag = '[object Boolean]',\n    dateTag = '[object Date]',\n    mapTag = '[object Map]',\n    numberTag = '[object Number]',\n    regexpTag = '[object RegExp]',\n    setTag = '[object Set]',\n    stringTag = '[object String]',\n    symbolTag = '[object Symbol]';\n\nvar arrayBufferTag = '[object ArrayBuffer]',\n    dataViewTag = '[object DataView]',\n    float32Tag = '[object Float32Array]',\n    float64Tag = '[object Float64Array]',\n    int8Tag = '[object Int8Array]',\n    int16Tag = '[object Int16Array]',\n    int32Tag = '[object Int32Array]',\n    uint8Tag = '[object Uint8Array]',\n    uint8ClampedTag = '[object Uint8ClampedArray]',\n    uint16Tag = '[object Uint16Array]',\n    uint32Tag = '[object Uint32Array]';\n\n/**\n * Initializes an object clone based on its `toStringTag`.\n *\n * **Note:** This function only supports cloning values with tags of\n * `Boolean`, `Date`, `Error`, `Map`, `Number`, `RegExp`, `Set`, or `String`.\n *\n * @private\n * @param {Object} object The object to clone.\n * @param {string} tag The `toStringTag` of the object to clone.\n * @param {boolean} [isDeep] Specify a deep clone.\n * @returns {Object} Returns the initialized clone.\n */\nfunction initCloneByTag(object, tag, isDeep) {\n  var Ctor = object.constructor;\n  switch (tag) {\n    case arrayBufferTag:\n      return (0,_cloneArrayBuffer_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(object);\n\n    case boolTag:\n    case dateTag:\n      return new Ctor(+object);\n\n    case dataViewTag:\n      return (0,_cloneDataView_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(object, isDeep);\n\n    case float32Tag: case float64Tag:\n    case int8Tag: case int16Tag: case int32Tag:\n    case uint8Tag: case uint8ClampedTag: case uint16Tag: case uint32Tag:\n      return (0,_cloneTypedArray_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])(object, isDeep);\n\n    case mapTag:\n      return new Ctor;\n\n    case numberTag:\n    case stringTag:\n      return new Ctor(object);\n\n    case regexpTag:\n      return (0,_cloneRegExp_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"])(object);\n\n    case setTag:\n      return new Ctor;\n\n    case symbolTag:\n      return (0,_cloneSymbol_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"])(object);\n  }\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (initCloneByTag);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_initCloneByTag.js?")},"./node_modules/lodash-es/_initCloneObject.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseCreate_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseCreate.js */ "./node_modules/lodash-es/_baseCreate.js");\n/* harmony import */ var _getPrototype_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_getPrototype.js */ "./node_modules/lodash-es/_getPrototype.js");\n/* harmony import */ var _isPrototype_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_isPrototype.js */ "./node_modules/lodash-es/_isPrototype.js");\n\n\n\n\n/**\n * Initializes an object clone.\n *\n * @private\n * @param {Object} object The object to clone.\n * @returns {Object} Returns the initialized clone.\n */\nfunction initCloneObject(object) {\n  return (typeof object.constructor == \'function\' && !(0,_isPrototype_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object))\n    ? (0,_baseCreate_js__WEBPACK_IMPORTED_MODULE_1__["default"])((0,_getPrototype_js__WEBPACK_IMPORTED_MODULE_2__["default"])(object))\n    : {};\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (initCloneObject);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_initCloneObject.js?')},"./node_modules/lodash-es/_isIndex.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/** Used as references for various `Number` constants. */\nvar MAX_SAFE_INTEGER = 9007199254740991;\n\n/** Used to detect unsigned integer values. */\nvar reIsUint = /^(?:0|[1-9]\\d*)$/;\n\n/**\n * Checks if `value` is a valid array-like index.\n *\n * @private\n * @param {*} value The value to check.\n * @param {number} [length=MAX_SAFE_INTEGER] The upper bounds of a valid index.\n * @returns {boolean} Returns `true` if `value` is a valid index, else `false`.\n */\nfunction isIndex(value, length) {\n  var type = typeof value;\n  length = length == null ? MAX_SAFE_INTEGER : length;\n\n  return !!length &&\n    (type == 'number' ||\n      (type != 'symbol' && reIsUint.test(value))) &&\n        (value > -1 && value % 1 == 0 && value < length);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (isIndex);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_isIndex.js?")},"./node_modules/lodash-es/_isIterateeCall.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _eq_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./eq.js */ "./node_modules/lodash-es/eq.js");\n/* harmony import */ var _isArrayLike_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isArrayLike.js */ "./node_modules/lodash-es/isArrayLike.js");\n/* harmony import */ var _isIndex_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_isIndex.js */ "./node_modules/lodash-es/_isIndex.js");\n/* harmony import */ var _isObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject.js */ "./node_modules/lodash-es/isObject.js");\n\n\n\n\n\n/**\n * Checks if the given arguments are from an iteratee call.\n *\n * @private\n * @param {*} value The potential iteratee value argument.\n * @param {*} index The potential iteratee index or key argument.\n * @param {*} object The potential iteratee object argument.\n * @returns {boolean} Returns `true` if the arguments are from an iteratee call,\n *  else `false`.\n */\nfunction isIterateeCall(value, index, object) {\n  if (!(0,_isObject_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object)) {\n    return false;\n  }\n  var type = typeof index;\n  if (type == \'number\'\n        ? ((0,_isArrayLike_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object) && (0,_isIndex_js__WEBPACK_IMPORTED_MODULE_2__["default"])(index, object.length))\n        : (type == \'string\' && index in object)\n      ) {\n    return (0,_eq_js__WEBPACK_IMPORTED_MODULE_3__["default"])(object[index], value);\n  }\n  return false;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (isIterateeCall);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_isIterateeCall.js?')},"./node_modules/lodash-es/_isKeyable.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * Checks if `value` is suitable for use as unique object key.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is suitable, else `false`.\n */\nfunction isKeyable(value) {\n  var type = typeof value;\n  return (type == 'string' || type == 'number' || type == 'symbol' || type == 'boolean')\n    ? (value !== '__proto__')\n    : (value === null);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (isKeyable);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_isKeyable.js?")},"./node_modules/lodash-es/_isMasked.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _coreJsData_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_coreJsData.js */ "./node_modules/lodash-es/_coreJsData.js");\n\n\n/** Used to detect methods masquerading as native. */\nvar maskSrcKey = (function() {\n  var uid = /[^.]+$/.exec(_coreJsData_js__WEBPACK_IMPORTED_MODULE_0__["default"] && _coreJsData_js__WEBPACK_IMPORTED_MODULE_0__["default"].keys && _coreJsData_js__WEBPACK_IMPORTED_MODULE_0__["default"].keys.IE_PROTO || \'\');\n  return uid ? (\'Symbol(src)_1.\' + uid) : \'\';\n}());\n\n/**\n * Checks if `func` has its source masked.\n *\n * @private\n * @param {Function} func The function to check.\n * @returns {boolean} Returns `true` if `func` is masked, else `false`.\n */\nfunction isMasked(func) {\n  return !!maskSrcKey && (maskSrcKey in func);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (isMasked);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_isMasked.js?')},"./node_modules/lodash-es/_isPrototype.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/**\n * Checks if `value` is likely a prototype object.\n *\n * @private\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a prototype, else `false`.\n */\nfunction isPrototype(value) {\n  var Ctor = value && value.constructor,\n      proto = (typeof Ctor == 'function' && Ctor.prototype) || objectProto;\n\n  return value === proto;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (isPrototype);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_isPrototype.js?")},"./node_modules/lodash-es/_listCacheClear.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Removes all key-value entries from the list cache.\n *\n * @private\n * @name clear\n * @memberOf ListCache\n */\nfunction listCacheClear() {\n  this.__data__ = [];\n  this.size = 0;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (listCacheClear);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_listCacheClear.js?')},"./node_modules/lodash-es/_listCacheDelete.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _assocIndexOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_assocIndexOf.js */ "./node_modules/lodash-es/_assocIndexOf.js");\n\n\n/** Used for built-in method references. */\nvar arrayProto = Array.prototype;\n\n/** Built-in value references. */\nvar splice = arrayProto.splice;\n\n/**\n * Removes `key` and its value from the list cache.\n *\n * @private\n * @name delete\n * @memberOf ListCache\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction listCacheDelete(key) {\n  var data = this.__data__,\n      index = (0,_assocIndexOf_js__WEBPACK_IMPORTED_MODULE_0__["default"])(data, key);\n\n  if (index < 0) {\n    return false;\n  }\n  var lastIndex = data.length - 1;\n  if (index == lastIndex) {\n    data.pop();\n  } else {\n    splice.call(data, index, 1);\n  }\n  --this.size;\n  return true;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (listCacheDelete);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_listCacheDelete.js?')},"./node_modules/lodash-es/_listCacheGet.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _assocIndexOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_assocIndexOf.js */ "./node_modules/lodash-es/_assocIndexOf.js");\n\n\n/**\n * Gets the list cache value for `key`.\n *\n * @private\n * @name get\n * @memberOf ListCache\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction listCacheGet(key) {\n  var data = this.__data__,\n      index = (0,_assocIndexOf_js__WEBPACK_IMPORTED_MODULE_0__["default"])(data, key);\n\n  return index < 0 ? undefined : data[index][1];\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (listCacheGet);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_listCacheGet.js?')},"./node_modules/lodash-es/_listCacheHas.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _assocIndexOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_assocIndexOf.js */ "./node_modules/lodash-es/_assocIndexOf.js");\n\n\n/**\n * Checks if a list cache value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf ListCache\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction listCacheHas(key) {\n  return (0,_assocIndexOf_js__WEBPACK_IMPORTED_MODULE_0__["default"])(this.__data__, key) > -1;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (listCacheHas);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_listCacheHas.js?')},"./node_modules/lodash-es/_listCacheSet.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _assocIndexOf_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_assocIndexOf.js */ "./node_modules/lodash-es/_assocIndexOf.js");\n\n\n/**\n * Sets the list cache `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf ListCache\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the list cache instance.\n */\nfunction listCacheSet(key, value) {\n  var data = this.__data__,\n      index = (0,_assocIndexOf_js__WEBPACK_IMPORTED_MODULE_0__["default"])(data, key);\n\n  if (index < 0) {\n    ++this.size;\n    data.push([key, value]);\n  } else {\n    data[index][1] = value;\n  }\n  return this;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (listCacheSet);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_listCacheSet.js?')},"./node_modules/lodash-es/_mapCacheClear.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _Hash_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_Hash.js */ "./node_modules/lodash-es/_Hash.js");\n/* harmony import */ var _ListCache_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_ListCache.js */ "./node_modules/lodash-es/_ListCache.js");\n/* harmony import */ var _Map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_Map.js */ "./node_modules/lodash-es/_Map.js");\n\n\n\n\n/**\n * Removes all key-value entries from the map.\n *\n * @private\n * @name clear\n * @memberOf MapCache\n */\nfunction mapCacheClear() {\n  this.size = 0;\n  this.__data__ = {\n    \'hash\': new _Hash_js__WEBPACK_IMPORTED_MODULE_0__["default"],\n    \'map\': new (_Map_js__WEBPACK_IMPORTED_MODULE_1__["default"] || _ListCache_js__WEBPACK_IMPORTED_MODULE_2__["default"]),\n    \'string\': new _Hash_js__WEBPACK_IMPORTED_MODULE_0__["default"]\n  };\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (mapCacheClear);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_mapCacheClear.js?')},"./node_modules/lodash-es/_mapCacheDelete.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getMapData_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getMapData.js */ "./node_modules/lodash-es/_getMapData.js");\n\n\n/**\n * Removes `key` and its value from the map.\n *\n * @private\n * @name delete\n * @memberOf MapCache\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction mapCacheDelete(key) {\n  var result = (0,_getMapData_js__WEBPACK_IMPORTED_MODULE_0__["default"])(this, key)[\'delete\'](key);\n  this.size -= result ? 1 : 0;\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (mapCacheDelete);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_mapCacheDelete.js?')},"./node_modules/lodash-es/_mapCacheGet.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getMapData_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getMapData.js */ "./node_modules/lodash-es/_getMapData.js");\n\n\n/**\n * Gets the map value for `key`.\n *\n * @private\n * @name get\n * @memberOf MapCache\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction mapCacheGet(key) {\n  return (0,_getMapData_js__WEBPACK_IMPORTED_MODULE_0__["default"])(this, key).get(key);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (mapCacheGet);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_mapCacheGet.js?')},"./node_modules/lodash-es/_mapCacheHas.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getMapData_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getMapData.js */ "./node_modules/lodash-es/_getMapData.js");\n\n\n/**\n * Checks if a map value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf MapCache\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction mapCacheHas(key) {\n  return (0,_getMapData_js__WEBPACK_IMPORTED_MODULE_0__["default"])(this, key).has(key);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (mapCacheHas);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_mapCacheHas.js?')},"./node_modules/lodash-es/_mapCacheSet.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getMapData_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getMapData.js */ "./node_modules/lodash-es/_getMapData.js");\n\n\n/**\n * Sets the map `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf MapCache\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the map cache instance.\n */\nfunction mapCacheSet(key, value) {\n  var data = (0,_getMapData_js__WEBPACK_IMPORTED_MODULE_0__["default"])(this, key),\n      size = data.size;\n\n  data.set(key, value);\n  this.size += data.size == size ? 0 : 1;\n  return this;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (mapCacheSet);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_mapCacheSet.js?')},"./node_modules/lodash-es/_mapToArray.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Converts `map` to its key-value pairs.\n *\n * @private\n * @param {Object} map The map to convert.\n * @returns {Array} Returns the key-value pairs.\n */\nfunction mapToArray(map) {\n  var index = -1,\n      result = Array(map.size);\n\n  map.forEach(function(value, key) {\n    result[++index] = [key, value];\n  });\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (mapToArray);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_mapToArray.js?')},"./node_modules/lodash-es/_nativeCreate.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _getNative_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_getNative.js */ "./node_modules/lodash-es/_getNative.js");\n\n\n/* Built-in method references that are verified to be native. */\nvar nativeCreate = (0,_getNative_js__WEBPACK_IMPORTED_MODULE_0__["default"])(Object, \'create\');\n\n/* harmony default export */ __webpack_exports__["default"] = (nativeCreate);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_nativeCreate.js?')},"./node_modules/lodash-es/_nativeKeys.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _overArg_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_overArg.js */ "./node_modules/lodash-es/_overArg.js");\n\n\n/* Built-in method references for those with the same name as other `lodash` methods. */\nvar nativeKeys = (0,_overArg_js__WEBPACK_IMPORTED_MODULE_0__["default"])(Object.keys, Object);\n\n/* harmony default export */ __webpack_exports__["default"] = (nativeKeys);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_nativeKeys.js?')},"./node_modules/lodash-es/_nativeKeysIn.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * This function is like\n * [`Object.keys`](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)\n * except that it includes inherited enumerable properties.\n *\n * @private\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names.\n */\nfunction nativeKeysIn(object) {\n  var result = [];\n  if (object != null) {\n    for (var key in Object(object)) {\n      result.push(key);\n    }\n  }\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (nativeKeysIn);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_nativeKeysIn.js?')},"./node_modules/lodash-es/_nodeUtil.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _freeGlobal_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_freeGlobal.js */ \"./node_modules/lodash-es/_freeGlobal.js\");\n\n\n/** Detect free variable `exports`. */\nvar freeExports = typeof exports == 'object' && exports && !exports.nodeType && exports;\n\n/** Detect free variable `module`. */\nvar freeModule = freeExports && typeof module == 'object' && module && !module.nodeType && module;\n\n/** Detect the popular CommonJS extension `module.exports`. */\nvar moduleExports = freeModule && freeModule.exports === freeExports;\n\n/** Detect free variable `process` from Node.js. */\nvar freeProcess = moduleExports && _freeGlobal_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].process;\n\n/** Used to access faster Node.js helpers. */\nvar nodeUtil = (function() {\n  try {\n    // Use `util.types` for Node.js 10+.\n    var types = freeModule && freeModule.require && freeModule.require('util').types;\n\n    if (types) {\n      return types;\n    }\n\n    // Legacy `process.binding('util')` for Node.js < 10.\n    return freeProcess && freeProcess.binding && freeProcess.binding('util');\n  } catch (e) {}\n}());\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (nodeUtil);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_nodeUtil.js?")},"./node_modules/lodash-es/_objectToString.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/**\n * Used to resolve the\n * [`toStringTag`](http://ecma-international.org/ecma-262/7.0/#sec-object.prototype.tostring)\n * of values.\n */\nvar nativeObjectToString = objectProto.toString;\n\n/**\n * Converts `value` to a string using `Object.prototype.toString`.\n *\n * @private\n * @param {*} value The value to convert.\n * @returns {string} Returns the converted string.\n */\nfunction objectToString(value) {\n  return nativeObjectToString.call(value);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (objectToString);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_objectToString.js?')},"./node_modules/lodash-es/_overArg.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Creates a unary function that invokes `func` with its argument transformed.\n *\n * @private\n * @param {Function} func The function to wrap.\n * @param {Function} transform The argument transform.\n * @returns {Function} Returns the new function.\n */\nfunction overArg(func, transform) {\n  return function(arg) {\n    return func(transform(arg));\n  };\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (overArg);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_overArg.js?')},"./node_modules/lodash-es/_overRest.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _apply_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_apply.js */ "./node_modules/lodash-es/_apply.js");\n\n\n/* Built-in method references for those with the same name as other `lodash` methods. */\nvar nativeMax = Math.max;\n\n/**\n * A specialized version of `baseRest` which transforms the rest array.\n *\n * @private\n * @param {Function} func The function to apply a rest parameter to.\n * @param {number} [start=func.length-1] The start position of the rest parameter.\n * @param {Function} transform The rest array transform.\n * @returns {Function} Returns the new function.\n */\nfunction overRest(func, start, transform) {\n  start = nativeMax(start === undefined ? (func.length - 1) : start, 0);\n  return function() {\n    var args = arguments,\n        index = -1,\n        length = nativeMax(args.length - start, 0),\n        array = Array(length);\n\n    while (++index < length) {\n      array[index] = args[start + index];\n    }\n    index = -1;\n    var otherArgs = Array(start + 1);\n    while (++index < start) {\n      otherArgs[index] = args[index];\n    }\n    otherArgs[start] = transform(array);\n    return (0,_apply_js__WEBPACK_IMPORTED_MODULE_0__["default"])(func, this, otherArgs);\n  };\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (overRest);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_overRest.js?')},"./node_modules/lodash-es/_root.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _freeGlobal_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_freeGlobal.js */ "./node_modules/lodash-es/_freeGlobal.js");\n\n\n/** Detect free variable `self`. */\nvar freeSelf = typeof self == \'object\' && self && self.Object === Object && self;\n\n/** Used as a reference to the global object. */\nvar root = _freeGlobal_js__WEBPACK_IMPORTED_MODULE_0__["default"] || freeSelf || Function(\'return this\')();\n\n/* harmony default export */ __webpack_exports__["default"] = (root);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_root.js?')},"./node_modules/lodash-es/_safeGet.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * Gets the value at `key`, unless `key` is \"__proto__\" or \"constructor\".\n *\n * @private\n * @param {Object} object The object to query.\n * @param {string} key The key of the property to get.\n * @returns {*} Returns the property value.\n */\nfunction safeGet(object, key) {\n  if (key === 'constructor' && typeof object[key] === 'function') {\n    return;\n  }\n\n  if (key == '__proto__') {\n    return;\n  }\n\n  return object[key];\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (safeGet);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_safeGet.js?")},"./node_modules/lodash-es/_setCacheAdd.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/** Used to stand-in for `undefined` hash values. */\nvar HASH_UNDEFINED = '__lodash_hash_undefined__';\n\n/**\n * Adds `value` to the array cache.\n *\n * @private\n * @name add\n * @memberOf SetCache\n * @alias push\n * @param {*} value The value to cache.\n * @returns {Object} Returns the cache instance.\n */\nfunction setCacheAdd(value) {\n  this.__data__.set(value, HASH_UNDEFINED);\n  return this;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (setCacheAdd);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_setCacheAdd.js?")},"./node_modules/lodash-es/_setCacheHas.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Checks if `value` is in the array cache.\n *\n * @private\n * @name has\n * @memberOf SetCache\n * @param {*} value The value to search for.\n * @returns {number} Returns `true` if `value` is found, else `false`.\n */\nfunction setCacheHas(value) {\n  return this.__data__.has(value);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (setCacheHas);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_setCacheHas.js?')},"./node_modules/lodash-es/_setToArray.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Converts `set` to an array of its values.\n *\n * @private\n * @param {Object} set The set to convert.\n * @returns {Array} Returns the values.\n */\nfunction setToArray(set) {\n  var index = -1,\n      result = Array(set.size);\n\n  set.forEach(function(value) {\n    result[++index] = value;\n  });\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (setToArray);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_setToArray.js?')},"./node_modules/lodash-es/_setToString.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseSetToString_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseSetToString.js */ "./node_modules/lodash-es/_baseSetToString.js");\n/* harmony import */ var _shortOut_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_shortOut.js */ "./node_modules/lodash-es/_shortOut.js");\n\n\n\n/**\n * Sets the `toString` method of `func` to return `string`.\n *\n * @private\n * @param {Function} func The function to modify.\n * @param {Function} string The `toString` result.\n * @returns {Function} Returns `func`.\n */\nvar setToString = (0,_shortOut_js__WEBPACK_IMPORTED_MODULE_0__["default"])(_baseSetToString_js__WEBPACK_IMPORTED_MODULE_1__["default"]);\n\n/* harmony default export */ __webpack_exports__["default"] = (setToString);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_setToString.js?')},"./node_modules/lodash-es/_shortOut.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/** Used to detect hot functions by number of calls within a span of milliseconds. */\nvar HOT_COUNT = 800,\n    HOT_SPAN = 16;\n\n/* Built-in method references for those with the same name as other `lodash` methods. */\nvar nativeNow = Date.now;\n\n/**\n * Creates a function that'll short out and invoke `identity` instead\n * of `func` when it's called `HOT_COUNT` or more times in `HOT_SPAN`\n * milliseconds.\n *\n * @private\n * @param {Function} func The function to restrict.\n * @returns {Function} Returns the new shortable function.\n */\nfunction shortOut(func) {\n  var count = 0,\n      lastCalled = 0;\n\n  return function() {\n    var stamp = nativeNow(),\n        remaining = HOT_SPAN - (stamp - lastCalled);\n\n    lastCalled = stamp;\n    if (remaining > 0) {\n      if (++count >= HOT_COUNT) {\n        return arguments[0];\n      }\n    } else {\n      count = 0;\n    }\n    return func.apply(undefined, arguments);\n  };\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (shortOut);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_shortOut.js?")},"./node_modules/lodash-es/_stackClear.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ListCache_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_ListCache.js */ "./node_modules/lodash-es/_ListCache.js");\n\n\n/**\n * Removes all key-value entries from the stack.\n *\n * @private\n * @name clear\n * @memberOf Stack\n */\nfunction stackClear() {\n  this.__data__ = new _ListCache_js__WEBPACK_IMPORTED_MODULE_0__["default"];\n  this.size = 0;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (stackClear);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_stackClear.js?')},"./node_modules/lodash-es/_stackDelete.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * Removes `key` and its value from the stack.\n *\n * @private\n * @name delete\n * @memberOf Stack\n * @param {string} key The key of the value to remove.\n * @returns {boolean} Returns `true` if the entry was removed, else `false`.\n */\nfunction stackDelete(key) {\n  var data = this.__data__,\n      result = data['delete'](key);\n\n  this.size = data.size;\n  return result;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (stackDelete);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_stackDelete.js?")},"./node_modules/lodash-es/_stackGet.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Gets the stack value for `key`.\n *\n * @private\n * @name get\n * @memberOf Stack\n * @param {string} key The key of the value to get.\n * @returns {*} Returns the entry value.\n */\nfunction stackGet(key) {\n  return this.__data__.get(key);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (stackGet);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_stackGet.js?')},"./node_modules/lodash-es/_stackHas.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Checks if a stack value for `key` exists.\n *\n * @private\n * @name has\n * @memberOf Stack\n * @param {string} key The key of the entry to check.\n * @returns {boolean} Returns `true` if an entry for `key` exists, else `false`.\n */\nfunction stackHas(key) {\n  return this.__data__.has(key);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (stackHas);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_stackHas.js?')},"./node_modules/lodash-es/_stackSet.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _ListCache_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_ListCache.js */ "./node_modules/lodash-es/_ListCache.js");\n/* harmony import */ var _Map_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_Map.js */ "./node_modules/lodash-es/_Map.js");\n/* harmony import */ var _MapCache_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_MapCache.js */ "./node_modules/lodash-es/_MapCache.js");\n\n\n\n\n/** Used as the size to enable large array optimizations. */\nvar LARGE_ARRAY_SIZE = 200;\n\n/**\n * Sets the stack `key` to `value`.\n *\n * @private\n * @name set\n * @memberOf Stack\n * @param {string} key The key of the value to set.\n * @param {*} value The value to set.\n * @returns {Object} Returns the stack cache instance.\n */\nfunction stackSet(key, value) {\n  var data = this.__data__;\n  if (data instanceof _ListCache_js__WEBPACK_IMPORTED_MODULE_0__["default"]) {\n    var pairs = data.__data__;\n    if (!_Map_js__WEBPACK_IMPORTED_MODULE_1__["default"] || (pairs.length < LARGE_ARRAY_SIZE - 1)) {\n      pairs.push([key, value]);\n      this.size = ++data.size;\n      return this;\n    }\n    data = this.__data__ = new _MapCache_js__WEBPACK_IMPORTED_MODULE_2__["default"](pairs);\n  }\n  data.set(key, value);\n  this.size = data.size;\n  return this;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (stackSet);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_stackSet.js?')},"./node_modules/lodash-es/_toSource.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/** Used for built-in method references. */\nvar funcProto = Function.prototype;\n\n/** Used to resolve the decompiled source of functions. */\nvar funcToString = funcProto.toString;\n\n/**\n * Converts `func` to its source code.\n *\n * @private\n * @param {Function} func The function to convert.\n * @returns {string} Returns the source code.\n */\nfunction toSource(func) {\n  if (func != null) {\n    try {\n      return funcToString.call(func);\n    } catch (e) {}\n    try {\n      return (func + '');\n    } catch (e) {}\n  }\n  return '';\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (toSource);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/_toSource.js?")},"./node_modules/lodash-es/cloneDeep.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseClone_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseClone.js */ "./node_modules/lodash-es/_baseClone.js");\n\n\n/** Used to compose bitmasks for cloning. */\nvar CLONE_DEEP_FLAG = 1,\n    CLONE_SYMBOLS_FLAG = 4;\n\n/**\n * This method is like `_.clone` except that it recursively clones `value`.\n *\n * @static\n * @memberOf _\n * @since 1.0.0\n * @category Lang\n * @param {*} value The value to recursively clone.\n * @returns {*} Returns the deep cloned value.\n * @see _.clone\n * @example\n *\n * var objects = [{ \'a\': 1 }, { \'b\': 2 }];\n *\n * var deep = _.cloneDeep(objects);\n * console.log(deep[0] === objects[0]);\n * // => false\n */\nfunction cloneDeep(value) {\n  return (0,_baseClone_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value, CLONE_DEEP_FLAG | CLONE_SYMBOLS_FLAG);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (cloneDeep);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/cloneDeep.js?')},"./node_modules/lodash-es/constant.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * Creates a function that returns `value`.\n *\n * @static\n * @memberOf _\n * @since 2.4.0\n * @category Util\n * @param {*} value The value to return from the new function.\n * @returns {Function} Returns the new constant function.\n * @example\n *\n * var objects = _.times(2, _.constant({ 'a': 1 }));\n *\n * console.log(objects);\n * // => [{ 'a': 1 }, { 'a': 1 }]\n *\n * console.log(objects[0] === objects[1]);\n * // => true\n */\nfunction constant(value) {\n  return function() {\n    return value;\n  };\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (constant);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/constant.js?")},"./node_modules/lodash-es/eq.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * Performs a\n * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)\n * comparison between two values to determine if they are equivalent.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to compare.\n * @param {*} other The other value to compare.\n * @returns {boolean} Returns `true` if the values are equivalent, else `false`.\n * @example\n *\n * var object = { 'a': 1 };\n * var other = { 'a': 1 };\n *\n * _.eq(object, object);\n * // => true\n *\n * _.eq(object, other);\n * // => false\n *\n * _.eq('a', 'a');\n * // => true\n *\n * _.eq('a', Object('a'));\n * // => false\n *\n * _.eq(NaN, NaN);\n * // => true\n */\nfunction eq(value, other) {\n  return value === other || (value !== value && other !== other);\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (eq);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/eq.js?")},"./node_modules/lodash-es/identity.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * This method returns the first argument it receives.\n *\n * @static\n * @since 0.1.0\n * @memberOf _\n * @category Util\n * @param {*} value Any value.\n * @returns {*} Returns `value`.\n * @example\n *\n * var object = { 'a': 1 };\n *\n * console.log(_.identity(object) === object);\n * // => true\n */\nfunction identity(value) {\n  return value;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (identity);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/identity.js?")},"./node_modules/lodash-es/isArguments.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseIsArguments_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseIsArguments.js */ "./node_modules/lodash-es/_baseIsArguments.js");\n/* harmony import */ var _isObjectLike_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isObjectLike.js */ "./node_modules/lodash-es/isObjectLike.js");\n\n\n\n/** Used for built-in method references. */\nvar objectProto = Object.prototype;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/** Built-in value references. */\nvar propertyIsEnumerable = objectProto.propertyIsEnumerable;\n\n/**\n * Checks if `value` is likely an `arguments` object.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an `arguments` object,\n *  else `false`.\n * @example\n *\n * _.isArguments(function() { return arguments; }());\n * // => true\n *\n * _.isArguments([1, 2, 3]);\n * // => false\n */\nvar isArguments = (0,_baseIsArguments_js__WEBPACK_IMPORTED_MODULE_0__["default"])(function() { return arguments; }()) ? _baseIsArguments_js__WEBPACK_IMPORTED_MODULE_0__["default"] : function(value) {\n  return (0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value) && hasOwnProperty.call(value, \'callee\') &&\n    !propertyIsEnumerable.call(value, \'callee\');\n};\n\n/* harmony default export */ __webpack_exports__["default"] = (isArguments);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isArguments.js?')},"./node_modules/lodash-es/isArray.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * Checks if `value` is classified as an `Array` object.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an array, else `false`.\n * @example\n *\n * _.isArray([1, 2, 3]);\n * // => true\n *\n * _.isArray(document.body.children);\n * // => false\n *\n * _.isArray('abc');\n * // => false\n *\n * _.isArray(_.noop);\n * // => false\n */\nvar isArray = Array.isArray;\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (isArray);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isArray.js?")},"./node_modules/lodash-es/isArrayLike.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _isFunction_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isFunction.js */ "./node_modules/lodash-es/isFunction.js");\n/* harmony import */ var _isLength_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isLength.js */ "./node_modules/lodash-es/isLength.js");\n\n\n\n/**\n * Checks if `value` is array-like. A value is considered array-like if it\'s\n * not a function and has a `value.length` that\'s an integer greater than or\n * equal to `0` and less than or equal to `Number.MAX_SAFE_INTEGER`.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is array-like, else `false`.\n * @example\n *\n * _.isArrayLike([1, 2, 3]);\n * // => true\n *\n * _.isArrayLike(document.body.children);\n * // => true\n *\n * _.isArrayLike(\'abc\');\n * // => true\n *\n * _.isArrayLike(_.noop);\n * // => false\n */\nfunction isArrayLike(value) {\n  return value != null && (0,_isLength_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value.length) && !(0,_isFunction_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (isArrayLike);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isArrayLike.js?')},"./node_modules/lodash-es/isArrayLikeObject.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _isArrayLike_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./isArrayLike.js */ "./node_modules/lodash-es/isArrayLike.js");\n/* harmony import */ var _isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObjectLike.js */ "./node_modules/lodash-es/isObjectLike.js");\n\n\n\n/**\n * This method is like `_.isArrayLike` except that it also checks if `value`\n * is an object.\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an array-like object,\n *  else `false`.\n * @example\n *\n * _.isArrayLikeObject([1, 2, 3]);\n * // => true\n *\n * _.isArrayLikeObject(document.body.children);\n * // => true\n *\n * _.isArrayLikeObject(\'abc\');\n * // => false\n *\n * _.isArrayLikeObject(_.noop);\n * // => false\n */\nfunction isArrayLikeObject(value) {\n  return (0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value) && (0,_isArrayLike_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (isArrayLikeObject);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isArrayLikeObject.js?')},"./node_modules/lodash-es/isBuffer.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _root_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_root.js */ "./node_modules/lodash-es/_root.js");\n/* harmony import */ var _stubFalse_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./stubFalse.js */ "./node_modules/lodash-es/stubFalse.js");\n\n\n\n/** Detect free variable `exports`. */\nvar freeExports = typeof exports == \'object\' && exports && !exports.nodeType && exports;\n\n/** Detect free variable `module`. */\nvar freeModule = freeExports && typeof module == \'object\' && module && !module.nodeType && module;\n\n/** Detect the popular CommonJS extension `module.exports`. */\nvar moduleExports = freeModule && freeModule.exports === freeExports;\n\n/** Built-in value references. */\nvar Buffer = moduleExports ? _root_js__WEBPACK_IMPORTED_MODULE_0__["default"].Buffer : undefined;\n\n/* Built-in method references for those with the same name as other `lodash` methods. */\nvar nativeIsBuffer = Buffer ? Buffer.isBuffer : undefined;\n\n/**\n * Checks if `value` is a buffer.\n *\n * @static\n * @memberOf _\n * @since 4.3.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a buffer, else `false`.\n * @example\n *\n * _.isBuffer(new Buffer(2));\n * // => true\n *\n * _.isBuffer(new Uint8Array(2));\n * // => false\n */\nvar isBuffer = nativeIsBuffer || _stubFalse_js__WEBPACK_IMPORTED_MODULE_1__["default"];\n\n/* harmony default export */ __webpack_exports__["default"] = (isBuffer);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isBuffer.js?')},"./node_modules/lodash-es/isEqual.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseIsEqual_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_baseIsEqual.js */ "./node_modules/lodash-es/_baseIsEqual.js");\n\n\n/**\n * Performs a deep comparison between two values to determine if they are\n * equivalent.\n *\n * **Note:** This method supports comparing arrays, array buffers, booleans,\n * date objects, error objects, maps, numbers, `Object` objects, regexes,\n * sets, strings, symbols, and typed arrays. `Object` objects are compared\n * by their own, not inherited, enumerable properties. Functions and DOM\n * nodes are compared by strict equality, i.e. `===`.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to compare.\n * @param {*} other The other value to compare.\n * @returns {boolean} Returns `true` if the values are equivalent, else `false`.\n * @example\n *\n * var object = { \'a\': 1 };\n * var other = { \'a\': 1 };\n *\n * _.isEqual(object, other);\n * // => true\n *\n * object === other;\n * // => false\n */\nfunction isEqual(value, other) {\n  return (0,_baseIsEqual_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value, other);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (isEqual);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isEqual.js?')},"./node_modules/lodash-es/isFunction.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseGetTag_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseGetTag.js */ \"./node_modules/lodash-es/_baseGetTag.js\");\n/* harmony import */ var _isObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObject.js */ \"./node_modules/lodash-es/isObject.js\");\n\n\n\n/** `Object#toString` result references. */\nvar asyncTag = '[object AsyncFunction]',\n    funcTag = '[object Function]',\n    genTag = '[object GeneratorFunction]',\n    proxyTag = '[object Proxy]';\n\n/**\n * Checks if `value` is classified as a `Function` object.\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a function, else `false`.\n * @example\n *\n * _.isFunction(_);\n * // => true\n *\n * _.isFunction(/abc/);\n * // => false\n */\nfunction isFunction(value) {\n  if (!(0,_isObject_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(value)) {\n    return false;\n  }\n  // The use of `Object#toString` avoids issues with the `typeof` operator\n  // in Safari 9 which returns 'object' for typed arrays and other constructors.\n  var tag = (0,_baseGetTag_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(value);\n  return tag == funcTag || tag == genTag || tag == asyncTag || tag == proxyTag;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (isFunction);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isFunction.js?")},"./node_modules/lodash-es/isLength.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/** Used as references for various `Number` constants. */\nvar MAX_SAFE_INTEGER = 9007199254740991;\n\n/**\n * Checks if `value` is a valid array-like length.\n *\n * **Note:** This method is loosely based on\n * [`ToLength`](http://ecma-international.org/ecma-262/7.0/#sec-tolength).\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a valid length, else `false`.\n * @example\n *\n * _.isLength(3);\n * // => true\n *\n * _.isLength(Number.MIN_VALUE);\n * // => false\n *\n * _.isLength(Infinity);\n * // => false\n *\n * _.isLength('3');\n * // => false\n */\nfunction isLength(value) {\n  return typeof value == 'number' &&\n    value > -1 && value % 1 == 0 && value <= MAX_SAFE_INTEGER;\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (isLength);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isLength.js?")},"./node_modules/lodash-es/isMap.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseIsMap_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_baseIsMap.js */ "./node_modules/lodash-es/_baseIsMap.js");\n/* harmony import */ var _baseUnary_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseUnary.js */ "./node_modules/lodash-es/_baseUnary.js");\n/* harmony import */ var _nodeUtil_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_nodeUtil.js */ "./node_modules/lodash-es/_nodeUtil.js");\n\n\n\n\n/* Node.js helper references. */\nvar nodeIsMap = _nodeUtil_js__WEBPACK_IMPORTED_MODULE_0__["default"] && _nodeUtil_js__WEBPACK_IMPORTED_MODULE_0__["default"].isMap;\n\n/**\n * Checks if `value` is classified as a `Map` object.\n *\n * @static\n * @memberOf _\n * @since 4.3.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a map, else `false`.\n * @example\n *\n * _.isMap(new Map);\n * // => true\n *\n * _.isMap(new WeakMap);\n * // => false\n */\nvar isMap = nodeIsMap ? (0,_baseUnary_js__WEBPACK_IMPORTED_MODULE_1__["default"])(nodeIsMap) : _baseIsMap_js__WEBPACK_IMPORTED_MODULE_2__["default"];\n\n/* harmony default export */ __webpack_exports__["default"] = (isMap);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isMap.js?')},"./node_modules/lodash-es/isObject.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/**\n * Checks if `value` is the\n * [language type](http://www.ecma-international.org/ecma-262/7.0/#sec-ecmascript-language-types)\n * of `Object`. (e.g. arrays, functions, objects, regexes, `new Number(0)`, and `new String('')`)\n *\n * @static\n * @memberOf _\n * @since 0.1.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is an object, else `false`.\n * @example\n *\n * _.isObject({});\n * // => true\n *\n * _.isObject([1, 2, 3]);\n * // => true\n *\n * _.isObject(_.noop);\n * // => true\n *\n * _.isObject(null);\n * // => false\n */\nfunction isObject(value) {\n  var type = typeof value;\n  return value != null && (type == 'object' || type == 'function');\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (isObject);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isObject.js?")},"./node_modules/lodash-es/isObjectLike.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * Checks if `value` is object-like. A value is object-like if it\'s not `null`\n * and has a `typeof` result of "object".\n *\n * @static\n * @memberOf _\n * @since 4.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is object-like, else `false`.\n * @example\n *\n * _.isObjectLike({});\n * // => true\n *\n * _.isObjectLike([1, 2, 3]);\n * // => true\n *\n * _.isObjectLike(_.noop);\n * // => false\n *\n * _.isObjectLike(null);\n * // => false\n */\nfunction isObjectLike(value) {\n  return value != null && typeof value == \'object\';\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (isObjectLike);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isObjectLike.js?')},"./node_modules/lodash-es/isPlainObject.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseGetTag_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseGetTag.js */ "./node_modules/lodash-es/_baseGetTag.js");\n/* harmony import */ var _getPrototype_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_getPrototype.js */ "./node_modules/lodash-es/_getPrototype.js");\n/* harmony import */ var _isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isObjectLike.js */ "./node_modules/lodash-es/isObjectLike.js");\n\n\n\n\n/** `Object#toString` result references. */\nvar objectTag = \'[object Object]\';\n\n/** Used for built-in method references. */\nvar funcProto = Function.prototype,\n    objectProto = Object.prototype;\n\n/** Used to resolve the decompiled source of functions. */\nvar funcToString = funcProto.toString;\n\n/** Used to check objects for own properties. */\nvar hasOwnProperty = objectProto.hasOwnProperty;\n\n/** Used to infer the `Object` constructor. */\nvar objectCtorString = funcToString.call(Object);\n\n/**\n * Checks if `value` is a plain object, that is, an object created by the\n * `Object` constructor or one with a `[[Prototype]]` of `null`.\n *\n * @static\n * @memberOf _\n * @since 0.8.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a plain object, else `false`.\n * @example\n *\n * function Foo() {\n *   this.a = 1;\n * }\n *\n * _.isPlainObject(new Foo);\n * // => false\n *\n * _.isPlainObject([1, 2, 3]);\n * // => false\n *\n * _.isPlainObject({ \'x\': 0, \'y\': 0 });\n * // => true\n *\n * _.isPlainObject(Object.create(null));\n * // => true\n */\nfunction isPlainObject(value) {\n  if (!(0,_isObjectLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(value) || (0,_baseGetTag_js__WEBPACK_IMPORTED_MODULE_1__["default"])(value) != objectTag) {\n    return false;\n  }\n  var proto = (0,_getPrototype_js__WEBPACK_IMPORTED_MODULE_2__["default"])(value);\n  if (proto === null) {\n    return true;\n  }\n  var Ctor = hasOwnProperty.call(proto, \'constructor\') && proto.constructor;\n  return typeof Ctor == \'function\' && Ctor instanceof Ctor &&\n    funcToString.call(Ctor) == objectCtorString;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (isPlainObject);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isPlainObject.js?')},"./node_modules/lodash-es/isSet.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseIsSet_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_baseIsSet.js */ "./node_modules/lodash-es/_baseIsSet.js");\n/* harmony import */ var _baseUnary_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseUnary.js */ "./node_modules/lodash-es/_baseUnary.js");\n/* harmony import */ var _nodeUtil_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_nodeUtil.js */ "./node_modules/lodash-es/_nodeUtil.js");\n\n\n\n\n/* Node.js helper references. */\nvar nodeIsSet = _nodeUtil_js__WEBPACK_IMPORTED_MODULE_0__["default"] && _nodeUtil_js__WEBPACK_IMPORTED_MODULE_0__["default"].isSet;\n\n/**\n * Checks if `value` is classified as a `Set` object.\n *\n * @static\n * @memberOf _\n * @since 4.3.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a set, else `false`.\n * @example\n *\n * _.isSet(new Set);\n * // => true\n *\n * _.isSet(new WeakSet);\n * // => false\n */\nvar isSet = nodeIsSet ? (0,_baseUnary_js__WEBPACK_IMPORTED_MODULE_1__["default"])(nodeIsSet) : _baseIsSet_js__WEBPACK_IMPORTED_MODULE_2__["default"];\n\n/* harmony default export */ __webpack_exports__["default"] = (isSet);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isSet.js?')},"./node_modules/lodash-es/isTypedArray.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseIsTypedArray_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_baseIsTypedArray.js */ "./node_modules/lodash-es/_baseIsTypedArray.js");\n/* harmony import */ var _baseUnary_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseUnary.js */ "./node_modules/lodash-es/_baseUnary.js");\n/* harmony import */ var _nodeUtil_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_nodeUtil.js */ "./node_modules/lodash-es/_nodeUtil.js");\n\n\n\n\n/* Node.js helper references. */\nvar nodeIsTypedArray = _nodeUtil_js__WEBPACK_IMPORTED_MODULE_0__["default"] && _nodeUtil_js__WEBPACK_IMPORTED_MODULE_0__["default"].isTypedArray;\n\n/**\n * Checks if `value` is classified as a typed array.\n *\n * @static\n * @memberOf _\n * @since 3.0.0\n * @category Lang\n * @param {*} value The value to check.\n * @returns {boolean} Returns `true` if `value` is a typed array, else `false`.\n * @example\n *\n * _.isTypedArray(new Uint8Array);\n * // => true\n *\n * _.isTypedArray([]);\n * // => false\n */\nvar isTypedArray = nodeIsTypedArray ? (0,_baseUnary_js__WEBPACK_IMPORTED_MODULE_1__["default"])(nodeIsTypedArray) : _baseIsTypedArray_js__WEBPACK_IMPORTED_MODULE_2__["default"];\n\n/* harmony default export */ __webpack_exports__["default"] = (isTypedArray);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/isTypedArray.js?')},"./node_modules/lodash-es/keys.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _arrayLikeKeys_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arrayLikeKeys.js */ "./node_modules/lodash-es/_arrayLikeKeys.js");\n/* harmony import */ var _baseKeys_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_baseKeys.js */ "./node_modules/lodash-es/_baseKeys.js");\n/* harmony import */ var _isArrayLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArrayLike.js */ "./node_modules/lodash-es/isArrayLike.js");\n\n\n\n\n/**\n * Creates an array of the own enumerable property names of `object`.\n *\n * **Note:** Non-object values are coerced to objects. See the\n * [ES spec](http://ecma-international.org/ecma-262/7.0/#sec-object.keys)\n * for more details.\n *\n * @static\n * @since 0.1.0\n * @memberOf _\n * @category Object\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names.\n * @example\n *\n * function Foo() {\n *   this.a = 1;\n *   this.b = 2;\n * }\n *\n * Foo.prototype.c = 3;\n *\n * _.keys(new Foo);\n * // => [\'a\', \'b\'] (iteration order is not guaranteed)\n *\n * _.keys(\'hi\');\n * // => [\'0\', \'1\']\n */\nfunction keys(object) {\n  return (0,_isArrayLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object) ? (0,_arrayLikeKeys_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object) : (0,_baseKeys_js__WEBPACK_IMPORTED_MODULE_2__["default"])(object);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (keys);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/keys.js?')},"./node_modules/lodash-es/keysIn.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _arrayLikeKeys_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_arrayLikeKeys.js */ "./node_modules/lodash-es/_arrayLikeKeys.js");\n/* harmony import */ var _baseKeysIn_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./_baseKeysIn.js */ "./node_modules/lodash-es/_baseKeysIn.js");\n/* harmony import */ var _isArrayLike_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./isArrayLike.js */ "./node_modules/lodash-es/isArrayLike.js");\n\n\n\n\n/**\n * Creates an array of the own and inherited enumerable property names of `object`.\n *\n * **Note:** Non-object values are coerced to objects.\n *\n * @static\n * @memberOf _\n * @since 3.0.0\n * @category Object\n * @param {Object} object The object to query.\n * @returns {Array} Returns the array of property names.\n * @example\n *\n * function Foo() {\n *   this.a = 1;\n *   this.b = 2;\n * }\n *\n * Foo.prototype.c = 3;\n *\n * _.keysIn(new Foo);\n * // => [\'a\', \'b\', \'c\'] (iteration order is not guaranteed)\n */\nfunction keysIn(object) {\n  return (0,_isArrayLike_js__WEBPACK_IMPORTED_MODULE_0__["default"])(object) ? (0,_arrayLikeKeys_js__WEBPACK_IMPORTED_MODULE_1__["default"])(object, true) : (0,_baseKeysIn_js__WEBPACK_IMPORTED_MODULE_2__["default"])(object);\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (keysIn);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/keysIn.js?')},"./node_modules/lodash-es/merge.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _baseMerge_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./_baseMerge.js */ \"./node_modules/lodash-es/_baseMerge.js\");\n/* harmony import */ var _createAssigner_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_createAssigner.js */ \"./node_modules/lodash-es/_createAssigner.js\");\n\n\n\n/**\n * This method is like `_.assign` except that it recursively merges own and\n * inherited enumerable string keyed properties of source objects into the\n * destination object. Source properties that resolve to `undefined` are\n * skipped if a destination value exists. Array and plain object properties\n * are merged recursively. Other objects and value types are overridden by\n * assignment. Source objects are applied from left to right. Subsequent\n * sources overwrite property assignments of previous sources.\n *\n * **Note:** This method mutates `object`.\n *\n * @static\n * @memberOf _\n * @since 0.5.0\n * @category Object\n * @param {Object} object The destination object.\n * @param {...Object} [sources] The source objects.\n * @returns {Object} Returns `object`.\n * @example\n *\n * var object = {\n *   'a': [{ 'b': 2 }, { 'd': 4 }]\n * };\n *\n * var other = {\n *   'a': [{ 'c': 3 }, { 'e': 5 }]\n * };\n *\n * _.merge(object, other);\n * // => { 'a': [{ 'b': 2, 'c': 3 }, { 'd': 4, 'e': 5 }] }\n */\nvar merge = (0,_createAssigner_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(function(object, source, srcIndex) {\n  (0,_baseMerge_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(object, source, srcIndex);\n});\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (merge);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/merge.js?")},"./node_modules/lodash-es/stubArray.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * This method returns a new empty array.\n *\n * @static\n * @memberOf _\n * @since 4.13.0\n * @category Util\n * @returns {Array} Returns the new empty array.\n * @example\n *\n * var arrays = _.times(2, _.stubArray);\n *\n * console.log(arrays);\n * // => [[], []]\n *\n * console.log(arrays[0] === arrays[1]);\n * // => false\n */\nfunction stubArray() {\n  return [];\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (stubArray);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/stubArray.js?')},"./node_modules/lodash-es/stubFalse.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/**\n * This method returns `false`.\n *\n * @static\n * @memberOf _\n * @since 4.13.0\n * @category Util\n * @returns {boolean} Returns `false`.\n * @example\n *\n * _.times(2, _.stubFalse);\n * // => [false, false]\n */\nfunction stubFalse() {\n  return false;\n}\n\n/* harmony default export */ __webpack_exports__["default"] = (stubFalse);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/stubFalse.js?')},"./node_modules/lodash-es/toPlainObject.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _copyObject_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./_copyObject.js */ \"./node_modules/lodash-es/_copyObject.js\");\n/* harmony import */ var _keysIn_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./keysIn.js */ \"./node_modules/lodash-es/keysIn.js\");\n\n\n\n/**\n * Converts `value` to a plain object flattening inherited enumerable string\n * keyed properties of `value` to own properties of the plain object.\n *\n * @static\n * @memberOf _\n * @since 3.0.0\n * @category Lang\n * @param {*} value The value to convert.\n * @returns {Object} Returns the converted plain object.\n * @example\n *\n * function Foo() {\n *   this.b = 2;\n * }\n *\n * Foo.prototype.c = 3;\n *\n * _.assign({ 'a': 1 }, new Foo);\n * // => { 'a': 1, 'b': 2 }\n *\n * _.assign({ 'a': 1 }, _.toPlainObject(new Foo));\n * // => { 'a': 1, 'b': 2, 'c': 3 }\n */\nfunction toPlainObject(value) {\n  return (0,_copyObject_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"])(value, (0,_keysIn_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"])(value));\n}\n\n/* harmony default export */ __webpack_exports__[\"default\"] = (toPlainObject);\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/lodash-es/toPlainObject.js?")},"./node_modules/parchment/dist/parchment.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Attributor: function() { return /* binding */ Attributor; },\n/* harmony export */   AttributorStore: function() { return /* binding */ AttributorStore$1; },\n/* harmony export */   BlockBlot: function() { return /* binding */ BlockBlot$1; },\n/* harmony export */   ClassAttributor: function() { return /* binding */ ClassAttributor$1; },\n/* harmony export */   ContainerBlot: function() { return /* binding */ ContainerBlot$1; },\n/* harmony export */   EmbedBlot: function() { return /* binding */ EmbedBlot$1; },\n/* harmony export */   InlineBlot: function() { return /* binding */ InlineBlot$1; },\n/* harmony export */   LeafBlot: function() { return /* binding */ LeafBlot$1; },\n/* harmony export */   ParentBlot: function() { return /* binding */ ParentBlot$1; },\n/* harmony export */   Registry: function() { return /* binding */ Registry; },\n/* harmony export */   Scope: function() { return /* binding */ Scope; },\n/* harmony export */   ScrollBlot: function() { return /* binding */ ScrollBlot$1; },\n/* harmony export */   StyleAttributor: function() { return /* binding */ StyleAttributor$1; },\n/* harmony export */   TextBlot: function() { return /* binding */ TextBlot$1; }\n/* harmony export */ });\nvar Scope = /* @__PURE__ */ ((Scope2) => (Scope2[Scope2.TYPE = 3] = "TYPE", Scope2[Scope2.LEVEL = 12] = "LEVEL", Scope2[Scope2.ATTRIBUTE = 13] = "ATTRIBUTE", Scope2[Scope2.BLOT = 14] = "BLOT", Scope2[Scope2.INLINE = 7] = "INLINE", Scope2[Scope2.BLOCK = 11] = "BLOCK", Scope2[Scope2.BLOCK_BLOT = 10] = "BLOCK_BLOT", Scope2[Scope2.INLINE_BLOT = 6] = "INLINE_BLOT", Scope2[Scope2.BLOCK_ATTRIBUTE = 9] = "BLOCK_ATTRIBUTE", Scope2[Scope2.INLINE_ATTRIBUTE = 5] = "INLINE_ATTRIBUTE", Scope2[Scope2.ANY = 15] = "ANY", Scope2))(Scope || {});\nclass Attributor {\n  constructor(attrName, keyName, options = {}) {\n    this.attrName = attrName, this.keyName = keyName;\n    const attributeBit = Scope.TYPE & Scope.ATTRIBUTE;\n    this.scope = options.scope != null ? (\n      // Ignore type bits, force attribute bit\n      options.scope & Scope.LEVEL | attributeBit\n    ) : Scope.ATTRIBUTE, options.whitelist != null && (this.whitelist = options.whitelist);\n  }\n  static keys(node) {\n    return Array.from(node.attributes).map((item) => item.name);\n  }\n  add(node, value) {\n    return this.canAdd(node, value) ? (node.setAttribute(this.keyName, value), !0) : !1;\n  }\n  canAdd(_node, value) {\n    return this.whitelist == null ? !0 : typeof value == "string" ? this.whitelist.indexOf(value.replace(/["\']/g, "")) > -1 : this.whitelist.indexOf(value) > -1;\n  }\n  remove(node) {\n    node.removeAttribute(this.keyName);\n  }\n  value(node) {\n    const value = node.getAttribute(this.keyName);\n    return this.canAdd(node, value) && value ? value : "";\n  }\n}\nclass ParchmentError extends Error {\n  constructor(message) {\n    message = "[Parchment] " + message, super(message), this.message = message, this.name = this.constructor.name;\n  }\n}\nconst _Registry = class _Registry {\n  constructor() {\n    this.attributes = {}, this.classes = {}, this.tags = {}, this.types = {};\n  }\n  static find(node, bubble = !1) {\n    if (node == null)\n      return null;\n    if (this.blots.has(node))\n      return this.blots.get(node) || null;\n    if (bubble) {\n      let parentNode = null;\n      try {\n        parentNode = node.parentNode;\n      } catch {\n        return null;\n      }\n      return this.find(parentNode, bubble);\n    }\n    return null;\n  }\n  create(scroll, input, value) {\n    const match2 = this.query(input);\n    if (match2 == null)\n      throw new ParchmentError(`Unable to create ${input} blot`);\n    const blotClass = match2, node = (\n      // @ts-expect-error Fix me later\n      input instanceof Node || input.nodeType === Node.TEXT_NODE ? input : blotClass.create(value)\n    ), blot = new blotClass(scroll, node, value);\n    return _Registry.blots.set(blot.domNode, blot), blot;\n  }\n  find(node, bubble = !1) {\n    return _Registry.find(node, bubble);\n  }\n  query(query, scope = Scope.ANY) {\n    let match2;\n    return typeof query == "string" ? match2 = this.types[query] || this.attributes[query] : query instanceof Text || query.nodeType === Node.TEXT_NODE ? match2 = this.types.text : typeof query == "number" ? query & Scope.LEVEL & Scope.BLOCK ? match2 = this.types.block : query & Scope.LEVEL & Scope.INLINE && (match2 = this.types.inline) : query instanceof Element && ((query.getAttribute("class") || "").split(/\\s+/).some((name) => (match2 = this.classes[name], !!match2)), match2 = match2 || this.tags[query.tagName]), match2 == null ? null : "scope" in match2 && scope & Scope.LEVEL & match2.scope && scope & Scope.TYPE & match2.scope ? match2 : null;\n  }\n  register(...definitions) {\n    return definitions.map((definition) => {\n      const isBlot = "blotName" in definition, isAttr = "attrName" in definition;\n      if (!isBlot && !isAttr)\n        throw new ParchmentError("Invalid definition");\n      if (isBlot && definition.blotName === "abstract")\n        throw new ParchmentError("Cannot register abstract class");\n      const key = isBlot ? definition.blotName : isAttr ? definition.attrName : void 0;\n      return this.types[key] = definition, isAttr ? typeof definition.keyName == "string" && (this.attributes[definition.keyName] = definition) : isBlot && (definition.className && (this.classes[definition.className] = definition), definition.tagName && (Array.isArray(definition.tagName) ? definition.tagName = definition.tagName.map((tagName) => tagName.toUpperCase()) : definition.tagName = definition.tagName.toUpperCase(), (Array.isArray(definition.tagName) ? definition.tagName : [definition.tagName]).forEach((tag) => {\n        (this.tags[tag] == null || definition.className == null) && (this.tags[tag] = definition);\n      }))), definition;\n    });\n  }\n};\n_Registry.blots = /* @__PURE__ */ new WeakMap();\nlet Registry = _Registry;\nfunction match(node, prefix) {\n  return (node.getAttribute("class") || "").split(/\\s+/).filter((name) => name.indexOf(`${prefix}-`) === 0);\n}\nclass ClassAttributor extends Attributor {\n  static keys(node) {\n    return (node.getAttribute("class") || "").split(/\\s+/).map((name) => name.split("-").slice(0, -1).join("-"));\n  }\n  add(node, value) {\n    return this.canAdd(node, value) ? (this.remove(node), node.classList.add(`${this.keyName}-${value}`), !0) : !1;\n  }\n  remove(node) {\n    match(node, this.keyName).forEach((name) => {\n      node.classList.remove(name);\n    }), node.classList.length === 0 && node.removeAttribute("class");\n  }\n  value(node) {\n    const value = (match(node, this.keyName)[0] || "").slice(this.keyName.length + 1);\n    return this.canAdd(node, value) ? value : "";\n  }\n}\nconst ClassAttributor$1 = ClassAttributor;\nfunction camelize(name) {\n  const parts = name.split("-"), rest = parts.slice(1).map((part) => part[0].toUpperCase() + part.slice(1)).join("");\n  return parts[0] + rest;\n}\nclass StyleAttributor extends Attributor {\n  static keys(node) {\n    return (node.getAttribute("style") || "").split(";").map((value) => value.split(":")[0].trim());\n  }\n  add(node, value) {\n    return this.canAdd(node, value) ? (node.style[camelize(this.keyName)] = value, !0) : !1;\n  }\n  remove(node) {\n    node.style[camelize(this.keyName)] = "", node.getAttribute("style") || node.removeAttribute("style");\n  }\n  value(node) {\n    const value = node.style[camelize(this.keyName)];\n    return this.canAdd(node, value) ? value : "";\n  }\n}\nconst StyleAttributor$1 = StyleAttributor;\nclass AttributorStore {\n  constructor(domNode) {\n    this.attributes = {}, this.domNode = domNode, this.build();\n  }\n  attribute(attribute, value) {\n    value ? attribute.add(this.domNode, value) && (attribute.value(this.domNode) != null ? this.attributes[attribute.attrName] = attribute : delete this.attributes[attribute.attrName]) : (attribute.remove(this.domNode), delete this.attributes[attribute.attrName]);\n  }\n  build() {\n    this.attributes = {};\n    const blot = Registry.find(this.domNode);\n    if (blot == null)\n      return;\n    const attributes = Attributor.keys(this.domNode), classes = ClassAttributor$1.keys(this.domNode), styles = StyleAttributor$1.keys(this.domNode);\n    attributes.concat(classes).concat(styles).forEach((name) => {\n      const attr = blot.scroll.query(name, Scope.ATTRIBUTE);\n      attr instanceof Attributor && (this.attributes[attr.attrName] = attr);\n    });\n  }\n  copy(target) {\n    Object.keys(this.attributes).forEach((key) => {\n      const value = this.attributes[key].value(this.domNode);\n      target.format(key, value);\n    });\n  }\n  move(target) {\n    this.copy(target), Object.keys(this.attributes).forEach((key) => {\n      this.attributes[key].remove(this.domNode);\n    }), this.attributes = {};\n  }\n  values() {\n    return Object.keys(this.attributes).reduce(\n      (attributes, name) => (attributes[name] = this.attributes[name].value(this.domNode), attributes),\n      {}\n    );\n  }\n}\nconst AttributorStore$1 = AttributorStore, _ShadowBlot = class _ShadowBlot {\n  constructor(scroll, domNode) {\n    this.scroll = scroll, this.domNode = domNode, Registry.blots.set(domNode, this), this.prev = null, this.next = null;\n  }\n  static create(rawValue) {\n    if (this.tagName == null)\n      throw new ParchmentError("Blot definition missing tagName");\n    let node, value;\n    return Array.isArray(this.tagName) ? (typeof rawValue == "string" ? (value = rawValue.toUpperCase(), parseInt(value, 10).toString() === value && (value = parseInt(value, 10))) : typeof rawValue == "number" && (value = rawValue), typeof value == "number" ? node = document.createElement(this.tagName[value - 1]) : value && this.tagName.indexOf(value) > -1 ? node = document.createElement(value) : node = document.createElement(this.tagName[0])) : node = document.createElement(this.tagName), this.className && node.classList.add(this.className), node;\n  }\n  // Hack for accessing inherited static methods\n  get statics() {\n    return this.constructor;\n  }\n  attach() {\n  }\n  clone() {\n    const domNode = this.domNode.cloneNode(!1);\n    return this.scroll.create(domNode);\n  }\n  detach() {\n    this.parent != null && this.parent.removeChild(this), Registry.blots.delete(this.domNode);\n  }\n  deleteAt(index, length) {\n    this.isolate(index, length).remove();\n  }\n  formatAt(index, length, name, value) {\n    const blot = this.isolate(index, length);\n    if (this.scroll.query(name, Scope.BLOT) != null && value)\n      blot.wrap(name, value);\n    else if (this.scroll.query(name, Scope.ATTRIBUTE) != null) {\n      const parent = this.scroll.create(this.statics.scope);\n      blot.wrap(parent), parent.format(name, value);\n    }\n  }\n  insertAt(index, value, def) {\n    const blot = def == null ? this.scroll.create("text", value) : this.scroll.create(value, def), ref = this.split(index);\n    this.parent.insertBefore(blot, ref || void 0);\n  }\n  isolate(index, length) {\n    const target = this.split(index);\n    if (target == null)\n      throw new Error("Attempt to isolate at end");\n    return target.split(length), target;\n  }\n  length() {\n    return 1;\n  }\n  offset(root = this.parent) {\n    return this.parent == null || this === root ? 0 : this.parent.children.offset(this) + this.parent.offset(root);\n  }\n  optimize(_context) {\n    this.statics.requiredContainer && !(this.parent instanceof this.statics.requiredContainer) && this.wrap(this.statics.requiredContainer.blotName);\n  }\n  remove() {\n    this.domNode.parentNode != null && this.domNode.parentNode.removeChild(this.domNode), this.detach();\n  }\n  replaceWith(name, value) {\n    const replacement = typeof name == "string" ? this.scroll.create(name, value) : name;\n    return this.parent != null && (this.parent.insertBefore(replacement, this.next || void 0), this.remove()), replacement;\n  }\n  split(index, _force) {\n    return index === 0 ? this : this.next;\n  }\n  update(_mutations, _context) {\n  }\n  wrap(name, value) {\n    const wrapper = typeof name == "string" ? this.scroll.create(name, value) : name;\n    if (this.parent != null && this.parent.insertBefore(wrapper, this.next || void 0), typeof wrapper.appendChild != "function")\n      throw new ParchmentError(`Cannot wrap ${name}`);\n    return wrapper.appendChild(this), wrapper;\n  }\n};\n_ShadowBlot.blotName = "abstract";\nlet ShadowBlot = _ShadowBlot;\nconst _LeafBlot = class _LeafBlot extends ShadowBlot {\n  /**\n   * Returns the value represented by domNode if it is this Blot\'s type\n   * No checking that domNode can represent this Blot type is required so\n   * applications needing it should check externally before calling.\n   */\n  static value(_domNode) {\n    return !0;\n  }\n  /**\n   * Given location represented by node and offset from DOM Selection Range,\n   * return index to that location.\n   */\n  index(node, offset) {\n    return this.domNode === node || this.domNode.compareDocumentPosition(node) & Node.DOCUMENT_POSITION_CONTAINED_BY ? Math.min(offset, 1) : -1;\n  }\n  /**\n   * Given index to location within blot, return node and offset representing\n   * that location, consumable by DOM Selection Range\n   */\n  position(index, _inclusive) {\n    let offset = Array.from(this.parent.domNode.childNodes).indexOf(this.domNode);\n    return index > 0 && (offset += 1), [this.parent.domNode, offset];\n  }\n  /**\n   * Return value represented by this blot\n   * Should not change without interaction from API or\n   * user change detectable by update()\n   */\n  value() {\n    return {\n      [this.statics.blotName]: this.statics.value(this.domNode) || !0\n    };\n  }\n};\n_LeafBlot.scope = Scope.INLINE_BLOT;\nlet LeafBlot = _LeafBlot;\nconst LeafBlot$1 = LeafBlot;\nclass LinkedList {\n  constructor() {\n    this.head = null, this.tail = null, this.length = 0;\n  }\n  append(...nodes) {\n    if (this.insertBefore(nodes[0], null), nodes.length > 1) {\n      const rest = nodes.slice(1);\n      this.append(...rest);\n    }\n  }\n  at(index) {\n    const next = this.iterator();\n    let cur = next();\n    for (; cur && index > 0; )\n      index -= 1, cur = next();\n    return cur;\n  }\n  contains(node) {\n    const next = this.iterator();\n    let cur = next();\n    for (; cur; ) {\n      if (cur === node)\n        return !0;\n      cur = next();\n    }\n    return !1;\n  }\n  indexOf(node) {\n    const next = this.iterator();\n    let cur = next(), index = 0;\n    for (; cur; ) {\n      if (cur === node)\n        return index;\n      index += 1, cur = next();\n    }\n    return -1;\n  }\n  insertBefore(node, refNode) {\n    node != null && (this.remove(node), node.next = refNode, refNode != null ? (node.prev = refNode.prev, refNode.prev != null && (refNode.prev.next = node), refNode.prev = node, refNode === this.head && (this.head = node)) : this.tail != null ? (this.tail.next = node, node.prev = this.tail, this.tail = node) : (node.prev = null, this.head = this.tail = node), this.length += 1);\n  }\n  offset(target) {\n    let index = 0, cur = this.head;\n    for (; cur != null; ) {\n      if (cur === target)\n        return index;\n      index += cur.length(), cur = cur.next;\n    }\n    return -1;\n  }\n  remove(node) {\n    this.contains(node) && (node.prev != null && (node.prev.next = node.next), node.next != null && (node.next.prev = node.prev), node === this.head && (this.head = node.next), node === this.tail && (this.tail = node.prev), this.length -= 1);\n  }\n  iterator(curNode = this.head) {\n    return () => {\n      const ret = curNode;\n      return curNode != null && (curNode = curNode.next), ret;\n    };\n  }\n  find(index, inclusive = !1) {\n    const next = this.iterator();\n    let cur = next();\n    for (; cur; ) {\n      const length = cur.length();\n      if (index < length || inclusive && index === length && (cur.next == null || cur.next.length() !== 0))\n        return [cur, index];\n      index -= length, cur = next();\n    }\n    return [null, 0];\n  }\n  forEach(callback) {\n    const next = this.iterator();\n    let cur = next();\n    for (; cur; )\n      callback(cur), cur = next();\n  }\n  forEachAt(index, length, callback) {\n    if (length <= 0)\n      return;\n    const [startNode, offset] = this.find(index);\n    let curIndex = index - offset;\n    const next = this.iterator(startNode);\n    let cur = next();\n    for (; cur && curIndex < index + length; ) {\n      const curLength = cur.length();\n      index > curIndex ? callback(\n        cur,\n        index - curIndex,\n        Math.min(length, curIndex + curLength - index)\n      ) : callback(cur, 0, Math.min(curLength, index + length - curIndex)), curIndex += curLength, cur = next();\n    }\n  }\n  map(callback) {\n    return this.reduce((memo, cur) => (memo.push(callback(cur)), memo), []);\n  }\n  reduce(callback, memo) {\n    const next = this.iterator();\n    let cur = next();\n    for (; cur; )\n      memo = callback(memo, cur), cur = next();\n    return memo;\n  }\n}\nfunction makeAttachedBlot(node, scroll) {\n  const found = scroll.find(node);\n  if (found)\n    return found;\n  try {\n    return scroll.create(node);\n  } catch {\n    const blot = scroll.create(Scope.INLINE);\n    return Array.from(node.childNodes).forEach((child) => {\n      blot.domNode.appendChild(child);\n    }), node.parentNode && node.parentNode.replaceChild(blot.domNode, node), blot.attach(), blot;\n  }\n}\nconst _ParentBlot = class _ParentBlot extends ShadowBlot {\n  constructor(scroll, domNode) {\n    super(scroll, domNode), this.uiNode = null, this.build();\n  }\n  appendChild(other) {\n    this.insertBefore(other);\n  }\n  attach() {\n    super.attach(), this.children.forEach((child) => {\n      child.attach();\n    });\n  }\n  attachUI(node) {\n    this.uiNode != null && this.uiNode.remove(), this.uiNode = node, _ParentBlot.uiClass && this.uiNode.classList.add(_ParentBlot.uiClass), this.uiNode.setAttribute("contenteditable", "false"), this.domNode.insertBefore(this.uiNode, this.domNode.firstChild);\n  }\n  /**\n   * Called during construction, should fill its own children LinkedList.\n   */\n  build() {\n    this.children = new LinkedList(), Array.from(this.domNode.childNodes).filter((node) => node !== this.uiNode).reverse().forEach((node) => {\n      try {\n        const child = makeAttachedBlot(node, this.scroll);\n        this.insertBefore(child, this.children.head || void 0);\n      } catch (err) {\n        if (err instanceof ParchmentError)\n          return;\n        throw err;\n      }\n    });\n  }\n  deleteAt(index, length) {\n    if (index === 0 && length === this.length())\n      return this.remove();\n    this.children.forEachAt(index, length, (child, offset, childLength) => {\n      child.deleteAt(offset, childLength);\n    });\n  }\n  descendant(criteria, index = 0) {\n    const [child, offset] = this.children.find(index);\n    return criteria.blotName == null && criteria(child) || criteria.blotName != null && child instanceof criteria ? [child, offset] : child instanceof _ParentBlot ? child.descendant(criteria, offset) : [null, -1];\n  }\n  descendants(criteria, index = 0, length = Number.MAX_VALUE) {\n    let descendants = [], lengthLeft = length;\n    return this.children.forEachAt(\n      index,\n      length,\n      (child, childIndex, childLength) => {\n        (criteria.blotName == null && criteria(child) || criteria.blotName != null && child instanceof criteria) && descendants.push(child), child instanceof _ParentBlot && (descendants = descendants.concat(\n          child.descendants(criteria, childIndex, lengthLeft)\n        )), lengthLeft -= childLength;\n      }\n    ), descendants;\n  }\n  detach() {\n    this.children.forEach((child) => {\n      child.detach();\n    }), super.detach();\n  }\n  enforceAllowedChildren() {\n    let done = !1;\n    this.children.forEach((child) => {\n      done || this.statics.allowedChildren.some(\n        (def) => child instanceof def\n      ) || (child.statics.scope === Scope.BLOCK_BLOT ? (child.next != null && this.splitAfter(child), child.prev != null && this.splitAfter(child.prev), child.parent.unwrap(), done = !0) : child instanceof _ParentBlot ? child.unwrap() : child.remove());\n    });\n  }\n  formatAt(index, length, name, value) {\n    this.children.forEachAt(index, length, (child, offset, childLength) => {\n      child.formatAt(offset, childLength, name, value);\n    });\n  }\n  insertAt(index, value, def) {\n    const [child, offset] = this.children.find(index);\n    if (child)\n      child.insertAt(offset, value, def);\n    else {\n      const blot = def == null ? this.scroll.create("text", value) : this.scroll.create(value, def);\n      this.appendChild(blot);\n    }\n  }\n  insertBefore(childBlot, refBlot) {\n    childBlot.parent != null && childBlot.parent.children.remove(childBlot);\n    let refDomNode = null;\n    this.children.insertBefore(childBlot, refBlot || null), childBlot.parent = this, refBlot != null && (refDomNode = refBlot.domNode), (this.domNode.parentNode !== childBlot.domNode || this.domNode.nextSibling !== refDomNode) && this.domNode.insertBefore(childBlot.domNode, refDomNode), childBlot.attach();\n  }\n  length() {\n    return this.children.reduce((memo, child) => memo + child.length(), 0);\n  }\n  moveChildren(targetParent, refNode) {\n    this.children.forEach((child) => {\n      targetParent.insertBefore(child, refNode);\n    });\n  }\n  optimize(context) {\n    if (super.optimize(context), this.enforceAllowedChildren(), this.uiNode != null && this.uiNode !== this.domNode.firstChild && this.domNode.insertBefore(this.uiNode, this.domNode.firstChild), this.children.length === 0)\n      if (this.statics.defaultChild != null) {\n        const child = this.scroll.create(this.statics.defaultChild.blotName);\n        this.appendChild(child);\n      } else\n        this.remove();\n  }\n  path(index, inclusive = !1) {\n    const [child, offset] = this.children.find(index, inclusive), position = [[this, index]];\n    return child instanceof _ParentBlot ? position.concat(child.path(offset, inclusive)) : (child != null && position.push([child, offset]), position);\n  }\n  removeChild(child) {\n    this.children.remove(child);\n  }\n  replaceWith(name, value) {\n    const replacement = typeof name == "string" ? this.scroll.create(name, value) : name;\n    return replacement instanceof _ParentBlot && this.moveChildren(replacement), super.replaceWith(replacement);\n  }\n  split(index, force = !1) {\n    if (!force) {\n      if (index === 0)\n        return this;\n      if (index === this.length())\n        return this.next;\n    }\n    const after = this.clone();\n    return this.parent && this.parent.insertBefore(after, this.next || void 0), this.children.forEachAt(index, this.length(), (child, offset, _length) => {\n      const split = child.split(offset, force);\n      split != null && after.appendChild(split);\n    }), after;\n  }\n  splitAfter(child) {\n    const after = this.clone();\n    for (; child.next != null; )\n      after.appendChild(child.next);\n    return this.parent && this.parent.insertBefore(after, this.next || void 0), after;\n  }\n  unwrap() {\n    this.parent && this.moveChildren(this.parent, this.next || void 0), this.remove();\n  }\n  update(mutations, _context) {\n    const addedNodes = [], removedNodes = [];\n    mutations.forEach((mutation) => {\n      mutation.target === this.domNode && mutation.type === "childList" && (addedNodes.push(...mutation.addedNodes), removedNodes.push(...mutation.removedNodes));\n    }), removedNodes.forEach((node) => {\n      if (node.parentNode != null && // @ts-expect-error Fix me later\n      node.tagName !== "IFRAME" && document.body.compareDocumentPosition(node) & Node.DOCUMENT_POSITION_CONTAINED_BY)\n        return;\n      const blot = this.scroll.find(node);\n      blot != null && (blot.domNode.parentNode == null || blot.domNode.parentNode === this.domNode) && blot.detach();\n    }), addedNodes.filter((node) => node.parentNode === this.domNode && node !== this.uiNode).sort((a, b) => a === b ? 0 : a.compareDocumentPosition(b) & Node.DOCUMENT_POSITION_FOLLOWING ? 1 : -1).forEach((node) => {\n      let refBlot = null;\n      node.nextSibling != null && (refBlot = this.scroll.find(node.nextSibling));\n      const blot = makeAttachedBlot(node, this.scroll);\n      (blot.next !== refBlot || blot.next == null) && (blot.parent != null && blot.parent.removeChild(this), this.insertBefore(blot, refBlot || void 0));\n    }), this.enforceAllowedChildren();\n  }\n};\n_ParentBlot.uiClass = "";\nlet ParentBlot = _ParentBlot;\nconst ParentBlot$1 = ParentBlot;\nfunction isEqual(obj1, obj2) {\n  if (Object.keys(obj1).length !== Object.keys(obj2).length)\n    return !1;\n  for (const prop in obj1)\n    if (obj1[prop] !== obj2[prop])\n      return !1;\n  return !0;\n}\nconst _InlineBlot = class _InlineBlot extends ParentBlot$1 {\n  static create(value) {\n    return super.create(value);\n  }\n  static formats(domNode, scroll) {\n    const match2 = scroll.query(_InlineBlot.blotName);\n    if (!(match2 != null && domNode.tagName === match2.tagName)) {\n      if (typeof this.tagName == "string")\n        return !0;\n      if (Array.isArray(this.tagName))\n        return domNode.tagName.toLowerCase();\n    }\n  }\n  constructor(scroll, domNode) {\n    super(scroll, domNode), this.attributes = new AttributorStore$1(this.domNode);\n  }\n  format(name, value) {\n    if (name === this.statics.blotName && !value)\n      this.children.forEach((child) => {\n        child instanceof _InlineBlot || (child = child.wrap(_InlineBlot.blotName, !0)), this.attributes.copy(child);\n      }), this.unwrap();\n    else {\n      const format = this.scroll.query(name, Scope.INLINE);\n      if (format == null)\n        return;\n      format instanceof Attributor ? this.attributes.attribute(format, value) : value && (name !== this.statics.blotName || this.formats()[name] !== value) && this.replaceWith(name, value);\n    }\n  }\n  formats() {\n    const formats = this.attributes.values(), format = this.statics.formats(this.domNode, this.scroll);\n    return format != null && (formats[this.statics.blotName] = format), formats;\n  }\n  formatAt(index, length, name, value) {\n    this.formats()[name] != null || this.scroll.query(name, Scope.ATTRIBUTE) ? this.isolate(index, length).format(name, value) : super.formatAt(index, length, name, value);\n  }\n  optimize(context) {\n    super.optimize(context);\n    const formats = this.formats();\n    if (Object.keys(formats).length === 0)\n      return this.unwrap();\n    const next = this.next;\n    next instanceof _InlineBlot && next.prev === this && isEqual(formats, next.formats()) && (next.moveChildren(this), next.remove());\n  }\n  replaceWith(name, value) {\n    const replacement = super.replaceWith(name, value);\n    return this.attributes.copy(replacement), replacement;\n  }\n  update(mutations, context) {\n    super.update(mutations, context), mutations.some(\n      (mutation) => mutation.target === this.domNode && mutation.type === "attributes"\n    ) && this.attributes.build();\n  }\n  wrap(name, value) {\n    const wrapper = super.wrap(name, value);\n    return wrapper instanceof _InlineBlot && this.attributes.move(wrapper), wrapper;\n  }\n};\n_InlineBlot.allowedChildren = [_InlineBlot, LeafBlot$1], _InlineBlot.blotName = "inline", _InlineBlot.scope = Scope.INLINE_BLOT, _InlineBlot.tagName = "SPAN";\nlet InlineBlot = _InlineBlot;\nconst InlineBlot$1 = InlineBlot, _BlockBlot = class _BlockBlot extends ParentBlot$1 {\n  static create(value) {\n    return super.create(value);\n  }\n  static formats(domNode, scroll) {\n    const match2 = scroll.query(_BlockBlot.blotName);\n    if (!(match2 != null && domNode.tagName === match2.tagName)) {\n      if (typeof this.tagName == "string")\n        return !0;\n      if (Array.isArray(this.tagName))\n        return domNode.tagName.toLowerCase();\n    }\n  }\n  constructor(scroll, domNode) {\n    super(scroll, domNode), this.attributes = new AttributorStore$1(this.domNode);\n  }\n  format(name, value) {\n    const format = this.scroll.query(name, Scope.BLOCK);\n    format != null && (format instanceof Attributor ? this.attributes.attribute(format, value) : name === this.statics.blotName && !value ? this.replaceWith(_BlockBlot.blotName) : value && (name !== this.statics.blotName || this.formats()[name] !== value) && this.replaceWith(name, value));\n  }\n  formats() {\n    const formats = this.attributes.values(), format = this.statics.formats(this.domNode, this.scroll);\n    return format != null && (formats[this.statics.blotName] = format), formats;\n  }\n  formatAt(index, length, name, value) {\n    this.scroll.query(name, Scope.BLOCK) != null ? this.format(name, value) : super.formatAt(index, length, name, value);\n  }\n  insertAt(index, value, def) {\n    if (def == null || this.scroll.query(value, Scope.INLINE) != null)\n      super.insertAt(index, value, def);\n    else {\n      const after = this.split(index);\n      if (after != null) {\n        const blot = this.scroll.create(value, def);\n        after.parent.insertBefore(blot, after);\n      } else\n        throw new Error("Attempt to insertAt after block boundaries");\n    }\n  }\n  replaceWith(name, value) {\n    const replacement = super.replaceWith(name, value);\n    return this.attributes.copy(replacement), replacement;\n  }\n  update(mutations, context) {\n    super.update(mutations, context), mutations.some(\n      (mutation) => mutation.target === this.domNode && mutation.type === "attributes"\n    ) && this.attributes.build();\n  }\n};\n_BlockBlot.blotName = "block", _BlockBlot.scope = Scope.BLOCK_BLOT, _BlockBlot.tagName = "P", _BlockBlot.allowedChildren = [\n  InlineBlot$1,\n  _BlockBlot,\n  LeafBlot$1\n];\nlet BlockBlot = _BlockBlot;\nconst BlockBlot$1 = BlockBlot, _ContainerBlot = class _ContainerBlot extends ParentBlot$1 {\n  checkMerge() {\n    return this.next !== null && this.next.statics.blotName === this.statics.blotName;\n  }\n  deleteAt(index, length) {\n    super.deleteAt(index, length), this.enforceAllowedChildren();\n  }\n  formatAt(index, length, name, value) {\n    super.formatAt(index, length, name, value), this.enforceAllowedChildren();\n  }\n  insertAt(index, value, def) {\n    super.insertAt(index, value, def), this.enforceAllowedChildren();\n  }\n  optimize(context) {\n    super.optimize(context), this.children.length > 0 && this.next != null && this.checkMerge() && (this.next.moveChildren(this), this.next.remove());\n  }\n};\n_ContainerBlot.blotName = "container", _ContainerBlot.scope = Scope.BLOCK_BLOT;\nlet ContainerBlot = _ContainerBlot;\nconst ContainerBlot$1 = ContainerBlot;\nclass EmbedBlot extends LeafBlot$1 {\n  static formats(_domNode, _scroll) {\n  }\n  format(name, value) {\n    super.formatAt(0, this.length(), name, value);\n  }\n  formatAt(index, length, name, value) {\n    index === 0 && length === this.length() ? this.format(name, value) : super.formatAt(index, length, name, value);\n  }\n  formats() {\n    return this.statics.formats(this.domNode, this.scroll);\n  }\n}\nconst EmbedBlot$1 = EmbedBlot, OBSERVER_CONFIG = {\n  attributes: !0,\n  characterData: !0,\n  characterDataOldValue: !0,\n  childList: !0,\n  subtree: !0\n}, MAX_OPTIMIZE_ITERATIONS = 100, _ScrollBlot = class _ScrollBlot extends ParentBlot$1 {\n  constructor(registry, node) {\n    super(null, node), this.registry = registry, this.scroll = this, this.build(), this.observer = new MutationObserver((mutations) => {\n      this.update(mutations);\n    }), this.observer.observe(this.domNode, OBSERVER_CONFIG), this.attach();\n  }\n  create(input, value) {\n    return this.registry.create(this, input, value);\n  }\n  find(node, bubble = !1) {\n    const blot = this.registry.find(node, bubble);\n    return blot ? blot.scroll === this ? blot : bubble ? this.find(blot.scroll.domNode.parentNode, !0) : null : null;\n  }\n  query(query, scope = Scope.ANY) {\n    return this.registry.query(query, scope);\n  }\n  register(...definitions) {\n    return this.registry.register(...definitions);\n  }\n  build() {\n    this.scroll != null && super.build();\n  }\n  detach() {\n    super.detach(), this.observer.disconnect();\n  }\n  deleteAt(index, length) {\n    this.update(), index === 0 && length === this.length() ? this.children.forEach((child) => {\n      child.remove();\n    }) : super.deleteAt(index, length);\n  }\n  formatAt(index, length, name, value) {\n    this.update(), super.formatAt(index, length, name, value);\n  }\n  insertAt(index, value, def) {\n    this.update(), super.insertAt(index, value, def);\n  }\n  optimize(mutations = [], context = {}) {\n    super.optimize(context);\n    const mutationsMap = context.mutationsMap || /* @__PURE__ */ new WeakMap();\n    let records = Array.from(this.observer.takeRecords());\n    for (; records.length > 0; )\n      mutations.push(records.pop());\n    const mark = (blot, markParent = !0) => {\n      blot == null || blot === this || blot.domNode.parentNode != null && (mutationsMap.has(blot.domNode) || mutationsMap.set(blot.domNode, []), markParent && mark(blot.parent));\n    }, optimize = (blot) => {\n      mutationsMap.has(blot.domNode) && (blot instanceof ParentBlot$1 && blot.children.forEach(optimize), mutationsMap.delete(blot.domNode), blot.optimize(context));\n    };\n    let remaining = mutations;\n    for (let i = 0; remaining.length > 0; i += 1) {\n      if (i >= MAX_OPTIMIZE_ITERATIONS)\n        throw new Error("[Parchment] Maximum optimize iterations reached");\n      for (remaining.forEach((mutation) => {\n        const blot = this.find(mutation.target, !0);\n        blot != null && (blot.domNode === mutation.target && (mutation.type === "childList" ? (mark(this.find(mutation.previousSibling, !1)), Array.from(mutation.addedNodes).forEach((node) => {\n          const child = this.find(node, !1);\n          mark(child, !1), child instanceof ParentBlot$1 && child.children.forEach((grandChild) => {\n            mark(grandChild, !1);\n          });\n        })) : mutation.type === "attributes" && mark(blot.prev)), mark(blot));\n      }), this.children.forEach(optimize), remaining = Array.from(this.observer.takeRecords()), records = remaining.slice(); records.length > 0; )\n        mutations.push(records.pop());\n    }\n  }\n  update(mutations, context = {}) {\n    mutations = mutations || this.observer.takeRecords();\n    const mutationsMap = /* @__PURE__ */ new WeakMap();\n    mutations.map((mutation) => {\n      const blot = this.find(mutation.target, !0);\n      return blot == null ? null : mutationsMap.has(blot.domNode) ? (mutationsMap.get(blot.domNode).push(mutation), null) : (mutationsMap.set(blot.domNode, [mutation]), blot);\n    }).forEach((blot) => {\n      blot != null && blot !== this && mutationsMap.has(blot.domNode) && blot.update(mutationsMap.get(blot.domNode) || [], context);\n    }), context.mutationsMap = mutationsMap, mutationsMap.has(this.domNode) && super.update(mutationsMap.get(this.domNode), context), this.optimize(mutations, context);\n  }\n};\n_ScrollBlot.blotName = "scroll", _ScrollBlot.defaultChild = BlockBlot$1, _ScrollBlot.allowedChildren = [BlockBlot$1, ContainerBlot$1], _ScrollBlot.scope = Scope.BLOCK_BLOT, _ScrollBlot.tagName = "DIV";\nlet ScrollBlot = _ScrollBlot;\nconst ScrollBlot$1 = ScrollBlot, _TextBlot = class _TextBlot extends LeafBlot$1 {\n  static create(value) {\n    return document.createTextNode(value);\n  }\n  static value(domNode) {\n    return domNode.data;\n  }\n  constructor(scroll, node) {\n    super(scroll, node), this.text = this.statics.value(this.domNode);\n  }\n  deleteAt(index, length) {\n    this.domNode.data = this.text = this.text.slice(0, index) + this.text.slice(index + length);\n  }\n  index(node, offset) {\n    return this.domNode === node ? offset : -1;\n  }\n  insertAt(index, value, def) {\n    def == null ? (this.text = this.text.slice(0, index) + value + this.text.slice(index), this.domNode.data = this.text) : super.insertAt(index, value, def);\n  }\n  length() {\n    return this.text.length;\n  }\n  optimize(context) {\n    super.optimize(context), this.text = this.statics.value(this.domNode), this.text.length === 0 ? this.remove() : this.next instanceof _TextBlot && this.next.prev === this && (this.insertAt(this.length(), this.next.value()), this.next.remove());\n  }\n  position(index, _inclusive = !1) {\n    return [this.domNode, index];\n  }\n  split(index, force = !1) {\n    if (!force) {\n      if (index === 0)\n        return this;\n      if (index === this.length())\n        return this.next;\n    }\n    const after = this.scroll.create(this.domNode.splitText(index));\n    return this.parent.insertBefore(after, this.next || void 0), this.text = this.statics.value(this.domNode), after;\n  }\n  update(mutations, _context) {\n    mutations.some((mutation) => mutation.type === "characterData" && mutation.target === this.domNode) && (this.text = this.statics.value(this.domNode));\n  }\n  value() {\n    return this.text;\n  }\n};\n_TextBlot.blotName = "text", _TextBlot.scope = Scope.INLINE_BLOT;\nlet TextBlot = _TextBlot;\nconst TextBlot$1 = TextBlot;\n\n//# sourceMappingURL=parchment.js.map\n\n\n//# sourceURL=webpack://Vuexy/./node_modules/parchment/dist/parchment.js?')},"./node_modules/quill/blots/block.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BlockEmbed: function() { return /* binding */ BlockEmbed; },\n/* harmony export */   blockDelta: function() { return /* binding */ blockDelta; },\n/* harmony export */   bubbleFormats: function() { return /* binding */ bubbleFormats; },\n/* harmony export */   "default": function() { return /* binding */ Block; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! parchment */ "./node_modules/parchment/dist/parchment.js");\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill-delta */ "./node_modules/quill-delta/dist/Delta.js");\n/* harmony import */ var _break_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./break.js */ "./node_modules/quill/blots/break.js");\n/* harmony import */ var _inline_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./inline.js */ "./node_modules/quill/blots/inline.js");\n/* harmony import */ var _text_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./text.js */ "./node_modules/quill/blots/text.js");\n\n\n\n\n\nconst NEWLINE_LENGTH = 1;\nclass Block extends parchment__WEBPACK_IMPORTED_MODULE_4__.BlockBlot {\n  cache = {};\n  delta() {\n    if (this.cache.delta == null) {\n      this.cache.delta = blockDelta(this);\n    }\n    return this.cache.delta;\n  }\n  deleteAt(index, length) {\n    super.deleteAt(index, length);\n    this.cache = {};\n  }\n  formatAt(index, length, name, value) {\n    if (length <= 0) return;\n    if (this.scroll.query(name, parchment__WEBPACK_IMPORTED_MODULE_4__.Scope.BLOCK)) {\n      if (index + length === this.length()) {\n        this.format(name, value);\n      }\n    } else {\n      super.formatAt(index, Math.min(length, this.length() - index - 1), name, value);\n    }\n    this.cache = {};\n  }\n  insertAt(index, value, def) {\n    if (def != null) {\n      super.insertAt(index, value, def);\n      this.cache = {};\n      return;\n    }\n    if (value.length === 0) return;\n    const lines = value.split(\'\\n\');\n    const text = lines.shift();\n    if (text.length > 0) {\n      if (index < this.length() - 1 || this.children.tail == null) {\n        super.insertAt(Math.min(index, this.length() - 1), text);\n      } else {\n        this.children.tail.insertAt(this.children.tail.length(), text);\n      }\n      this.cache = {};\n    }\n    // TODO: Fix this next time the file is edited.\n    // eslint-disable-next-line @typescript-eslint/no-this-alias\n    let block = this;\n    lines.reduce((lineIndex, line) => {\n      // @ts-expect-error Fix me later\n      block = block.split(lineIndex, true);\n      block.insertAt(0, line);\n      return line.length;\n    }, index + text.length);\n  }\n  insertBefore(blot, ref) {\n    const {\n      head\n    } = this.children;\n    super.insertBefore(blot, ref);\n    if (head instanceof _break_js__WEBPACK_IMPORTED_MODULE_1__["default"]) {\n      head.remove();\n    }\n    this.cache = {};\n  }\n  length() {\n    if (this.cache.length == null) {\n      this.cache.length = super.length() + NEWLINE_LENGTH;\n    }\n    return this.cache.length;\n  }\n  moveChildren(target, ref) {\n    super.moveChildren(target, ref);\n    this.cache = {};\n  }\n  optimize(context) {\n    super.optimize(context);\n    this.cache = {};\n  }\n  path(index) {\n    return super.path(index, true);\n  }\n  removeChild(child) {\n    super.removeChild(child);\n    this.cache = {};\n  }\n  split(index) {\n    let force = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n    if (force && (index === 0 || index >= this.length() - NEWLINE_LENGTH)) {\n      const clone = this.clone();\n      if (index === 0) {\n        this.parent.insertBefore(clone, this);\n        return this;\n      }\n      this.parent.insertBefore(clone, this.next);\n      return clone;\n    }\n    const next = super.split(index, force);\n    this.cache = {};\n    return next;\n  }\n}\nBlock.blotName = \'block\';\nBlock.tagName = \'P\';\nBlock.defaultChild = _break_js__WEBPACK_IMPORTED_MODULE_1__["default"];\nBlock.allowedChildren = [_break_js__WEBPACK_IMPORTED_MODULE_1__["default"], _inline_js__WEBPACK_IMPORTED_MODULE_2__["default"], parchment__WEBPACK_IMPORTED_MODULE_4__.EmbedBlot, _text_js__WEBPACK_IMPORTED_MODULE_3__["default"]];\nclass BlockEmbed extends parchment__WEBPACK_IMPORTED_MODULE_4__.EmbedBlot {\n  attach() {\n    super.attach();\n    this.attributes = new parchment__WEBPACK_IMPORTED_MODULE_4__.AttributorStore(this.domNode);\n  }\n  delta() {\n    return new quill_delta__WEBPACK_IMPORTED_MODULE_0__().insert(this.value(), {\n      ...this.formats(),\n      ...this.attributes.values()\n    });\n  }\n  format(name, value) {\n    const attribute = this.scroll.query(name, parchment__WEBPACK_IMPORTED_MODULE_4__.Scope.BLOCK_ATTRIBUTE);\n    if (attribute != null) {\n      // @ts-expect-error TODO: Scroll#query() should return Attributor when scope is attribute\n      this.attributes.attribute(attribute, value);\n    }\n  }\n  formatAt(index, length, name, value) {\n    this.format(name, value);\n  }\n  insertAt(index, value, def) {\n    if (def != null) {\n      super.insertAt(index, value, def);\n      return;\n    }\n    const lines = value.split(\'\\n\');\n    const text = lines.pop();\n    const blocks = lines.map(line => {\n      const block = this.scroll.create(Block.blotName);\n      block.insertAt(0, line);\n      return block;\n    });\n    const ref = this.split(index);\n    blocks.forEach(block => {\n      this.parent.insertBefore(block, ref);\n    });\n    if (text) {\n      this.parent.insertBefore(this.scroll.create(\'text\', text), ref);\n    }\n  }\n}\nBlockEmbed.scope = parchment__WEBPACK_IMPORTED_MODULE_4__.Scope.BLOCK_BLOT;\n// It is important for cursor behavior BlockEmbeds use tags that are block level elements\n\nfunction blockDelta(blot) {\n  let filter = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;\n  return blot.descendants(parchment__WEBPACK_IMPORTED_MODULE_4__.LeafBlot).reduce((delta, leaf) => {\n    if (leaf.length() === 0) {\n      return delta;\n    }\n    return delta.insert(leaf.value(), bubbleFormats(leaf, {}, filter));\n  }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__()).insert(\'\\n\', bubbleFormats(blot));\n}\nfunction bubbleFormats(blot) {\n  let formats = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n  let filter = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;\n  if (blot == null) return formats;\n  if (\'formats\' in blot && typeof blot.formats === \'function\') {\n    formats = {\n      ...formats,\n      ...blot.formats()\n    };\n    if (filter) {\n      // exclude syntax highlighting from deltas and getFormat()\n      delete formats[\'code-token\'];\n    }\n  }\n  if (blot.parent == null || blot.parent.statics.blotName === \'scroll\' || blot.parent.statics.scope !== blot.statics.scope) {\n    return formats;\n  }\n  return bubbleFormats(blot.parent, formats, filter);\n}\n\n//# sourceMappingURL=block.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/blots/block.js?')},"./node_modules/quill/blots/break.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n\nclass Break extends parchment__WEBPACK_IMPORTED_MODULE_0__.EmbedBlot {\n  static value() {\n    return undefined;\n  }\n  optimize() {\n    if (this.prev || this.next) {\n      this.remove();\n    }\n  }\n  length() {\n    return 0;\n  }\n  value() {\n    return '';\n  }\n}\nBreak.blotName = 'break';\nBreak.tagName = 'BR';\n/* harmony default export */ __webpack_exports__[\"default\"] = (Break);\n//# sourceMappingURL=break.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/blots/break.js?")},"./node_modules/quill/blots/container.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! parchment */ "./node_modules/parchment/dist/parchment.js");\n\nclass Container extends parchment__WEBPACK_IMPORTED_MODULE_0__.ContainerBlot {}\n/* harmony default export */ __webpack_exports__["default"] = (Container);\n//# sourceMappingURL=container.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/blots/container.js?')},"./node_modules/quill/blots/cursor.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! parchment */ "./node_modules/parchment/dist/parchment.js");\n/* harmony import */ var _text_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./text.js */ "./node_modules/quill/blots/text.js");\n\n\nclass Cursor extends parchment__WEBPACK_IMPORTED_MODULE_1__.EmbedBlot {\n  static blotName = \'cursor\';\n  static className = \'ql-cursor\';\n  static tagName = \'span\';\n  static CONTENTS = \'\\uFEFF\'; // Zero width no break space\n\n  static value() {\n    return undefined;\n  }\n  constructor(scroll, domNode, selection) {\n    super(scroll, domNode);\n    this.selection = selection;\n    this.textNode = document.createTextNode(Cursor.CONTENTS);\n    this.domNode.appendChild(this.textNode);\n    this.savedLength = 0;\n  }\n  detach() {\n    // super.detach() will also clear domNode.__blot\n    if (this.parent != null) this.parent.removeChild(this);\n  }\n  format(name, value) {\n    if (this.savedLength !== 0) {\n      super.format(name, value);\n      return;\n    }\n    // TODO: Fix this next time the file is edited.\n    // eslint-disable-next-line @typescript-eslint/no-this-alias\n    let target = this;\n    let index = 0;\n    while (target != null && target.statics.scope !== parchment__WEBPACK_IMPORTED_MODULE_1__.Scope.BLOCK_BLOT) {\n      index += target.offset(target.parent);\n      target = target.parent;\n    }\n    if (target != null) {\n      this.savedLength = Cursor.CONTENTS.length;\n      // @ts-expect-error TODO: allow empty context in Parchment\n      target.optimize();\n      target.formatAt(index, Cursor.CONTENTS.length, name, value);\n      this.savedLength = 0;\n    }\n  }\n  index(node, offset) {\n    if (node === this.textNode) return 0;\n    return super.index(node, offset);\n  }\n  length() {\n    return this.savedLength;\n  }\n  position() {\n    return [this.textNode, this.textNode.data.length];\n  }\n  remove() {\n    super.remove();\n    // @ts-expect-error Fix me later\n    this.parent = null;\n  }\n  restore() {\n    if (this.selection.composing || this.parent == null) return null;\n    const range = this.selection.getNativeRange();\n    // Browser may push down styles/nodes inside the cursor blot.\n    // https://dvcs.w3.org/hg/editing/raw-file/tip/editing.html#push-down-values\n    while (this.domNode.lastChild != null && this.domNode.lastChild !== this.textNode) {\n      // @ts-expect-error Fix me later\n      this.domNode.parentNode.insertBefore(this.domNode.lastChild, this.domNode);\n    }\n    const prevTextBlot = this.prev instanceof _text_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? this.prev : null;\n    const prevTextLength = prevTextBlot ? prevTextBlot.length() : 0;\n    const nextTextBlot = this.next instanceof _text_js__WEBPACK_IMPORTED_MODULE_0__["default"] ? this.next : null;\n    // @ts-expect-error TODO: make TextBlot.text public\n    const nextText = nextTextBlot ? nextTextBlot.text : \'\';\n    const {\n      textNode\n    } = this;\n    // take text from inside this blot and reset it\n    const newText = textNode.data.split(Cursor.CONTENTS).join(\'\');\n    textNode.data = Cursor.CONTENTS;\n\n    // proactively merge TextBlots around cursor so that optimization\n    // doesn\'t lose the cursor.  the reason we are here in cursor.restore\n    // could be that the user clicked in prevTextBlot or nextTextBlot, or\n    // the user typed something.\n    let mergedTextBlot;\n    if (prevTextBlot) {\n      mergedTextBlot = prevTextBlot;\n      if (newText || nextTextBlot) {\n        prevTextBlot.insertAt(prevTextBlot.length(), newText + nextText);\n        if (nextTextBlot) {\n          nextTextBlot.remove();\n        }\n      }\n    } else if (nextTextBlot) {\n      mergedTextBlot = nextTextBlot;\n      nextTextBlot.insertAt(0, newText);\n    } else {\n      const newTextNode = document.createTextNode(newText);\n      mergedTextBlot = this.scroll.create(newTextNode);\n      this.parent.insertBefore(mergedTextBlot, this);\n    }\n    this.remove();\n    if (range) {\n      // calculate selection to restore\n      const remapOffset = (node, offset) => {\n        if (prevTextBlot && node === prevTextBlot.domNode) {\n          return offset;\n        }\n        if (node === textNode) {\n          return prevTextLength + offset - 1;\n        }\n        if (nextTextBlot && node === nextTextBlot.domNode) {\n          return prevTextLength + newText.length + offset;\n        }\n        return null;\n      };\n      const start = remapOffset(range.start.node, range.start.offset);\n      const end = remapOffset(range.end.node, range.end.offset);\n      if (start !== null && end !== null) {\n        return {\n          startNode: mergedTextBlot.domNode,\n          startOffset: start,\n          endNode: mergedTextBlot.domNode,\n          endOffset: end\n        };\n      }\n    }\n    return null;\n  }\n  update(mutations, context) {\n    if (mutations.some(mutation => {\n      return mutation.type === \'characterData\' && mutation.target === this.textNode;\n    })) {\n      const range = this.restore();\n      if (range) context.range = range;\n    }\n  }\n\n  // Avoid .ql-cursor being a descendant of `<a/>`.\n  // The reason is Safari pushes down `<a/>` on text insertion.\n  // That will cause DOM nodes not sync with the model.\n  //\n  // For example ({I} is the caret), given the markup:\n  //    <a><span class="ql-cursor">\\uFEFF{I}</span></a>\n  // When typing a char "x", `<a/>` will be pushed down inside the `<span>` first:\n  //    <span class="ql-cursor"><a>\\uFEFF{I}</a></span>\n  // And then "x" will be inserted after `<a/>`:\n  //    <span class="ql-cursor"><a>\\uFEFF</a>d{I}</span>\n  optimize(context) {\n    // @ts-expect-error Fix me later\n    super.optimize(context);\n    let {\n      parent\n    } = this;\n    while (parent) {\n      if (parent.domNode.tagName === \'A\') {\n        this.savedLength = Cursor.CONTENTS.length;\n        // @ts-expect-error TODO: make isolate generic\n        parent.isolate(this.offset(parent), this.length()).unwrap();\n        this.savedLength = 0;\n        break;\n      }\n      parent = parent.parent;\n    }\n  }\n  value() {\n    return \'\';\n  }\n}\n/* harmony default export */ __webpack_exports__["default"] = (Cursor);\n//# sourceMappingURL=cursor.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/blots/cursor.js?')},"./node_modules/quill/blots/embed.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var _text_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./text.js */ \"./node_modules/quill/blots/text.js\");\n\n\nconst GUARD_TEXT = '\\uFEFF';\nclass Embed extends parchment__WEBPACK_IMPORTED_MODULE_1__.EmbedBlot {\n  constructor(scroll, node) {\n    super(scroll, node);\n    this.contentNode = document.createElement('span');\n    this.contentNode.setAttribute('contenteditable', 'false');\n    Array.from(this.domNode.childNodes).forEach(childNode => {\n      this.contentNode.appendChild(childNode);\n    });\n    this.leftGuard = document.createTextNode(GUARD_TEXT);\n    this.rightGuard = document.createTextNode(GUARD_TEXT);\n    this.domNode.appendChild(this.leftGuard);\n    this.domNode.appendChild(this.contentNode);\n    this.domNode.appendChild(this.rightGuard);\n  }\n  index(node, offset) {\n    if (node === this.leftGuard) return 0;\n    if (node === this.rightGuard) return 1;\n    return super.index(node, offset);\n  }\n  restore(node) {\n    let range = null;\n    let textNode;\n    const text = node.data.split(GUARD_TEXT).join('');\n    if (node === this.leftGuard) {\n      if (this.prev instanceof _text_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]) {\n        const prevLength = this.prev.length();\n        this.prev.insertAt(prevLength, text);\n        range = {\n          startNode: this.prev.domNode,\n          startOffset: prevLength + text.length\n        };\n      } else {\n        textNode = document.createTextNode(text);\n        this.parent.insertBefore(this.scroll.create(textNode), this);\n        range = {\n          startNode: textNode,\n          startOffset: text.length\n        };\n      }\n    } else if (node === this.rightGuard) {\n      if (this.next instanceof _text_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"]) {\n        this.next.insertAt(0, text);\n        range = {\n          startNode: this.next.domNode,\n          startOffset: text.length\n        };\n      } else {\n        textNode = document.createTextNode(text);\n        this.parent.insertBefore(this.scroll.create(textNode), this.next);\n        range = {\n          startNode: textNode,\n          startOffset: text.length\n        };\n      }\n    }\n    node.data = GUARD_TEXT;\n    return range;\n  }\n  update(mutations, context) {\n    mutations.forEach(mutation => {\n      if (mutation.type === 'characterData' && (mutation.target === this.leftGuard || mutation.target === this.rightGuard)) {\n        const range = this.restore(mutation.target);\n        if (range) context.range = range;\n      }\n    });\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Embed);\n//# sourceMappingURL=embed.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/blots/embed.js?")},"./node_modules/quill/blots/inline.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var _break_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./break.js */ \"./node_modules/quill/blots/break.js\");\n/* harmony import */ var _text_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./text.js */ \"./node_modules/quill/blots/text.js\");\n\n\n\nclass Inline extends parchment__WEBPACK_IMPORTED_MODULE_2__.InlineBlot {\n  static allowedChildren = [Inline, _break_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"], parchment__WEBPACK_IMPORTED_MODULE_2__.EmbedBlot, _text_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]];\n  // Lower index means deeper in the DOM tree, since not found (-1) is for embeds\n  static order = ['cursor', 'inline',\n  // Must be lower\n  'link',\n  // Chrome wants <a> to be lower\n  'underline', 'strike', 'italic', 'bold', 'script', 'code' // Must be higher\n  ];\n  static compare(self, other) {\n    const selfIndex = Inline.order.indexOf(self);\n    const otherIndex = Inline.order.indexOf(other);\n    if (selfIndex >= 0 || otherIndex >= 0) {\n      return selfIndex - otherIndex;\n    }\n    if (self === other) {\n      return 0;\n    }\n    if (self < other) {\n      return -1;\n    }\n    return 1;\n  }\n  formatAt(index, length, name, value) {\n    if (Inline.compare(this.statics.blotName, name) < 0 && this.scroll.query(name, parchment__WEBPACK_IMPORTED_MODULE_2__.Scope.BLOT)) {\n      const blot = this.isolate(index, length);\n      if (value) {\n        blot.wrap(name, value);\n      }\n    } else {\n      super.formatAt(index, length, name, value);\n    }\n  }\n  optimize(context) {\n    super.optimize(context);\n    if (this.parent instanceof Inline && Inline.compare(this.statics.blotName, this.parent.statics.blotName) > 0) {\n      const parent = this.parent.isolate(this.offset(), this.length());\n      // @ts-expect-error TODO: make isolate generic\n      this.moveChildren(parent);\n      parent.wrap(this);\n    }\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Inline);\n//# sourceMappingURL=inline.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/blots/inline.js?")},"./node_modules/quill/blots/scroll.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill-delta */ \"./node_modules/quill-delta/dist/Delta.js\");\n/* harmony import */ var _core_emitter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/emitter.js */ \"./node_modules/quill/core/emitter.js\");\n/* harmony import */ var _block_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./block.js */ \"./node_modules/quill/blots/block.js\");\n/* harmony import */ var _break_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./break.js */ \"./node_modules/quill/blots/break.js\");\n/* harmony import */ var _container_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./container.js */ \"./node_modules/quill/blots/container.js\");\n\n\n\n\n\n\nfunction isLine(blot) {\n  return blot instanceof _block_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"] || blot instanceof _block_js__WEBPACK_IMPORTED_MODULE_2__.BlockEmbed;\n}\nfunction isUpdatable(blot) {\n  return typeof blot.updateContent === 'function';\n}\nclass Scroll extends parchment__WEBPACK_IMPORTED_MODULE_5__.ScrollBlot {\n  static blotName = 'scroll';\n  static className = 'ql-editor';\n  static tagName = 'DIV';\n  static defaultChild = _block_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"];\n  static allowedChildren = [_block_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], _block_js__WEBPACK_IMPORTED_MODULE_2__.BlockEmbed, _container_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]];\n  constructor(registry, domNode, _ref) {\n    let {\n      emitter\n    } = _ref;\n    super(registry, domNode);\n    this.emitter = emitter;\n    this.batch = false;\n    this.optimize();\n    this.enable();\n    this.domNode.addEventListener('dragstart', e => this.handleDragStart(e));\n  }\n  batchStart() {\n    if (!Array.isArray(this.batch)) {\n      this.batch = [];\n    }\n  }\n  batchEnd() {\n    if (!this.batch) return;\n    const mutations = this.batch;\n    this.batch = false;\n    this.update(mutations);\n  }\n  emitMount(blot) {\n    this.emitter.emit(_core_emitter_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].events.SCROLL_BLOT_MOUNT, blot);\n  }\n  emitUnmount(blot) {\n    this.emitter.emit(_core_emitter_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].events.SCROLL_BLOT_UNMOUNT, blot);\n  }\n  emitEmbedUpdate(blot, change) {\n    this.emitter.emit(_core_emitter_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].events.SCROLL_EMBED_UPDATE, blot, change);\n  }\n  deleteAt(index, length) {\n    const [first, offset] = this.line(index);\n    const [last] = this.line(index + length);\n    super.deleteAt(index, length);\n    if (last != null && first !== last && offset > 0) {\n      if (first instanceof _block_js__WEBPACK_IMPORTED_MODULE_2__.BlockEmbed || last instanceof _block_js__WEBPACK_IMPORTED_MODULE_2__.BlockEmbed) {\n        this.optimize();\n        return;\n      }\n      const ref = last.children.head instanceof _break_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"] ? null : last.children.head;\n      // @ts-expect-error\n      first.moveChildren(last, ref);\n      // @ts-expect-error\n      first.remove();\n    }\n    this.optimize();\n  }\n  enable() {\n    let enabled = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;\n    this.domNode.setAttribute('contenteditable', enabled ? 'true' : 'false');\n  }\n  formatAt(index, length, format, value) {\n    super.formatAt(index, length, format, value);\n    this.optimize();\n  }\n  insertAt(index, value, def) {\n    if (index >= this.length()) {\n      if (def == null || this.scroll.query(value, parchment__WEBPACK_IMPORTED_MODULE_5__.Scope.BLOCK) == null) {\n        const blot = this.scroll.create(this.statics.defaultChild.blotName);\n        this.appendChild(blot);\n        if (def == null && value.endsWith('\\n')) {\n          blot.insertAt(0, value.slice(0, -1), def);\n        } else {\n          blot.insertAt(0, value, def);\n        }\n      } else {\n        const embed = this.scroll.create(value, def);\n        this.appendChild(embed);\n      }\n    } else {\n      super.insertAt(index, value, def);\n    }\n    this.optimize();\n  }\n  insertBefore(blot, ref) {\n    if (blot.statics.scope === parchment__WEBPACK_IMPORTED_MODULE_5__.Scope.INLINE_BLOT) {\n      const wrapper = this.scroll.create(this.statics.defaultChild.blotName);\n      wrapper.appendChild(blot);\n      super.insertBefore(wrapper, ref);\n    } else {\n      super.insertBefore(blot, ref);\n    }\n  }\n  insertContents(index, delta) {\n    const renderBlocks = this.deltaToRenderBlocks(delta.concat(new quill_delta__WEBPACK_IMPORTED_MODULE_0__().insert('\\n')));\n    const last = renderBlocks.pop();\n    if (last == null) return;\n    this.batchStart();\n    const first = renderBlocks.shift();\n    if (first) {\n      const shouldInsertNewlineChar = first.type === 'block' && (first.delta.length() === 0 || !this.descendant(_block_js__WEBPACK_IMPORTED_MODULE_2__.BlockEmbed, index)[0] && index < this.length());\n      const delta = first.type === 'block' ? first.delta : new quill_delta__WEBPACK_IMPORTED_MODULE_0__().insert({\n        [first.key]: first.value\n      });\n      insertInlineContents(this, index, delta);\n      const newlineCharLength = first.type === 'block' ? 1 : 0;\n      const lineEndIndex = index + delta.length() + newlineCharLength;\n      if (shouldInsertNewlineChar) {\n        this.insertAt(lineEndIndex - 1, '\\n');\n      }\n      const formats = (0,_block_js__WEBPACK_IMPORTED_MODULE_2__.bubbleFormats)(this.line(index)[0]);\n      const attributes = quill_delta__WEBPACK_IMPORTED_MODULE_0__.AttributeMap.diff(formats, first.attributes) || {};\n      Object.keys(attributes).forEach(name => {\n        this.formatAt(lineEndIndex - 1, 1, name, attributes[name]);\n      });\n      index = lineEndIndex;\n    }\n    let [refBlot, refBlotOffset] = this.children.find(index);\n    if (renderBlocks.length) {\n      if (refBlot) {\n        refBlot = refBlot.split(refBlotOffset);\n        refBlotOffset = 0;\n      }\n      renderBlocks.forEach(renderBlock => {\n        if (renderBlock.type === 'block') {\n          const block = this.createBlock(renderBlock.attributes, refBlot || undefined);\n          insertInlineContents(block, 0, renderBlock.delta);\n        } else {\n          const blockEmbed = this.create(renderBlock.key, renderBlock.value);\n          this.insertBefore(blockEmbed, refBlot || undefined);\n          Object.keys(renderBlock.attributes).forEach(name => {\n            blockEmbed.format(name, renderBlock.attributes[name]);\n          });\n        }\n      });\n    }\n    if (last.type === 'block' && last.delta.length()) {\n      const offset = refBlot ? refBlot.offset(refBlot.scroll) + refBlotOffset : this.length();\n      insertInlineContents(this, offset, last.delta);\n    }\n    this.batchEnd();\n    this.optimize();\n  }\n  isEnabled() {\n    return this.domNode.getAttribute('contenteditable') === 'true';\n  }\n  leaf(index) {\n    const last = this.path(index).pop();\n    if (!last) {\n      return [null, -1];\n    }\n    const [blot, offset] = last;\n    return blot instanceof parchment__WEBPACK_IMPORTED_MODULE_5__.LeafBlot ? [blot, offset] : [null, -1];\n  }\n  line(index) {\n    if (index === this.length()) {\n      return this.line(index - 1);\n    }\n    // @ts-expect-error TODO: make descendant() generic\n    return this.descendant(isLine, index);\n  }\n  lines() {\n    let index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;\n    let length = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Number.MAX_VALUE;\n    const getLines = (blot, blotIndex, blotLength) => {\n      let lines = [];\n      let lengthLeft = blotLength;\n      blot.children.forEachAt(blotIndex, blotLength, (child, childIndex, childLength) => {\n        if (isLine(child)) {\n          lines.push(child);\n        } else if (child instanceof parchment__WEBPACK_IMPORTED_MODULE_5__.ContainerBlot) {\n          lines = lines.concat(getLines(child, childIndex, lengthLeft));\n        }\n        lengthLeft -= childLength;\n      });\n      return lines;\n    };\n    return getLines(this, index, length);\n  }\n  optimize() {\n    let mutations = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];\n    let context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n    if (this.batch) return;\n    super.optimize(mutations, context);\n    if (mutations.length > 0) {\n      this.emitter.emit(_core_emitter_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].events.SCROLL_OPTIMIZE, mutations, context);\n    }\n  }\n  path(index) {\n    return super.path(index).slice(1); // Exclude self\n  }\n  remove() {\n    // Never remove self\n  }\n  update(mutations) {\n    if (this.batch) {\n      if (Array.isArray(mutations)) {\n        this.batch = this.batch.concat(mutations);\n      }\n      return;\n    }\n    let source = _core_emitter_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER;\n    if (typeof mutations === 'string') {\n      source = mutations;\n    }\n    if (!Array.isArray(mutations)) {\n      mutations = this.observer.takeRecords();\n    }\n    mutations = mutations.filter(_ref2 => {\n      let {\n        target\n      } = _ref2;\n      const blot = this.find(target, true);\n      return blot && !isUpdatable(blot);\n    });\n    if (mutations.length > 0) {\n      this.emitter.emit(_core_emitter_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].events.SCROLL_BEFORE_UPDATE, source, mutations);\n    }\n    super.update(mutations.concat([])); // pass copy\n    if (mutations.length > 0) {\n      this.emitter.emit(_core_emitter_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].events.SCROLL_UPDATE, source, mutations);\n    }\n  }\n  updateEmbedAt(index, key, change) {\n    // Currently it only supports top-level embeds (BlockEmbed).\n    // We can update `ParentBlot` in parchment to support inline embeds.\n    const [blot] = this.descendant(b => b instanceof _block_js__WEBPACK_IMPORTED_MODULE_2__.BlockEmbed, index);\n    if (blot && blot.statics.blotName === key && isUpdatable(blot)) {\n      blot.updateContent(change);\n    }\n  }\n  handleDragStart(event) {\n    event.preventDefault();\n  }\n  deltaToRenderBlocks(delta) {\n    const renderBlocks = [];\n    let currentBlockDelta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__();\n    delta.forEach(op => {\n      const insert = op?.insert;\n      if (!insert) return;\n      if (typeof insert === 'string') {\n        const splitted = insert.split('\\n');\n        splitted.slice(0, -1).forEach(text => {\n          currentBlockDelta.insert(text, op.attributes);\n          renderBlocks.push({\n            type: 'block',\n            delta: currentBlockDelta,\n            attributes: op.attributes ?? {}\n          });\n          currentBlockDelta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__();\n        });\n        const last = splitted[splitted.length - 1];\n        if (last) {\n          currentBlockDelta.insert(last, op.attributes);\n        }\n      } else {\n        const key = Object.keys(insert)[0];\n        if (!key) return;\n        if (this.query(key, parchment__WEBPACK_IMPORTED_MODULE_5__.Scope.INLINE)) {\n          currentBlockDelta.push(op);\n        } else {\n          if (currentBlockDelta.length()) {\n            renderBlocks.push({\n              type: 'block',\n              delta: currentBlockDelta,\n              attributes: {}\n            });\n          }\n          currentBlockDelta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__();\n          renderBlocks.push({\n            type: 'blockEmbed',\n            key,\n            value: insert[key],\n            attributes: op.attributes ?? {}\n          });\n        }\n      }\n    });\n    if (currentBlockDelta.length()) {\n      renderBlocks.push({\n        type: 'block',\n        delta: currentBlockDelta,\n        attributes: {}\n      });\n    }\n    return renderBlocks;\n  }\n  createBlock(attributes, refBlot) {\n    let blotName;\n    const formats = {};\n    Object.entries(attributes).forEach(_ref3 => {\n      let [key, value] = _ref3;\n      const isBlockBlot = this.query(key, parchment__WEBPACK_IMPORTED_MODULE_5__.Scope.BLOCK & parchment__WEBPACK_IMPORTED_MODULE_5__.Scope.BLOT) != null;\n      if (isBlockBlot) {\n        blotName = key;\n      } else {\n        formats[key] = value;\n      }\n    });\n    const block = this.create(blotName || this.statics.defaultChild.blotName, blotName ? attributes[blotName] : undefined);\n    this.insertBefore(block, refBlot || undefined);\n    const length = block.length();\n    Object.entries(formats).forEach(_ref4 => {\n      let [key, value] = _ref4;\n      block.formatAt(0, length, key, value);\n    });\n    return block;\n  }\n}\nfunction insertInlineContents(parent, index, inlineContents) {\n  inlineContents.reduce((index, op) => {\n    const length = quill_delta__WEBPACK_IMPORTED_MODULE_0__.Op.length(op);\n    let attributes = op.attributes || {};\n    if (op.insert != null) {\n      if (typeof op.insert === 'string') {\n        const text = op.insert;\n        parent.insertAt(index, text);\n        const [leaf] = parent.descendant(parchment__WEBPACK_IMPORTED_MODULE_5__.LeafBlot, index);\n        const formats = (0,_block_js__WEBPACK_IMPORTED_MODULE_2__.bubbleFormats)(leaf);\n        attributes = quill_delta__WEBPACK_IMPORTED_MODULE_0__.AttributeMap.diff(formats, attributes) || {};\n      } else if (typeof op.insert === 'object') {\n        const key = Object.keys(op.insert)[0]; // There should only be one key\n        if (key == null) return index;\n        parent.insertAt(index, key, op.insert[key]);\n        const isInlineEmbed = parent.scroll.query(key, parchment__WEBPACK_IMPORTED_MODULE_5__.Scope.INLINE) != null;\n        if (isInlineEmbed) {\n          const [leaf] = parent.descendant(parchment__WEBPACK_IMPORTED_MODULE_5__.LeafBlot, index);\n          const formats = (0,_block_js__WEBPACK_IMPORTED_MODULE_2__.bubbleFormats)(leaf);\n          attributes = quill_delta__WEBPACK_IMPORTED_MODULE_0__.AttributeMap.diff(formats, attributes) || {};\n        }\n      }\n    }\n    Object.keys(attributes).forEach(key => {\n      parent.formatAt(index, length, key, attributes[key]);\n    });\n    return index + length;\n  }, index);\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Scroll);\n//# sourceMappingURL=scroll.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/blots/scroll.js?")},"./node_modules/quill/blots/text.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": function() { return /* binding */ Text; },\n/* harmony export */   escapeText: function() { return /* binding */ escapeText; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n\nclass Text extends parchment__WEBPACK_IMPORTED_MODULE_0__.TextBlot {}\n\n// https://lodash.com/docs#escape\nconst entityMap = {\n  '&': '&amp;',\n  '<': '&lt;',\n  '>': '&gt;',\n  '\"': '&quot;',\n  \"'\": '&#39;'\n};\nfunction escapeText(text) {\n  return text.replace(/[&<>\"']/g, s => entityMap[s]);\n}\n\n//# sourceMappingURL=text.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/blots/text.js?")},"./node_modules/quill/core.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AttributeMap: function() { return /* reexport safe */ quill_delta__WEBPACK_IMPORTED_MODULE_13__.AttributeMap; },\n/* harmony export */   Delta: function() { return /* reexport default export from named module */ quill_delta__WEBPACK_IMPORTED_MODULE_13__; },\n/* harmony export */   Module: function() { return /* reexport safe */ _core_module_js__WEBPACK_IMPORTED_MODULE_16__["default"]; },\n/* harmony export */   Op: function() { return /* reexport safe */ quill_delta__WEBPACK_IMPORTED_MODULE_13__.Op; },\n/* harmony export */   OpIterator: function() { return /* reexport safe */ quill_delta__WEBPACK_IMPORTED_MODULE_13__.OpIterator; },\n/* harmony export */   Parchment: function() { return /* reexport safe */ _core_quill_js__WEBPACK_IMPORTED_MODULE_0__.Parchment; },\n/* harmony export */   Range: function() { return /* reexport safe */ _core_quill_js__WEBPACK_IMPORTED_MODULE_0__.Range; }\n/* harmony export */ });\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core/quill.js */ "./node_modules/quill/core/quill.js");\n/* harmony import */ var _blots_block_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./blots/block.js */ "./node_modules/quill/blots/block.js");\n/* harmony import */ var _blots_break_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./blots/break.js */ "./node_modules/quill/blots/break.js");\n/* harmony import */ var _blots_container_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./blots/container.js */ "./node_modules/quill/blots/container.js");\n/* harmony import */ var _blots_cursor_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./blots/cursor.js */ "./node_modules/quill/blots/cursor.js");\n/* harmony import */ var _blots_embed_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./blots/embed.js */ "./node_modules/quill/blots/embed.js");\n/* harmony import */ var _blots_inline_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./blots/inline.js */ "./node_modules/quill/blots/inline.js");\n/* harmony import */ var _blots_scroll_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./blots/scroll.js */ "./node_modules/quill/blots/scroll.js");\n/* harmony import */ var _blots_text_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./blots/text.js */ "./node_modules/quill/blots/text.js");\n/* harmony import */ var _modules_clipboard_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./modules/clipboard.js */ "./node_modules/quill/modules/clipboard.js");\n/* harmony import */ var _modules_history_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./modules/history.js */ "./node_modules/quill/modules/history.js");\n/* harmony import */ var _modules_keyboard_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./modules/keyboard.js */ "./node_modules/quill/modules/keyboard.js");\n/* harmony import */ var _modules_uploader_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./modules/uploader.js */ "./node_modules/quill/modules/uploader.js");\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! quill-delta */ "./node_modules/quill-delta/dist/Delta.js");\n/* harmony import */ var _modules_input_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./modules/input.js */ "./node_modules/quill/modules/input.js");\n/* harmony import */ var _modules_uiNode_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./modules/uiNode.js */ "./node_modules/quill/modules/uiNode.js");\n/* harmony import */ var _core_module_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./core/module.js */ "./node_modules/quill/core/module.js");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n_core_quill_js__WEBPACK_IMPORTED_MODULE_0__["default"].register({\n  \'blots/block\': _blots_block_js__WEBPACK_IMPORTED_MODULE_1__["default"],\n  \'blots/block/embed\': _blots_block_js__WEBPACK_IMPORTED_MODULE_1__.BlockEmbed,\n  \'blots/break\': _blots_break_js__WEBPACK_IMPORTED_MODULE_2__["default"],\n  \'blots/container\': _blots_container_js__WEBPACK_IMPORTED_MODULE_3__["default"],\n  \'blots/cursor\': _blots_cursor_js__WEBPACK_IMPORTED_MODULE_4__["default"],\n  \'blots/embed\': _blots_embed_js__WEBPACK_IMPORTED_MODULE_5__["default"],\n  \'blots/inline\': _blots_inline_js__WEBPACK_IMPORTED_MODULE_6__["default"],\n  \'blots/scroll\': _blots_scroll_js__WEBPACK_IMPORTED_MODULE_7__["default"],\n  \'blots/text\': _blots_text_js__WEBPACK_IMPORTED_MODULE_8__["default"],\n  \'modules/clipboard\': _modules_clipboard_js__WEBPACK_IMPORTED_MODULE_9__["default"],\n  \'modules/history\': _modules_history_js__WEBPACK_IMPORTED_MODULE_10__["default"],\n  \'modules/keyboard\': _modules_keyboard_js__WEBPACK_IMPORTED_MODULE_11__["default"],\n  \'modules/uploader\': _modules_uploader_js__WEBPACK_IMPORTED_MODULE_12__["default"],\n  \'modules/input\': _modules_input_js__WEBPACK_IMPORTED_MODULE_14__["default"],\n  \'modules/uiNode\': _modules_uiNode_js__WEBPACK_IMPORTED_MODULE_15__["default"]\n});\n/* harmony default export */ __webpack_exports__["default"] = (_core_quill_js__WEBPACK_IMPORTED_MODULE_0__["default"]);\n//# sourceMappingURL=core.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core.js?')},"./node_modules/quill/core/composition.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _blots_embed_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/embed.js */ "./node_modules/quill/blots/embed.js");\n/* harmony import */ var _emitter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./emitter.js */ "./node_modules/quill/core/emitter.js");\n\n\nclass Composition {\n  isComposing = false;\n  constructor(scroll, emitter) {\n    this.scroll = scroll;\n    this.emitter = emitter;\n    this.setupListeners();\n  }\n  setupListeners() {\n    this.scroll.domNode.addEventListener(\'compositionstart\', event => {\n      if (!this.isComposing) {\n        this.handleCompositionStart(event);\n      }\n    });\n    this.scroll.domNode.addEventListener(\'compositionend\', event => {\n      if (this.isComposing) {\n        // Webkit makes DOM changes after compositionend, so we use microtask to\n        // ensure the order.\n        // https://bugs.webkit.org/show_bug.cgi?id=31902\n        queueMicrotask(() => {\n          this.handleCompositionEnd(event);\n        });\n      }\n    });\n  }\n  handleCompositionStart(event) {\n    const blot = event.target instanceof Node ? this.scroll.find(event.target, true) : null;\n    if (blot && !(blot instanceof _blots_embed_js__WEBPACK_IMPORTED_MODULE_0__["default"])) {\n      this.emitter.emit(_emitter_js__WEBPACK_IMPORTED_MODULE_1__["default"].events.COMPOSITION_BEFORE_START, event);\n      this.scroll.batchStart();\n      this.emitter.emit(_emitter_js__WEBPACK_IMPORTED_MODULE_1__["default"].events.COMPOSITION_START, event);\n      this.isComposing = true;\n    }\n  }\n  handleCompositionEnd(event) {\n    this.emitter.emit(_emitter_js__WEBPACK_IMPORTED_MODULE_1__["default"].events.COMPOSITION_BEFORE_END, event);\n    this.scroll.batchEnd();\n    this.emitter.emit(_emitter_js__WEBPACK_IMPORTED_MODULE_1__["default"].events.COMPOSITION_END, event);\n    this.isComposing = false;\n  }\n}\n/* harmony default export */ __webpack_exports__["default"] = (Composition);\n//# sourceMappingURL=composition.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core/composition.js?')},"./node_modules/quill/core/editor.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash-es */ \"./node_modules/lodash-es/merge.js\");\n/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! lodash-es */ \"./node_modules/lodash-es/cloneDeep.js\");\n/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! lodash-es */ \"./node_modules/lodash-es/isEqual.js\");\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill-delta */ \"./node_modules/quill-delta/dist/Delta.js\");\n/* harmony import */ var _blots_block_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../blots/block.js */ \"./node_modules/quill/blots/block.js\");\n/* harmony import */ var _blots_break_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../blots/break.js */ \"./node_modules/quill/blots/break.js\");\n/* harmony import */ var _blots_cursor_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../blots/cursor.js */ \"./node_modules/quill/blots/cursor.js\");\n/* harmony import */ var _blots_text_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../blots/text.js */ \"./node_modules/quill/blots/text.js\");\n/* harmony import */ var _selection_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./selection.js */ \"./node_modules/quill/core/selection.js\");\n\n\n\n\n\n\n\n\nconst ASCII = /^[ -~]*$/;\nclass Editor {\n  constructor(scroll) {\n    this.scroll = scroll;\n    this.delta = this.getDelta();\n  }\n  applyDelta(delta) {\n    this.scroll.update();\n    let scrollLength = this.scroll.length();\n    this.scroll.batchStart();\n    const normalizedDelta = normalizeDelta(delta);\n    const deleteDelta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__();\n    const normalizedOps = splitOpLines(normalizedDelta.ops.slice());\n    normalizedOps.reduce((index, op) => {\n      const length = quill_delta__WEBPACK_IMPORTED_MODULE_0__.Op.length(op);\n      let attributes = op.attributes || {};\n      let isImplicitNewlinePrepended = false;\n      let isImplicitNewlineAppended = false;\n      if (op.insert != null) {\n        deleteDelta.retain(length);\n        if (typeof op.insert === 'string') {\n          const text = op.insert;\n          isImplicitNewlineAppended = !text.endsWith('\\n') && (scrollLength <= index || !!this.scroll.descendant(_blots_block_js__WEBPACK_IMPORTED_MODULE_1__.BlockEmbed, index)[0]);\n          this.scroll.insertAt(index, text);\n          const [line, offset] = this.scroll.line(index);\n          let formats = (0,lodash_es__WEBPACK_IMPORTED_MODULE_6__[\"default\"])({}, (0,_blots_block_js__WEBPACK_IMPORTED_MODULE_1__.bubbleFormats)(line));\n          if (line instanceof _blots_block_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]) {\n            const [leaf] = line.descendant(parchment__WEBPACK_IMPORTED_MODULE_7__.LeafBlot, offset);\n            if (leaf) {\n              formats = (0,lodash_es__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(formats, (0,_blots_block_js__WEBPACK_IMPORTED_MODULE_1__.bubbleFormats)(leaf));\n            }\n          }\n          attributes = quill_delta__WEBPACK_IMPORTED_MODULE_0__.AttributeMap.diff(formats, attributes) || {};\n        } else if (typeof op.insert === 'object') {\n          const key = Object.keys(op.insert)[0]; // There should only be one key\n          if (key == null) return index;\n          const isInlineEmbed = this.scroll.query(key, parchment__WEBPACK_IMPORTED_MODULE_7__.Scope.INLINE) != null;\n          if (isInlineEmbed) {\n            if (scrollLength <= index || !!this.scroll.descendant(_blots_block_js__WEBPACK_IMPORTED_MODULE_1__.BlockEmbed, index)[0]) {\n              isImplicitNewlineAppended = true;\n            }\n          } else if (index > 0) {\n            const [leaf, offset] = this.scroll.descendant(parchment__WEBPACK_IMPORTED_MODULE_7__.LeafBlot, index - 1);\n            if (leaf instanceof _blots_text_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]) {\n              const text = leaf.value();\n              if (text[offset] !== '\\n') {\n                isImplicitNewlinePrepended = true;\n              }\n            } else if (leaf instanceof parchment__WEBPACK_IMPORTED_MODULE_7__.EmbedBlot && leaf.statics.scope === parchment__WEBPACK_IMPORTED_MODULE_7__.Scope.INLINE_BLOT) {\n              isImplicitNewlinePrepended = true;\n            }\n          }\n          this.scroll.insertAt(index, key, op.insert[key]);\n          if (isInlineEmbed) {\n            const [leaf] = this.scroll.descendant(parchment__WEBPACK_IMPORTED_MODULE_7__.LeafBlot, index);\n            if (leaf) {\n              const formats = (0,lodash_es__WEBPACK_IMPORTED_MODULE_6__[\"default\"])({}, (0,_blots_block_js__WEBPACK_IMPORTED_MODULE_1__.bubbleFormats)(leaf));\n              attributes = quill_delta__WEBPACK_IMPORTED_MODULE_0__.AttributeMap.diff(formats, attributes) || {};\n            }\n          }\n        }\n        scrollLength += length;\n      } else {\n        deleteDelta.push(op);\n        if (op.retain !== null && typeof op.retain === 'object') {\n          const key = Object.keys(op.retain)[0];\n          if (key == null) return index;\n          this.scroll.updateEmbedAt(index, key, op.retain[key]);\n        }\n      }\n      Object.keys(attributes).forEach(name => {\n        this.scroll.formatAt(index, length, name, attributes[name]);\n      });\n      const prependedLength = isImplicitNewlinePrepended ? 1 : 0;\n      const addedLength = isImplicitNewlineAppended ? 1 : 0;\n      scrollLength += prependedLength + addedLength;\n      deleteDelta.retain(prependedLength);\n      deleteDelta.delete(addedLength);\n      return index + length + prependedLength + addedLength;\n    }, 0);\n    deleteDelta.reduce((index, op) => {\n      if (typeof op.delete === 'number') {\n        this.scroll.deleteAt(index, op.delete);\n        return index;\n      }\n      return index + quill_delta__WEBPACK_IMPORTED_MODULE_0__.Op.length(op);\n    }, 0);\n    this.scroll.batchEnd();\n    this.scroll.optimize();\n    return this.update(normalizedDelta);\n  }\n  deleteText(index, length) {\n    this.scroll.deleteAt(index, length);\n    return this.update(new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(index).delete(length));\n  }\n  formatLine(index, length) {\n    let formats = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};\n    this.scroll.update();\n    Object.keys(formats).forEach(format => {\n      this.scroll.lines(index, Math.max(length, 1)).forEach(line => {\n        line.format(format, formats[format]);\n      });\n    });\n    this.scroll.optimize();\n    const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(index).retain(length, (0,lodash_es__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(formats));\n    return this.update(delta);\n  }\n  formatText(index, length) {\n    let formats = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};\n    Object.keys(formats).forEach(format => {\n      this.scroll.formatAt(index, length, format, formats[format]);\n    });\n    const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(index).retain(length, (0,lodash_es__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(formats));\n    return this.update(delta);\n  }\n  getContents(index, length) {\n    return this.delta.slice(index, index + length);\n  }\n  getDelta() {\n    return this.scroll.lines().reduce((delta, line) => {\n      return delta.concat(line.delta());\n    }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__());\n  }\n  getFormat(index) {\n    let length = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;\n    let lines = [];\n    let leaves = [];\n    if (length === 0) {\n      this.scroll.path(index).forEach(path => {\n        const [blot] = path;\n        if (blot instanceof _blots_block_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"]) {\n          lines.push(blot);\n        } else if (blot instanceof parchment__WEBPACK_IMPORTED_MODULE_7__.LeafBlot) {\n          leaves.push(blot);\n        }\n      });\n    } else {\n      lines = this.scroll.lines(index, length);\n      leaves = this.scroll.descendants(parchment__WEBPACK_IMPORTED_MODULE_7__.LeafBlot, index, length);\n    }\n    const [lineFormats, leafFormats] = [lines, leaves].map(blots => {\n      const blot = blots.shift();\n      if (blot == null) return {};\n      let formats = (0,_blots_block_js__WEBPACK_IMPORTED_MODULE_1__.bubbleFormats)(blot);\n      while (Object.keys(formats).length > 0) {\n        const blot = blots.shift();\n        if (blot == null) return formats;\n        formats = combineFormats((0,_blots_block_js__WEBPACK_IMPORTED_MODULE_1__.bubbleFormats)(blot), formats);\n      }\n      return formats;\n    });\n    return {\n      ...lineFormats,\n      ...leafFormats\n    };\n  }\n  getHTML(index, length) {\n    const [line, lineOffset] = this.scroll.line(index);\n    if (line) {\n      const lineLength = line.length();\n      const isWithinLine = line.length() >= lineOffset + length;\n      if (isWithinLine && !(lineOffset === 0 && length === lineLength)) {\n        return convertHTML(line, lineOffset, length, true);\n      }\n      return convertHTML(this.scroll, index, length, true);\n    }\n    return '';\n  }\n  getText(index, length) {\n    return this.getContents(index, length).filter(op => typeof op.insert === 'string').map(op => op.insert).join('');\n  }\n  insertContents(index, contents) {\n    const normalizedDelta = normalizeDelta(contents);\n    const change = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(index).concat(normalizedDelta);\n    this.scroll.insertContents(index, normalizedDelta);\n    return this.update(change);\n  }\n  insertEmbed(index, embed, value) {\n    this.scroll.insertAt(index, embed, value);\n    return this.update(new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(index).insert({\n      [embed]: value\n    }));\n  }\n  insertText(index, text) {\n    let formats = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};\n    text = text.replace(/\\r\\n/g, '\\n').replace(/\\r/g, '\\n');\n    this.scroll.insertAt(index, text);\n    Object.keys(formats).forEach(format => {\n      this.scroll.formatAt(index, text.length, format, formats[format]);\n    });\n    return this.update(new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(index).insert(text, (0,lodash_es__WEBPACK_IMPORTED_MODULE_8__[\"default\"])(formats)));\n  }\n  isBlank() {\n    if (this.scroll.children.length === 0) return true;\n    if (this.scroll.children.length > 1) return false;\n    const blot = this.scroll.children.head;\n    if (blot?.statics.blotName !== _blots_block_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].blotName) return false;\n    const block = blot;\n    if (block.children.length > 1) return false;\n    return block.children.head instanceof _blots_break_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"];\n  }\n  removeFormat(index, length) {\n    const text = this.getText(index, length);\n    const [line, offset] = this.scroll.line(index + length);\n    let suffixLength = 0;\n    let suffix = new quill_delta__WEBPACK_IMPORTED_MODULE_0__();\n    if (line != null) {\n      suffixLength = line.length() - offset;\n      suffix = line.delta().slice(offset, offset + suffixLength - 1).insert('\\n');\n    }\n    const contents = this.getContents(index, length + suffixLength);\n    const diff = contents.diff(new quill_delta__WEBPACK_IMPORTED_MODULE_0__().insert(text).concat(suffix));\n    const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(index).concat(diff);\n    return this.applyDelta(delta);\n  }\n  update(change) {\n    let mutations = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : [];\n    let selectionInfo = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : undefined;\n    const oldDelta = this.delta;\n    if (mutations.length === 1 && mutations[0].type === 'characterData' &&\n    // @ts-expect-error Fix me later\n    mutations[0].target.data.match(ASCII) && this.scroll.find(mutations[0].target)) {\n      // Optimization for character changes\n      const textBlot = this.scroll.find(mutations[0].target);\n      const formats = (0,_blots_block_js__WEBPACK_IMPORTED_MODULE_1__.bubbleFormats)(textBlot);\n      const index = textBlot.offset(this.scroll);\n      // @ts-expect-error Fix me later\n      const oldValue = mutations[0].oldValue.replace(_blots_cursor_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"].CONTENTS, '');\n      const oldText = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().insert(oldValue);\n      // @ts-expect-error\n      const newText = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().insert(textBlot.value());\n      const relativeSelectionInfo = selectionInfo && {\n        oldRange: shiftRange(selectionInfo.oldRange, -index),\n        newRange: shiftRange(selectionInfo.newRange, -index)\n      };\n      const diffDelta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(index).concat(oldText.diff(newText, relativeSelectionInfo));\n      change = diffDelta.reduce((delta, op) => {\n        if (op.insert) {\n          return delta.insert(op.insert, formats);\n        }\n        return delta.push(op);\n      }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__());\n      this.delta = oldDelta.compose(change);\n    } else {\n      this.delta = this.getDelta();\n      if (!change || !(0,lodash_es__WEBPACK_IMPORTED_MODULE_9__[\"default\"])(oldDelta.compose(change), this.delta)) {\n        change = oldDelta.diff(this.delta, selectionInfo);\n      }\n    }\n    return change;\n  }\n}\nfunction convertListHTML(items, lastIndent, types) {\n  if (items.length === 0) {\n    const [endTag] = getListType(types.pop());\n    if (lastIndent <= 0) {\n      return `</li></${endTag}>`;\n    }\n    return `</li></${endTag}>${convertListHTML([], lastIndent - 1, types)}`;\n  }\n  const [{\n    child,\n    offset,\n    length,\n    indent,\n    type\n  }, ...rest] = items;\n  const [tag, attribute] = getListType(type);\n  if (indent > lastIndent) {\n    types.push(type);\n    if (indent === lastIndent + 1) {\n      return `<${tag}><li${attribute}>${convertHTML(child, offset, length)}${convertListHTML(rest, indent, types)}`;\n    }\n    return `<${tag}><li>${convertListHTML(items, lastIndent + 1, types)}`;\n  }\n  const previousType = types[types.length - 1];\n  if (indent === lastIndent && type === previousType) {\n    return `</li><li${attribute}>${convertHTML(child, offset, length)}${convertListHTML(rest, indent, types)}`;\n  }\n  const [endTag] = getListType(types.pop());\n  return `</li></${endTag}>${convertListHTML(items, lastIndent - 1, types)}`;\n}\nfunction convertHTML(blot, index, length) {\n  let isRoot = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;\n  if ('html' in blot && typeof blot.html === 'function') {\n    return blot.html(index, length);\n  }\n  if (blot instanceof _blots_text_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]) {\n    const escapedText = (0,_blots_text_js__WEBPACK_IMPORTED_MODULE_4__.escapeText)(blot.value().slice(index, index + length));\n    return escapedText.replaceAll(' ', '&nbsp;');\n  }\n  if (blot instanceof parchment__WEBPACK_IMPORTED_MODULE_7__.ParentBlot) {\n    // TODO fix API\n    if (blot.statics.blotName === 'list-container') {\n      const items = [];\n      blot.children.forEachAt(index, length, (child, offset, childLength) => {\n        const formats = 'formats' in child && typeof child.formats === 'function' ? child.formats() : {};\n        items.push({\n          child,\n          offset,\n          length: childLength,\n          indent: formats.indent || 0,\n          type: formats.list\n        });\n      });\n      return convertListHTML(items, -1, []);\n    }\n    const parts = [];\n    blot.children.forEachAt(index, length, (child, offset, childLength) => {\n      parts.push(convertHTML(child, offset, childLength));\n    });\n    if (isRoot || blot.statics.blotName === 'list') {\n      return parts.join('');\n    }\n    const {\n      outerHTML,\n      innerHTML\n    } = blot.domNode;\n    const [start, end] = outerHTML.split(`>${innerHTML}<`);\n    // TODO cleanup\n    if (start === '<table') {\n      return `<table style=\"border: 1px solid #000;\">${parts.join('')}<${end}`;\n    }\n    return `${start}>${parts.join('')}<${end}`;\n  }\n  return blot.domNode instanceof Element ? blot.domNode.outerHTML : '';\n}\nfunction combineFormats(formats, combined) {\n  return Object.keys(combined).reduce((merged, name) => {\n    if (formats[name] == null) return merged;\n    const combinedValue = combined[name];\n    if (combinedValue === formats[name]) {\n      merged[name] = combinedValue;\n    } else if (Array.isArray(combinedValue)) {\n      if (combinedValue.indexOf(formats[name]) < 0) {\n        merged[name] = combinedValue.concat([formats[name]]);\n      } else {\n        // If style already exists, don't add to an array, but don't lose other styles\n        merged[name] = combinedValue;\n      }\n    } else {\n      merged[name] = [combinedValue, formats[name]];\n    }\n    return merged;\n  }, {});\n}\nfunction getListType(type) {\n  const tag = type === 'ordered' ? 'ol' : 'ul';\n  switch (type) {\n    case 'checked':\n      return [tag, ' data-list=\"checked\"'];\n    case 'unchecked':\n      return [tag, ' data-list=\"unchecked\"'];\n    default:\n      return [tag, ''];\n  }\n}\nfunction normalizeDelta(delta) {\n  return delta.reduce((normalizedDelta, op) => {\n    if (typeof op.insert === 'string') {\n      const text = op.insert.replace(/\\r\\n/g, '\\n').replace(/\\r/g, '\\n');\n      return normalizedDelta.insert(text, op.attributes);\n    }\n    return normalizedDelta.push(op);\n  }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__());\n}\nfunction shiftRange(_ref, amount) {\n  let {\n    index,\n    length\n  } = _ref;\n  return new _selection_js__WEBPACK_IMPORTED_MODULE_5__.Range(index + amount, length);\n}\nfunction splitOpLines(ops) {\n  const split = [];\n  ops.forEach(op => {\n    if (typeof op.insert === 'string') {\n      const lines = op.insert.split('\\n');\n      lines.forEach((line, index) => {\n        if (index) split.push({\n          insert: '\\n',\n          attributes: op.attributes\n        });\n        if (line) split.push({\n          insert: line,\n          attributes: op.attributes\n        });\n      });\n    } else {\n      split.push(op);\n    }\n  });\n  return split;\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Editor);\n//# sourceMappingURL=editor.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core/editor.js?")},"./node_modules/quill/core/emitter.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var eventemitter3__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! eventemitter3 */ \"./node_modules/eventemitter3/index.mjs\");\n/* harmony import */ var _instances_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./instances.js */ \"./node_modules/quill/core/instances.js\");\n/* harmony import */ var _logger_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./logger.js */ \"./node_modules/quill/core/logger.js\");\n\n\n\nconst debug = (0,_logger_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])('quill:events');\nconst EVENTS = ['selectionchange', 'mousedown', 'mouseup', 'click'];\nEVENTS.forEach(eventName => {\n  document.addEventListener(eventName, function () {\n    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {\n      args[_key] = arguments[_key];\n    }\n    Array.from(document.querySelectorAll('.ql-container')).forEach(node => {\n      const quill = _instances_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].get(node);\n      if (quill && quill.emitter) {\n        quill.emitter.handleDOM(...args);\n      }\n    });\n  });\n});\nclass Emitter extends eventemitter3__WEBPACK_IMPORTED_MODULE_0__.EventEmitter {\n  static events = {\n    EDITOR_CHANGE: 'editor-change',\n    SCROLL_BEFORE_UPDATE: 'scroll-before-update',\n    SCROLL_BLOT_MOUNT: 'scroll-blot-mount',\n    SCROLL_BLOT_UNMOUNT: 'scroll-blot-unmount',\n    SCROLL_OPTIMIZE: 'scroll-optimize',\n    SCROLL_UPDATE: 'scroll-update',\n    SCROLL_EMBED_UPDATE: 'scroll-embed-update',\n    SELECTION_CHANGE: 'selection-change',\n    TEXT_CHANGE: 'text-change',\n    COMPOSITION_BEFORE_START: 'composition-before-start',\n    COMPOSITION_START: 'composition-start',\n    COMPOSITION_BEFORE_END: 'composition-before-end',\n    COMPOSITION_END: 'composition-end'\n  };\n  static sources = {\n    API: 'api',\n    SILENT: 'silent',\n    USER: 'user'\n  };\n  constructor() {\n    super();\n    this.domListeners = {};\n    this.on('error', debug.error);\n  }\n  emit() {\n    for (var _len2 = arguments.length, args = new Array(_len2), _key2 = 0; _key2 < _len2; _key2++) {\n      args[_key2] = arguments[_key2];\n    }\n    debug.log.call(debug, ...args);\n    // @ts-expect-error\n    return super.emit(...args);\n  }\n  handleDOM(event) {\n    for (var _len3 = arguments.length, args = new Array(_len3 > 1 ? _len3 - 1 : 0), _key3 = 1; _key3 < _len3; _key3++) {\n      args[_key3 - 1] = arguments[_key3];\n    }\n    (this.domListeners[event.type] || []).forEach(_ref => {\n      let {\n        node,\n        handler\n      } = _ref;\n      if (event.target === node || node.contains(event.target)) {\n        handler(event, ...args);\n      }\n    });\n  }\n  listenDOM(eventName, node, handler) {\n    if (!this.domListeners[eventName]) {\n      this.domListeners[eventName] = [];\n    }\n    this.domListeners[eventName].push({\n      node,\n      handler\n    });\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Emitter);\n//# sourceMappingURL=emitter.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core/emitter.js?")},"./node_modules/quill/core/instances.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony default export */ __webpack_exports__["default"] = (new WeakMap());\n//# sourceMappingURL=instances.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core/instances.js?')},"./node_modules/quill/core/logger.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\nconst levels = ['error', 'warn', 'log', 'info'];\nlet level = 'warn';\nfunction debug(method) {\n  if (level) {\n    if (levels.indexOf(method) <= levels.indexOf(level)) {\n      for (var _len = arguments.length, args = new Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {\n        args[_key - 1] = arguments[_key];\n      }\n      console[method](...args); // eslint-disable-line no-console\n    }\n  }\n}\nfunction namespace(ns) {\n  return levels.reduce((logger, method) => {\n    logger[method] = debug.bind(console, method, ns);\n    return logger;\n  }, {});\n}\nnamespace.level = newLevel => {\n  level = newLevel;\n};\ndebug.level = namespace.level;\n/* harmony default export */ __webpack_exports__[\"default\"] = (namespace);\n//# sourceMappingURL=logger.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core/logger.js?")},"./node_modules/quill/core/module.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\nclass Module {\n  static DEFAULTS = {};\n  constructor(quill) {\n    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n    this.quill = quill;\n    this.options = options;\n  }\n}\n/* harmony default export */ __webpack_exports__["default"] = (Module);\n//# sourceMappingURL=module.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core/module.js?')},"./node_modules/quill/core/quill.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Parchment: function() { return /* reexport module object */ parchment__WEBPACK_IMPORTED_MODULE_11__; },\n/* harmony export */   Range: function() { return /* reexport safe */ _selection_js__WEBPACK_IMPORTED_MODULE_6__.Range; },\n/* harmony export */   "default": function() { return /* binding */ Quill; },\n/* harmony export */   expandConfig: function() { return /* binding */ expandConfig; },\n/* harmony export */   globalRegistry: function() { return /* binding */ globalRegistry; },\n/* harmony export */   overload: function() { return /* binding */ overload; }\n/* harmony export */ });\n/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/merge.js");\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! parchment */ "./node_modules/parchment/dist/parchment.js");\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill-delta */ "./node_modules/quill-delta/dist/Delta.js");\n/* harmony import */ var _editor_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./editor.js */ "./node_modules/quill/core/editor.js");\n/* harmony import */ var _emitter_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./emitter.js */ "./node_modules/quill/core/emitter.js");\n/* harmony import */ var _instances_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./instances.js */ "./node_modules/quill/core/instances.js");\n/* harmony import */ var _logger_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./logger.js */ "./node_modules/quill/core/logger.js");\n/* harmony import */ var _module_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./module.js */ "./node_modules/quill/core/module.js");\n/* harmony import */ var _selection_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./selection.js */ "./node_modules/quill/core/selection.js");\n/* harmony import */ var _composition_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./composition.js */ "./node_modules/quill/core/composition.js");\n/* harmony import */ var _theme_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./theme.js */ "./node_modules/quill/core/theme.js");\n/* harmony import */ var _utils_scrollRectIntoView_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./utils/scrollRectIntoView.js */ "./node_modules/quill/core/utils/scrollRectIntoView.js");\n/* harmony import */ var _utils_createRegistryWithFormats_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./utils/createRegistryWithFormats.js */ "./node_modules/quill/core/utils/createRegistryWithFormats.js");\n\n\n\n\n\n\n\n\n\n\n\n\n\nconst debug = (0,_logger_js__WEBPACK_IMPORTED_MODULE_4__["default"])(\'quill\');\nconst globalRegistry = new parchment__WEBPACK_IMPORTED_MODULE_11__.Registry();\nparchment__WEBPACK_IMPORTED_MODULE_11__.ParentBlot.uiClass = \'ql-ui\';\n\n/**\n * Options for initializing a Quill instance\n */\n\n/**\n * Similar to QuillOptions, but with all properties expanded to their default values,\n * and all selectors resolved to HTMLElements.\n */\n\nclass Quill {\n  static DEFAULTS = {\n    bounds: null,\n    modules: {\n      clipboard: true,\n      keyboard: true,\n      history: true,\n      uploader: true\n    },\n    placeholder: \'\',\n    readOnly: false,\n    registry: globalRegistry,\n    theme: \'default\'\n  };\n  static events = _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].events;\n  static sources = _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources;\n  static version =  false ? 0 : "2.0.3";\n  static imports = {\n    delta: quill_delta__WEBPACK_IMPORTED_MODULE_0__,\n    parchment: parchment__WEBPACK_IMPORTED_MODULE_11__,\n    \'core/module\': _module_js__WEBPACK_IMPORTED_MODULE_5__["default"],\n    \'core/theme\': _theme_js__WEBPACK_IMPORTED_MODULE_8__["default"]\n  };\n  static debug(limit) {\n    if (limit === true) {\n      limit = \'log\';\n    }\n    _logger_js__WEBPACK_IMPORTED_MODULE_4__["default"].level(limit);\n  }\n  static find(node) {\n    let bubble = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n    return _instances_js__WEBPACK_IMPORTED_MODULE_3__["default"].get(node) || globalRegistry.find(node, bubble);\n  }\n  static import(name) {\n    if (this.imports[name] == null) {\n      debug.error(`Cannot import ${name}. Are you sure it was registered?`);\n    }\n    return this.imports[name];\n  }\n  static register() {\n    if (typeof (arguments.length <= 0 ? undefined : arguments[0]) !== \'string\') {\n      const target = arguments.length <= 0 ? undefined : arguments[0];\n      const overwrite = !!(arguments.length <= 1 ? undefined : arguments[1]);\n      const name = \'attrName\' in target ? target.attrName : target.blotName;\n      if (typeof name === \'string\') {\n        // Shortcut for formats:\n        // register(Blot | Attributor, overwrite)\n        this.register(`formats/${name}`, target, overwrite);\n      } else {\n        Object.keys(target).forEach(key => {\n          this.register(key, target[key], overwrite);\n        });\n      }\n    } else {\n      const path = arguments.length <= 0 ? undefined : arguments[0];\n      const target = arguments.length <= 1 ? undefined : arguments[1];\n      const overwrite = !!(arguments.length <= 2 ? undefined : arguments[2]);\n      if (this.imports[path] != null && !overwrite) {\n        debug.warn(`Overwriting ${path} with`, target);\n      }\n      this.imports[path] = target;\n      if ((path.startsWith(\'blots/\') || path.startsWith(\'formats/\')) && target && typeof target !== \'boolean\' && target.blotName !== \'abstract\') {\n        globalRegistry.register(target);\n      }\n      if (typeof target.register === \'function\') {\n        target.register(globalRegistry);\n      }\n    }\n  }\n  constructor(container) {\n    let options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n    this.options = expandConfig(container, options);\n    this.container = this.options.container;\n    if (this.container == null) {\n      debug.error(\'Invalid Quill container\', container);\n      return;\n    }\n    if (this.options.debug) {\n      Quill.debug(this.options.debug);\n    }\n    const html = this.container.innerHTML.trim();\n    this.container.classList.add(\'ql-container\');\n    this.container.innerHTML = \'\';\n    _instances_js__WEBPACK_IMPORTED_MODULE_3__["default"].set(this.container, this);\n    this.root = this.addContainer(\'ql-editor\');\n    this.root.classList.add(\'ql-blank\');\n    this.emitter = new _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"]();\n    const scrollBlotName = parchment__WEBPACK_IMPORTED_MODULE_11__.ScrollBlot.blotName;\n    const ScrollBlot = this.options.registry.query(scrollBlotName);\n    if (!ScrollBlot || !(\'blotName\' in ScrollBlot)) {\n      throw new Error(`Cannot initialize Quill without "${scrollBlotName}" blot`);\n    }\n    this.scroll = new ScrollBlot(this.options.registry, this.root, {\n      emitter: this.emitter\n    });\n    this.editor = new _editor_js__WEBPACK_IMPORTED_MODULE_1__["default"](this.scroll);\n    this.selection = new _selection_js__WEBPACK_IMPORTED_MODULE_6__["default"](this.scroll, this.emitter);\n    this.composition = new _composition_js__WEBPACK_IMPORTED_MODULE_7__["default"](this.scroll, this.emitter);\n    this.theme = new this.options.theme(this, this.options); // eslint-disable-line new-cap\n    this.keyboard = this.theme.addModule(\'keyboard\');\n    this.clipboard = this.theme.addModule(\'clipboard\');\n    this.history = this.theme.addModule(\'history\');\n    this.uploader = this.theme.addModule(\'uploader\');\n    this.theme.addModule(\'input\');\n    this.theme.addModule(\'uiNode\');\n    this.theme.init();\n    this.emitter.on(_emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].events.EDITOR_CHANGE, type => {\n      if (type === _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].events.TEXT_CHANGE) {\n        this.root.classList.toggle(\'ql-blank\', this.editor.isBlank());\n      }\n    });\n    this.emitter.on(_emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].events.SCROLL_UPDATE, (source, mutations) => {\n      const oldRange = this.selection.lastRange;\n      const [newRange] = this.selection.getRange();\n      const selectionInfo = oldRange && newRange ? {\n        oldRange,\n        newRange\n      } : undefined;\n      modify.call(this, () => this.editor.update(null, mutations, selectionInfo), source);\n    });\n    this.emitter.on(_emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].events.SCROLL_EMBED_UPDATE, (blot, delta) => {\n      const oldRange = this.selection.lastRange;\n      const [newRange] = this.selection.getRange();\n      const selectionInfo = oldRange && newRange ? {\n        oldRange,\n        newRange\n      } : undefined;\n      modify.call(this, () => {\n        const change = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(blot.offset(this)).retain({\n          [blot.statics.blotName]: delta\n        });\n        return this.editor.update(change, [], selectionInfo);\n      }, Quill.sources.USER);\n    });\n    if (html) {\n      const contents = this.clipboard.convert({\n        html: `${html}<p><br></p>`,\n        text: \'\\n\'\n      });\n      this.setContents(contents);\n    }\n    this.history.clear();\n    if (this.options.placeholder) {\n      this.root.setAttribute(\'data-placeholder\', this.options.placeholder);\n    }\n    if (this.options.readOnly) {\n      this.disable();\n    }\n    this.allowReadOnlyEdits = false;\n  }\n  addContainer(container) {\n    let refNode = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n    if (typeof container === \'string\') {\n      const className = container;\n      container = document.createElement(\'div\');\n      container.classList.add(className);\n    }\n    this.container.insertBefore(container, refNode);\n    return container;\n  }\n  blur() {\n    this.selection.setRange(null);\n  }\n  deleteText(index, length, source) {\n    // @ts-expect-error\n    [index, length,, source] = overload(index, length, source);\n    return modify.call(this, () => {\n      return this.editor.deleteText(index, length);\n    }, source, index, -1 * length);\n  }\n  disable() {\n    this.enable(false);\n  }\n  editReadOnly(modifier) {\n    this.allowReadOnlyEdits = true;\n    const value = modifier();\n    this.allowReadOnlyEdits = false;\n    return value;\n  }\n  enable() {\n    let enabled = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : true;\n    this.scroll.enable(enabled);\n    this.container.classList.toggle(\'ql-disabled\', !enabled);\n  }\n  focus() {\n    let options = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};\n    this.selection.focus();\n    if (!options.preventScroll) {\n      this.scrollSelectionIntoView();\n    }\n  }\n  format(name, value) {\n    let source = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.API;\n    return modify.call(this, () => {\n      const range = this.getSelection(true);\n      let change = new quill_delta__WEBPACK_IMPORTED_MODULE_0__();\n      if (range == null) return change;\n      if (this.scroll.query(name, parchment__WEBPACK_IMPORTED_MODULE_11__.Scope.BLOCK)) {\n        change = this.editor.formatLine(range.index, range.length, {\n          [name]: value\n        });\n      } else if (range.length === 0) {\n        this.selection.format(name, value);\n        return change;\n      } else {\n        change = this.editor.formatText(range.index, range.length, {\n          [name]: value\n        });\n      }\n      this.setSelection(range, _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.SILENT);\n      return change;\n    }, source);\n  }\n  formatLine(index, length, name, value, source) {\n    let formats;\n    // eslint-disable-next-line prefer-const\n    [index, length, formats, source] = overload(index, length,\n    // @ts-expect-error\n    name, value, source);\n    return modify.call(this, () => {\n      return this.editor.formatLine(index, length, formats);\n    }, source, index, 0);\n  }\n  formatText(index, length, name, value, source) {\n    let formats;\n    // eslint-disable-next-line prefer-const\n    [index, length, formats, source] = overload(\n    // @ts-expect-error\n    index, length, name, value, source);\n    return modify.call(this, () => {\n      return this.editor.formatText(index, length, formats);\n    }, source, index, 0);\n  }\n  getBounds(index) {\n    let length = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;\n    let bounds = null;\n    if (typeof index === \'number\') {\n      bounds = this.selection.getBounds(index, length);\n    } else {\n      bounds = this.selection.getBounds(index.index, index.length);\n    }\n    if (!bounds) return null;\n    const containerBounds = this.container.getBoundingClientRect();\n    return {\n      bottom: bounds.bottom - containerBounds.top,\n      height: bounds.height,\n      left: bounds.left - containerBounds.left,\n      right: bounds.right - containerBounds.left,\n      top: bounds.top - containerBounds.top,\n      width: bounds.width\n    };\n  }\n  getContents() {\n    let index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;\n    let length = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : this.getLength() - index;\n    [index, length] = overload(index, length);\n    return this.editor.getContents(index, length);\n  }\n  getFormat() {\n    let index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.getSelection(true);\n    let length = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;\n    if (typeof index === \'number\') {\n      return this.editor.getFormat(index, length);\n    }\n    return this.editor.getFormat(index.index, index.length);\n  }\n  getIndex(blot) {\n    return blot.offset(this.scroll);\n  }\n  getLength() {\n    return this.scroll.length();\n  }\n  getLeaf(index) {\n    return this.scroll.leaf(index);\n  }\n  getLine(index) {\n    return this.scroll.line(index);\n  }\n  getLines() {\n    let index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;\n    let length = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : Number.MAX_VALUE;\n    if (typeof index !== \'number\') {\n      return this.scroll.lines(index.index, index.length);\n    }\n    return this.scroll.lines(index, length);\n  }\n  getModule(name) {\n    return this.theme.modules[name];\n  }\n  getSelection() {\n    let focus = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;\n    if (focus) this.focus();\n    this.update(); // Make sure we access getRange with editor in consistent state\n    return this.selection.getRange()[0];\n  }\n  getSemanticHTML() {\n    let index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;\n    let length = arguments.length > 1 ? arguments[1] : undefined;\n    if (typeof index === \'number\') {\n      length = length ?? this.getLength() - index;\n    }\n    // @ts-expect-error\n    [index, length] = overload(index, length);\n    return this.editor.getHTML(index, length);\n  }\n  getText() {\n    let index = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;\n    let length = arguments.length > 1 ? arguments[1] : undefined;\n    if (typeof index === \'number\') {\n      length = length ?? this.getLength() - index;\n    }\n    // @ts-expect-error\n    [index, length] = overload(index, length);\n    return this.editor.getText(index, length);\n  }\n  hasFocus() {\n    return this.selection.hasFocus();\n  }\n  insertEmbed(index, embed, value) {\n    let source = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : Quill.sources.API;\n    return modify.call(this, () => {\n      return this.editor.insertEmbed(index, embed, value);\n    }, source, index);\n  }\n  insertText(index, text, name, value, source) {\n    let formats;\n    // eslint-disable-next-line prefer-const\n    // @ts-expect-error\n    [index,, formats, source] = overload(index, 0, name, value, source);\n    return modify.call(this, () => {\n      return this.editor.insertText(index, text, formats);\n    }, source, index, text.length);\n  }\n  isEnabled() {\n    return this.scroll.isEnabled();\n  }\n  off() {\n    return this.emitter.off(...arguments);\n  }\n  on() {\n    return this.emitter.on(...arguments);\n  }\n  once() {\n    return this.emitter.once(...arguments);\n  }\n  removeFormat(index, length, source) {\n    [index, length,, source] = overload(index, length, source);\n    return modify.call(this, () => {\n      return this.editor.removeFormat(index, length);\n    }, source, index);\n  }\n  scrollRectIntoView(rect) {\n    (0,_utils_scrollRectIntoView_js__WEBPACK_IMPORTED_MODULE_9__["default"])(this.root, rect);\n  }\n\n  /**\n   * @deprecated Use Quill#scrollSelectionIntoView() instead.\n   */\n  scrollIntoView() {\n    console.warn(\'Quill#scrollIntoView() has been deprecated and will be removed in the near future. Please use Quill#scrollSelectionIntoView() instead.\');\n    this.scrollSelectionIntoView();\n  }\n\n  /**\n   * Scroll the current selection into the visible area.\n   * If the selection is already visible, no scrolling will occur.\n   */\n  scrollSelectionIntoView() {\n    const range = this.selection.lastRange;\n    const bounds = range && this.selection.getBounds(range.index, range.length);\n    if (bounds) {\n      this.scrollRectIntoView(bounds);\n    }\n  }\n  setContents(delta) {\n    let source = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.API;\n    return modify.call(this, () => {\n      delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__(delta);\n      const length = this.getLength();\n      // Quill will set empty editor to \\n\n      const delete1 = this.editor.deleteText(0, length);\n      const applied = this.editor.insertContents(0, delta);\n      // Remove extra \\n from empty editor initialization\n      const delete2 = this.editor.deleteText(this.getLength() - 1, 1);\n      return delete1.compose(applied).compose(delete2);\n    }, source);\n  }\n  setSelection(index, length, source) {\n    if (index == null) {\n      // @ts-expect-error https://github.com/microsoft/TypeScript/issues/22609\n      this.selection.setRange(null, length || Quill.sources.API);\n    } else {\n      // @ts-expect-error\n      [index, length,, source] = overload(index, length, source);\n      this.selection.setRange(new _selection_js__WEBPACK_IMPORTED_MODULE_6__.Range(Math.max(0, index), length), source);\n      if (source !== _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.SILENT) {\n        this.scrollSelectionIntoView();\n      }\n    }\n  }\n  setText(text) {\n    let source = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.API;\n    const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().insert(text);\n    return this.setContents(delta, source);\n  }\n  update() {\n    let source = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.USER;\n    const change = this.scroll.update(source); // Will update selection before selection.update() does if text changes\n    this.selection.update(source);\n    // TODO this is usually undefined\n    return change;\n  }\n  updateContents(delta) {\n    let source = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.API;\n    return modify.call(this, () => {\n      delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__(delta);\n      return this.editor.applyDelta(delta);\n    }, source, true);\n  }\n}\nfunction resolveSelector(selector) {\n  return typeof selector === \'string\' ? document.querySelector(selector) : selector;\n}\nfunction expandModuleConfig(config) {\n  return Object.entries(config ?? {}).reduce((expanded, _ref) => {\n    let [key, value] = _ref;\n    return {\n      ...expanded,\n      [key]: value === true ? {} : value\n    };\n  }, {});\n}\nfunction omitUndefinedValuesFromOptions(obj) {\n  return Object.fromEntries(Object.entries(obj).filter(entry => entry[1] !== undefined));\n}\nfunction expandConfig(containerOrSelector, options) {\n  const container = resolveSelector(containerOrSelector);\n  if (!container) {\n    throw new Error(\'Invalid Quill container\');\n  }\n  const shouldUseDefaultTheme = !options.theme || options.theme === Quill.DEFAULTS.theme;\n  const theme = shouldUseDefaultTheme ? _theme_js__WEBPACK_IMPORTED_MODULE_8__["default"] : Quill.import(`themes/${options.theme}`);\n  if (!theme) {\n    throw new Error(`Invalid theme ${options.theme}. Did you register it?`);\n  }\n  const {\n    modules: quillModuleDefaults,\n    ...quillDefaults\n  } = Quill.DEFAULTS;\n  const {\n    modules: themeModuleDefaults,\n    ...themeDefaults\n  } = theme.DEFAULTS;\n  let userModuleOptions = expandModuleConfig(options.modules);\n  // Special case toolbar shorthand\n  if (userModuleOptions != null && userModuleOptions.toolbar && userModuleOptions.toolbar.constructor !== Object) {\n    userModuleOptions = {\n      ...userModuleOptions,\n      toolbar: {\n        container: userModuleOptions.toolbar\n      }\n    };\n  }\n  const modules = (0,lodash_es__WEBPACK_IMPORTED_MODULE_12__["default"])({}, expandModuleConfig(quillModuleDefaults), expandModuleConfig(themeModuleDefaults), userModuleOptions);\n  const config = {\n    ...quillDefaults,\n    ...omitUndefinedValuesFromOptions(themeDefaults),\n    ...omitUndefinedValuesFromOptions(options)\n  };\n  let registry = options.registry;\n  if (registry) {\n    if (options.formats) {\n      debug.warn(\'Ignoring "formats" option because "registry" is specified\');\n    }\n  } else {\n    registry = options.formats ? (0,_utils_createRegistryWithFormats_js__WEBPACK_IMPORTED_MODULE_10__["default"])(options.formats, config.registry, debug) : config.registry;\n  }\n  return {\n    ...config,\n    registry,\n    container,\n    theme,\n    modules: Object.entries(modules).reduce((modulesWithDefaults, _ref2) => {\n      let [name, value] = _ref2;\n      if (!value) return modulesWithDefaults;\n      const moduleClass = Quill.import(`modules/${name}`);\n      if (moduleClass == null) {\n        debug.error(`Cannot load ${name} module. Are you sure you registered it?`);\n        return modulesWithDefaults;\n      }\n      return {\n        ...modulesWithDefaults,\n        // @ts-expect-error\n        [name]: (0,lodash_es__WEBPACK_IMPORTED_MODULE_12__["default"])({}, moduleClass.DEFAULTS || {}, value)\n      };\n    }, {}),\n    bounds: resolveSelector(config.bounds)\n  };\n}\n\n// Handle selection preservation and TEXT_CHANGE emission\n// common to modification APIs\nfunction modify(modifier, source, index, shift) {\n  if (!this.isEnabled() && source === _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.USER && !this.allowReadOnlyEdits) {\n    return new quill_delta__WEBPACK_IMPORTED_MODULE_0__();\n  }\n  let range = index == null ? null : this.getSelection();\n  const oldDelta = this.editor.delta;\n  const change = modifier();\n  if (range != null) {\n    if (index === true) {\n      index = range.index; // eslint-disable-line prefer-destructuring\n    }\n    if (shift == null) {\n      range = shiftRange(range, change, source);\n    } else if (shift !== 0) {\n      // @ts-expect-error index should always be number\n      range = shiftRange(range, index, shift, source);\n    }\n    this.setSelection(range, _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.SILENT);\n  }\n  if (change.length() > 0) {\n    const args = [_emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].events.TEXT_CHANGE, change, oldDelta, source];\n    this.emitter.emit(_emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].events.EDITOR_CHANGE, ...args);\n    if (source !== _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.SILENT) {\n      this.emitter.emit(...args);\n    }\n  }\n  return change;\n}\nfunction overload(index, length, name, value, source) {\n  let formats = {};\n  // @ts-expect-error\n  if (typeof index.index === \'number\' && typeof index.length === \'number\') {\n    // Allow for throwaway end (used by insertText/insertEmbed)\n    if (typeof length !== \'number\') {\n      // @ts-expect-error\n      source = value;\n      value = name;\n      name = length;\n      // @ts-expect-error\n      length = index.length; // eslint-disable-line prefer-destructuring\n      // @ts-expect-error\n      index = index.index; // eslint-disable-line prefer-destructuring\n    } else {\n      // @ts-expect-error\n      length = index.length; // eslint-disable-line prefer-destructuring\n      // @ts-expect-error\n      index = index.index; // eslint-disable-line prefer-destructuring\n    }\n  } else if (typeof length !== \'number\') {\n    // @ts-expect-error\n    source = value;\n    value = name;\n    name = length;\n    length = 0;\n  }\n  // Handle format being object, two format name/value strings or excluded\n  if (typeof name === \'object\') {\n    // @ts-expect-error Fix me later\n    formats = name;\n    // @ts-expect-error\n    source = value;\n  } else if (typeof name === \'string\') {\n    if (value != null) {\n      formats[name] = value;\n    } else {\n      // @ts-expect-error\n      source = name;\n    }\n  }\n  // Handle optional source\n  source = source || _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.API;\n  // @ts-expect-error\n  return [index, length, formats, source];\n}\nfunction shiftRange(range, index, lengthOrSource, source) {\n  const length = typeof lengthOrSource === \'number\' ? lengthOrSource : 0;\n  if (range == null) return null;\n  let start;\n  let end;\n  // @ts-expect-error -- TODO: add a better type guard around `index`\n  if (index && typeof index.transformPosition === \'function\') {\n    [start, end] = [range.index, range.index + range.length].map(pos =>\n    // @ts-expect-error -- TODO: add a better type guard around `index`\n    index.transformPosition(pos, source !== _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.USER));\n  } else {\n    [start, end] = [range.index, range.index + range.length].map(pos => {\n      // @ts-expect-error -- TODO: add a better type guard around `index`\n      if (pos < index || pos === index && source === _emitter_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.USER) return pos;\n      if (length >= 0) {\n        return pos + length;\n      }\n      // @ts-expect-error -- TODO: add a better type guard around `index`\n      return Math.max(index, pos + length);\n    });\n  }\n  return new _selection_js__WEBPACK_IMPORTED_MODULE_6__.Range(start, end - start);\n}\n\n\n//# sourceMappingURL=quill.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core/quill.js?')},"./node_modules/quill/core/selection.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Range: function() { return /* binding */ Range; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! parchment */ "./node_modules/parchment/dist/parchment.js");\n/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/isEqual.js");\n/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/cloneDeep.js");\n/* harmony import */ var _emitter_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./emitter.js */ "./node_modules/quill/core/emitter.js");\n/* harmony import */ var _logger_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./logger.js */ "./node_modules/quill/core/logger.js");\n\n\n\n\nconst debug = (0,_logger_js__WEBPACK_IMPORTED_MODULE_1__["default"])(\'quill:selection\');\nclass Range {\n  constructor(index) {\n    let length = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;\n    this.index = index;\n    this.length = length;\n  }\n}\nclass Selection {\n  constructor(scroll, emitter) {\n    this.emitter = emitter;\n    this.scroll = scroll;\n    this.composing = false;\n    this.mouseDown = false;\n    this.root = this.scroll.domNode;\n    // @ts-expect-error\n    this.cursor = this.scroll.create(\'cursor\', this);\n    // savedRange is last non-null range\n    this.savedRange = new Range(0, 0);\n    this.lastRange = this.savedRange;\n    this.lastNative = null;\n    this.handleComposition();\n    this.handleDragging();\n    this.emitter.listenDOM(\'selectionchange\', document, () => {\n      if (!this.mouseDown && !this.composing) {\n        setTimeout(this.update.bind(this, _emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].sources.USER), 1);\n      }\n    });\n    this.emitter.on(_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].events.SCROLL_BEFORE_UPDATE, () => {\n      if (!this.hasFocus()) return;\n      const native = this.getNativeRange();\n      if (native == null) return;\n      if (native.start.node === this.cursor.textNode) return; // cursor.restore() will handle\n      this.emitter.once(_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].events.SCROLL_UPDATE, (source, mutations) => {\n        try {\n          if (this.root.contains(native.start.node) && this.root.contains(native.end.node)) {\n            this.setNativeRange(native.start.node, native.start.offset, native.end.node, native.end.offset);\n          }\n          const triggeredByTyping = mutations.some(mutation => mutation.type === \'characterData\' || mutation.type === \'childList\' || mutation.type === \'attributes\' && mutation.target === this.root);\n          this.update(triggeredByTyping ? _emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].sources.SILENT : source);\n        } catch (ignored) {\n          // ignore\n        }\n      });\n    });\n    this.emitter.on(_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].events.SCROLL_OPTIMIZE, (mutations, context) => {\n      if (context.range) {\n        const {\n          startNode,\n          startOffset,\n          endNode,\n          endOffset\n        } = context.range;\n        this.setNativeRange(startNode, startOffset, endNode, endOffset);\n        this.update(_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].sources.SILENT);\n      }\n    });\n    this.update(_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].sources.SILENT);\n  }\n  handleComposition() {\n    this.emitter.on(_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].events.COMPOSITION_BEFORE_START, () => {\n      this.composing = true;\n    });\n    this.emitter.on(_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].events.COMPOSITION_END, () => {\n      this.composing = false;\n      if (this.cursor.parent) {\n        const range = this.cursor.restore();\n        if (!range) return;\n        setTimeout(() => {\n          this.setNativeRange(range.startNode, range.startOffset, range.endNode, range.endOffset);\n        }, 1);\n      }\n    });\n  }\n  handleDragging() {\n    this.emitter.listenDOM(\'mousedown\', document.body, () => {\n      this.mouseDown = true;\n    });\n    this.emitter.listenDOM(\'mouseup\', document.body, () => {\n      this.mouseDown = false;\n      this.update(_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].sources.USER);\n    });\n  }\n  focus() {\n    if (this.hasFocus()) return;\n    this.root.focus({\n      preventScroll: true\n    });\n    this.setRange(this.savedRange);\n  }\n  format(format, value) {\n    this.scroll.update();\n    const nativeRange = this.getNativeRange();\n    if (nativeRange == null || !nativeRange.native.collapsed || this.scroll.query(format, parchment__WEBPACK_IMPORTED_MODULE_2__.Scope.BLOCK)) return;\n    if (nativeRange.start.node !== this.cursor.textNode) {\n      const blot = this.scroll.find(nativeRange.start.node, false);\n      if (blot == null) return;\n      // TODO Give blot ability to not split\n      if (blot instanceof parchment__WEBPACK_IMPORTED_MODULE_2__.LeafBlot) {\n        const after = blot.split(nativeRange.start.offset);\n        blot.parent.insertBefore(this.cursor, after);\n      } else {\n        // @ts-expect-error TODO: nativeRange.start.node doesn\'t seem to match function signature\n        blot.insertBefore(this.cursor, nativeRange.start.node); // Should never happen\n      }\n      this.cursor.attach();\n    }\n    this.cursor.format(format, value);\n    this.scroll.optimize();\n    this.setNativeRange(this.cursor.textNode, this.cursor.textNode.data.length);\n    this.update();\n  }\n  getBounds(index) {\n    let length = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;\n    const scrollLength = this.scroll.length();\n    index = Math.min(index, scrollLength - 1);\n    length = Math.min(index + length, scrollLength - 1) - index;\n    let node;\n    let [leaf, offset] = this.scroll.leaf(index);\n    if (leaf == null) return null;\n    if (length > 0 && offset === leaf.length()) {\n      const [next] = this.scroll.leaf(index + 1);\n      if (next) {\n        const [line] = this.scroll.line(index);\n        const [nextLine] = this.scroll.line(index + 1);\n        if (line === nextLine) {\n          leaf = next;\n          offset = 0;\n        }\n      }\n    }\n    [node, offset] = leaf.position(offset, true);\n    const range = document.createRange();\n    if (length > 0) {\n      range.setStart(node, offset);\n      [leaf, offset] = this.scroll.leaf(index + length);\n      if (leaf == null) return null;\n      [node, offset] = leaf.position(offset, true);\n      range.setEnd(node, offset);\n      return range.getBoundingClientRect();\n    }\n    let side = \'left\';\n    let rect;\n    if (node instanceof Text) {\n      // Return null if the text node is empty because it is\n      // not able to get a useful client rect:\n      // https://github.com/w3c/csswg-drafts/issues/2514.\n      // Empty text nodes are most likely caused by TextBlot#optimize()\n      // not getting called when editor content changes.\n      if (!node.data.length) {\n        return null;\n      }\n      if (offset < node.data.length) {\n        range.setStart(node, offset);\n        range.setEnd(node, offset + 1);\n      } else {\n        range.setStart(node, offset - 1);\n        range.setEnd(node, offset);\n        side = \'right\';\n      }\n      rect = range.getBoundingClientRect();\n    } else {\n      if (!(leaf.domNode instanceof Element)) return null;\n      rect = leaf.domNode.getBoundingClientRect();\n      if (offset > 0) side = \'right\';\n    }\n    return {\n      bottom: rect.top + rect.height,\n      height: rect.height,\n      left: rect[side],\n      right: rect[side],\n      top: rect.top,\n      width: 0\n    };\n  }\n  getNativeRange() {\n    const selection = document.getSelection();\n    if (selection == null || selection.rangeCount <= 0) return null;\n    const nativeRange = selection.getRangeAt(0);\n    if (nativeRange == null) return null;\n    const range = this.normalizeNative(nativeRange);\n    debug.info(\'getNativeRange\', range);\n    return range;\n  }\n  getRange() {\n    const root = this.scroll.domNode;\n    if (\'isConnected\' in root && !root.isConnected) {\n      // document.getSelection() forces layout on Blink, so we trend to\n      // not calling it.\n      return [null, null];\n    }\n    const normalized = this.getNativeRange();\n    if (normalized == null) return [null, null];\n    const range = this.normalizedToRange(normalized);\n    return [range, normalized];\n  }\n  hasFocus() {\n    return document.activeElement === this.root || document.activeElement != null && contains(this.root, document.activeElement);\n  }\n  normalizedToRange(range) {\n    const positions = [[range.start.node, range.start.offset]];\n    if (!range.native.collapsed) {\n      positions.push([range.end.node, range.end.offset]);\n    }\n    const indexes = positions.map(position => {\n      const [node, offset] = position;\n      const blot = this.scroll.find(node, true);\n      // @ts-expect-error Fix me later\n      const index = blot.offset(this.scroll);\n      if (offset === 0) {\n        return index;\n      }\n      if (blot instanceof parchment__WEBPACK_IMPORTED_MODULE_2__.LeafBlot) {\n        return index + blot.index(node, offset);\n      }\n      // @ts-expect-error Fix me later\n      return index + blot.length();\n    });\n    const end = Math.min(Math.max(...indexes), this.scroll.length() - 1);\n    const start = Math.min(end, ...indexes);\n    return new Range(start, end - start);\n  }\n  normalizeNative(nativeRange) {\n    if (!contains(this.root, nativeRange.startContainer) || !nativeRange.collapsed && !contains(this.root, nativeRange.endContainer)) {\n      return null;\n    }\n    const range = {\n      start: {\n        node: nativeRange.startContainer,\n        offset: nativeRange.startOffset\n      },\n      end: {\n        node: nativeRange.endContainer,\n        offset: nativeRange.endOffset\n      },\n      native: nativeRange\n    };\n    [range.start, range.end].forEach(position => {\n      let {\n        node,\n        offset\n      } = position;\n      while (!(node instanceof Text) && node.childNodes.length > 0) {\n        if (node.childNodes.length > offset) {\n          node = node.childNodes[offset];\n          offset = 0;\n        } else if (node.childNodes.length === offset) {\n          // @ts-expect-error Fix me later\n          node = node.lastChild;\n          if (node instanceof Text) {\n            offset = node.data.length;\n          } else if (node.childNodes.length > 0) {\n            // Container case\n            offset = node.childNodes.length;\n          } else {\n            // Embed case\n            offset = node.childNodes.length + 1;\n          }\n        } else {\n          break;\n        }\n      }\n      position.node = node;\n      position.offset = offset;\n    });\n    return range;\n  }\n  rangeToNative(range) {\n    const scrollLength = this.scroll.length();\n    const getPosition = (index, inclusive) => {\n      index = Math.min(scrollLength - 1, index);\n      const [leaf, leafOffset] = this.scroll.leaf(index);\n      return leaf ? leaf.position(leafOffset, inclusive) : [null, -1];\n    };\n    return [...getPosition(range.index, false), ...getPosition(range.index + range.length, true)];\n  }\n  setNativeRange(startNode, startOffset) {\n    let endNode = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : startNode;\n    let endOffset = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : startOffset;\n    let force = arguments.length > 4 && arguments[4] !== undefined ? arguments[4] : false;\n    debug.info(\'setNativeRange\', startNode, startOffset, endNode, endOffset);\n    if (startNode != null && (this.root.parentNode == null || startNode.parentNode == null ||\n    // @ts-expect-error Fix me later\n    endNode.parentNode == null)) {\n      return;\n    }\n    const selection = document.getSelection();\n    if (selection == null) return;\n    if (startNode != null) {\n      if (!this.hasFocus()) this.root.focus({\n        preventScroll: true\n      });\n      const {\n        native\n      } = this.getNativeRange() || {};\n      if (native == null || force || startNode !== native.startContainer || startOffset !== native.startOffset || endNode !== native.endContainer || endOffset !== native.endOffset) {\n        if (startNode instanceof Element && startNode.tagName === \'BR\') {\n          // @ts-expect-error Fix me later\n          startOffset = Array.from(startNode.parentNode.childNodes).indexOf(startNode);\n          startNode = startNode.parentNode;\n        }\n        if (endNode instanceof Element && endNode.tagName === \'BR\') {\n          // @ts-expect-error Fix me later\n          endOffset = Array.from(endNode.parentNode.childNodes).indexOf(endNode);\n          endNode = endNode.parentNode;\n        }\n        const range = document.createRange();\n        // @ts-expect-error Fix me later\n        range.setStart(startNode, startOffset);\n        // @ts-expect-error Fix me later\n        range.setEnd(endNode, endOffset);\n        selection.removeAllRanges();\n        selection.addRange(range);\n      }\n    } else {\n      selection.removeAllRanges();\n      this.root.blur();\n    }\n  }\n  setRange(range) {\n    let force = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n    let source = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].sources.API;\n    if (typeof force === \'string\') {\n      source = force;\n      force = false;\n    }\n    debug.info(\'setRange\', range);\n    if (range != null) {\n      const args = this.rangeToNative(range);\n      this.setNativeRange(...args, force);\n    } else {\n      this.setNativeRange(null);\n    }\n    this.update(source);\n  }\n  update() {\n    let source = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : _emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].sources.USER;\n    const oldRange = this.lastRange;\n    const [lastRange, nativeRange] = this.getRange();\n    this.lastRange = lastRange;\n    this.lastNative = nativeRange;\n    if (this.lastRange != null) {\n      this.savedRange = this.lastRange;\n    }\n    if (!(0,lodash_es__WEBPACK_IMPORTED_MODULE_3__["default"])(oldRange, this.lastRange)) {\n      if (!this.composing && nativeRange != null && nativeRange.native.collapsed && nativeRange.start.node !== this.cursor.textNode) {\n        const range = this.cursor.restore();\n        if (range) {\n          this.setNativeRange(range.startNode, range.startOffset, range.endNode, range.endOffset);\n        }\n      }\n      const args = [_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].events.SELECTION_CHANGE, (0,lodash_es__WEBPACK_IMPORTED_MODULE_4__["default"])(this.lastRange), (0,lodash_es__WEBPACK_IMPORTED_MODULE_4__["default"])(oldRange), source];\n      this.emitter.emit(_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].events.EDITOR_CHANGE, ...args);\n      if (source !== _emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].sources.SILENT) {\n        this.emitter.emit(...args);\n      }\n    }\n  }\n}\nfunction contains(parent, descendant) {\n  try {\n    // Firefox inserts inaccessible nodes around video elements\n    descendant.parentNode; // eslint-disable-line @typescript-eslint/no-unused-expressions\n  } catch (e) {\n    return false;\n  }\n  return parent.contains(descendant);\n}\n/* harmony default export */ __webpack_exports__["default"] = (Selection);\n//# sourceMappingURL=selection.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core/selection.js?')},"./node_modules/quill/core/theme.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\nclass Theme {\n  static DEFAULTS = {\n    modules: {}\n  };\n  static themes = {\n    default: Theme\n  };\n  modules = {};\n  constructor(quill, options) {\n    this.quill = quill;\n    this.options = options;\n  }\n  init() {\n    Object.keys(this.options.modules).forEach(name => {\n      if (this.modules[name] == null) {\n        this.addModule(name);\n      }\n    });\n  }\n  addModule(name) {\n    // @ts-expect-error\n    const ModuleClass = this.quill.constructor.import(`modules/${name}`);\n    this.modules[name] = new ModuleClass(this.quill, this.options.modules[name] || {});\n    return this.modules[name];\n  }\n}\n/* harmony default export */ __webpack_exports__["default"] = (Theme);\n//# sourceMappingURL=theme.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core/theme.js?')},"./node_modules/quill/core/utils/createRegistryWithFormats.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n\nconst MAX_REGISTER_ITERATIONS = 100;\nconst CORE_FORMATS = ['block', 'break', 'cursor', 'inline', 'scroll', 'text'];\nconst createRegistryWithFormats = (formats, sourceRegistry, debug) => {\n  const registry = new parchment__WEBPACK_IMPORTED_MODULE_0__.Registry();\n  CORE_FORMATS.forEach(name => {\n    const coreBlot = sourceRegistry.query(name);\n    if (coreBlot) registry.register(coreBlot);\n  });\n  formats.forEach(name => {\n    let format = sourceRegistry.query(name);\n    if (!format) {\n      debug.error(`Cannot register \"${name}\" specified in \"formats\" config. Are you sure it was registered?`);\n    }\n    let iterations = 0;\n    while (format) {\n      registry.register(format);\n      format = 'blotName' in format ? format.requiredContainer ?? null : null;\n      iterations += 1;\n      if (iterations > MAX_REGISTER_ITERATIONS) {\n        debug.error(`Cycle detected in registering blot requiredContainer: \"${name}\"`);\n        break;\n      }\n    }\n  });\n  return registry;\n};\n/* harmony default export */ __webpack_exports__[\"default\"] = (createRegistryWithFormats);\n//# sourceMappingURL=createRegistryWithFormats.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core/utils/createRegistryWithFormats.js?")},"./node_modules/quill/core/utils/scrollRectIntoView.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\nconst getParentElement = element => element.parentElement || element.getRootNode().host || null;\nconst getElementRect = element => {\n  const rect = element.getBoundingClientRect();\n  const scaleX = 'offsetWidth' in element && Math.abs(rect.width) / element.offsetWidth || 1;\n  const scaleY = 'offsetHeight' in element && Math.abs(rect.height) / element.offsetHeight || 1;\n  return {\n    top: rect.top,\n    right: rect.left + element.clientWidth * scaleX,\n    bottom: rect.top + element.clientHeight * scaleY,\n    left: rect.left\n  };\n};\nconst paddingValueToInt = value => {\n  const number = parseInt(value, 10);\n  return Number.isNaN(number) ? 0 : number;\n};\n\n// Follow the steps described in https://www.w3.org/TR/cssom-view-1/#element-scrolling-members,\n// assuming that the scroll option is set to 'nearest'.\nconst getScrollDistance = (targetStart, targetEnd, scrollStart, scrollEnd, scrollPaddingStart, scrollPaddingEnd) => {\n  if (targetStart < scrollStart && targetEnd > scrollEnd) {\n    return 0;\n  }\n  if (targetStart < scrollStart) {\n    return -(scrollStart - targetStart + scrollPaddingStart);\n  }\n  if (targetEnd > scrollEnd) {\n    return targetEnd - targetStart > scrollEnd - scrollStart ? targetStart + scrollPaddingStart - scrollStart : targetEnd - scrollEnd + scrollPaddingEnd;\n  }\n  return 0;\n};\nconst scrollRectIntoView = (root, targetRect) => {\n  const document = root.ownerDocument;\n  let rect = targetRect;\n  let current = root;\n  while (current) {\n    const isDocumentBody = current === document.body;\n    const bounding = isDocumentBody ? {\n      top: 0,\n      right: window.visualViewport?.width ?? document.documentElement.clientWidth,\n      bottom: window.visualViewport?.height ?? document.documentElement.clientHeight,\n      left: 0\n    } : getElementRect(current);\n    const style = getComputedStyle(current);\n    const scrollDistanceX = getScrollDistance(rect.left, rect.right, bounding.left, bounding.right, paddingValueToInt(style.scrollPaddingLeft), paddingValueToInt(style.scrollPaddingRight));\n    const scrollDistanceY = getScrollDistance(rect.top, rect.bottom, bounding.top, bounding.bottom, paddingValueToInt(style.scrollPaddingTop), paddingValueToInt(style.scrollPaddingBottom));\n    if (scrollDistanceX || scrollDistanceY) {\n      if (isDocumentBody) {\n        document.defaultView?.scrollBy(scrollDistanceX, scrollDistanceY);\n      } else {\n        const {\n          scrollLeft,\n          scrollTop\n        } = current;\n        if (scrollDistanceY) {\n          current.scrollTop += scrollDistanceY;\n        }\n        if (scrollDistanceX) {\n          current.scrollLeft += scrollDistanceX;\n        }\n        const scrolledLeft = current.scrollLeft - scrollLeft;\n        const scrolledTop = current.scrollTop - scrollTop;\n        rect = {\n          left: rect.left - scrolledLeft,\n          top: rect.top - scrolledTop,\n          right: rect.right - scrolledLeft,\n          bottom: rect.bottom - scrolledTop\n        };\n      }\n    }\n    current = isDocumentBody || style.position === 'fixed' ? null : getParentElement(current);\n  }\n};\n/* harmony default export */ __webpack_exports__[\"default\"] = (scrollRectIntoView);\n//# sourceMappingURL=scrollRectIntoView.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/core/utils/scrollRectIntoView.js?")},"./node_modules/quill/formats/align.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AlignAttribute: function() { return /* binding */ AlignAttribute; },\n/* harmony export */   AlignClass: function() { return /* binding */ AlignClass; },\n/* harmony export */   AlignStyle: function() { return /* binding */ AlignStyle; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n\nconst config = {\n  scope: parchment__WEBPACK_IMPORTED_MODULE_0__.Scope.BLOCK,\n  whitelist: ['right', 'center', 'justify']\n};\nconst AlignAttribute = new parchment__WEBPACK_IMPORTED_MODULE_0__.Attributor('align', 'align', config);\nconst AlignClass = new parchment__WEBPACK_IMPORTED_MODULE_0__.ClassAttributor('align', 'ql-align', config);\nconst AlignStyle = new parchment__WEBPACK_IMPORTED_MODULE_0__.StyleAttributor('align', 'text-align', config);\n\n//# sourceMappingURL=align.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/align.js?")},"./node_modules/quill/formats/background.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BackgroundClass: function() { return /* binding */ BackgroundClass; },\n/* harmony export */   BackgroundStyle: function() { return /* binding */ BackgroundStyle; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var _color_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./color.js */ \"./node_modules/quill/formats/color.js\");\n\n\nconst BackgroundClass = new parchment__WEBPACK_IMPORTED_MODULE_1__.ClassAttributor('background', 'ql-bg', {\n  scope: parchment__WEBPACK_IMPORTED_MODULE_1__.Scope.INLINE\n});\nconst BackgroundStyle = new _color_js__WEBPACK_IMPORTED_MODULE_0__.ColorAttributor('background', 'background-color', {\n  scope: parchment__WEBPACK_IMPORTED_MODULE_1__.Scope.INLINE\n});\n\n//# sourceMappingURL=background.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/background.js?")},"./node_modules/quill/formats/blockquote.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _blots_block_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/block.js */ "./node_modules/quill/blots/block.js");\n\nclass Blockquote extends _blots_block_js__WEBPACK_IMPORTED_MODULE_0__["default"] {\n  static blotName = \'blockquote\';\n  static tagName = \'blockquote\';\n}\n/* harmony default export */ __webpack_exports__["default"] = (Blockquote);\n//# sourceMappingURL=blockquote.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/blockquote.js?')},"./node_modules/quill/formats/bold.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _blots_inline_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/inline.js */ \"./node_modules/quill/blots/inline.js\");\n\nclass Bold extends _blots_inline_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  static blotName = 'bold';\n  static tagName = ['STRONG', 'B'];\n  static create() {\n    return super.create();\n  }\n  static formats() {\n    return true;\n  }\n  optimize(context) {\n    super.optimize(context);\n    if (this.domNode.tagName !== this.statics.tagName[0]) {\n      this.replaceWith(this.statics.blotName);\n    }\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Bold);\n//# sourceMappingURL=bold.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/bold.js?")},"./node_modules/quill/formats/code.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   Code: function() { return /* binding */ Code; },\n/* harmony export */   CodeBlockContainer: function() { return /* binding */ CodeBlockContainer; },\n/* harmony export */   "default": function() { return /* binding */ CodeBlock; }\n/* harmony export */ });\n/* harmony import */ var _blots_block_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/block.js */ "./node_modules/quill/blots/block.js");\n/* harmony import */ var _blots_break_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../blots/break.js */ "./node_modules/quill/blots/break.js");\n/* harmony import */ var _blots_cursor_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../blots/cursor.js */ "./node_modules/quill/blots/cursor.js");\n/* harmony import */ var _blots_inline_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../blots/inline.js */ "./node_modules/quill/blots/inline.js");\n/* harmony import */ var _blots_text_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../blots/text.js */ "./node_modules/quill/blots/text.js");\n/* harmony import */ var _blots_container_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../blots/container.js */ "./node_modules/quill/blots/container.js");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../core/quill.js */ "./node_modules/quill/core/quill.js");\n\n\n\n\n\n\n\nclass CodeBlockContainer extends _blots_container_js__WEBPACK_IMPORTED_MODULE_5__["default"] {\n  static create(value) {\n    const domNode = super.create(value);\n    domNode.setAttribute(\'spellcheck\', \'false\');\n    return domNode;\n  }\n  code(index, length) {\n    return this.children\n    // @ts-expect-error\n    .map(child => child.length() <= 1 ? \'\' : child.domNode.innerText).join(\'\\n\').slice(index, index + length);\n  }\n  html(index, length) {\n    // `\\n`s are needed in order to support empty lines at the beginning and the end.\n    // https://html.spec.whatwg.org/multipage/syntax.html#element-restrictions\n    return `<pre>\\n${(0,_blots_text_js__WEBPACK_IMPORTED_MODULE_4__.escapeText)(this.code(index, length))}\\n</pre>`;\n  }\n}\nclass CodeBlock extends _blots_block_js__WEBPACK_IMPORTED_MODULE_0__["default"] {\n  static TAB = \'  \';\n  static register() {\n    _core_quill_js__WEBPACK_IMPORTED_MODULE_6__["default"].register(CodeBlockContainer);\n  }\n}\nclass Code extends _blots_inline_js__WEBPACK_IMPORTED_MODULE_3__["default"] {}\nCode.blotName = \'code\';\nCode.tagName = \'CODE\';\nCodeBlock.blotName = \'code-block\';\nCodeBlock.className = \'ql-code-block\';\nCodeBlock.tagName = \'DIV\';\nCodeBlockContainer.blotName = \'code-block-container\';\nCodeBlockContainer.className = \'ql-code-block-container\';\nCodeBlockContainer.tagName = \'DIV\';\nCodeBlockContainer.allowedChildren = [CodeBlock];\nCodeBlock.allowedChildren = [_blots_text_js__WEBPACK_IMPORTED_MODULE_4__["default"], _blots_break_js__WEBPACK_IMPORTED_MODULE_1__["default"], _blots_cursor_js__WEBPACK_IMPORTED_MODULE_2__["default"]];\nCodeBlock.requiredContainer = CodeBlockContainer;\n\n//# sourceMappingURL=code.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/code.js?')},"./node_modules/quill/formats/color.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ColorAttributor: function() { return /* binding */ ColorAttributor; },\n/* harmony export */   ColorClass: function() { return /* binding */ ColorClass; },\n/* harmony export */   ColorStyle: function() { return /* binding */ ColorStyle; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n\nclass ColorAttributor extends parchment__WEBPACK_IMPORTED_MODULE_0__.StyleAttributor {\n  value(domNode) {\n    let value = super.value(domNode);\n    if (!value.startsWith('rgb(')) return value;\n    value = value.replace(/^[^\\d]+/, '').replace(/[^\\d]+$/, '');\n    const hex = value.split(',').map(component => `00${parseInt(component, 10).toString(16)}`.slice(-2)).join('');\n    return `#${hex}`;\n  }\n}\nconst ColorClass = new parchment__WEBPACK_IMPORTED_MODULE_0__.ClassAttributor('color', 'ql-color', {\n  scope: parchment__WEBPACK_IMPORTED_MODULE_0__.Scope.INLINE\n});\nconst ColorStyle = new ColorAttributor('color', 'color', {\n  scope: parchment__WEBPACK_IMPORTED_MODULE_0__.Scope.INLINE\n});\n\n//# sourceMappingURL=color.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/color.js?")},"./node_modules/quill/formats/direction.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   DirectionAttribute: function() { return /* binding */ DirectionAttribute; },\n/* harmony export */   DirectionClass: function() { return /* binding */ DirectionClass; },\n/* harmony export */   DirectionStyle: function() { return /* binding */ DirectionStyle; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n\nconst config = {\n  scope: parchment__WEBPACK_IMPORTED_MODULE_0__.Scope.BLOCK,\n  whitelist: ['rtl']\n};\nconst DirectionAttribute = new parchment__WEBPACK_IMPORTED_MODULE_0__.Attributor('direction', 'dir', config);\nconst DirectionClass = new parchment__WEBPACK_IMPORTED_MODULE_0__.ClassAttributor('direction', 'ql-direction', config);\nconst DirectionStyle = new parchment__WEBPACK_IMPORTED_MODULE_0__.StyleAttributor('direction', 'direction', config);\n\n//# sourceMappingURL=direction.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/direction.js?")},"./node_modules/quill/formats/font.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   FontClass: function() { return /* binding */ FontClass; },\n/* harmony export */   FontStyle: function() { return /* binding */ FontStyle; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n\nconst config = {\n  scope: parchment__WEBPACK_IMPORTED_MODULE_0__.Scope.INLINE,\n  whitelist: ['serif', 'monospace']\n};\nconst FontClass = new parchment__WEBPACK_IMPORTED_MODULE_0__.ClassAttributor('font', 'ql-font', config);\nclass FontStyleAttributor extends parchment__WEBPACK_IMPORTED_MODULE_0__.StyleAttributor {\n  value(node) {\n    return super.value(node).replace(/[\"']/g, '');\n  }\n}\nconst FontStyle = new FontStyleAttributor('font', 'font-family', config);\n\n//# sourceMappingURL=font.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/font.js?")},"./node_modules/quill/formats/formula.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _blots_embed_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/embed.js */ \"./node_modules/quill/blots/embed.js\");\n\nclass Formula extends _blots_embed_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  static blotName = 'formula';\n  static className = 'ql-formula';\n  static tagName = 'SPAN';\n  static create(value) {\n    // @ts-expect-error\n    if (window.katex == null) {\n      throw new Error('Formula module requires KaTeX.');\n    }\n    const node = super.create(value);\n    if (typeof value === 'string') {\n      // @ts-expect-error\n      window.katex.render(value, node, {\n        throwOnError: false,\n        errorColor: '#f00'\n      });\n      node.setAttribute('data-value', value);\n    }\n    return node;\n  }\n  static value(domNode) {\n    return domNode.getAttribute('data-value');\n  }\n  html() {\n    const {\n      formula\n    } = this.value();\n    return `<span>${formula}</span>`;\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Formula);\n//# sourceMappingURL=formula.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/formula.js?")},"./node_modules/quill/formats/header.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _blots_block_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/block.js */ \"./node_modules/quill/blots/block.js\");\n\nclass Header extends _blots_block_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  static blotName = 'header';\n  static tagName = ['H1', 'H2', 'H3', 'H4', 'H5', 'H6'];\n  static formats(domNode) {\n    return this.tagName.indexOf(domNode.tagName) + 1;\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Header);\n//# sourceMappingURL=header.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/header.js?")},"./node_modules/quill/formats/image.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var _link_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./link.js */ \"./node_modules/quill/formats/link.js\");\n\n\nconst ATTRIBUTES = ['alt', 'height', 'width'];\nclass Image extends parchment__WEBPACK_IMPORTED_MODULE_1__.EmbedBlot {\n  static blotName = 'image';\n  static tagName = 'IMG';\n  static create(value) {\n    const node = super.create(value);\n    if (typeof value === 'string') {\n      node.setAttribute('src', this.sanitize(value));\n    }\n    return node;\n  }\n  static formats(domNode) {\n    return ATTRIBUTES.reduce((formats, attribute) => {\n      if (domNode.hasAttribute(attribute)) {\n        formats[attribute] = domNode.getAttribute(attribute);\n      }\n      return formats;\n    }, {});\n  }\n  static match(url) {\n    return /\\.(jpe?g|gif|png)$/.test(url) || /^data:image\\/.+;base64/.test(url);\n  }\n  static sanitize(url) {\n    return (0,_link_js__WEBPACK_IMPORTED_MODULE_0__.sanitize)(url, ['http', 'https', 'data']) ? url : '//:0';\n  }\n  static value(domNode) {\n    return domNode.getAttribute('src');\n  }\n  format(name, value) {\n    if (ATTRIBUTES.indexOf(name) > -1) {\n      if (value) {\n        this.domNode.setAttribute(name, value);\n      } else {\n        this.domNode.removeAttribute(name);\n      }\n    } else {\n      super.format(name, value);\n    }\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Image);\n//# sourceMappingURL=image.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/image.js?")},"./node_modules/quill/formats/indent.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n\nclass IndentAttributor extends parchment__WEBPACK_IMPORTED_MODULE_0__.ClassAttributor {\n  add(node, value) {\n    let normalizedValue = 0;\n    if (value === '+1' || value === '-1') {\n      const indent = this.value(node) || 0;\n      normalizedValue = value === '+1' ? indent + 1 : indent - 1;\n    } else if (typeof value === 'number') {\n      normalizedValue = value;\n    }\n    if (normalizedValue === 0) {\n      this.remove(node);\n      return true;\n    }\n    return super.add(node, normalizedValue.toString());\n  }\n  canAdd(node, value) {\n    return super.canAdd(node, value) || super.canAdd(node, parseInt(value, 10));\n  }\n  value(node) {\n    return parseInt(super.value(node), 10) || undefined; // Don't return NaN\n  }\n}\nconst IndentClass = new IndentAttributor('indent', 'ql-indent', {\n  scope: parchment__WEBPACK_IMPORTED_MODULE_0__.Scope.BLOCK,\n  // @ts-expect-error\n  whitelist: [1, 2, 3, 4, 5, 6, 7, 8]\n});\n/* harmony default export */ __webpack_exports__[\"default\"] = (IndentClass);\n//# sourceMappingURL=indent.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/indent.js?")},"./node_modules/quill/formats/italic.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _bold_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bold.js */ \"./node_modules/quill/formats/bold.js\");\n\nclass Italic extends _bold_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  static blotName = 'italic';\n  static tagName = ['EM', 'I'];\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Italic);\n//# sourceMappingURL=italic.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/italic.js?")},"./node_modules/quill/formats/link.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": function() { return /* binding */ Link; },\n/* harmony export */   sanitize: function() { return /* binding */ sanitize; }\n/* harmony export */ });\n/* harmony import */ var _blots_inline_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/inline.js */ \"./node_modules/quill/blots/inline.js\");\n\nclass Link extends _blots_inline_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  static blotName = 'link';\n  static tagName = 'A';\n  static SANITIZED_URL = 'about:blank';\n  static PROTOCOL_WHITELIST = ['http', 'https', 'mailto', 'tel', 'sms'];\n  static create(value) {\n    const node = super.create(value);\n    node.setAttribute('href', this.sanitize(value));\n    node.setAttribute('rel', 'noopener noreferrer');\n    node.setAttribute('target', '_blank');\n    return node;\n  }\n  static formats(domNode) {\n    return domNode.getAttribute('href');\n  }\n  static sanitize(url) {\n    return sanitize(url, this.PROTOCOL_WHITELIST) ? url : this.SANITIZED_URL;\n  }\n  format(name, value) {\n    if (name !== this.statics.blotName || !value) {\n      super.format(name, value);\n    } else {\n      // @ts-expect-error\n      this.domNode.setAttribute('href', this.constructor.sanitize(value));\n    }\n  }\n}\nfunction sanitize(url, protocols) {\n  const anchor = document.createElement('a');\n  anchor.href = url;\n  const protocol = anchor.href.slice(0, anchor.href.indexOf(':'));\n  return protocols.indexOf(protocol) > -1;\n}\n\n//# sourceMappingURL=link.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/link.js?")},"./node_modules/quill/formats/list.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   ListContainer: function() { return /* binding */ ListContainer; },\n/* harmony export */   \"default\": function() { return /* binding */ ListItem; }\n/* harmony export */ });\n/* harmony import */ var _blots_block_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/block.js */ \"./node_modules/quill/blots/block.js\");\n/* harmony import */ var _blots_container_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../blots/container.js */ \"./node_modules/quill/blots/container.js\");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/quill.js */ \"./node_modules/quill/core/quill.js\");\n\n\n\nclass ListContainer extends _blots_container_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"] {}\nListContainer.blotName = 'list-container';\nListContainer.tagName = 'OL';\nclass ListItem extends _blots_block_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  static create(value) {\n    const node = super.create();\n    node.setAttribute('data-list', value);\n    return node;\n  }\n  static formats(domNode) {\n    return domNode.getAttribute('data-list') || undefined;\n  }\n  static register() {\n    _core_quill_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].register(ListContainer);\n  }\n  constructor(scroll, domNode) {\n    super(scroll, domNode);\n    const ui = domNode.ownerDocument.createElement('span');\n    const listEventHandler = e => {\n      if (!scroll.isEnabled()) return;\n      const format = this.statics.formats(domNode, scroll);\n      if (format === 'checked') {\n        this.format('list', 'unchecked');\n        e.preventDefault();\n      } else if (format === 'unchecked') {\n        this.format('list', 'checked');\n        e.preventDefault();\n      }\n    };\n    ui.addEventListener('mousedown', listEventHandler);\n    ui.addEventListener('touchstart', listEventHandler);\n    this.attachUI(ui);\n  }\n  format(name, value) {\n    if (name === this.statics.blotName && value) {\n      this.domNode.setAttribute('data-list', value);\n    } else {\n      super.format(name, value);\n    }\n  }\n}\nListItem.blotName = 'list';\nListItem.tagName = 'LI';\nListContainer.allowedChildren = [ListItem];\nListItem.requiredContainer = ListContainer;\n\n//# sourceMappingURL=list.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/list.js?")},"./node_modules/quill/formats/script.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _blots_inline_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/inline.js */ \"./node_modules/quill/blots/inline.js\");\n\nclass Script extends _blots_inline_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  static blotName = 'script';\n  static tagName = ['SUB', 'SUP'];\n  static create(value) {\n    if (value === 'super') {\n      return document.createElement('sup');\n    }\n    if (value === 'sub') {\n      return document.createElement('sub');\n    }\n    return super.create(value);\n  }\n  static formats(domNode) {\n    if (domNode.tagName === 'SUB') return 'sub';\n    if (domNode.tagName === 'SUP') return 'super';\n    return undefined;\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Script);\n//# sourceMappingURL=script.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/script.js?")},"./node_modules/quill/formats/size.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SizeClass: function() { return /* binding */ SizeClass; },\n/* harmony export */   SizeStyle: function() { return /* binding */ SizeStyle; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n\nconst SizeClass = new parchment__WEBPACK_IMPORTED_MODULE_0__.ClassAttributor('size', 'ql-size', {\n  scope: parchment__WEBPACK_IMPORTED_MODULE_0__.Scope.INLINE,\n  whitelist: ['small', 'large', 'huge']\n});\nconst SizeStyle = new parchment__WEBPACK_IMPORTED_MODULE_0__.StyleAttributor('size', 'font-size', {\n  scope: parchment__WEBPACK_IMPORTED_MODULE_0__.Scope.INLINE,\n  whitelist: ['10px', '18px', '32px']\n});\n\n//# sourceMappingURL=size.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/size.js?")},"./node_modules/quill/formats/strike.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _bold_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./bold.js */ \"./node_modules/quill/formats/bold.js\");\n\nclass Strike extends _bold_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  static blotName = 'strike';\n  static tagName = ['S', 'STRIKE'];\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Strike);\n//# sourceMappingURL=strike.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/strike.js?")},"./node_modules/quill/formats/table.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TableBody: function() { return /* binding */ TableBody; },\n/* harmony export */   TableCell: function() { return /* binding */ TableCell; },\n/* harmony export */   TableContainer: function() { return /* binding */ TableContainer; },\n/* harmony export */   TableRow: function() { return /* binding */ TableRow; },\n/* harmony export */   tableId: function() { return /* binding */ tableId; }\n/* harmony export */ });\n/* harmony import */ var _blots_block_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/block.js */ \"./node_modules/quill/blots/block.js\");\n/* harmony import */ var _blots_container_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../blots/container.js */ \"./node_modules/quill/blots/container.js\");\n\n\nclass TableCell extends _blots_block_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  static blotName = 'table';\n  static tagName = 'TD';\n  static create(value) {\n    const node = super.create();\n    if (value) {\n      node.setAttribute('data-row', value);\n    } else {\n      node.setAttribute('data-row', tableId());\n    }\n    return node;\n  }\n  static formats(domNode) {\n    if (domNode.hasAttribute('data-row')) {\n      return domNode.getAttribute('data-row');\n    }\n    return undefined;\n  }\n  cellOffset() {\n    if (this.parent) {\n      return this.parent.children.indexOf(this);\n    }\n    return -1;\n  }\n  format(name, value) {\n    if (name === TableCell.blotName && value) {\n      this.domNode.setAttribute('data-row', value);\n    } else {\n      super.format(name, value);\n    }\n  }\n  row() {\n    return this.parent;\n  }\n  rowOffset() {\n    if (this.row()) {\n      return this.row().rowOffset();\n    }\n    return -1;\n  }\n  table() {\n    return this.row() && this.row().table();\n  }\n}\nclass TableRow extends _blots_container_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"] {\n  static blotName = 'table-row';\n  static tagName = 'TR';\n  checkMerge() {\n    // @ts-expect-error\n    if (super.checkMerge() && this.next.children.head != null) {\n      // @ts-expect-error\n      const thisHead = this.children.head.formats();\n      // @ts-expect-error\n      const thisTail = this.children.tail.formats();\n      // @ts-expect-error\n      const nextHead = this.next.children.head.formats();\n      // @ts-expect-error\n      const nextTail = this.next.children.tail.formats();\n      return thisHead.table === thisTail.table && thisHead.table === nextHead.table && thisHead.table === nextTail.table;\n    }\n    return false;\n  }\n  optimize(context) {\n    super.optimize(context);\n    this.children.forEach(child => {\n      if (child.next == null) return;\n      const childFormats = child.formats();\n      const nextFormats = child.next.formats();\n      if (childFormats.table !== nextFormats.table) {\n        const next = this.splitAfter(child);\n        if (next) {\n          // @ts-expect-error TODO: parameters of optimize() should be a optional\n          next.optimize();\n        }\n        // We might be able to merge with prev now\n        if (this.prev) {\n          // @ts-expect-error TODO: parameters of optimize() should be a optional\n          this.prev.optimize();\n        }\n      }\n    });\n  }\n  rowOffset() {\n    if (this.parent) {\n      return this.parent.children.indexOf(this);\n    }\n    return -1;\n  }\n  table() {\n    return this.parent && this.parent.parent;\n  }\n}\nclass TableBody extends _blots_container_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"] {\n  static blotName = 'table-body';\n  static tagName = 'TBODY';\n}\nclass TableContainer extends _blots_container_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"] {\n  static blotName = 'table-container';\n  static tagName = 'TABLE';\n  balanceCells() {\n    const rows = this.descendants(TableRow);\n    const maxColumns = rows.reduce((max, row) => {\n      return Math.max(row.children.length, max);\n    }, 0);\n    rows.forEach(row => {\n      new Array(maxColumns - row.children.length).fill(0).forEach(() => {\n        let value;\n        if (row.children.head != null) {\n          value = TableCell.formats(row.children.head.domNode);\n        }\n        const blot = this.scroll.create(TableCell.blotName, value);\n        row.appendChild(blot);\n        // @ts-expect-error TODO: parameters of optimize() should be a optional\n        blot.optimize(); // Add break blot\n      });\n    });\n  }\n  cells(column) {\n    return this.rows().map(row => row.children.at(column));\n  }\n  deleteColumn(index) {\n    // @ts-expect-error\n    const [body] = this.descendant(TableBody);\n    if (body == null || body.children.head == null) return;\n    body.children.forEach(row => {\n      const cell = row.children.at(index);\n      if (cell != null) {\n        cell.remove();\n      }\n    });\n  }\n  insertColumn(index) {\n    // @ts-expect-error\n    const [body] = this.descendant(TableBody);\n    if (body == null || body.children.head == null) return;\n    body.children.forEach(row => {\n      const ref = row.children.at(index);\n      // @ts-expect-error\n      const value = TableCell.formats(row.children.head.domNode);\n      const cell = this.scroll.create(TableCell.blotName, value);\n      row.insertBefore(cell, ref);\n    });\n  }\n  insertRow(index) {\n    // @ts-expect-error\n    const [body] = this.descendant(TableBody);\n    if (body == null || body.children.head == null) return;\n    const id = tableId();\n    const row = this.scroll.create(TableRow.blotName);\n    body.children.head.children.forEach(() => {\n      const cell = this.scroll.create(TableCell.blotName, id);\n      row.appendChild(cell);\n    });\n    const ref = body.children.at(index);\n    body.insertBefore(row, ref);\n  }\n  rows() {\n    const body = this.children.head;\n    if (body == null) return [];\n    return body.children.map(row => row);\n  }\n}\nTableContainer.allowedChildren = [TableBody];\nTableBody.requiredContainer = TableContainer;\nTableBody.allowedChildren = [TableRow];\nTableRow.requiredContainer = TableBody;\nTableRow.allowedChildren = [TableCell];\nTableCell.requiredContainer = TableRow;\nfunction tableId() {\n  const id = Math.random().toString(36).slice(2, 6);\n  return `row-${id}`;\n}\n\n//# sourceMappingURL=table.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/table.js?")},"./node_modules/quill/formats/underline.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _blots_inline_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/inline.js */ "./node_modules/quill/blots/inline.js");\n\nclass Underline extends _blots_inline_js__WEBPACK_IMPORTED_MODULE_0__["default"] {\n  static blotName = \'underline\';\n  static tagName = \'U\';\n}\n/* harmony default export */ __webpack_exports__["default"] = (Underline);\n//# sourceMappingURL=underline.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/underline.js?')},"./node_modules/quill/formats/video.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _blots_block_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../blots/block.js */ \"./node_modules/quill/blots/block.js\");\n/* harmony import */ var _link_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./link.js */ \"./node_modules/quill/formats/link.js\");\n\n\nconst ATTRIBUTES = ['height', 'width'];\nclass Video extends _blots_block_js__WEBPACK_IMPORTED_MODULE_0__.BlockEmbed {\n  static blotName = 'video';\n  static className = 'ql-video';\n  static tagName = 'IFRAME';\n  static create(value) {\n    const node = super.create(value);\n    node.setAttribute('frameborder', '0');\n    node.setAttribute('allowfullscreen', 'true');\n    node.setAttribute('src', this.sanitize(value));\n    return node;\n  }\n  static formats(domNode) {\n    return ATTRIBUTES.reduce((formats, attribute) => {\n      if (domNode.hasAttribute(attribute)) {\n        formats[attribute] = domNode.getAttribute(attribute);\n      }\n      return formats;\n    }, {});\n  }\n  static sanitize(url) {\n    return _link_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sanitize(url);\n  }\n  static value(domNode) {\n    return domNode.getAttribute('src');\n  }\n  format(name, value) {\n    if (ATTRIBUTES.indexOf(name) > -1) {\n      if (value) {\n        this.domNode.setAttribute(name, value);\n      } else {\n        this.domNode.removeAttribute(name);\n      }\n    } else {\n      super.format(name, value);\n    }\n  }\n  html() {\n    const {\n      video\n    } = this.value();\n    return `<a href=\"${video}\">${video}</a>`;\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Video);\n//# sourceMappingURL=video.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/formats/video.js?")},"./node_modules/quill/modules/clipboard.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": function() { return /* binding */ Clipboard; },\n/* harmony export */   matchAttributor: function() { return /* binding */ matchAttributor; },\n/* harmony export */   matchBlot: function() { return /* binding */ matchBlot; },\n/* harmony export */   matchNewline: function() { return /* binding */ matchNewline; },\n/* harmony export */   matchText: function() { return /* binding */ matchText; },\n/* harmony export */   traverse: function() { return /* binding */ traverse; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill-delta */ \"./node_modules/quill-delta/dist/Delta.js\");\n/* harmony import */ var _blots_block_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../blots/block.js */ \"./node_modules/quill/blots/block.js\");\n/* harmony import */ var _core_logger_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/logger.js */ \"./node_modules/quill/core/logger.js\");\n/* harmony import */ var _core_module_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/module.js */ \"./node_modules/quill/core/module.js\");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/quill.js */ \"./node_modules/quill/core/quill.js\");\n/* harmony import */ var _formats_align_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../formats/align.js */ \"./node_modules/quill/formats/align.js\");\n/* harmony import */ var _formats_background_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../formats/background.js */ \"./node_modules/quill/formats/background.js\");\n/* harmony import */ var _formats_code_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../formats/code.js */ \"./node_modules/quill/formats/code.js\");\n/* harmony import */ var _formats_color_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../formats/color.js */ \"./node_modules/quill/formats/color.js\");\n/* harmony import */ var _formats_direction_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../formats/direction.js */ \"./node_modules/quill/formats/direction.js\");\n/* harmony import */ var _formats_font_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../formats/font.js */ \"./node_modules/quill/formats/font.js\");\n/* harmony import */ var _formats_size_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../formats/size.js */ \"./node_modules/quill/formats/size.js\");\n/* harmony import */ var _keyboard_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./keyboard.js */ \"./node_modules/quill/modules/keyboard.js\");\n/* harmony import */ var _normalizeExternalHTML_index_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./normalizeExternalHTML/index.js */ \"./node_modules/quill/modules/normalizeExternalHTML/index.js\");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\nconst debug = (0,_core_logger_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])('quill:clipboard');\nconst CLIPBOARD_CONFIG = [[Node.TEXT_NODE, matchText], [Node.TEXT_NODE, matchNewline], ['br', matchBreak], [Node.ELEMENT_NODE, matchNewline], [Node.ELEMENT_NODE, matchBlot], [Node.ELEMENT_NODE, matchAttributor], [Node.ELEMENT_NODE, matchStyles], ['li', matchIndent], ['ol, ul', matchList], ['pre', matchCodeBlock], ['tr', matchTable], ['b', createMatchAlias('bold')], ['i', createMatchAlias('italic')], ['strike', createMatchAlias('strike')], ['style', matchIgnore]];\nconst ATTRIBUTE_ATTRIBUTORS = [_formats_align_js__WEBPACK_IMPORTED_MODULE_5__.AlignAttribute, _formats_direction_js__WEBPACK_IMPORTED_MODULE_9__.DirectionAttribute].reduce((memo, attr) => {\n  memo[attr.keyName] = attr;\n  return memo;\n}, {});\nconst STYLE_ATTRIBUTORS = [_formats_align_js__WEBPACK_IMPORTED_MODULE_5__.AlignStyle, _formats_background_js__WEBPACK_IMPORTED_MODULE_6__.BackgroundStyle, _formats_color_js__WEBPACK_IMPORTED_MODULE_8__.ColorStyle, _formats_direction_js__WEBPACK_IMPORTED_MODULE_9__.DirectionStyle, _formats_font_js__WEBPACK_IMPORTED_MODULE_10__.FontStyle, _formats_size_js__WEBPACK_IMPORTED_MODULE_11__.SizeStyle].reduce((memo, attr) => {\n  memo[attr.keyName] = attr;\n  return memo;\n}, {});\nclass Clipboard extends _core_module_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"] {\n  static DEFAULTS = {\n    matchers: []\n  };\n  constructor(quill, options) {\n    super(quill, options);\n    this.quill.root.addEventListener('copy', e => this.onCaptureCopy(e, false));\n    this.quill.root.addEventListener('cut', e => this.onCaptureCopy(e, true));\n    this.quill.root.addEventListener('paste', this.onCapturePaste.bind(this));\n    this.matchers = [];\n    CLIPBOARD_CONFIG.concat(this.options.matchers ?? []).forEach(_ref => {\n      let [selector, matcher] = _ref;\n      this.addMatcher(selector, matcher);\n    });\n  }\n  addMatcher(selector, matcher) {\n    this.matchers.push([selector, matcher]);\n  }\n  convert(_ref2) {\n    let {\n      html,\n      text\n    } = _ref2;\n    let formats = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n    if (formats[_formats_code_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"].blotName]) {\n      return new quill_delta__WEBPACK_IMPORTED_MODULE_0__().insert(text || '', {\n        [_formats_code_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"].blotName]: formats[_formats_code_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"].blotName]\n      });\n    }\n    if (!html) {\n      return new quill_delta__WEBPACK_IMPORTED_MODULE_0__().insert(text || '', formats);\n    }\n    const delta = this.convertHTML(html);\n    // Remove trailing newline\n    if (deltaEndsWith(delta, '\\n') && (delta.ops[delta.ops.length - 1].attributes == null || formats.table)) {\n      return delta.compose(new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(delta.length() - 1).delete(1));\n    }\n    return delta;\n  }\n  normalizeHTML(doc) {\n    (0,_normalizeExternalHTML_index_js__WEBPACK_IMPORTED_MODULE_13__[\"default\"])(doc);\n  }\n  convertHTML(html) {\n    const doc = new DOMParser().parseFromString(html, 'text/html');\n    this.normalizeHTML(doc);\n    const container = doc.body;\n    const nodeMatches = new WeakMap();\n    const [elementMatchers, textMatchers] = this.prepareMatching(container, nodeMatches);\n    return traverse(this.quill.scroll, container, elementMatchers, textMatchers, nodeMatches);\n  }\n  dangerouslyPasteHTML(index, html) {\n    let source = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : _core_quill_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].sources.API;\n    if (typeof index === 'string') {\n      const delta = this.convert({\n        html: index,\n        text: ''\n      });\n      // @ts-expect-error\n      this.quill.setContents(delta, html);\n      this.quill.setSelection(0, _core_quill_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].sources.SILENT);\n    } else {\n      const paste = this.convert({\n        html,\n        text: ''\n      });\n      this.quill.updateContents(new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(index).concat(paste), source);\n      this.quill.setSelection(index + paste.length(), _core_quill_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].sources.SILENT);\n    }\n  }\n  onCaptureCopy(e) {\n    let isCut = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n    if (e.defaultPrevented) return;\n    e.preventDefault();\n    const [range] = this.quill.selection.getRange();\n    if (range == null) return;\n    const {\n      html,\n      text\n    } = this.onCopy(range, isCut);\n    e.clipboardData?.setData('text/plain', text);\n    e.clipboardData?.setData('text/html', html);\n    if (isCut) {\n      (0,_keyboard_js__WEBPACK_IMPORTED_MODULE_12__.deleteRange)({\n        range,\n        quill: this.quill\n      });\n    }\n  }\n\n  /*\n   * https://www.iana.org/assignments/media-types/text/uri-list\n   */\n  normalizeURIList(urlList) {\n    return urlList.split(/\\r?\\n/)\n    // Ignore all comments\n    .filter(url => url[0] !== '#').join('\\n');\n  }\n  onCapturePaste(e) {\n    if (e.defaultPrevented || !this.quill.isEnabled()) return;\n    e.preventDefault();\n    const range = this.quill.getSelection(true);\n    if (range == null) return;\n    const html = e.clipboardData?.getData('text/html');\n    let text = e.clipboardData?.getData('text/plain');\n    if (!html && !text) {\n      const urlList = e.clipboardData?.getData('text/uri-list');\n      if (urlList) {\n        text = this.normalizeURIList(urlList);\n      }\n    }\n    const files = Array.from(e.clipboardData?.files || []);\n    if (!html && files.length > 0) {\n      this.quill.uploader.upload(range, files);\n      return;\n    }\n    if (html && files.length > 0) {\n      const doc = new DOMParser().parseFromString(html, 'text/html');\n      if (doc.body.childElementCount === 1 && doc.body.firstElementChild?.tagName === 'IMG') {\n        this.quill.uploader.upload(range, files);\n        return;\n      }\n    }\n    this.onPaste(range, {\n      html,\n      text\n    });\n  }\n  onCopy(range) {\n    const text = this.quill.getText(range);\n    const html = this.quill.getSemanticHTML(range);\n    return {\n      html,\n      text\n    };\n  }\n  onPaste(range, _ref3) {\n    let {\n      text,\n      html\n    } = _ref3;\n    const formats = this.quill.getFormat(range.index);\n    const pastedDelta = this.convert({\n      text,\n      html\n    }, formats);\n    debug.log('onPaste', pastedDelta, {\n      text,\n      html\n    });\n    const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(range.index).delete(range.length).concat(pastedDelta);\n    this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].sources.USER);\n    // range.length contributes to delta.length()\n    this.quill.setSelection(delta.length() - range.length, _core_quill_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"].sources.SILENT);\n    this.quill.scrollSelectionIntoView();\n  }\n  prepareMatching(container, nodeMatches) {\n    const elementMatchers = [];\n    const textMatchers = [];\n    this.matchers.forEach(pair => {\n      const [selector, matcher] = pair;\n      switch (selector) {\n        case Node.TEXT_NODE:\n          textMatchers.push(matcher);\n          break;\n        case Node.ELEMENT_NODE:\n          elementMatchers.push(matcher);\n          break;\n        default:\n          Array.from(container.querySelectorAll(selector)).forEach(node => {\n            if (nodeMatches.has(node)) {\n              const matches = nodeMatches.get(node);\n              matches?.push(matcher);\n            } else {\n              nodeMatches.set(node, [matcher]);\n            }\n          });\n          break;\n      }\n    });\n    return [elementMatchers, textMatchers];\n  }\n}\nfunction applyFormat(delta, format, value, scroll) {\n  if (!scroll.query(format)) {\n    return delta;\n  }\n  return delta.reduce((newDelta, op) => {\n    if (!op.insert) return newDelta;\n    if (op.attributes && op.attributes[format]) {\n      return newDelta.push(op);\n    }\n    const formats = value ? {\n      [format]: value\n    } : {};\n    return newDelta.insert(op.insert, {\n      ...formats,\n      ...op.attributes\n    });\n  }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__());\n}\nfunction deltaEndsWith(delta, text) {\n  let endText = '';\n  for (let i = delta.ops.length - 1; i >= 0 && endText.length < text.length; --i // eslint-disable-line no-plusplus\n  ) {\n    const op = delta.ops[i];\n    if (typeof op.insert !== 'string') break;\n    endText = op.insert + endText;\n  }\n  return endText.slice(-1 * text.length) === text;\n}\nfunction isLine(node, scroll) {\n  if (!(node instanceof Element)) return false;\n  const match = scroll.query(node);\n  // @ts-expect-error\n  if (match && match.prototype instanceof parchment__WEBPACK_IMPORTED_MODULE_14__.EmbedBlot) return false;\n  return ['address', 'article', 'blockquote', 'canvas', 'dd', 'div', 'dl', 'dt', 'fieldset', 'figcaption', 'figure', 'footer', 'form', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6', 'header', 'iframe', 'li', 'main', 'nav', 'ol', 'output', 'p', 'pre', 'section', 'table', 'td', 'tr', 'ul', 'video'].includes(node.tagName.toLowerCase());\n}\nfunction isBetweenInlineElements(node, scroll) {\n  return node.previousElementSibling && node.nextElementSibling && !isLine(node.previousElementSibling, scroll) && !isLine(node.nextElementSibling, scroll);\n}\nconst preNodes = new WeakMap();\nfunction isPre(node) {\n  if (node == null) return false;\n  if (!preNodes.has(node)) {\n    // @ts-expect-error\n    if (node.tagName === 'PRE') {\n      preNodes.set(node, true);\n    } else {\n      preNodes.set(node, isPre(node.parentNode));\n    }\n  }\n  return preNodes.get(node);\n}\nfunction traverse(scroll, node, elementMatchers, textMatchers, nodeMatches) {\n  // Post-order\n  if (node.nodeType === node.TEXT_NODE) {\n    return textMatchers.reduce((delta, matcher) => {\n      return matcher(node, delta, scroll);\n    }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__());\n  }\n  if (node.nodeType === node.ELEMENT_NODE) {\n    return Array.from(node.childNodes || []).reduce((delta, childNode) => {\n      let childrenDelta = traverse(scroll, childNode, elementMatchers, textMatchers, nodeMatches);\n      if (childNode.nodeType === node.ELEMENT_NODE) {\n        childrenDelta = elementMatchers.reduce((reducedDelta, matcher) => {\n          return matcher(childNode, reducedDelta, scroll);\n        }, childrenDelta);\n        childrenDelta = (nodeMatches.get(childNode) || []).reduce((reducedDelta, matcher) => {\n          return matcher(childNode, reducedDelta, scroll);\n        }, childrenDelta);\n      }\n      return delta.concat(childrenDelta);\n    }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__());\n  }\n  return new quill_delta__WEBPACK_IMPORTED_MODULE_0__();\n}\nfunction createMatchAlias(format) {\n  return (_node, delta, scroll) => {\n    return applyFormat(delta, format, true, scroll);\n  };\n}\nfunction matchAttributor(node, delta, scroll) {\n  const attributes = parchment__WEBPACK_IMPORTED_MODULE_14__.Attributor.keys(node);\n  const classes = parchment__WEBPACK_IMPORTED_MODULE_14__.ClassAttributor.keys(node);\n  const styles = parchment__WEBPACK_IMPORTED_MODULE_14__.StyleAttributor.keys(node);\n  const formats = {};\n  attributes.concat(classes).concat(styles).forEach(name => {\n    let attr = scroll.query(name, parchment__WEBPACK_IMPORTED_MODULE_14__.Scope.ATTRIBUTE);\n    if (attr != null) {\n      formats[attr.attrName] = attr.value(node);\n      if (formats[attr.attrName]) return;\n    }\n    attr = ATTRIBUTE_ATTRIBUTORS[name];\n    if (attr != null && (attr.attrName === name || attr.keyName === name)) {\n      formats[attr.attrName] = attr.value(node) || undefined;\n    }\n    attr = STYLE_ATTRIBUTORS[name];\n    if (attr != null && (attr.attrName === name || attr.keyName === name)) {\n      attr = STYLE_ATTRIBUTORS[name];\n      formats[attr.attrName] = attr.value(node) || undefined;\n    }\n  });\n  return Object.entries(formats).reduce((newDelta, _ref4) => {\n    let [name, value] = _ref4;\n    return applyFormat(newDelta, name, value, scroll);\n  }, delta);\n}\nfunction matchBlot(node, delta, scroll) {\n  const match = scroll.query(node);\n  if (match == null) return delta;\n  // @ts-expect-error\n  if (match.prototype instanceof parchment__WEBPACK_IMPORTED_MODULE_14__.EmbedBlot) {\n    const embed = {};\n    // @ts-expect-error\n    const value = match.value(node);\n    if (value != null) {\n      // @ts-expect-error\n      embed[match.blotName] = value;\n      // @ts-expect-error\n      return new quill_delta__WEBPACK_IMPORTED_MODULE_0__().insert(embed, match.formats(node, scroll));\n    }\n  } else {\n    // @ts-expect-error\n    if (match.prototype instanceof parchment__WEBPACK_IMPORTED_MODULE_14__.BlockBlot && !deltaEndsWith(delta, '\\n')) {\n      delta.insert('\\n');\n    }\n    if ('blotName' in match && 'formats' in match && typeof match.formats === 'function') {\n      return applyFormat(delta, match.blotName, match.formats(node, scroll), scroll);\n    }\n  }\n  return delta;\n}\nfunction matchBreak(node, delta) {\n  if (!deltaEndsWith(delta, '\\n')) {\n    delta.insert('\\n');\n  }\n  return delta;\n}\nfunction matchCodeBlock(node, delta, scroll) {\n  const match = scroll.query('code-block');\n  const language = match && 'formats' in match && typeof match.formats === 'function' ? match.formats(node, scroll) : true;\n  return applyFormat(delta, 'code-block', language, scroll);\n}\nfunction matchIgnore() {\n  return new quill_delta__WEBPACK_IMPORTED_MODULE_0__();\n}\nfunction matchIndent(node, delta, scroll) {\n  const match = scroll.query(node);\n  if (match == null ||\n  // @ts-expect-error\n  match.blotName !== 'list' || !deltaEndsWith(delta, '\\n')) {\n    return delta;\n  }\n  let indent = -1;\n  let parent = node.parentNode;\n  while (parent != null) {\n    // @ts-expect-error\n    if (['OL', 'UL'].includes(parent.tagName)) {\n      indent += 1;\n    }\n    parent = parent.parentNode;\n  }\n  if (indent <= 0) return delta;\n  return delta.reduce((composed, op) => {\n    if (!op.insert) return composed;\n    if (op.attributes && typeof op.attributes.indent === 'number') {\n      return composed.push(op);\n    }\n    return composed.insert(op.insert, {\n      indent,\n      ...(op.attributes || {})\n    });\n  }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__());\n}\nfunction matchList(node, delta, scroll) {\n  const element = node;\n  let list = element.tagName === 'OL' ? 'ordered' : 'bullet';\n  const checkedAttr = element.getAttribute('data-checked');\n  if (checkedAttr) {\n    list = checkedAttr === 'true' ? 'checked' : 'unchecked';\n  }\n  return applyFormat(delta, 'list', list, scroll);\n}\nfunction matchNewline(node, delta, scroll) {\n  if (!deltaEndsWith(delta, '\\n')) {\n    if (isLine(node, scroll) && (node.childNodes.length > 0 || node instanceof HTMLParagraphElement)) {\n      return delta.insert('\\n');\n    }\n    if (delta.length() > 0 && node.nextSibling) {\n      let nextSibling = node.nextSibling;\n      while (nextSibling != null) {\n        if (isLine(nextSibling, scroll)) {\n          return delta.insert('\\n');\n        }\n        const match = scroll.query(nextSibling);\n        // @ts-expect-error\n        if (match && match.prototype instanceof _blots_block_js__WEBPACK_IMPORTED_MODULE_1__.BlockEmbed) {\n          return delta.insert('\\n');\n        }\n        nextSibling = nextSibling.firstChild;\n      }\n    }\n  }\n  return delta;\n}\nfunction matchStyles(node, delta, scroll) {\n  const formats = {};\n  const style = node.style || {};\n  if (style.fontStyle === 'italic') {\n    formats.italic = true;\n  }\n  if (style.textDecoration === 'underline') {\n    formats.underline = true;\n  }\n  if (style.textDecoration === 'line-through') {\n    formats.strike = true;\n  }\n  if (style.fontWeight?.startsWith('bold') ||\n  // @ts-expect-error Fix me later\n  parseInt(style.fontWeight, 10) >= 700) {\n    formats.bold = true;\n  }\n  delta = Object.entries(formats).reduce((newDelta, _ref5) => {\n    let [name, value] = _ref5;\n    return applyFormat(newDelta, name, value, scroll);\n  }, delta);\n  // @ts-expect-error\n  if (parseFloat(style.textIndent || 0) > 0) {\n    // Could be 0.5in\n    return new quill_delta__WEBPACK_IMPORTED_MODULE_0__().insert('\\t').concat(delta);\n  }\n  return delta;\n}\nfunction matchTable(node, delta, scroll) {\n  const table = node.parentElement?.tagName === 'TABLE' ? node.parentElement : node.parentElement?.parentElement;\n  if (table != null) {\n    const rows = Array.from(table.querySelectorAll('tr'));\n    const row = rows.indexOf(node) + 1;\n    return applyFormat(delta, 'table', row, scroll);\n  }\n  return delta;\n}\nfunction matchText(node, delta, scroll) {\n  // @ts-expect-error\n  let text = node.data;\n  // Word represents empty line with <o:p>&nbsp;</o:p>\n  if (node.parentElement?.tagName === 'O:P') {\n    return delta.insert(text.trim());\n  }\n  if (!isPre(node)) {\n    if (text.trim().length === 0 && text.includes('\\n') && !isBetweenInlineElements(node, scroll)) {\n      return delta;\n    }\n    // convert all non-nbsp whitespace into regular space\n    text = text.replace(/[^\\S\\u00a0]/g, ' ');\n    // collapse consecutive spaces into one\n    text = text.replace(/ {2,}/g, ' ');\n    if (node.previousSibling == null && node.parentElement != null && isLine(node.parentElement, scroll) || node.previousSibling instanceof Element && isLine(node.previousSibling, scroll)) {\n      // block structure means we don't need leading space\n      text = text.replace(/^ /, '');\n    }\n    if (node.nextSibling == null && node.parentElement != null && isLine(node.parentElement, scroll) || node.nextSibling instanceof Element && isLine(node.nextSibling, scroll)) {\n      // block structure means we don't need trailing space\n      text = text.replace(/ $/, '');\n    }\n    // done removing whitespace and can normalize all to regular space\n    text = text.replaceAll('\\u00a0', ' ');\n  }\n  return delta.insert(text);\n}\n\n//# sourceMappingURL=clipboard.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/clipboard.js?")},"./node_modules/quill/modules/history.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": function() { return /* binding */ History; },\n/* harmony export */   getLastChangeIndex: function() { return /* binding */ getLastChangeIndex; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var _core_module_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/module.js */ \"./node_modules/quill/core/module.js\");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/quill.js */ \"./node_modules/quill/core/quill.js\");\n\n\n\nclass History extends _core_module_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  static DEFAULTS = {\n    delay: 1000,\n    maxStack: 100,\n    userOnly: false\n  };\n  lastRecorded = 0;\n  ignoreChange = false;\n  stack = {\n    undo: [],\n    redo: []\n  };\n  currentRange = null;\n  constructor(quill, options) {\n    super(quill, options);\n    this.quill.on(_core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].events.EDITOR_CHANGE, (eventName, value, oldValue, source) => {\n      if (eventName === _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].events.SELECTION_CHANGE) {\n        if (value && source !== _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.SILENT) {\n          this.currentRange = value;\n        }\n      } else if (eventName === _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].events.TEXT_CHANGE) {\n        if (!this.ignoreChange) {\n          if (!this.options.userOnly || source === _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER) {\n            this.record(value, oldValue);\n          } else {\n            this.transform(value);\n          }\n        }\n        this.currentRange = transformRange(this.currentRange, value);\n      }\n    });\n    this.quill.keyboard.addBinding({\n      key: 'z',\n      shortKey: true\n    }, this.undo.bind(this));\n    this.quill.keyboard.addBinding({\n      key: ['z', 'Z'],\n      shortKey: true,\n      shiftKey: true\n    }, this.redo.bind(this));\n    if (/Win/i.test(navigator.platform)) {\n      this.quill.keyboard.addBinding({\n        key: 'y',\n        shortKey: true\n      }, this.redo.bind(this));\n    }\n    this.quill.root.addEventListener('beforeinput', event => {\n      if (event.inputType === 'historyUndo') {\n        this.undo();\n        event.preventDefault();\n      } else if (event.inputType === 'historyRedo') {\n        this.redo();\n        event.preventDefault();\n      }\n    });\n  }\n  change(source, dest) {\n    if (this.stack[source].length === 0) return;\n    const item = this.stack[source].pop();\n    if (!item) return;\n    const base = this.quill.getContents();\n    const inverseDelta = item.delta.invert(base);\n    this.stack[dest].push({\n      delta: inverseDelta,\n      range: transformRange(item.range, inverseDelta)\n    });\n    this.lastRecorded = 0;\n    this.ignoreChange = true;\n    this.quill.updateContents(item.delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n    this.ignoreChange = false;\n    this.restoreSelection(item);\n  }\n  clear() {\n    this.stack = {\n      undo: [],\n      redo: []\n    };\n  }\n  cutoff() {\n    this.lastRecorded = 0;\n  }\n  record(changeDelta, oldDelta) {\n    if (changeDelta.ops.length === 0) return;\n    this.stack.redo = [];\n    let undoDelta = changeDelta.invert(oldDelta);\n    let undoRange = this.currentRange;\n    const timestamp = Date.now();\n    if (\n    // @ts-expect-error Fix me later\n    this.lastRecorded + this.options.delay > timestamp && this.stack.undo.length > 0) {\n      const item = this.stack.undo.pop();\n      if (item) {\n        undoDelta = undoDelta.compose(item.delta);\n        undoRange = item.range;\n      }\n    } else {\n      this.lastRecorded = timestamp;\n    }\n    if (undoDelta.length() === 0) return;\n    this.stack.undo.push({\n      delta: undoDelta,\n      range: undoRange\n    });\n    // @ts-expect-error Fix me later\n    if (this.stack.undo.length > this.options.maxStack) {\n      this.stack.undo.shift();\n    }\n  }\n  redo() {\n    this.change('redo', 'undo');\n  }\n  transform(delta) {\n    transformStack(this.stack.undo, delta);\n    transformStack(this.stack.redo, delta);\n  }\n  undo() {\n    this.change('undo', 'redo');\n  }\n  restoreSelection(stackItem) {\n    if (stackItem.range) {\n      this.quill.setSelection(stackItem.range, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n    } else {\n      const index = getLastChangeIndex(this.quill.scroll, stackItem.delta);\n      this.quill.setSelection(index, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n    }\n  }\n}\nfunction transformStack(stack, delta) {\n  let remoteDelta = delta;\n  for (let i = stack.length - 1; i >= 0; i -= 1) {\n    const oldItem = stack[i];\n    stack[i] = {\n      delta: remoteDelta.transform(oldItem.delta, true),\n      range: oldItem.range && transformRange(oldItem.range, remoteDelta)\n    };\n    remoteDelta = oldItem.delta.transform(remoteDelta);\n    if (stack[i].delta.length() === 0) {\n      stack.splice(i, 1);\n    }\n  }\n}\nfunction endsWithNewlineChange(scroll, delta) {\n  const lastOp = delta.ops[delta.ops.length - 1];\n  if (lastOp == null) return false;\n  if (lastOp.insert != null) {\n    return typeof lastOp.insert === 'string' && lastOp.insert.endsWith('\\n');\n  }\n  if (lastOp.attributes != null) {\n    return Object.keys(lastOp.attributes).some(attr => {\n      return scroll.query(attr, parchment__WEBPACK_IMPORTED_MODULE_2__.Scope.BLOCK) != null;\n    });\n  }\n  return false;\n}\nfunction getLastChangeIndex(scroll, delta) {\n  const deleteLength = delta.reduce((length, op) => {\n    return length + (op.delete || 0);\n  }, 0);\n  let changeIndex = delta.length() - deleteLength;\n  if (endsWithNewlineChange(scroll, delta)) {\n    changeIndex -= 1;\n  }\n  return changeIndex;\n}\nfunction transformRange(range, delta) {\n  if (!range) return range;\n  const start = delta.transformPosition(range.index);\n  const end = delta.transformPosition(range.index + range.length);\n  return {\n    index: start,\n    length: end - start\n  };\n}\n\n//# sourceMappingURL=history.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/history.js?")},"./node_modules/quill/modules/input.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill-delta */ "./node_modules/quill-delta/dist/Delta.js");\n/* harmony import */ var _core_module_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/module.js */ "./node_modules/quill/core/module.js");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/quill.js */ "./node_modules/quill/core/quill.js");\n/* harmony import */ var _keyboard_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./keyboard.js */ "./node_modules/quill/modules/keyboard.js");\n\n\n\n\nconst INSERT_TYPES = [\'insertText\', \'insertReplacementText\'];\nclass Input extends _core_module_js__WEBPACK_IMPORTED_MODULE_1__["default"] {\n  constructor(quill, options) {\n    super(quill, options);\n    quill.root.addEventListener(\'beforeinput\', event => {\n      this.handleBeforeInput(event);\n    });\n\n    // Gboard with English input on Android triggers `compositionstart` sometimes even\n    // users are not going to type anything.\n    if (!/Android/i.test(navigator.userAgent)) {\n      quill.on(_core_quill_js__WEBPACK_IMPORTED_MODULE_2__["default"].events.COMPOSITION_BEFORE_START, () => {\n        this.handleCompositionStart();\n      });\n    }\n  }\n  deleteRange(range) {\n    (0,_keyboard_js__WEBPACK_IMPORTED_MODULE_3__.deleteRange)({\n      range,\n      quill: this.quill\n    });\n  }\n  replaceText(range) {\n    let text = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : \'\';\n    if (range.length === 0) return false;\n    if (text) {\n      // Follow the native behavior that inherits the formats of the first character\n      const formats = this.quill.getFormat(range.index, 1);\n      this.deleteRange(range);\n      this.quill.updateContents(new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(range.index).insert(text, formats), _core_quill_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.USER);\n    } else {\n      this.deleteRange(range);\n    }\n    this.quill.setSelection(range.index + text.length, 0, _core_quill_js__WEBPACK_IMPORTED_MODULE_2__["default"].sources.SILENT);\n    return true;\n  }\n  handleBeforeInput(event) {\n    if (this.quill.composition.isComposing || event.defaultPrevented || !INSERT_TYPES.includes(event.inputType)) {\n      return;\n    }\n    const staticRange = event.getTargetRanges ? event.getTargetRanges()[0] : null;\n    if (!staticRange || staticRange.collapsed === true) {\n      return;\n    }\n    const text = getPlainTextFromInputEvent(event);\n    if (text == null) {\n      return;\n    }\n    const normalized = this.quill.selection.normalizeNative(staticRange);\n    const range = normalized ? this.quill.selection.normalizedToRange(normalized) : null;\n    if (range && this.replaceText(range, text)) {\n      event.preventDefault();\n    }\n  }\n  handleCompositionStart() {\n    const range = this.quill.getSelection();\n    if (range) {\n      this.replaceText(range);\n    }\n  }\n}\nfunction getPlainTextFromInputEvent(event) {\n  // When `inputType` is "insertText":\n  // - `event.data` should be string (Safari uses `event.dataTransfer`).\n  // - `event.dataTransfer` should be null.\n  // When `inputType` is "insertReplacementText":\n  // - `event.data` should be null.\n  // - `event.dataTransfer` should contain "text/plain" data.\n\n  if (typeof event.data === \'string\') {\n    return event.data;\n  }\n  if (event.dataTransfer?.types.includes(\'text/plain\')) {\n    return event.dataTransfer.getData(\'text/plain\');\n  }\n  return null;\n}\n/* harmony default export */ __webpack_exports__["default"] = (Input);\n//# sourceMappingURL=input.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/input.js?')},"./node_modules/quill/modules/keyboard.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   SHORTKEY: function() { return /* binding */ SHORTKEY; },\n/* harmony export */   \"default\": function() { return /* binding */ Keyboard; },\n/* harmony export */   deleteRange: function() { return /* binding */ deleteRange; },\n/* harmony export */   normalize: function() { return /* binding */ normalize; }\n/* harmony export */ });\n/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash-es */ \"./node_modules/lodash-es/isEqual.js\");\n/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash-es */ \"./node_modules/lodash-es/cloneDeep.js\");\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill-delta */ \"./node_modules/quill-delta/dist/Delta.js\");\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/quill.js */ \"./node_modules/quill/core/quill.js\");\n/* harmony import */ var _core_logger_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/logger.js */ \"./node_modules/quill/core/logger.js\");\n/* harmony import */ var _core_module_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/module.js */ \"./node_modules/quill/core/module.js\");\n\n\n\n\n\n\nconst debug = (0,_core_logger_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])('quill:keyboard');\nconst SHORTKEY = /Mac/i.test(navigator.platform) ? 'metaKey' : 'ctrlKey';\nclass Keyboard extends _core_module_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"] {\n  static match(evt, binding) {\n    if (['altKey', 'ctrlKey', 'metaKey', 'shiftKey'].some(key => {\n      return !!binding[key] !== evt[key] && binding[key] !== null;\n    })) {\n      return false;\n    }\n    return binding.key === evt.key || binding.key === evt.which;\n  }\n  constructor(quill, options) {\n    super(quill, options);\n    this.bindings = {};\n    // @ts-expect-error Fix me later\n    Object.keys(this.options.bindings).forEach(name => {\n      // @ts-expect-error Fix me later\n      if (this.options.bindings[name]) {\n        // @ts-expect-error Fix me later\n        this.addBinding(this.options.bindings[name]);\n      }\n    });\n    this.addBinding({\n      key: 'Enter',\n      shiftKey: null\n    }, this.handleEnter);\n    this.addBinding({\n      key: 'Enter',\n      metaKey: null,\n      ctrlKey: null,\n      altKey: null\n    }, () => {});\n    if (/Firefox/i.test(navigator.userAgent)) {\n      // Need to handle delete and backspace for Firefox in the general case #1171\n      this.addBinding({\n        key: 'Backspace'\n      }, {\n        collapsed: true\n      }, this.handleBackspace);\n      this.addBinding({\n        key: 'Delete'\n      }, {\n        collapsed: true\n      }, this.handleDelete);\n    } else {\n      this.addBinding({\n        key: 'Backspace'\n      }, {\n        collapsed: true,\n        prefix: /^.?$/\n      }, this.handleBackspace);\n      this.addBinding({\n        key: 'Delete'\n      }, {\n        collapsed: true,\n        suffix: /^.?$/\n      }, this.handleDelete);\n    }\n    this.addBinding({\n      key: 'Backspace'\n    }, {\n      collapsed: false\n    }, this.handleDeleteRange);\n    this.addBinding({\n      key: 'Delete'\n    }, {\n      collapsed: false\n    }, this.handleDeleteRange);\n    this.addBinding({\n      key: 'Backspace',\n      altKey: null,\n      ctrlKey: null,\n      metaKey: null,\n      shiftKey: null\n    }, {\n      collapsed: true,\n      offset: 0\n    }, this.handleBackspace);\n    this.listen();\n  }\n  addBinding(keyBinding) {\n    let context = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};\n    let handler = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};\n    const binding = normalize(keyBinding);\n    if (binding == null) {\n      debug.warn('Attempted to add invalid keyboard binding', binding);\n      return;\n    }\n    if (typeof context === 'function') {\n      context = {\n        handler: context\n      };\n    }\n    if (typeof handler === 'function') {\n      handler = {\n        handler\n      };\n    }\n    const keys = Array.isArray(binding.key) ? binding.key : [binding.key];\n    keys.forEach(key => {\n      const singleBinding = {\n        ...binding,\n        key,\n        ...context,\n        ...handler\n      };\n      this.bindings[singleBinding.key] = this.bindings[singleBinding.key] || [];\n      this.bindings[singleBinding.key].push(singleBinding);\n    });\n  }\n  listen() {\n    this.quill.root.addEventListener('keydown', evt => {\n      if (evt.defaultPrevented || evt.isComposing) return;\n\n      // evt.isComposing is false when pressing Enter/Backspace when composing in Safari\n      // https://bugs.webkit.org/show_bug.cgi?id=165004\n      const isComposing = evt.keyCode === 229 && (evt.key === 'Enter' || evt.key === 'Backspace');\n      if (isComposing) return;\n      const bindings = (this.bindings[evt.key] || []).concat(this.bindings[evt.which] || []);\n      const matches = bindings.filter(binding => Keyboard.match(evt, binding));\n      if (matches.length === 0) return;\n      // @ts-expect-error\n      const blot = _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].find(evt.target, true);\n      if (blot && blot.scroll !== this.quill.scroll) return;\n      const range = this.quill.getSelection();\n      if (range == null || !this.quill.hasFocus()) return;\n      const [line, offset] = this.quill.getLine(range.index);\n      const [leafStart, offsetStart] = this.quill.getLeaf(range.index);\n      const [leafEnd, offsetEnd] = range.length === 0 ? [leafStart, offsetStart] : this.quill.getLeaf(range.index + range.length);\n      const prefixText = leafStart instanceof parchment__WEBPACK_IMPORTED_MODULE_4__.TextBlot ? leafStart.value().slice(0, offsetStart) : '';\n      const suffixText = leafEnd instanceof parchment__WEBPACK_IMPORTED_MODULE_4__.TextBlot ? leafEnd.value().slice(offsetEnd) : '';\n      const curContext = {\n        collapsed: range.length === 0,\n        // @ts-expect-error Fix me later\n        empty: range.length === 0 && line.length() <= 1,\n        format: this.quill.getFormat(range),\n        line,\n        offset,\n        prefix: prefixText,\n        suffix: suffixText,\n        event: evt\n      };\n      const prevented = matches.some(binding => {\n        if (binding.collapsed != null && binding.collapsed !== curContext.collapsed) {\n          return false;\n        }\n        if (binding.empty != null && binding.empty !== curContext.empty) {\n          return false;\n        }\n        if (binding.offset != null && binding.offset !== curContext.offset) {\n          return false;\n        }\n        if (Array.isArray(binding.format)) {\n          // any format is present\n          if (binding.format.every(name => curContext.format[name] == null)) {\n            return false;\n          }\n        } else if (typeof binding.format === 'object') {\n          // all formats must match\n          if (!Object.keys(binding.format).every(name => {\n            // @ts-expect-error Fix me later\n            if (binding.format[name] === true) return curContext.format[name] != null;\n            // @ts-expect-error Fix me later\n            if (binding.format[name] === false) return curContext.format[name] == null;\n            // @ts-expect-error Fix me later\n            return (0,lodash_es__WEBPACK_IMPORTED_MODULE_5__[\"default\"])(binding.format[name], curContext.format[name]);\n          })) {\n            return false;\n          }\n        }\n        if (binding.prefix != null && !binding.prefix.test(curContext.prefix)) {\n          return false;\n        }\n        if (binding.suffix != null && !binding.suffix.test(curContext.suffix)) {\n          return false;\n        }\n        // @ts-expect-error Fix me later\n        return binding.handler.call(this, range, curContext, binding) !== true;\n      });\n      if (prevented) {\n        evt.preventDefault();\n      }\n    });\n  }\n  handleBackspace(range, context) {\n    // Check for astral symbols\n    const length = /[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]$/.test(context.prefix) ? 2 : 1;\n    if (range.index === 0 || this.quill.getLength() <= 1) return;\n    let formats = {};\n    const [line] = this.quill.getLine(range.index);\n    let delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(range.index - length).delete(length);\n    if (context.offset === 0) {\n      // Always deleting newline here, length always 1\n      const [prev] = this.quill.getLine(range.index - 1);\n      if (prev) {\n        const isPrevLineEmpty = prev.statics.blotName === 'block' && prev.length() <= 1;\n        if (!isPrevLineEmpty) {\n          // @ts-expect-error Fix me later\n          const curFormats = line.formats();\n          const prevFormats = this.quill.getFormat(range.index - 1, 1);\n          formats = quill_delta__WEBPACK_IMPORTED_MODULE_0__.AttributeMap.diff(curFormats, prevFormats) || {};\n          if (Object.keys(formats).length > 0) {\n            // line.length() - 1 targets \\n in line, another -1 for newline being deleted\n            const formatDelta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__()\n            // @ts-expect-error Fix me later\n            .retain(range.index + line.length() - 2).retain(1, formats);\n            delta = delta.compose(formatDelta);\n          }\n        }\n      }\n    }\n    this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n    this.quill.focus();\n  }\n  handleDelete(range, context) {\n    // Check for astral symbols\n    const length = /^[\\uD800-\\uDBFF][\\uDC00-\\uDFFF]/.test(context.suffix) ? 2 : 1;\n    if (range.index >= this.quill.getLength() - length) return;\n    let formats = {};\n    const [line] = this.quill.getLine(range.index);\n    let delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(range.index).delete(length);\n    // @ts-expect-error Fix me later\n    if (context.offset >= line.length() - 1) {\n      const [next] = this.quill.getLine(range.index + 1);\n      if (next) {\n        // @ts-expect-error Fix me later\n        const curFormats = line.formats();\n        const nextFormats = this.quill.getFormat(range.index, 1);\n        formats = quill_delta__WEBPACK_IMPORTED_MODULE_0__.AttributeMap.diff(curFormats, nextFormats) || {};\n        if (Object.keys(formats).length > 0) {\n          delta = delta.retain(next.length() - 1).retain(1, formats);\n        }\n      }\n    }\n    this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n    this.quill.focus();\n  }\n  handleDeleteRange(range) {\n    deleteRange({\n      range,\n      quill: this.quill\n    });\n    this.quill.focus();\n  }\n  handleEnter(range, context) {\n    const lineFormats = Object.keys(context.format).reduce((formats, format) => {\n      if (this.quill.scroll.query(format, parchment__WEBPACK_IMPORTED_MODULE_4__.Scope.BLOCK) && !Array.isArray(context.format[format])) {\n        formats[format] = context.format[format];\n      }\n      return formats;\n    }, {});\n    const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(range.index).delete(range.length).insert('\\n', lineFormats);\n    this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n    this.quill.setSelection(range.index + 1, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.SILENT);\n    this.quill.focus();\n  }\n}\nconst defaultOptions = {\n  bindings: {\n    bold: makeFormatHandler('bold'),\n    italic: makeFormatHandler('italic'),\n    underline: makeFormatHandler('underline'),\n    indent: {\n      // highlight tab or tab at beginning of list, indent or blockquote\n      key: 'Tab',\n      format: ['blockquote', 'indent', 'list'],\n      handler(range, context) {\n        if (context.collapsed && context.offset !== 0) return true;\n        this.quill.format('indent', '+1', _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        return false;\n      }\n    },\n    outdent: {\n      key: 'Tab',\n      shiftKey: true,\n      format: ['blockquote', 'indent', 'list'],\n      // highlight tab or tab at beginning of list, indent or blockquote\n      handler(range, context) {\n        if (context.collapsed && context.offset !== 0) return true;\n        this.quill.format('indent', '-1', _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        return false;\n      }\n    },\n    'outdent backspace': {\n      key: 'Backspace',\n      collapsed: true,\n      shiftKey: null,\n      metaKey: null,\n      ctrlKey: null,\n      altKey: null,\n      format: ['indent', 'list'],\n      offset: 0,\n      handler(range, context) {\n        if (context.format.indent != null) {\n          this.quill.format('indent', '-1', _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        } else if (context.format.list != null) {\n          this.quill.format('list', false, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        }\n      }\n    },\n    'indent code-block': makeCodeBlockHandler(true),\n    'outdent code-block': makeCodeBlockHandler(false),\n    'remove tab': {\n      key: 'Tab',\n      shiftKey: true,\n      collapsed: true,\n      prefix: /\\t$/,\n      handler(range) {\n        this.quill.deleteText(range.index - 1, 1, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      }\n    },\n    tab: {\n      key: 'Tab',\n      handler(range, context) {\n        if (context.format.table) return true;\n        this.quill.history.cutoff();\n        const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(range.index).delete(range.length).insert('\\t');\n        this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        this.quill.history.cutoff();\n        this.quill.setSelection(range.index + 1, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.SILENT);\n        return false;\n      }\n    },\n    'blockquote empty enter': {\n      key: 'Enter',\n      collapsed: true,\n      format: ['blockquote'],\n      empty: true,\n      handler() {\n        this.quill.format('blockquote', false, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      }\n    },\n    'list empty enter': {\n      key: 'Enter',\n      collapsed: true,\n      format: ['list'],\n      empty: true,\n      handler(range, context) {\n        const formats = {\n          list: false\n        };\n        if (context.format.indent) {\n          formats.indent = false;\n        }\n        this.quill.formatLine(range.index, range.length, formats, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      }\n    },\n    'checklist enter': {\n      key: 'Enter',\n      collapsed: true,\n      format: {\n        list: 'checked'\n      },\n      handler(range) {\n        const [line, offset] = this.quill.getLine(range.index);\n        const formats = {\n          // @ts-expect-error Fix me later\n          ...line.formats(),\n          list: 'checked'\n        };\n        const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(range.index).insert('\\n', formats)\n        // @ts-expect-error Fix me later\n        .retain(line.length() - offset - 1).retain(1, {\n          list: 'unchecked'\n        });\n        this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        this.quill.setSelection(range.index + 1, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.SILENT);\n        this.quill.scrollSelectionIntoView();\n      }\n    },\n    'header enter': {\n      key: 'Enter',\n      collapsed: true,\n      format: ['header'],\n      suffix: /^$/,\n      handler(range, context) {\n        const [line, offset] = this.quill.getLine(range.index);\n        const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(range.index).insert('\\n', context.format)\n        // @ts-expect-error Fix me later\n        .retain(line.length() - offset - 1).retain(1, {\n          header: null\n        });\n        this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        this.quill.setSelection(range.index + 1, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.SILENT);\n        this.quill.scrollSelectionIntoView();\n      }\n    },\n    'table backspace': {\n      key: 'Backspace',\n      format: ['table'],\n      collapsed: true,\n      offset: 0,\n      handler() {}\n    },\n    'table delete': {\n      key: 'Delete',\n      format: ['table'],\n      collapsed: true,\n      suffix: /^$/,\n      handler() {}\n    },\n    'table enter': {\n      key: 'Enter',\n      shiftKey: null,\n      format: ['table'],\n      handler(range) {\n        const module = this.quill.getModule('table');\n        if (module) {\n          // @ts-expect-error\n          const [table, row, cell, offset] = module.getTable(range);\n          const shift = tableSide(table, row, cell, offset);\n          if (shift == null) return;\n          let index = table.offset();\n          if (shift < 0) {\n            const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(index).insert('\\n');\n            this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n            this.quill.setSelection(range.index + 1, range.length, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.SILENT);\n          } else if (shift > 0) {\n            index += table.length();\n            const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(index).insert('\\n');\n            this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n            this.quill.setSelection(index, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n          }\n        }\n      }\n    },\n    'table tab': {\n      key: 'Tab',\n      shiftKey: null,\n      format: ['table'],\n      handler(range, context) {\n        const {\n          event,\n          line: cell\n        } = context;\n        const offset = cell.offset(this.quill.scroll);\n        if (event.shiftKey) {\n          this.quill.setSelection(offset - 1, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        } else {\n          this.quill.setSelection(offset + cell.length(), _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        }\n      }\n    },\n    'list autofill': {\n      key: ' ',\n      shiftKey: null,\n      collapsed: true,\n      format: {\n        'code-block': false,\n        blockquote: false,\n        table: false\n      },\n      prefix: /^\\s*?(\\d+\\.|-|\\*|\\[ ?\\]|\\[x\\])$/,\n      handler(range, context) {\n        if (this.quill.scroll.query('list') == null) return true;\n        const {\n          length\n        } = context.prefix;\n        const [line, offset] = this.quill.getLine(range.index);\n        if (offset > length) return true;\n        let value;\n        switch (context.prefix.trim()) {\n          case '[]':\n          case '[ ]':\n            value = 'unchecked';\n            break;\n          case '[x]':\n            value = 'checked';\n            break;\n          case '-':\n          case '*':\n            value = 'bullet';\n            break;\n          default:\n            value = 'ordered';\n        }\n        this.quill.insertText(range.index, ' ', _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        this.quill.history.cutoff();\n        const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(range.index - offset).delete(length + 1)\n        // @ts-expect-error Fix me later\n        .retain(line.length() - 2 - offset).retain(1, {\n          list: value\n        });\n        this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        this.quill.history.cutoff();\n        this.quill.setSelection(range.index - length, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.SILENT);\n        return false;\n      }\n    },\n    'code exit': {\n      key: 'Enter',\n      collapsed: true,\n      format: ['code-block'],\n      prefix: /^$/,\n      suffix: /^\\s*$/,\n      handler(range) {\n        const [line, offset] = this.quill.getLine(range.index);\n        let numLines = 2;\n        let cur = line;\n        while (cur != null && cur.length() <= 1 && cur.formats()['code-block']) {\n          // @ts-expect-error\n          cur = cur.prev;\n          numLines -= 1;\n          // Requisite prev lines are empty\n          if (numLines <= 0) {\n            const delta = new quill_delta__WEBPACK_IMPORTED_MODULE_0__()\n            // @ts-expect-error Fix me later\n            .retain(range.index + line.length() - offset - 2).retain(1, {\n              'code-block': null\n            }).delete(1);\n            this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n            this.quill.setSelection(range.index - 1, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.SILENT);\n            return false;\n          }\n        }\n        return true;\n      }\n    },\n    'embed left': makeEmbedArrowHandler('ArrowLeft', false),\n    'embed left shift': makeEmbedArrowHandler('ArrowLeft', true),\n    'embed right': makeEmbedArrowHandler('ArrowRight', false),\n    'embed right shift': makeEmbedArrowHandler('ArrowRight', true),\n    'table down': makeTableArrowHandler(false),\n    'table up': makeTableArrowHandler(true)\n  }\n};\nKeyboard.DEFAULTS = defaultOptions;\nfunction makeCodeBlockHandler(indent) {\n  return {\n    key: 'Tab',\n    shiftKey: !indent,\n    format: {\n      'code-block': true\n    },\n    handler(range, _ref) {\n      let {\n        event\n      } = _ref;\n      const CodeBlock = this.quill.scroll.query('code-block');\n      // @ts-expect-error\n      const {\n        TAB\n      } = CodeBlock;\n      if (range.length === 0 && !event.shiftKey) {\n        this.quill.insertText(range.index, TAB, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        this.quill.setSelection(range.index + TAB.length, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.SILENT);\n        return;\n      }\n      const lines = range.length === 0 ? this.quill.getLines(range.index, 1) : this.quill.getLines(range);\n      let {\n        index,\n        length\n      } = range;\n      lines.forEach((line, i) => {\n        if (indent) {\n          line.insertAt(0, TAB);\n          if (i === 0) {\n            index += TAB.length;\n          } else {\n            length += TAB.length;\n          }\n          // @ts-expect-error Fix me later\n        } else if (line.domNode.textContent.startsWith(TAB)) {\n          line.deleteAt(0, TAB.length);\n          if (i === 0) {\n            index -= TAB.length;\n          } else {\n            length -= TAB.length;\n          }\n        }\n      });\n      this.quill.update(_core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      this.quill.setSelection(index, length, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.SILENT);\n    }\n  };\n}\nfunction makeEmbedArrowHandler(key, shiftKey) {\n  const where = key === 'ArrowLeft' ? 'prefix' : 'suffix';\n  return {\n    key,\n    shiftKey,\n    altKey: null,\n    [where]: /^$/,\n    handler(range) {\n      let {\n        index\n      } = range;\n      if (key === 'ArrowRight') {\n        index += range.length + 1;\n      }\n      const [leaf] = this.quill.getLeaf(index);\n      if (!(leaf instanceof parchment__WEBPACK_IMPORTED_MODULE_4__.EmbedBlot)) return true;\n      if (key === 'ArrowLeft') {\n        if (shiftKey) {\n          this.quill.setSelection(range.index - 1, range.length + 1, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        } else {\n          this.quill.setSelection(range.index - 1, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        }\n      } else if (shiftKey) {\n        this.quill.setSelection(range.index, range.length + 1, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      } else {\n        this.quill.setSelection(range.index + range.length + 1, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      }\n      return false;\n    }\n  };\n}\nfunction makeFormatHandler(format) {\n  return {\n    key: format[0],\n    shortKey: true,\n    handler(range, context) {\n      this.quill.format(format, !context.format[format], _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n    }\n  };\n}\nfunction makeTableArrowHandler(up) {\n  return {\n    key: up ? 'ArrowUp' : 'ArrowDown',\n    collapsed: true,\n    format: ['table'],\n    handler(range, context) {\n      // TODO move to table module\n      const key = up ? 'prev' : 'next';\n      const cell = context.line;\n      const targetRow = cell.parent[key];\n      if (targetRow != null) {\n        if (targetRow.statics.blotName === 'table-row') {\n          // @ts-expect-error\n          let targetCell = targetRow.children.head;\n          let cur = cell;\n          while (cur.prev != null) {\n            // @ts-expect-error\n            cur = cur.prev;\n            targetCell = targetCell.next;\n          }\n          const index = targetCell.offset(this.quill.scroll) + Math.min(context.offset, targetCell.length() - 1);\n          this.quill.setSelection(index, 0, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        }\n      } else {\n        // @ts-expect-error\n        const targetLine = cell.table()[key];\n        if (targetLine != null) {\n          if (up) {\n            this.quill.setSelection(targetLine.offset(this.quill.scroll) + targetLine.length() - 1, 0, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n          } else {\n            this.quill.setSelection(targetLine.offset(this.quill.scroll), 0, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n          }\n        }\n      }\n      return false;\n    }\n  };\n}\nfunction normalize(binding) {\n  if (typeof binding === 'string' || typeof binding === 'number') {\n    binding = {\n      key: binding\n    };\n  } else if (typeof binding === 'object') {\n    binding = (0,lodash_es__WEBPACK_IMPORTED_MODULE_6__[\"default\"])(binding);\n  } else {\n    return null;\n  }\n  if (binding.shortKey) {\n    binding[SHORTKEY] = binding.shortKey;\n    delete binding.shortKey;\n  }\n  return binding;\n}\n\n// TODO: Move into quill.ts or editor.ts\nfunction deleteRange(_ref2) {\n  let {\n    quill,\n    range\n  } = _ref2;\n  const lines = quill.getLines(range);\n  let formats = {};\n  if (lines.length > 1) {\n    const firstFormats = lines[0].formats();\n    const lastFormats = lines[lines.length - 1].formats();\n    formats = quill_delta__WEBPACK_IMPORTED_MODULE_0__.AttributeMap.diff(lastFormats, firstFormats) || {};\n  }\n  quill.deleteText(range, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n  if (Object.keys(formats).length > 0) {\n    quill.formatLine(range.index, 1, formats, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n  }\n  quill.setSelection(range.index, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.SILENT);\n}\nfunction tableSide(_table, row, cell, offset) {\n  if (row.prev == null && row.next == null) {\n    if (cell.prev == null && cell.next == null) {\n      return offset === 0 ? -1 : 1;\n    }\n    return cell.prev == null ? -1 : 1;\n  }\n  if (row.prev == null) {\n    return -1;\n  }\n  if (row.next == null) {\n    return 1;\n  }\n  return null;\n}\n\n//# sourceMappingURL=keyboard.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/keyboard.js?")},"./node_modules/quill/modules/normalizeExternalHTML/index.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _normalizers_googleDocs_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./normalizers/googleDocs.js */ "./node_modules/quill/modules/normalizeExternalHTML/normalizers/googleDocs.js");\n/* harmony import */ var _normalizers_msWord_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./normalizers/msWord.js */ "./node_modules/quill/modules/normalizeExternalHTML/normalizers/msWord.js");\n\n\nconst NORMALIZERS = [_normalizers_msWord_js__WEBPACK_IMPORTED_MODULE_1__["default"], _normalizers_googleDocs_js__WEBPACK_IMPORTED_MODULE_0__["default"]];\nconst normalizeExternalHTML = doc => {\n  if (doc.documentElement) {\n    NORMALIZERS.forEach(normalize => {\n      normalize(doc);\n    });\n  }\n};\n/* harmony default export */ __webpack_exports__["default"] = (normalizeExternalHTML);\n//# sourceMappingURL=index.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/normalizeExternalHTML/index.js?')},"./node_modules/quill/modules/normalizeExternalHTML/normalizers/googleDocs.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": function() { return /* binding */ normalize; }\n/* harmony export */ });\nconst normalWeightRegexp = /font-weight:\\s*normal/;\nconst blockTagNames = ['P', 'OL', 'UL'];\nconst isBlockElement = element => {\n  return element && blockTagNames.includes(element.tagName);\n};\nconst normalizeEmptyLines = doc => {\n  Array.from(doc.querySelectorAll('br')).filter(br => isBlockElement(br.previousElementSibling) && isBlockElement(br.nextElementSibling)).forEach(br => {\n    br.parentNode?.removeChild(br);\n  });\n};\nconst normalizeFontWeight = doc => {\n  Array.from(doc.querySelectorAll('b[style*=\"font-weight\"]')).filter(node => node.getAttribute('style')?.match(normalWeightRegexp)).forEach(node => {\n    const fragment = doc.createDocumentFragment();\n    fragment.append(...node.childNodes);\n    node.parentNode?.replaceChild(fragment, node);\n  });\n};\nfunction normalize(doc) {\n  if (doc.querySelector('[id^=\"docs-internal-guid-\"]')) {\n    normalizeFontWeight(doc);\n    normalizeEmptyLines(doc);\n  }\n}\n//# sourceMappingURL=googleDocs.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/normalizeExternalHTML/normalizers/googleDocs.js?")},"./node_modules/quill/modules/normalizeExternalHTML/normalizers/msWord.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   \"default\": function() { return /* binding */ normalize; }\n/* harmony export */ });\nconst ignoreRegexp = /\\bmso-list:[^;]*ignore/i;\nconst idRegexp = /\\bmso-list:[^;]*\\bl(\\d+)/i;\nconst indentRegexp = /\\bmso-list:[^;]*\\blevel(\\d+)/i;\nconst parseListItem = (element, html) => {\n  const style = element.getAttribute('style');\n  const idMatch = style?.match(idRegexp);\n  if (!idMatch) {\n    return null;\n  }\n  const id = Number(idMatch[1]);\n  const indentMatch = style?.match(indentRegexp);\n  const indent = indentMatch ? Number(indentMatch[1]) : 1;\n  const typeRegexp = new RegExp(`@list l${id}:level${indent}\\\\s*\\\\{[^\\\\}]*mso-level-number-format:\\\\s*([\\\\w-]+)`, 'i');\n  const typeMatch = html.match(typeRegexp);\n  const type = typeMatch && typeMatch[1] === 'bullet' ? 'bullet' : 'ordered';\n  return {\n    id,\n    indent,\n    type,\n    element\n  };\n};\n\n// list items are represented as `p` tags with styles like `mso-list: l0 level1` where:\n// 1. \"0\" in \"l0\" means the list item id;\n// 2. \"1\" in \"level1\" means the indent level, starting from 1.\nconst normalizeListItem = doc => {\n  const msoList = Array.from(doc.querySelectorAll('[style*=mso-list]'));\n  const ignored = [];\n  const others = [];\n  msoList.forEach(node => {\n    const shouldIgnore = (node.getAttribute('style') || '').match(ignoreRegexp);\n    if (shouldIgnore) {\n      ignored.push(node);\n    } else {\n      others.push(node);\n    }\n  });\n\n  // Each list item contains a marker wrapped with \"mso-list: Ignore\".\n  ignored.forEach(node => node.parentNode?.removeChild(node));\n\n  // The list stype is not defined inline with the tag, instead, it's in the\n  // style tag so we need to pass the html as a string.\n  const html = doc.documentElement.innerHTML;\n  const listItems = others.map(element => parseListItem(element, html)).filter(parsed => parsed);\n  while (listItems.length) {\n    const childListItems = [];\n    let current = listItems.shift();\n    // Group continuous items into the same group (aka \"ul\")\n    while (current) {\n      childListItems.push(current);\n      current = listItems.length && listItems[0]?.element === current.element.nextElementSibling &&\n      // Different id means the next item doesn't belong to this group.\n      listItems[0].id === current.id ? listItems.shift() : null;\n    }\n    const ul = document.createElement('ul');\n    childListItems.forEach(listItem => {\n      const li = document.createElement('li');\n      li.setAttribute('data-list', listItem.type);\n      if (listItem.indent > 1) {\n        li.setAttribute('class', `ql-indent-${listItem.indent - 1}`);\n      }\n      li.innerHTML = listItem.element.innerHTML;\n      ul.appendChild(li);\n    });\n    const element = childListItems[0]?.element;\n    const {\n      parentNode\n    } = element ?? {};\n    if (element) {\n      parentNode?.replaceChild(ul, element);\n    }\n    childListItems.slice(1).forEach(_ref => {\n      let {\n        element: e\n      } = _ref;\n      parentNode?.removeChild(e);\n    });\n  }\n};\nfunction normalize(doc) {\n  if (doc.documentElement.getAttribute('xmlns:w') === 'urn:schemas-microsoft-com:office:word') {\n    normalizeListItem(doc);\n  }\n}\n//# sourceMappingURL=msWord.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/normalizeExternalHTML/normalizers/msWord.js?")},"./node_modules/quill/modules/syntax.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   CodeBlock: function() { return /* binding */ SyntaxCodeBlock; },\n/* harmony export */   CodeToken: function() { return /* binding */ CodeToken; },\n/* harmony export */   \"default\": function() { return /* binding */ Syntax; }\n/* harmony export */ });\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill-delta */ \"./node_modules/quill-delta/dist/Delta.js\");\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var _blots_inline_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../blots/inline.js */ \"./node_modules/quill/blots/inline.js\");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/quill.js */ \"./node_modules/quill/core/quill.js\");\n/* harmony import */ var _core_module_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/module.js */ \"./node_modules/quill/core/module.js\");\n/* harmony import */ var _blots_block_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../blots/block.js */ \"./node_modules/quill/blots/block.js\");\n/* harmony import */ var _blots_break_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../blots/break.js */ \"./node_modules/quill/blots/break.js\");\n/* harmony import */ var _blots_cursor_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../blots/cursor.js */ \"./node_modules/quill/blots/cursor.js\");\n/* harmony import */ var _blots_text_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../blots/text.js */ \"./node_modules/quill/blots/text.js\");\n/* harmony import */ var _formats_code_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../formats/code.js */ \"./node_modules/quill/formats/code.js\");\n/* harmony import */ var _clipboard_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./clipboard.js */ \"./node_modules/quill/modules/clipboard.js\");\n\n\n\n\n\n\n\n\n\n\n\nconst TokenAttributor = new parchment__WEBPACK_IMPORTED_MODULE_10__.ClassAttributor('code-token', 'hljs', {\n  scope: parchment__WEBPACK_IMPORTED_MODULE_10__.Scope.INLINE\n});\nclass CodeToken extends _blots_inline_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"] {\n  static formats(node, scroll) {\n    while (node != null && node !== scroll.domNode) {\n      if (node.classList && node.classList.contains(_formats_code_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"].className)) {\n        // @ts-expect-error\n        return super.formats(node, scroll);\n      }\n      // @ts-expect-error\n      node = node.parentNode;\n    }\n    return undefined;\n  }\n  constructor(scroll, domNode, value) {\n    // @ts-expect-error\n    super(scroll, domNode, value);\n    TokenAttributor.add(this.domNode, value);\n  }\n  format(format, value) {\n    if (format !== CodeToken.blotName) {\n      super.format(format, value);\n    } else if (value) {\n      TokenAttributor.add(this.domNode, value);\n    } else {\n      TokenAttributor.remove(this.domNode);\n      this.domNode.classList.remove(this.statics.className);\n    }\n  }\n  optimize() {\n    // @ts-expect-error\n    super.optimize(...arguments);\n    if (!TokenAttributor.value(this.domNode)) {\n      this.unwrap();\n    }\n  }\n}\nCodeToken.blotName = 'code-token';\nCodeToken.className = 'ql-token';\nclass SyntaxCodeBlock extends _formats_code_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"] {\n  static create(value) {\n    const domNode = super.create(value);\n    if (typeof value === 'string') {\n      domNode.setAttribute('data-language', value);\n    }\n    return domNode;\n  }\n  static formats(domNode) {\n    // @ts-expect-error\n    return domNode.getAttribute('data-language') || 'plain';\n  }\n  static register() {} // Syntax module will register\n\n  format(name, value) {\n    if (name === this.statics.blotName && value) {\n      // @ts-expect-error\n      this.domNode.setAttribute('data-language', value);\n    } else {\n      super.format(name, value);\n    }\n  }\n  replaceWith(name, value) {\n    this.formatAt(0, this.length(), CodeToken.blotName, false);\n    return super.replaceWith(name, value);\n  }\n}\nclass SyntaxCodeBlockContainer extends _formats_code_js__WEBPACK_IMPORTED_MODULE_8__.CodeBlockContainer {\n  attach() {\n    super.attach();\n    this.forceNext = false;\n    // @ts-expect-error\n    this.scroll.emitMount(this);\n  }\n  format(name, value) {\n    if (name === SyntaxCodeBlock.blotName) {\n      this.forceNext = true;\n      this.children.forEach(child => {\n        // @ts-expect-error\n        child.format(name, value);\n      });\n    }\n  }\n  formatAt(index, length, name, value) {\n    if (name === SyntaxCodeBlock.blotName) {\n      this.forceNext = true;\n    }\n    super.formatAt(index, length, name, value);\n  }\n  highlight(highlight) {\n    let forced = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n    if (this.children.head == null) return;\n    const nodes = Array.from(this.domNode.childNodes).filter(node => node !== this.uiNode);\n    const text = `${nodes.map(node => node.textContent).join('\\n')}\\n`;\n    const language = SyntaxCodeBlock.formats(this.children.head.domNode);\n    if (forced || this.forceNext || this.cachedText !== text) {\n      if (text.trim().length > 0 || this.cachedText == null) {\n        const oldDelta = this.children.reduce((delta, child) => {\n          // @ts-expect-error\n          return delta.concat((0,_blots_block_js__WEBPACK_IMPORTED_MODULE_4__.blockDelta)(child, false));\n        }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__());\n        const delta = highlight(text, language);\n        oldDelta.diff(delta).reduce((index, _ref) => {\n          let {\n            retain,\n            attributes\n          } = _ref;\n          // Should be all retains\n          if (!retain) return index;\n          if (attributes) {\n            Object.keys(attributes).forEach(format => {\n              if ([SyntaxCodeBlock.blotName, CodeToken.blotName].includes(format)) {\n                // @ts-expect-error\n                this.formatAt(index, retain, format, attributes[format]);\n              }\n            });\n          }\n          // @ts-expect-error\n          return index + retain;\n        }, 0);\n      }\n      this.cachedText = text;\n      this.forceNext = false;\n    }\n  }\n  html(index, length) {\n    const [codeBlock] = this.children.find(index);\n    const language = codeBlock ? SyntaxCodeBlock.formats(codeBlock.domNode) : 'plain';\n    return `<pre data-language=\"${language}\">\\n${(0,_blots_text_js__WEBPACK_IMPORTED_MODULE_7__.escapeText)(this.code(index, length))}\\n</pre>`;\n  }\n  optimize(context) {\n    super.optimize(context);\n    if (this.parent != null && this.children.head != null && this.uiNode != null) {\n      const language = SyntaxCodeBlock.formats(this.children.head.domNode);\n      // @ts-expect-error\n      if (language !== this.uiNode.value) {\n        // @ts-expect-error\n        this.uiNode.value = language;\n      }\n    }\n  }\n}\nSyntaxCodeBlockContainer.allowedChildren = [SyntaxCodeBlock];\nSyntaxCodeBlock.requiredContainer = SyntaxCodeBlockContainer;\nSyntaxCodeBlock.allowedChildren = [CodeToken, _blots_cursor_js__WEBPACK_IMPORTED_MODULE_6__[\"default\"], _blots_text_js__WEBPACK_IMPORTED_MODULE_7__[\"default\"], _blots_break_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"]];\nconst highlight = (lib, language, text) => {\n  if (typeof lib.versionString === 'string') {\n    const majorVersion = lib.versionString.split('.')[0];\n    if (parseInt(majorVersion, 10) >= 11) {\n      return lib.highlight(text, {\n        language\n      }).value;\n    }\n  }\n  return lib.highlight(language, text).value;\n};\nclass Syntax extends _core_module_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"] {\n  static register() {\n    _core_quill_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].register(CodeToken, true);\n    _core_quill_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].register(SyntaxCodeBlock, true);\n    _core_quill_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].register(SyntaxCodeBlockContainer, true);\n  }\n  constructor(quill, options) {\n    super(quill, options);\n    if (this.options.hljs == null) {\n      throw new Error('Syntax module requires highlight.js. Please include the library on the page before Quill.');\n    }\n    // @ts-expect-error Fix me later\n    this.languages = this.options.languages.reduce((memo, _ref2) => {\n      let {\n        key\n      } = _ref2;\n      memo[key] = true;\n      return memo;\n    }, {});\n    this.highlightBlot = this.highlightBlot.bind(this);\n    this.initListener();\n    this.initTimer();\n  }\n  initListener() {\n    this.quill.on(_core_quill_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].events.SCROLL_BLOT_MOUNT, blot => {\n      if (!(blot instanceof SyntaxCodeBlockContainer)) return;\n      const select = this.quill.root.ownerDocument.createElement('select');\n      // @ts-expect-error Fix me later\n      this.options.languages.forEach(_ref3 => {\n        let {\n          key,\n          label\n        } = _ref3;\n        const option = select.ownerDocument.createElement('option');\n        option.textContent = label;\n        option.setAttribute('value', key);\n        select.appendChild(option);\n      });\n      select.addEventListener('change', () => {\n        blot.format(SyntaxCodeBlock.blotName, select.value);\n        this.quill.root.focus(); // Prevent scrolling\n        this.highlight(blot, true);\n      });\n      if (blot.uiNode == null) {\n        blot.attachUI(select);\n        if (blot.children.head) {\n          select.value = SyntaxCodeBlock.formats(blot.children.head.domNode);\n        }\n      }\n    });\n  }\n  initTimer() {\n    let timer = null;\n    this.quill.on(_core_quill_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].events.SCROLL_OPTIMIZE, () => {\n      if (timer) {\n        clearTimeout(timer);\n      }\n      timer = setTimeout(() => {\n        this.highlight();\n        timer = null;\n      }, this.options.interval);\n    });\n  }\n  highlight() {\n    let blot = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;\n    let force = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n    if (this.quill.selection.composing) return;\n    this.quill.update(_core_quill_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].sources.USER);\n    const range = this.quill.getSelection();\n    const blots = blot == null ? this.quill.scroll.descendants(SyntaxCodeBlockContainer) : [blot];\n    blots.forEach(container => {\n      container.highlight(this.highlightBlot, force);\n    });\n    this.quill.update(_core_quill_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].sources.SILENT);\n    if (range != null) {\n      this.quill.setSelection(range, _core_quill_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].sources.SILENT);\n    }\n  }\n  highlightBlot(text) {\n    let language = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'plain';\n    language = this.languages[language] ? language : 'plain';\n    if (language === 'plain') {\n      return (0,_blots_text_js__WEBPACK_IMPORTED_MODULE_7__.escapeText)(text).split('\\n').reduce((delta, line, i) => {\n        if (i !== 0) {\n          delta.insert('\\n', {\n            [_formats_code_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"].blotName]: language\n          });\n        }\n        return delta.insert(line);\n      }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__());\n    }\n    const container = this.quill.root.ownerDocument.createElement('div');\n    container.classList.add(_formats_code_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"].className);\n    container.innerHTML = highlight(this.options.hljs, language, text);\n    return (0,_clipboard_js__WEBPACK_IMPORTED_MODULE_9__.traverse)(this.quill.scroll, container, [(node, delta) => {\n      // @ts-expect-error\n      const value = TokenAttributor.value(node);\n      if (value) {\n        return delta.compose(new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(delta.length(), {\n          [CodeToken.blotName]: value\n        }));\n      }\n      return delta;\n    }], [(node, delta) => {\n      // @ts-expect-error\n      return node.data.split('\\n').reduce((memo, nodeText, i) => {\n        if (i !== 0) memo.insert('\\n', {\n          [_formats_code_js__WEBPACK_IMPORTED_MODULE_8__[\"default\"].blotName]: language\n        });\n        return memo.insert(nodeText);\n      }, delta);\n    }], new WeakMap());\n  }\n}\nSyntax.DEFAULTS = {\n  hljs: (() => {\n    return window.hljs;\n  })(),\n  interval: 1000,\n  languages: [{\n    key: 'plain',\n    label: 'Plain'\n  }, {\n    key: 'bash',\n    label: 'Bash'\n  }, {\n    key: 'cpp',\n    label: 'C++'\n  }, {\n    key: 'cs',\n    label: 'C#'\n  }, {\n    key: 'css',\n    label: 'CSS'\n  }, {\n    key: 'diff',\n    label: 'Diff'\n  }, {\n    key: 'xml',\n    label: 'HTML/XML'\n  }, {\n    key: 'java',\n    label: 'Java'\n  }, {\n    key: 'javascript',\n    label: 'JavaScript'\n  }, {\n    key: 'markdown',\n    label: 'Markdown'\n  }, {\n    key: 'php',\n    label: 'PHP'\n  }, {\n    key: 'python',\n    label: 'Python'\n  }, {\n    key: 'ruby',\n    label: 'Ruby'\n  }, {\n    key: 'sql',\n    label: 'SQL'\n  }]\n};\n\n//# sourceMappingURL=syntax.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/syntax.js?")},"./node_modules/quill/modules/table.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill-delta */ "./node_modules/quill-delta/dist/Delta.js");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/quill.js */ "./node_modules/quill/core/quill.js");\n/* harmony import */ var _core_module_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/module.js */ "./node_modules/quill/core/module.js");\n/* harmony import */ var _formats_table_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../formats/table.js */ "./node_modules/quill/formats/table.js");\n\n\n\n\nclass Table extends _core_module_js__WEBPACK_IMPORTED_MODULE_2__["default"] {\n  static register() {\n    _core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].register(_formats_table_js__WEBPACK_IMPORTED_MODULE_3__.TableCell);\n    _core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].register(_formats_table_js__WEBPACK_IMPORTED_MODULE_3__.TableRow);\n    _core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].register(_formats_table_js__WEBPACK_IMPORTED_MODULE_3__.TableBody);\n    _core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].register(_formats_table_js__WEBPACK_IMPORTED_MODULE_3__.TableContainer);\n  }\n  constructor() {\n    super(...arguments);\n    this.listenBalanceCells();\n  }\n  balanceTables() {\n    this.quill.scroll.descendants(_formats_table_js__WEBPACK_IMPORTED_MODULE_3__.TableContainer).forEach(table => {\n      table.balanceCells();\n    });\n  }\n  deleteColumn() {\n    const [table,, cell] = this.getTable();\n    if (cell == null) return;\n    // @ts-expect-error\n    table.deleteColumn(cell.cellOffset());\n    this.quill.update(_core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.USER);\n  }\n  deleteRow() {\n    const [, row] = this.getTable();\n    if (row == null) return;\n    row.remove();\n    this.quill.update(_core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.USER);\n  }\n  deleteTable() {\n    const [table] = this.getTable();\n    if (table == null) return;\n    // @ts-expect-error\n    const offset = table.offset();\n    // @ts-expect-error\n    table.remove();\n    this.quill.update(_core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.USER);\n    this.quill.setSelection(offset, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.SILENT);\n  }\n  getTable() {\n    let range = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : this.quill.getSelection();\n    if (range == null) return [null, null, null, -1];\n    const [cell, offset] = this.quill.getLine(range.index);\n    if (cell == null || cell.statics.blotName !== _formats_table_js__WEBPACK_IMPORTED_MODULE_3__.TableCell.blotName) {\n      return [null, null, null, -1];\n    }\n    const row = cell.parent;\n    const table = row.parent.parent;\n    // @ts-expect-error\n    return [table, row, cell, offset];\n  }\n  insertColumn(offset) {\n    const range = this.quill.getSelection();\n    if (!range) return;\n    const [table, row, cell] = this.getTable(range);\n    if (cell == null) return;\n    const column = cell.cellOffset();\n    table.insertColumn(column + offset);\n    this.quill.update(_core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.USER);\n    let shift = row.rowOffset();\n    if (offset === 0) {\n      shift += 1;\n    }\n    this.quill.setSelection(range.index + shift, range.length, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.SILENT);\n  }\n  insertColumnLeft() {\n    this.insertColumn(0);\n  }\n  insertColumnRight() {\n    this.insertColumn(1);\n  }\n  insertRow(offset) {\n    const range = this.quill.getSelection();\n    if (!range) return;\n    const [table, row, cell] = this.getTable(range);\n    if (cell == null) return;\n    const index = row.rowOffset();\n    table.insertRow(index + offset);\n    this.quill.update(_core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.USER);\n    if (offset > 0) {\n      this.quill.setSelection(range, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.SILENT);\n    } else {\n      this.quill.setSelection(range.index + row.children.length, range.length, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.SILENT);\n    }\n  }\n  insertRowAbove() {\n    this.insertRow(0);\n  }\n  insertRowBelow() {\n    this.insertRow(1);\n  }\n  insertTable(rows, columns) {\n    const range = this.quill.getSelection();\n    if (range == null) return;\n    const delta = new Array(rows).fill(0).reduce(memo => {\n      const text = new Array(columns).fill(\'\\n\').join(\'\');\n      return memo.insert(text, {\n        table: (0,_formats_table_js__WEBPACK_IMPORTED_MODULE_3__.tableId)()\n      });\n    }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(range.index));\n    this.quill.updateContents(delta, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.USER);\n    this.quill.setSelection(range.index, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.SILENT);\n    this.balanceTables();\n  }\n  listenBalanceCells() {\n    this.quill.on(_core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].events.SCROLL_OPTIMIZE, mutations => {\n      mutations.some(mutation => {\n        if ([\'TD\', \'TR\', \'TBODY\', \'TABLE\'].includes(mutation.target.tagName)) {\n          this.quill.once(_core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].events.TEXT_CHANGE, (delta, old, source) => {\n            if (source !== _core_quill_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.USER) return;\n            this.balanceTables();\n          });\n          return true;\n        }\n        return false;\n      });\n    });\n  }\n}\n/* harmony default export */ __webpack_exports__["default"] = (Table);\n//# sourceMappingURL=table.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/table.js?')},"./node_modules/quill/modules/toolbar.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   addControls: function() { return /* binding */ addControls; },\n/* harmony export */   \"default\": function() { return /* binding */ Toolbar; }\n/* harmony export */ });\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill-delta */ \"./node_modules/quill-delta/dist/Delta.js\");\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/quill.js */ \"./node_modules/quill/core/quill.js\");\n/* harmony import */ var _core_logger_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/logger.js */ \"./node_modules/quill/core/logger.js\");\n/* harmony import */ var _core_module_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/module.js */ \"./node_modules/quill/core/module.js\");\n\n\n\n\n\nconst debug = (0,_core_logger_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"])('quill:toolbar');\nclass Toolbar extends _core_module_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"] {\n  constructor(quill, options) {\n    super(quill, options);\n    if (Array.isArray(this.options.container)) {\n      const container = document.createElement('div');\n      container.setAttribute('role', 'toolbar');\n      addControls(container, this.options.container);\n      quill.container?.parentNode?.insertBefore(container, quill.container);\n      this.container = container;\n    } else if (typeof this.options.container === 'string') {\n      this.container = document.querySelector(this.options.container);\n    } else {\n      this.container = this.options.container;\n    }\n    if (!(this.container instanceof HTMLElement)) {\n      debug.error('Container required for toolbar', this.options);\n      return;\n    }\n    this.container.classList.add('ql-toolbar');\n    this.controls = [];\n    this.handlers = {};\n    if (this.options.handlers) {\n      Object.keys(this.options.handlers).forEach(format => {\n        const handler = this.options.handlers?.[format];\n        if (handler) {\n          this.addHandler(format, handler);\n        }\n      });\n    }\n    Array.from(this.container.querySelectorAll('button, select')).forEach(input => {\n      // @ts-expect-error\n      this.attach(input);\n    });\n    this.quill.on(_core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].events.EDITOR_CHANGE, () => {\n      const [range] = this.quill.selection.getRange(); // quill.getSelection triggers update\n      this.update(range);\n    });\n  }\n  addHandler(format, handler) {\n    this.handlers[format] = handler;\n  }\n  attach(input) {\n    let format = Array.from(input.classList).find(className => {\n      return className.indexOf('ql-') === 0;\n    });\n    if (!format) return;\n    format = format.slice('ql-'.length);\n    if (input.tagName === 'BUTTON') {\n      input.setAttribute('type', 'button');\n    }\n    if (this.handlers[format] == null && this.quill.scroll.query(format) == null) {\n      debug.warn('ignoring attaching to nonexistent format', format, input);\n      return;\n    }\n    const eventName = input.tagName === 'SELECT' ? 'change' : 'click';\n    input.addEventListener(eventName, e => {\n      let value;\n      if (input.tagName === 'SELECT') {\n        // @ts-expect-error\n        if (input.selectedIndex < 0) return;\n        // @ts-expect-error\n        const selected = input.options[input.selectedIndex];\n        if (selected.hasAttribute('selected')) {\n          value = false;\n        } else {\n          value = selected.value || false;\n        }\n      } else {\n        if (input.classList.contains('ql-active')) {\n          value = false;\n        } else {\n          // @ts-expect-error\n          value = input.value || !input.hasAttribute('value');\n        }\n        e.preventDefault();\n      }\n      this.quill.focus();\n      const [range] = this.quill.selection.getRange();\n      if (this.handlers[format] != null) {\n        this.handlers[format].call(this, value);\n      } else if (\n      // @ts-expect-error\n      this.quill.scroll.query(format).prototype instanceof parchment__WEBPACK_IMPORTED_MODULE_4__.EmbedBlot) {\n        value = prompt(`Enter ${format}`); // eslint-disable-line no-alert\n        if (!value) return;\n        this.quill.updateContents(new quill_delta__WEBPACK_IMPORTED_MODULE_0__()\n        // @ts-expect-error Fix me later\n        .retain(range.index)\n        // @ts-expect-error Fix me later\n        .delete(range.length).insert({\n          [format]: value\n        }), _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      } else {\n        this.quill.format(format, value, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      }\n      this.update(range);\n    });\n    this.controls.push([format, input]);\n  }\n  update(range) {\n    const formats = range == null ? {} : this.quill.getFormat(range);\n    this.controls.forEach(pair => {\n      const [format, input] = pair;\n      if (input.tagName === 'SELECT') {\n        let option = null;\n        if (range == null) {\n          option = null;\n        } else if (formats[format] == null) {\n          option = input.querySelector('option[selected]');\n        } else if (!Array.isArray(formats[format])) {\n          let value = formats[format];\n          if (typeof value === 'string') {\n            value = value.replace(/\"/g, '\\\\\"');\n          }\n          option = input.querySelector(`option[value=\"${value}\"]`);\n        }\n        if (option == null) {\n          // @ts-expect-error TODO fix me later\n          input.value = ''; // TODO make configurable?\n          // @ts-expect-error TODO fix me later\n          input.selectedIndex = -1;\n        } else {\n          option.selected = true;\n        }\n      } else if (range == null) {\n        input.classList.remove('ql-active');\n        input.setAttribute('aria-pressed', 'false');\n      } else if (input.hasAttribute('value')) {\n        // both being null should match (default values)\n        // '1' should match with 1 (headers)\n        const value = formats[format];\n        const isActive = value === input.getAttribute('value') || value != null && value.toString() === input.getAttribute('value') || value == null && !input.getAttribute('value');\n        input.classList.toggle('ql-active', isActive);\n        input.setAttribute('aria-pressed', isActive.toString());\n      } else {\n        const isActive = formats[format] != null;\n        input.classList.toggle('ql-active', isActive);\n        input.setAttribute('aria-pressed', isActive.toString());\n      }\n    });\n  }\n}\nToolbar.DEFAULTS = {};\nfunction addButton(container, format, value) {\n  const input = document.createElement('button');\n  input.setAttribute('type', 'button');\n  input.classList.add(`ql-${format}`);\n  input.setAttribute('aria-pressed', 'false');\n  if (value != null) {\n    input.value = value;\n    input.setAttribute('aria-label', `${format}: ${value}`);\n  } else {\n    input.setAttribute('aria-label', format);\n  }\n  container.appendChild(input);\n}\nfunction addControls(container, groups) {\n  if (!Array.isArray(groups[0])) {\n    // @ts-expect-error\n    groups = [groups];\n  }\n  groups.forEach(controls => {\n    const group = document.createElement('span');\n    group.classList.add('ql-formats');\n    controls.forEach(control => {\n      if (typeof control === 'string') {\n        addButton(group, control);\n      } else {\n        const format = Object.keys(control)[0];\n        const value = control[format];\n        if (Array.isArray(value)) {\n          addSelect(group, format, value);\n        } else {\n          addButton(group, format, value);\n        }\n      }\n    });\n    container.appendChild(group);\n  });\n}\nfunction addSelect(container, format, values) {\n  const input = document.createElement('select');\n  input.classList.add(`ql-${format}`);\n  values.forEach(value => {\n    const option = document.createElement('option');\n    if (value !== false) {\n      option.setAttribute('value', String(value));\n    } else {\n      option.setAttribute('selected', 'selected');\n    }\n    input.appendChild(option);\n  });\n  container.appendChild(input);\n}\nToolbar.DEFAULTS = {\n  container: null,\n  handlers: {\n    clean() {\n      const range = this.quill.getSelection();\n      if (range == null) return;\n      if (range.length === 0) {\n        const formats = this.quill.getFormat();\n        Object.keys(formats).forEach(name => {\n          // Clean functionality in existing apps only clean inline formats\n          if (this.quill.scroll.query(name, parchment__WEBPACK_IMPORTED_MODULE_4__.Scope.INLINE) != null) {\n            this.quill.format(name, false, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n          }\n        });\n      } else {\n        this.quill.removeFormat(range.index, range.length, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      }\n    },\n    direction(value) {\n      const {\n        align\n      } = this.quill.getFormat();\n      if (value === 'rtl' && align == null) {\n        this.quill.format('align', 'right', _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      } else if (!value && align === 'right') {\n        this.quill.format('align', false, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      }\n      this.quill.format('direction', value, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n    },\n    indent(value) {\n      const range = this.quill.getSelection();\n      // @ts-expect-error\n      const formats = this.quill.getFormat(range);\n      // @ts-expect-error\n      const indent = parseInt(formats.indent || 0, 10);\n      if (value === '+1' || value === '-1') {\n        let modifier = value === '+1' ? 1 : -1;\n        if (formats.direction === 'rtl') modifier *= -1;\n        this.quill.format('indent', indent + modifier, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      }\n    },\n    link(value) {\n      if (value === true) {\n        value = prompt('Enter link URL:'); // eslint-disable-line no-alert\n      }\n      this.quill.format('link', value, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n    },\n    list(value) {\n      const range = this.quill.getSelection();\n      // @ts-expect-error\n      const formats = this.quill.getFormat(range);\n      if (value === 'check') {\n        if (formats.list === 'checked' || formats.list === 'unchecked') {\n          this.quill.format('list', false, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        } else {\n          this.quill.format('list', 'unchecked', _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        }\n      } else {\n        this.quill.format('list', value, _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n      }\n    }\n  }\n};\n\n//# sourceMappingURL=toolbar.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/toolbar.js?")},"./node_modules/quill/modules/uiNode.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   TTL_FOR_VALID_SELECTION_CHANGE: function() { return /* binding */ TTL_FOR_VALID_SELECTION_CHANGE; }\n/* harmony export */ });\n/* harmony import */ var parchment__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! parchment */ \"./node_modules/parchment/dist/parchment.js\");\n/* harmony import */ var _core_module_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/module.js */ \"./node_modules/quill/core/module.js\");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/quill.js */ \"./node_modules/quill/core/quill.js\");\n\n\n\nconst isMac = /Mac/i.test(navigator.platform);\n\n// Export for testing\nconst TTL_FOR_VALID_SELECTION_CHANGE = 100;\n\n// A loose check to determine if the shortcut can move the caret before a UI node:\n// <ANY_PARENT>[CARET]<div class=\"ql-ui\"></div>[CONTENT]</ANY_PARENT>\nconst canMoveCaretBeforeUINode = event => {\n  if (event.key === 'ArrowLeft' || event.key === 'ArrowRight' ||\n  // RTL scripts or moving from the end of the previous line\n  event.key === 'ArrowUp' || event.key === 'ArrowDown' || event.key === 'Home') {\n    return true;\n  }\n  if (isMac && event.key === 'a' && event.ctrlKey === true) {\n    return true;\n  }\n  return false;\n};\nclass UINode extends _core_module_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  isListening = false;\n  selectionChangeDeadline = 0;\n  constructor(quill, options) {\n    super(quill, options);\n    this.handleArrowKeys();\n    this.handleNavigationShortcuts();\n  }\n  handleArrowKeys() {\n    this.quill.keyboard.addBinding({\n      key: ['ArrowLeft', 'ArrowRight'],\n      offset: 0,\n      shiftKey: null,\n      handler(range, _ref) {\n        let {\n          line,\n          event\n        } = _ref;\n        if (!(line instanceof parchment__WEBPACK_IMPORTED_MODULE_2__.ParentBlot) || !line.uiNode) {\n          return true;\n        }\n        const isRTL = getComputedStyle(line.domNode)['direction'] === 'rtl';\n        if (isRTL && event.key !== 'ArrowRight' || !isRTL && event.key !== 'ArrowLeft') {\n          return true;\n        }\n        this.quill.setSelection(range.index - 1, range.length + (event.shiftKey ? 1 : 0), _core_quill_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].sources.USER);\n        return false;\n      }\n    });\n  }\n  handleNavigationShortcuts() {\n    this.quill.root.addEventListener('keydown', event => {\n      if (!event.defaultPrevented && canMoveCaretBeforeUINode(event)) {\n        this.ensureListeningToSelectionChange();\n      }\n    });\n  }\n\n  /**\n   * We only listen to the `selectionchange` event when\n   * there is an intention of moving the caret to the beginning using shortcuts.\n   * This is primarily implemented to prevent infinite loops, as we are changing\n   * the selection within the handler of a `selectionchange` event.\n   */\n  ensureListeningToSelectionChange() {\n    this.selectionChangeDeadline = Date.now() + TTL_FOR_VALID_SELECTION_CHANGE;\n    if (this.isListening) return;\n    this.isListening = true;\n    const listener = () => {\n      this.isListening = false;\n      if (Date.now() <= this.selectionChangeDeadline) {\n        this.handleSelectionChange();\n      }\n    };\n    document.addEventListener('selectionchange', listener, {\n      once: true\n    });\n  }\n  handleSelectionChange() {\n    const selection = document.getSelection();\n    if (!selection) return;\n    const range = selection.getRangeAt(0);\n    if (range.collapsed !== true || range.startOffset !== 0) return;\n    const line = this.quill.scroll.find(range.startContainer);\n    if (!(line instanceof parchment__WEBPACK_IMPORTED_MODULE_2__.ParentBlot) || !line.uiNode) return;\n    const newRange = document.createRange();\n    newRange.setStartAfter(line.uiNode);\n    newRange.setEndAfter(line.uiNode);\n    selection.removeAllRanges();\n    selection.addRange(newRange);\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (UINode);\n//# sourceMappingURL=uiNode.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/uiNode.js?")},"./node_modules/quill/modules/uploader.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var quill_delta__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! quill-delta */ "./node_modules/quill-delta/dist/Delta.js");\n/* harmony import */ var _core_emitter_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/emitter.js */ "./node_modules/quill/core/emitter.js");\n/* harmony import */ var _core_module_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/module.js */ "./node_modules/quill/core/module.js");\n\n\n\nclass Uploader extends _core_module_js__WEBPACK_IMPORTED_MODULE_2__["default"] {\n  constructor(quill, options) {\n    super(quill, options);\n    quill.root.addEventListener(\'drop\', e => {\n      e.preventDefault();\n      let native = null;\n      if (document.caretRangeFromPoint) {\n        native = document.caretRangeFromPoint(e.clientX, e.clientY);\n        // @ts-expect-error\n      } else if (document.caretPositionFromPoint) {\n        // @ts-expect-error\n        const position = document.caretPositionFromPoint(e.clientX, e.clientY);\n        native = document.createRange();\n        native.setStart(position.offsetNode, position.offset);\n        native.setEnd(position.offsetNode, position.offset);\n      }\n      const normalized = native && quill.selection.normalizeNative(native);\n      if (normalized) {\n        const range = quill.selection.normalizedToRange(normalized);\n        if (e.dataTransfer?.files) {\n          this.upload(range, e.dataTransfer.files);\n        }\n      }\n    });\n  }\n  upload(range, files) {\n    const uploads = [];\n    Array.from(files).forEach(file => {\n      if (file && this.options.mimetypes?.includes(file.type)) {\n        uploads.push(file);\n      }\n    });\n    if (uploads.length > 0) {\n      // @ts-expect-error Fix me later\n      this.options.handler.call(this, range, uploads);\n    }\n  }\n}\nUploader.DEFAULTS = {\n  mimetypes: [\'image/png\', \'image/jpeg\'],\n  handler(range, files) {\n    if (!this.quill.scroll.query(\'image\')) {\n      return;\n    }\n    const promises = files.map(file => {\n      return new Promise(resolve => {\n        const reader = new FileReader();\n        reader.onload = () => {\n          resolve(reader.result);\n        };\n        reader.readAsDataURL(file);\n      });\n    });\n    Promise.all(promises).then(images => {\n      const update = images.reduce((delta, image) => {\n        return delta.insert({\n          image\n        });\n      }, new quill_delta__WEBPACK_IMPORTED_MODULE_0__().retain(range.index).delete(range.length));\n      this.quill.updateContents(update, _core_emitter_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.USER);\n      this.quill.setSelection(range.index + images.length, _core_emitter_js__WEBPACK_IMPORTED_MODULE_1__["default"].sources.SILENT);\n    });\n  }\n};\n/* harmony default export */ __webpack_exports__["default"] = (Uploader);\n//# sourceMappingURL=uploader.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/modules/uploader.js?')},"./node_modules/quill/quill.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   AttributeMap: function() { return /* reexport safe */ _core_js__WEBPACK_IMPORTED_MODULE_0__.AttributeMap; },\n/* harmony export */   Delta: function() { return /* reexport safe */ _core_js__WEBPACK_IMPORTED_MODULE_0__.Delta; },\n/* harmony export */   Module: function() { return /* reexport safe */ _core_js__WEBPACK_IMPORTED_MODULE_0__.Module; },\n/* harmony export */   Op: function() { return /* reexport safe */ _core_js__WEBPACK_IMPORTED_MODULE_0__.Op; },\n/* harmony export */   OpIterator: function() { return /* reexport safe */ _core_js__WEBPACK_IMPORTED_MODULE_0__.OpIterator; },\n/* harmony export */   Parchment: function() { return /* reexport safe */ _core_js__WEBPACK_IMPORTED_MODULE_0__.Parchment; },\n/* harmony export */   Range: function() { return /* reexport safe */ _core_js__WEBPACK_IMPORTED_MODULE_0__.Range; }\n/* harmony export */ });\n/* harmony import */ var _core_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core.js */ "./node_modules/quill/core.js");\n/* harmony import */ var _formats_align_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./formats/align.js */ "./node_modules/quill/formats/align.js");\n/* harmony import */ var _formats_direction_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./formats/direction.js */ "./node_modules/quill/formats/direction.js");\n/* harmony import */ var _formats_indent_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./formats/indent.js */ "./node_modules/quill/formats/indent.js");\n/* harmony import */ var _formats_blockquote_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./formats/blockquote.js */ "./node_modules/quill/formats/blockquote.js");\n/* harmony import */ var _formats_header_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./formats/header.js */ "./node_modules/quill/formats/header.js");\n/* harmony import */ var _formats_list_js__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./formats/list.js */ "./node_modules/quill/formats/list.js");\n/* harmony import */ var _formats_background_js__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./formats/background.js */ "./node_modules/quill/formats/background.js");\n/* harmony import */ var _formats_color_js__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./formats/color.js */ "./node_modules/quill/formats/color.js");\n/* harmony import */ var _formats_font_js__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./formats/font.js */ "./node_modules/quill/formats/font.js");\n/* harmony import */ var _formats_size_js__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./formats/size.js */ "./node_modules/quill/formats/size.js");\n/* harmony import */ var _formats_bold_js__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./formats/bold.js */ "./node_modules/quill/formats/bold.js");\n/* harmony import */ var _formats_italic_js__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./formats/italic.js */ "./node_modules/quill/formats/italic.js");\n/* harmony import */ var _formats_link_js__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./formats/link.js */ "./node_modules/quill/formats/link.js");\n/* harmony import */ var _formats_script_js__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./formats/script.js */ "./node_modules/quill/formats/script.js");\n/* harmony import */ var _formats_strike_js__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./formats/strike.js */ "./node_modules/quill/formats/strike.js");\n/* harmony import */ var _formats_underline_js__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./formats/underline.js */ "./node_modules/quill/formats/underline.js");\n/* harmony import */ var _formats_formula_js__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./formats/formula.js */ "./node_modules/quill/formats/formula.js");\n/* harmony import */ var _formats_image_js__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./formats/image.js */ "./node_modules/quill/formats/image.js");\n/* harmony import */ var _formats_video_js__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./formats/video.js */ "./node_modules/quill/formats/video.js");\n/* harmony import */ var _formats_code_js__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./formats/code.js */ "./node_modules/quill/formats/code.js");\n/* harmony import */ var _modules_syntax_js__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./modules/syntax.js */ "./node_modules/quill/modules/syntax.js");\n/* harmony import */ var _modules_table_js__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./modules/table.js */ "./node_modules/quill/modules/table.js");\n/* harmony import */ var _modules_toolbar_js__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./modules/toolbar.js */ "./node_modules/quill/modules/toolbar.js");\n/* harmony import */ var _ui_icons_js__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./ui/icons.js */ "./node_modules/quill/ui/icons.js");\n/* harmony import */ var _ui_picker_js__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./ui/picker.js */ "./node_modules/quill/ui/picker.js");\n/* harmony import */ var _ui_color_picker_js__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./ui/color-picker.js */ "./node_modules/quill/ui/color-picker.js");\n/* harmony import */ var _ui_icon_picker_js__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./ui/icon-picker.js */ "./node_modules/quill/ui/icon-picker.js");\n/* harmony import */ var _ui_tooltip_js__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./ui/tooltip.js */ "./node_modules/quill/ui/tooltip.js");\n/* harmony import */ var _themes_bubble_js__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./themes/bubble.js */ "./node_modules/quill/themes/bubble.js");\n/* harmony import */ var _themes_snow_js__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./themes/snow.js */ "./node_modules/quill/themes/snow.js");\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n_core_js__WEBPACK_IMPORTED_MODULE_0__["default"].register({\n  \'attributors/attribute/direction\': _formats_direction_js__WEBPACK_IMPORTED_MODULE_2__.DirectionAttribute,\n  \'attributors/class/align\': _formats_align_js__WEBPACK_IMPORTED_MODULE_1__.AlignClass,\n  \'attributors/class/background\': _formats_background_js__WEBPACK_IMPORTED_MODULE_7__.BackgroundClass,\n  \'attributors/class/color\': _formats_color_js__WEBPACK_IMPORTED_MODULE_8__.ColorClass,\n  \'attributors/class/direction\': _formats_direction_js__WEBPACK_IMPORTED_MODULE_2__.DirectionClass,\n  \'attributors/class/font\': _formats_font_js__WEBPACK_IMPORTED_MODULE_9__.FontClass,\n  \'attributors/class/size\': _formats_size_js__WEBPACK_IMPORTED_MODULE_10__.SizeClass,\n  \'attributors/style/align\': _formats_align_js__WEBPACK_IMPORTED_MODULE_1__.AlignStyle,\n  \'attributors/style/background\': _formats_background_js__WEBPACK_IMPORTED_MODULE_7__.BackgroundStyle,\n  \'attributors/style/color\': _formats_color_js__WEBPACK_IMPORTED_MODULE_8__.ColorStyle,\n  \'attributors/style/direction\': _formats_direction_js__WEBPACK_IMPORTED_MODULE_2__.DirectionStyle,\n  \'attributors/style/font\': _formats_font_js__WEBPACK_IMPORTED_MODULE_9__.FontStyle,\n  \'attributors/style/size\': _formats_size_js__WEBPACK_IMPORTED_MODULE_10__.SizeStyle\n}, true);\n_core_js__WEBPACK_IMPORTED_MODULE_0__["default"].register({\n  \'formats/align\': _formats_align_js__WEBPACK_IMPORTED_MODULE_1__.AlignClass,\n  \'formats/direction\': _formats_direction_js__WEBPACK_IMPORTED_MODULE_2__.DirectionClass,\n  \'formats/indent\': _formats_indent_js__WEBPACK_IMPORTED_MODULE_3__["default"],\n  \'formats/background\': _formats_background_js__WEBPACK_IMPORTED_MODULE_7__.BackgroundStyle,\n  \'formats/color\': _formats_color_js__WEBPACK_IMPORTED_MODULE_8__.ColorStyle,\n  \'formats/font\': _formats_font_js__WEBPACK_IMPORTED_MODULE_9__.FontClass,\n  \'formats/size\': _formats_size_js__WEBPACK_IMPORTED_MODULE_10__.SizeClass,\n  \'formats/blockquote\': _formats_blockquote_js__WEBPACK_IMPORTED_MODULE_4__["default"],\n  \'formats/code-block\': _formats_code_js__WEBPACK_IMPORTED_MODULE_20__["default"],\n  \'formats/header\': _formats_header_js__WEBPACK_IMPORTED_MODULE_5__["default"],\n  \'formats/list\': _formats_list_js__WEBPACK_IMPORTED_MODULE_6__["default"],\n  \'formats/bold\': _formats_bold_js__WEBPACK_IMPORTED_MODULE_11__["default"],\n  \'formats/code\': _formats_code_js__WEBPACK_IMPORTED_MODULE_20__.Code,\n  \'formats/italic\': _formats_italic_js__WEBPACK_IMPORTED_MODULE_12__["default"],\n  \'formats/link\': _formats_link_js__WEBPACK_IMPORTED_MODULE_13__["default"],\n  \'formats/script\': _formats_script_js__WEBPACK_IMPORTED_MODULE_14__["default"],\n  \'formats/strike\': _formats_strike_js__WEBPACK_IMPORTED_MODULE_15__["default"],\n  \'formats/underline\': _formats_underline_js__WEBPACK_IMPORTED_MODULE_16__["default"],\n  \'formats/formula\': _formats_formula_js__WEBPACK_IMPORTED_MODULE_17__["default"],\n  \'formats/image\': _formats_image_js__WEBPACK_IMPORTED_MODULE_18__["default"],\n  \'formats/video\': _formats_video_js__WEBPACK_IMPORTED_MODULE_19__["default"],\n  \'modules/syntax\': _modules_syntax_js__WEBPACK_IMPORTED_MODULE_21__["default"],\n  \'modules/table\': _modules_table_js__WEBPACK_IMPORTED_MODULE_22__["default"],\n  \'modules/toolbar\': _modules_toolbar_js__WEBPACK_IMPORTED_MODULE_23__["default"],\n  \'themes/bubble\': _themes_bubble_js__WEBPACK_IMPORTED_MODULE_29__["default"],\n  \'themes/snow\': _themes_snow_js__WEBPACK_IMPORTED_MODULE_30__["default"],\n  \'ui/icons\': _ui_icons_js__WEBPACK_IMPORTED_MODULE_24__["default"],\n  \'ui/picker\': _ui_picker_js__WEBPACK_IMPORTED_MODULE_25__["default"],\n  \'ui/icon-picker\': _ui_icon_picker_js__WEBPACK_IMPORTED_MODULE_27__["default"],\n  \'ui/color-picker\': _ui_color_picker_js__WEBPACK_IMPORTED_MODULE_26__["default"],\n  \'ui/tooltip\': _ui_tooltip_js__WEBPACK_IMPORTED_MODULE_28__["default"]\n}, true);\n\n/* harmony default export */ __webpack_exports__["default"] = (_core_js__WEBPACK_IMPORTED_MODULE_0__["default"]);\n//# sourceMappingURL=quill.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/quill.js?')},"./node_modules/quill/themes/base.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BaseTooltip: function() { return /* binding */ BaseTooltip; },\n/* harmony export */   \"default\": function() { return /* binding */ BaseTheme; }\n/* harmony export */ });\n/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash-es */ \"./node_modules/lodash-es/merge.js\");\n/* harmony import */ var _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/emitter.js */ \"./node_modules/quill/core/emitter.js\");\n/* harmony import */ var _core_theme_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../core/theme.js */ \"./node_modules/quill/core/theme.js\");\n/* harmony import */ var _ui_color_picker_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../ui/color-picker.js */ \"./node_modules/quill/ui/color-picker.js\");\n/* harmony import */ var _ui_icon_picker_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../ui/icon-picker.js */ \"./node_modules/quill/ui/icon-picker.js\");\n/* harmony import */ var _ui_picker_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../ui/picker.js */ \"./node_modules/quill/ui/picker.js\");\n/* harmony import */ var _ui_tooltip_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../ui/tooltip.js */ \"./node_modules/quill/ui/tooltip.js\");\n\n\n\n\n\n\n\nconst ALIGNS = [false, 'center', 'right', 'justify'];\nconst COLORS = ['#000000', '#e60000', '#ff9900', '#ffff00', '#008a00', '#0066cc', '#9933ff', '#ffffff', '#facccc', '#ffebcc', '#ffffcc', '#cce8cc', '#cce0f5', '#ebd6ff', '#bbbbbb', '#f06666', '#ffc266', '#ffff66', '#66b966', '#66a3e0', '#c285ff', '#888888', '#a10000', '#b26b00', '#b2b200', '#006100', '#0047b2', '#6b24b2', '#444444', '#5c0000', '#663d00', '#666600', '#003700', '#002966', '#3d1466'];\nconst FONTS = [false, 'serif', 'monospace'];\nconst HEADERS = ['1', '2', '3', false];\nconst SIZES = ['small', false, 'large', 'huge'];\nclass BaseTheme extends _core_theme_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"] {\n  constructor(quill, options) {\n    super(quill, options);\n    const listener = e => {\n      if (!document.body.contains(quill.root)) {\n        document.body.removeEventListener('click', listener);\n        return;\n      }\n      if (this.tooltip != null &&\n      // @ts-expect-error\n      !this.tooltip.root.contains(e.target) &&\n      // @ts-expect-error\n      document.activeElement !== this.tooltip.textbox && !this.quill.hasFocus()) {\n        this.tooltip.hide();\n      }\n      if (this.pickers != null) {\n        this.pickers.forEach(picker => {\n          // @ts-expect-error\n          if (!picker.container.contains(e.target)) {\n            picker.close();\n          }\n        });\n      }\n    };\n    quill.emitter.listenDOM('click', document.body, listener);\n  }\n  addModule(name) {\n    const module = super.addModule(name);\n    if (name === 'toolbar') {\n      // @ts-expect-error\n      this.extendToolbar(module);\n    }\n    return module;\n  }\n  buildButtons(buttons, icons) {\n    Array.from(buttons).forEach(button => {\n      const className = button.getAttribute('class') || '';\n      className.split(/\\s+/).forEach(name => {\n        if (!name.startsWith('ql-')) return;\n        name = name.slice('ql-'.length);\n        if (icons[name] == null) return;\n        if (name === 'direction') {\n          // @ts-expect-error\n          button.innerHTML = icons[name][''] + icons[name].rtl;\n        } else if (typeof icons[name] === 'string') {\n          // @ts-expect-error\n          button.innerHTML = icons[name];\n        } else {\n          // @ts-expect-error\n          const value = button.value || '';\n          // @ts-expect-error\n          if (value != null && icons[name][value]) {\n            // @ts-expect-error\n            button.innerHTML = icons[name][value];\n          }\n        }\n      });\n    });\n  }\n  buildPickers(selects, icons) {\n    this.pickers = Array.from(selects).map(select => {\n      if (select.classList.contains('ql-align')) {\n        if (select.querySelector('option') == null) {\n          fillSelect(select, ALIGNS);\n        }\n        if (typeof icons.align === 'object') {\n          return new _ui_icon_picker_js__WEBPACK_IMPORTED_MODULE_3__[\"default\"](select, icons.align);\n        }\n      }\n      if (select.classList.contains('ql-background') || select.classList.contains('ql-color')) {\n        const format = select.classList.contains('ql-background') ? 'background' : 'color';\n        if (select.querySelector('option') == null) {\n          fillSelect(select, COLORS, format === 'background' ? '#ffffff' : '#000000');\n        }\n        return new _ui_color_picker_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"](select, icons[format]);\n      }\n      if (select.querySelector('option') == null) {\n        if (select.classList.contains('ql-font')) {\n          fillSelect(select, FONTS);\n        } else if (select.classList.contains('ql-header')) {\n          fillSelect(select, HEADERS);\n        } else if (select.classList.contains('ql-size')) {\n          fillSelect(select, SIZES);\n        }\n      }\n      return new _ui_picker_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"](select);\n    });\n    const update = () => {\n      this.pickers.forEach(picker => {\n        picker.update();\n      });\n    };\n    this.quill.on(_core_emitter_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].events.EDITOR_CHANGE, update);\n  }\n}\nBaseTheme.DEFAULTS = (0,lodash_es__WEBPACK_IMPORTED_MODULE_6__[\"default\"])({}, _core_theme_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].DEFAULTS, {\n  modules: {\n    toolbar: {\n      handlers: {\n        formula() {\n          this.quill.theme.tooltip.edit('formula');\n        },\n        image() {\n          let fileInput = this.container.querySelector('input.ql-image[type=file]');\n          if (fileInput == null) {\n            fileInput = document.createElement('input');\n            fileInput.setAttribute('type', 'file');\n            fileInput.setAttribute('accept', this.quill.uploader.options.mimetypes.join(', '));\n            fileInput.classList.add('ql-image');\n            fileInput.addEventListener('change', () => {\n              const range = this.quill.getSelection(true);\n              this.quill.uploader.upload(range, fileInput.files);\n              fileInput.value = '';\n            });\n            this.container.appendChild(fileInput);\n          }\n          fileInput.click();\n        },\n        video() {\n          this.quill.theme.tooltip.edit('video');\n        }\n      }\n    }\n  }\n});\nclass BaseTooltip extends _ui_tooltip_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"] {\n  constructor(quill, boundsContainer) {\n    super(quill, boundsContainer);\n    this.textbox = this.root.querySelector('input[type=\"text\"]');\n    this.listen();\n  }\n  listen() {\n    // @ts-expect-error Fix me later\n    this.textbox.addEventListener('keydown', event => {\n      if (event.key === 'Enter') {\n        this.save();\n        event.preventDefault();\n      } else if (event.key === 'Escape') {\n        this.cancel();\n        event.preventDefault();\n      }\n    });\n  }\n  cancel() {\n    this.hide();\n    this.restoreFocus();\n  }\n  edit() {\n    let mode = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 'link';\n    let preview = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;\n    this.root.classList.remove('ql-hidden');\n    this.root.classList.add('ql-editing');\n    if (this.textbox == null) return;\n    if (preview != null) {\n      this.textbox.value = preview;\n    } else if (mode !== this.root.getAttribute('data-mode')) {\n      this.textbox.value = '';\n    }\n    const bounds = this.quill.getBounds(this.quill.selection.savedRange);\n    if (bounds != null) {\n      this.position(bounds);\n    }\n    this.textbox.select();\n    this.textbox.setAttribute('placeholder', this.textbox.getAttribute(`data-${mode}`) || '');\n    this.root.setAttribute('data-mode', mode);\n  }\n  restoreFocus() {\n    this.quill.focus({\n      preventScroll: true\n    });\n  }\n  save() {\n    // @ts-expect-error Fix me later\n    let {\n      value\n    } = this.textbox;\n    switch (this.root.getAttribute('data-mode')) {\n      case 'link':\n        {\n          const {\n            scrollTop\n          } = this.quill.root;\n          if (this.linkRange) {\n            this.quill.formatText(this.linkRange, 'link', value, _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].sources.USER);\n            delete this.linkRange;\n          } else {\n            this.restoreFocus();\n            this.quill.format('link', value, _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].sources.USER);\n          }\n          this.quill.root.scrollTop = scrollTop;\n          break;\n        }\n      case 'video':\n        {\n          value = extractVideoUrl(value);\n        }\n      // eslint-disable-next-line no-fallthrough\n      case 'formula':\n        {\n          if (!value) break;\n          const range = this.quill.getSelection(true);\n          if (range != null) {\n            const index = range.index + range.length;\n            this.quill.insertEmbed(index,\n            // @ts-expect-error Fix me later\n            this.root.getAttribute('data-mode'), value, _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].sources.USER);\n            if (this.root.getAttribute('data-mode') === 'formula') {\n              this.quill.insertText(index + 1, ' ', _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].sources.USER);\n            }\n            this.quill.setSelection(index + 2, _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].sources.USER);\n          }\n          break;\n        }\n      default:\n    }\n    // @ts-expect-error Fix me later\n    this.textbox.value = '';\n    this.hide();\n  }\n}\nfunction extractVideoUrl(url) {\n  let match = url.match(/^(?:(https?):\\/\\/)?(?:(?:www|m)\\.)?youtube\\.com\\/watch.*v=([a-zA-Z0-9_-]+)/) || url.match(/^(?:(https?):\\/\\/)?(?:(?:www|m)\\.)?youtu\\.be\\/([a-zA-Z0-9_-]+)/);\n  if (match) {\n    return `${match[1] || 'https'}://www.youtube.com/embed/${match[2]}?showinfo=0`;\n  }\n  // eslint-disable-next-line no-cond-assign\n  if (match = url.match(/^(?:(https?):\\/\\/)?(?:www\\.)?vimeo\\.com\\/(\\d+)/)) {\n    return `${match[1] || 'https'}://player.vimeo.com/video/${match[2]}/`;\n  }\n  return url;\n}\nfunction fillSelect(select, values) {\n  let defaultValue = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;\n  values.forEach(value => {\n    const option = document.createElement('option');\n    if (value === defaultValue) {\n      option.setAttribute('selected', 'selected');\n    } else {\n      option.setAttribute('value', String(value));\n    }\n    select.appendChild(option);\n  });\n}\n\n//# sourceMappingURL=base.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/themes/base.js?")},"./node_modules/quill/themes/bubble.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\n/* harmony export */ __webpack_require__.d(__webpack_exports__, {\n/* harmony export */   BubbleTooltip: function() { return /* binding */ BubbleTooltip; },\n/* harmony export */   "default": function() { return /* binding */ BubbleTheme; }\n/* harmony export */ });\n/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! lodash-es */ "./node_modules/lodash-es/merge.js");\n/* harmony import */ var _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/emitter.js */ "./node_modules/quill/core/emitter.js");\n/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./base.js */ "./node_modules/quill/themes/base.js");\n/* harmony import */ var _core_selection_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../core/selection.js */ "./node_modules/quill/core/selection.js");\n/* harmony import */ var _ui_icons_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../ui/icons.js */ "./node_modules/quill/ui/icons.js");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../core/quill.js */ "./node_modules/quill/core/quill.js");\n\n\n\n\n\n\nconst TOOLBAR_CONFIG = [[\'bold\', \'italic\', \'link\'], [{\n  header: 1\n}, {\n  header: 2\n}, \'blockquote\']];\nclass BubbleTooltip extends _base_js__WEBPACK_IMPORTED_MODULE_1__.BaseTooltip {\n  static TEMPLATE = [\'<span class="ql-tooltip-arrow"></span>\', \'<div class="ql-tooltip-editor">\', \'<input type="text" data-formula="e=mc^2" data-link="https://quilljs.com" data-video="Embed URL">\', \'<a class="ql-close"></a>\', \'</div>\'].join(\'\');\n  constructor(quill, bounds) {\n    super(quill, bounds);\n    this.quill.on(_core_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].events.EDITOR_CHANGE, (type, range, oldRange, source) => {\n      if (type !== _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].events.SELECTION_CHANGE) return;\n      if (range != null && range.length > 0 && source === _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].sources.USER) {\n        this.show();\n        // Lock our width so we will expand beyond our offsetParent boundaries\n        this.root.style.left = \'0px\';\n        this.root.style.width = \'\';\n        this.root.style.width = `${this.root.offsetWidth}px`;\n        const lines = this.quill.getLines(range.index, range.length);\n        if (lines.length === 1) {\n          const bounds = this.quill.getBounds(range);\n          if (bounds != null) {\n            this.position(bounds);\n          }\n        } else {\n          const lastLine = lines[lines.length - 1];\n          const index = this.quill.getIndex(lastLine);\n          const length = Math.min(lastLine.length() - 1, range.index + range.length - index);\n          const indexBounds = this.quill.getBounds(new _core_selection_js__WEBPACK_IMPORTED_MODULE_2__.Range(index, length));\n          if (indexBounds != null) {\n            this.position(indexBounds);\n          }\n        }\n      } else if (document.activeElement !== this.textbox && this.quill.hasFocus()) {\n        this.hide();\n      }\n    });\n  }\n  listen() {\n    super.listen();\n    // @ts-expect-error Fix me later\n    this.root.querySelector(\'.ql-close\').addEventListener(\'click\', () => {\n      this.root.classList.remove(\'ql-editing\');\n    });\n    this.quill.on(_core_emitter_js__WEBPACK_IMPORTED_MODULE_0__["default"].events.SCROLL_OPTIMIZE, () => {\n      // Let selection be restored by toolbar handlers before repositioning\n      setTimeout(() => {\n        if (this.root.classList.contains(\'ql-hidden\')) return;\n        const range = this.quill.getSelection();\n        if (range != null) {\n          const bounds = this.quill.getBounds(range);\n          if (bounds != null) {\n            this.position(bounds);\n          }\n        }\n      }, 1);\n    });\n  }\n  cancel() {\n    this.show();\n  }\n  position(reference) {\n    const shift = super.position(reference);\n    const arrow = this.root.querySelector(\'.ql-tooltip-arrow\');\n    // @ts-expect-error\n    arrow.style.marginLeft = \'\';\n    if (shift !== 0) {\n      // @ts-expect-error\n      arrow.style.marginLeft = `${-1 * shift - arrow.offsetWidth / 2}px`;\n    }\n    return shift;\n  }\n}\nclass BubbleTheme extends _base_js__WEBPACK_IMPORTED_MODULE_1__["default"] {\n  constructor(quill, options) {\n    if (options.modules.toolbar != null && options.modules.toolbar.container == null) {\n      options.modules.toolbar.container = TOOLBAR_CONFIG;\n    }\n    super(quill, options);\n    this.quill.container.classList.add(\'ql-bubble\');\n  }\n  extendToolbar(toolbar) {\n    // @ts-expect-error\n    this.tooltip = new BubbleTooltip(this.quill, this.options.bounds);\n    if (toolbar.container != null) {\n      this.tooltip.root.appendChild(toolbar.container);\n      this.buildButtons(toolbar.container.querySelectorAll(\'button\'), _ui_icons_js__WEBPACK_IMPORTED_MODULE_3__["default"]);\n      this.buildPickers(toolbar.container.querySelectorAll(\'select\'), _ui_icons_js__WEBPACK_IMPORTED_MODULE_3__["default"]);\n    }\n  }\n}\nBubbleTheme.DEFAULTS = (0,lodash_es__WEBPACK_IMPORTED_MODULE_5__["default"])({}, _base_js__WEBPACK_IMPORTED_MODULE_1__["default"].DEFAULTS, {\n  modules: {\n    toolbar: {\n      handlers: {\n        link(value) {\n          if (!value) {\n            this.quill.format(\'link\', false, _core_quill_js__WEBPACK_IMPORTED_MODULE_4__["default"].sources.USER);\n          } else {\n            // @ts-expect-error\n            this.quill.theme.tooltip.edit();\n          }\n        }\n      }\n    }\n  }\n});\n\n//# sourceMappingURL=bubble.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/themes/bubble.js?')},"./node_modules/quill/themes/snow.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var lodash_es__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! lodash-es */ \"./node_modules/lodash-es/merge.js\");\n/* harmony import */ var _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../core/emitter.js */ \"./node_modules/quill/core/emitter.js\");\n/* harmony import */ var _base_js__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./base.js */ \"./node_modules/quill/themes/base.js\");\n/* harmony import */ var _formats_link_js__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../formats/link.js */ \"./node_modules/quill/formats/link.js\");\n/* harmony import */ var _core_selection_js__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../core/selection.js */ \"./node_modules/quill/core/selection.js\");\n/* harmony import */ var _ui_icons_js__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../ui/icons.js */ \"./node_modules/quill/ui/icons.js\");\n/* harmony import */ var _core_quill_js__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../core/quill.js */ \"./node_modules/quill/core/quill.js\");\n\n\n\n\n\n\n\nconst TOOLBAR_CONFIG = [[{\n  header: ['1', '2', '3', false]\n}], ['bold', 'italic', 'underline', 'link'], [{\n  list: 'ordered'\n}, {\n  list: 'bullet'\n}], ['clean']];\nclass SnowTooltip extends _base_js__WEBPACK_IMPORTED_MODULE_1__.BaseTooltip {\n  static TEMPLATE = ['<a class=\"ql-preview\" rel=\"noopener noreferrer\" target=\"_blank\" href=\"about:blank\"></a>', '<input type=\"text\" data-formula=\"e=mc^2\" data-link=\"https://quilljs.com\" data-video=\"Embed URL\">', '<a class=\"ql-action\"></a>', '<a class=\"ql-remove\"></a>'].join('');\n  preview = this.root.querySelector('a.ql-preview');\n  listen() {\n    super.listen();\n    // @ts-expect-error Fix me later\n    this.root.querySelector('a.ql-action').addEventListener('click', event => {\n      if (this.root.classList.contains('ql-editing')) {\n        this.save();\n      } else {\n        // @ts-expect-error Fix me later\n        this.edit('link', this.preview.textContent);\n      }\n      event.preventDefault();\n    });\n    // @ts-expect-error Fix me later\n    this.root.querySelector('a.ql-remove').addEventListener('click', event => {\n      if (this.linkRange != null) {\n        const range = this.linkRange;\n        this.restoreFocus();\n        this.quill.formatText(range, 'link', false, _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].sources.USER);\n        delete this.linkRange;\n      }\n      event.preventDefault();\n      this.hide();\n    });\n    this.quill.on(_core_emitter_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].events.SELECTION_CHANGE, (range, oldRange, source) => {\n      if (range == null) return;\n      if (range.length === 0 && source === _core_emitter_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"].sources.USER) {\n        const [link, offset] = this.quill.scroll.descendant(_formats_link_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"], range.index);\n        if (link != null) {\n          this.linkRange = new _core_selection_js__WEBPACK_IMPORTED_MODULE_3__.Range(range.index - offset, link.length());\n          const preview = _formats_link_js__WEBPACK_IMPORTED_MODULE_2__[\"default\"].formats(link.domNode);\n          // @ts-expect-error Fix me later\n          this.preview.textContent = preview;\n          // @ts-expect-error Fix me later\n          this.preview.setAttribute('href', preview);\n          this.show();\n          const bounds = this.quill.getBounds(this.linkRange);\n          if (bounds != null) {\n            this.position(bounds);\n          }\n          return;\n        }\n      } else {\n        delete this.linkRange;\n      }\n      this.hide();\n    });\n  }\n  show() {\n    super.show();\n    this.root.removeAttribute('data-mode');\n  }\n}\nclass SnowTheme extends _base_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"] {\n  constructor(quill, options) {\n    if (options.modules.toolbar != null && options.modules.toolbar.container == null) {\n      options.modules.toolbar.container = TOOLBAR_CONFIG;\n    }\n    super(quill, options);\n    this.quill.container.classList.add('ql-snow');\n  }\n  extendToolbar(toolbar) {\n    if (toolbar.container != null) {\n      toolbar.container.classList.add('ql-snow');\n      this.buildButtons(toolbar.container.querySelectorAll('button'), _ui_icons_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]);\n      this.buildPickers(toolbar.container.querySelectorAll('select'), _ui_icons_js__WEBPACK_IMPORTED_MODULE_4__[\"default\"]);\n      // @ts-expect-error\n      this.tooltip = new SnowTooltip(this.quill, this.options.bounds);\n      if (toolbar.container.querySelector('.ql-link')) {\n        this.quill.keyboard.addBinding({\n          key: 'k',\n          shortKey: true\n        }, (_range, context) => {\n          toolbar.handlers.link.call(toolbar, !context.format.link);\n        });\n      }\n    }\n  }\n}\nSnowTheme.DEFAULTS = (0,lodash_es__WEBPACK_IMPORTED_MODULE_6__[\"default\"])({}, _base_js__WEBPACK_IMPORTED_MODULE_1__[\"default\"].DEFAULTS, {\n  modules: {\n    toolbar: {\n      handlers: {\n        link(value) {\n          if (value) {\n            const range = this.quill.getSelection();\n            if (range == null || range.length === 0) return;\n            let preview = this.quill.getText(range);\n            if (/^\\S+@\\S+\\.\\S+$/.test(preview) && preview.indexOf('mailto:') !== 0) {\n              preview = `mailto:${preview}`;\n            }\n            // @ts-expect-error\n            const {\n              tooltip\n            } = this.quill.theme;\n            tooltip.edit('link', preview);\n          } else {\n            this.quill.format('link', false, _core_quill_js__WEBPACK_IMPORTED_MODULE_5__[\"default\"].sources.USER);\n          }\n        }\n      }\n    }\n  }\n});\n/* harmony default export */ __webpack_exports__[\"default\"] = (SnowTheme);\n//# sourceMappingURL=snow.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/themes/snow.js?")},"./node_modules/quill/ui/color-picker.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _picker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./picker.js */ \"./node_modules/quill/ui/picker.js\");\n\nclass ColorPicker extends _picker_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  constructor(select, label) {\n    super(select);\n    this.label.innerHTML = label;\n    this.container.classList.add('ql-color-picker');\n    Array.from(this.container.querySelectorAll('.ql-picker-item')).slice(0, 7).forEach(item => {\n      item.classList.add('ql-primary');\n    });\n  }\n  buildItem(option) {\n    const item = super.buildItem(option);\n    item.style.backgroundColor = option.getAttribute('value') || '';\n    return item;\n  }\n  selectItem(item, trigger) {\n    super.selectItem(item, trigger);\n    const colorLabel = this.label.querySelector('.ql-color-label');\n    const value = item ? item.getAttribute('data-value') || '' : '';\n    if (colorLabel) {\n      if (colorLabel.tagName === 'line') {\n        colorLabel.style.stroke = value;\n      } else {\n        colorLabel.style.fill = value;\n      }\n    }\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (ColorPicker);\n//# sourceMappingURL=color-picker.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/ui/color-picker.js?")},"./node_modules/quill/ui/icon-picker.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\n/* harmony import */ var _picker_js__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./picker.js */ \"./node_modules/quill/ui/picker.js\");\n\nclass IconPicker extends _picker_js__WEBPACK_IMPORTED_MODULE_0__[\"default\"] {\n  constructor(select, icons) {\n    super(select);\n    this.container.classList.add('ql-icon-picker');\n    Array.from(this.container.querySelectorAll('.ql-picker-item')).forEach(item => {\n      item.innerHTML = icons[item.getAttribute('data-value') || ''];\n    });\n    this.defaultItem = this.container.querySelector('.ql-selected');\n    this.selectItem(this.defaultItem);\n  }\n  selectItem(target, trigger) {\n    super.selectItem(target, trigger);\n    const item = target || this.defaultItem;\n    if (item != null) {\n      if (this.label.innerHTML === item.innerHTML) return;\n      this.label.innerHTML = item.innerHTML;\n    }\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (IconPicker);\n//# sourceMappingURL=icon-picker.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/ui/icon-picker.js?")},"./node_modules/quill/ui/icons.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval('__webpack_require__.r(__webpack_exports__);\nconst alignLeftIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"3\\" x2=\\"15\\" y1=\\"9\\" y2=\\"9\\"/><line class=\\"ql-stroke\\" x1=\\"3\\" x2=\\"13\\" y1=\\"14\\" y2=\\"14\\"/><line class=\\"ql-stroke\\" x1=\\"3\\" x2=\\"9\\" y1=\\"4\\" y2=\\"4\\"/></svg>";\nconst alignCenterIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"15\\" x2=\\"3\\" y1=\\"9\\" y2=\\"9\\"/><line class=\\"ql-stroke\\" x1=\\"14\\" x2=\\"4\\" y1=\\"14\\" y2=\\"14\\"/><line class=\\"ql-stroke\\" x1=\\"12\\" x2=\\"6\\" y1=\\"4\\" y2=\\"4\\"/></svg>";\nconst alignRightIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"15\\" x2=\\"3\\" y1=\\"9\\" y2=\\"9\\"/><line class=\\"ql-stroke\\" x1=\\"15\\" x2=\\"5\\" y1=\\"14\\" y2=\\"14\\"/><line class=\\"ql-stroke\\" x1=\\"15\\" x2=\\"9\\" y1=\\"4\\" y2=\\"4\\"/></svg>";\nconst alignJustifyIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"15\\" x2=\\"3\\" y1=\\"9\\" y2=\\"9\\"/><line class=\\"ql-stroke\\" x1=\\"15\\" x2=\\"3\\" y1=\\"14\\" y2=\\"14\\"/><line class=\\"ql-stroke\\" x1=\\"15\\" x2=\\"3\\" y1=\\"4\\" y2=\\"4\\"/></svg>";\nconst backgroundIcon = "<svg viewbox=\\"0 0 18 18\\"><g class=\\"ql-fill ql-color-label\\"><polygon points=\\"6 6.868 6 6 5 6 5 7 5.942 7 6 6.868\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"4\\" y=\\"4\\"/><polygon points=\\"6.817 5 6 5 6 6 6.38 6 6.817 5\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"2\\" y=\\"6\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"3\\" y=\\"5\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"4\\" y=\\"7\\"/><polygon points=\\"4 11.439 4 11 3 11 3 12 3.755 12 4 11.439\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"2\\" y=\\"12\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"2\\" y=\\"9\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"2\\" y=\\"15\\"/><polygon points=\\"4.63 10 4 10 4 11 4.192 11 4.63 10\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"3\\" y=\\"8\\"/><path d=\\"M10.832,4.2L11,4.582V4H10.708A1.948,1.948,0,0,1,10.832,4.2Z\\"/><path d=\\"M7,4.582L7.168,4.2A1.929,1.929,0,0,1,7.292,4H7V4.582Z\\"/><path d=\\"M8,13H7.683l-0.351.8a1.933,1.933,0,0,1-.124.2H8V13Z\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"12\\" y=\\"2\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"11\\" y=\\"3\\"/><path d=\\"M9,3H8V3.282A1.985,1.985,0,0,1,9,3Z\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"2\\" y=\\"3\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"6\\" y=\\"2\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"3\\" y=\\"2\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"5\\" y=\\"3\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"9\\" y=\\"2\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"15\\" y=\\"14\\"/><polygon points=\\"13.447 10.174 13.469 10.225 13.472 10.232 13.808 11 14 11 14 10 13.37 10 13.447 10.174\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"13\\" y=\\"7\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"15\\" y=\\"5\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"14\\" y=\\"6\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"15\\" y=\\"8\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"14\\" y=\\"9\\"/><path d=\\"M3.775,14H3v1H4V14.314A1.97,1.97,0,0,1,3.775,14Z\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"14\\" y=\\"3\\"/><polygon points=\\"12 6.868 12 6 11.62 6 12 6.868\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"15\\" y=\\"2\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"12\\" y=\\"5\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"13\\" y=\\"4\\"/><polygon points=\\"12.933 9 13 9 13 8 12.495 8 12.933 9\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"9\\" y=\\"14\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"8\\" y=\\"15\\"/><path d=\\"M6,14.926V15H7V14.316A1.993,1.993,0,0,1,6,14.926Z\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"5\\" y=\\"15\\"/><path d=\\"M10.668,13.8L10.317,13H10v1h0.792A1.947,1.947,0,0,1,10.668,13.8Z\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"11\\" y=\\"15\\"/><path d=\\"M14.332,12.2a1.99,1.99,0,0,1,.166.8H15V12H14.245Z\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"14\\" y=\\"15\\"/><rect height=\\"1\\" width=\\"1\\" x=\\"15\\" y=\\"11\\"/></g><polyline class=\\"ql-stroke\\" points=\\"5.5 13 9 5 12.5 13\\"/><line class=\\"ql-stroke\\" x1=\\"11.63\\" x2=\\"6.38\\" y1=\\"11\\" y2=\\"11\\"/></svg>";\nconst blockquoteIcon = "<svg viewbox=\\"0 0 18 18\\"><rect class=\\"ql-fill ql-stroke\\" height=\\"3\\" width=\\"3\\" x=\\"4\\" y=\\"5\\"/><rect class=\\"ql-fill ql-stroke\\" height=\\"3\\" width=\\"3\\" x=\\"11\\" y=\\"5\\"/><path class=\\"ql-even ql-fill ql-stroke\\" d=\\"M7,8c0,4.031-3,5-3,5\\"/><path class=\\"ql-even ql-fill ql-stroke\\" d=\\"M14,8c0,4.031-3,5-3,5\\"/></svg>";\nconst boldIcon = "<svg viewbox=\\"0 0 18 18\\"><path class=\\"ql-stroke\\" d=\\"M5,4H9.5A2.5,2.5,0,0,1,12,6.5v0A2.5,2.5,0,0,1,9.5,9H5A0,0,0,0,1,5,9V4A0,0,0,0,1,5,4Z\\"/><path class=\\"ql-stroke\\" d=\\"M5,9h5.5A2.5,2.5,0,0,1,13,11.5v0A2.5,2.5,0,0,1,10.5,14H5a0,0,0,0,1,0,0V9A0,0,0,0,1,5,9Z\\"/></svg>";\nconst cleanIcon = "<svg class=\\"\\" viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"5\\" x2=\\"13\\" y1=\\"3\\" y2=\\"3\\"/><line class=\\"ql-stroke\\" x1=\\"6\\" x2=\\"9.35\\" y1=\\"12\\" y2=\\"3\\"/><line class=\\"ql-stroke\\" x1=\\"11\\" x2=\\"15\\" y1=\\"11\\" y2=\\"15\\"/><line class=\\"ql-stroke\\" x1=\\"15\\" x2=\\"11\\" y1=\\"11\\" y2=\\"15\\"/><rect class=\\"ql-fill\\" height=\\"1\\" rx=\\"0.5\\" ry=\\"0.5\\" width=\\"7\\" x=\\"2\\" y=\\"14\\"/></svg>";\nconst codeIcon = "<svg viewbox=\\"0 0 18 18\\"><polyline class=\\"ql-even ql-stroke\\" points=\\"5 7 3 9 5 11\\"/><polyline class=\\"ql-even ql-stroke\\" points=\\"13 7 15 9 13 11\\"/><line class=\\"ql-stroke\\" x1=\\"10\\" x2=\\"8\\" y1=\\"5\\" y2=\\"13\\"/></svg>";\nconst colorIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-color-label ql-stroke ql-transparent\\" x1=\\"3\\" x2=\\"15\\" y1=\\"15\\" y2=\\"15\\"/><polyline class=\\"ql-stroke\\" points=\\"5.5 11 9 3 12.5 11\\"/><line class=\\"ql-stroke\\" x1=\\"11.63\\" x2=\\"6.38\\" y1=\\"9\\" y2=\\"9\\"/></svg>";\nconst directionLeftToRightIcon = "<svg viewbox=\\"0 0 18 18\\"><polygon class=\\"ql-stroke ql-fill\\" points=\\"3 11 5 9 3 7 3 11\\"/><line class=\\"ql-stroke ql-fill\\" x1=\\"15\\" x2=\\"11\\" y1=\\"4\\" y2=\\"4\\"/><path class=\\"ql-fill\\" d=\\"M11,3a3,3,0,0,0,0,6h1V3H11Z\\"/><rect class=\\"ql-fill\\" height=\\"11\\" width=\\"1\\" x=\\"11\\" y=\\"4\\"/><rect class=\\"ql-fill\\" height=\\"11\\" width=\\"1\\" x=\\"13\\" y=\\"4\\"/></svg>";\nconst directionRightToLeftIcon = "<svg viewbox=\\"0 0 18 18\\"><polygon class=\\"ql-stroke ql-fill\\" points=\\"15 12 13 10 15 8 15 12\\"/><line class=\\"ql-stroke ql-fill\\" x1=\\"9\\" x2=\\"5\\" y1=\\"4\\" y2=\\"4\\"/><path class=\\"ql-fill\\" d=\\"M5,3A3,3,0,0,0,5,9H6V3H5Z\\"/><rect class=\\"ql-fill\\" height=\\"11\\" width=\\"1\\" x=\\"5\\" y=\\"4\\"/><rect class=\\"ql-fill\\" height=\\"11\\" width=\\"1\\" x=\\"7\\" y=\\"4\\"/></svg>";\nconst formulaIcon = "<svg viewbox=\\"0 0 18 18\\"><path class=\\"ql-fill\\" d=\\"M11.759,2.482a2.561,2.561,0,0,0-3.53.607A7.656,7.656,0,0,0,6.8,6.2C6.109,9.188,5.275,14.677,4.15,14.927a1.545,1.545,0,0,0-1.3-.933A0.922,0.922,0,0,0,2,15.036S1.954,16,4.119,16s3.091-2.691,3.7-5.553c0.177-.826.36-1.726,0.554-2.6L8.775,6.2c0.381-1.421.807-2.521,1.306-2.676a1.014,1.014,0,0,0,1.02.56A0.966,0.966,0,0,0,11.759,2.482Z\\"/><rect class=\\"ql-fill\\" height=\\"1.6\\" rx=\\"0.8\\" ry=\\"0.8\\" width=\\"5\\" x=\\"5.15\\" y=\\"6.2\\"/><path class=\\"ql-fill\\" d=\\"M13.663,12.027a1.662,1.662,0,0,1,.266-0.276q0.193,0.069.456,0.138a2.1,2.1,0,0,0,.535.069,1.075,1.075,0,0,0,.767-0.3,1.044,1.044,0,0,0,.314-0.8,0.84,0.84,0,0,0-.238-0.619,0.8,0.8,0,0,0-.594-0.239,1.154,1.154,0,0,0-.781.3,4.607,4.607,0,0,0-.781,1q-0.091.15-.218,0.346l-0.246.38c-0.068-.288-0.137-0.582-0.212-0.885-0.459-1.847-2.494-.984-2.941-0.8-0.482.2-.353,0.647-0.094,0.529a0.869,0.869,0,0,1,1.281.585c0.217,0.751.377,1.436,0.527,2.038a5.688,5.688,0,0,1-.362.467,2.69,2.69,0,0,1-.264.271q-0.221-.08-0.471-0.147a2.029,2.029,0,0,0-.522-0.066,1.079,1.079,0,0,0-.768.3A1.058,1.058,0,0,0,9,15.131a0.82,0.82,0,0,0,.832.852,1.134,1.134,0,0,0,.787-0.3,5.11,5.11,0,0,0,.776-0.993q0.141-.219.215-0.34c0.046-.076.122-0.194,0.223-0.346a2.786,2.786,0,0,0,.918,1.726,2.582,2.582,0,0,0,2.376-.185c0.317-.181.212-0.565,0-0.494A0.807,0.807,0,0,1,14.176,15a5.159,5.159,0,0,1-.913-2.446l0,0Q13.487,12.24,13.663,12.027Z\\"/></svg>";\nconst headerIcon = "<svg viewBox=\\"0 0 18 18\\"><path class=\\"ql-fill\\" d=\\"M10,4V14a1,1,0,0,1-2,0V10H3v4a1,1,0,0,1-2,0V4A1,1,0,0,1,3,4V8H8V4a1,1,0,0,1,2,0Zm6.06787,9.209H14.98975V7.59863a.54085.54085,0,0,0-.605-.60547h-.62744a1.01119,1.01119,0,0,0-.748.29688L11.645,8.56641a.5435.5435,0,0,0-.022.8584l.28613.30762a.53861.53861,0,0,0,.84717.0332l.09912-.08789a1.2137,1.2137,0,0,0,.2417-.35254h.02246s-.01123.30859-.01123.60547V13.209H12.041a.54085.54085,0,0,0-.605.60547v.43945a.54085.54085,0,0,0,.605.60547h4.02686a.54085.54085,0,0,0,.605-.60547v-.43945A.54085.54085,0,0,0,16.06787,13.209Z\\"/></svg>";\nconst header2Icon = "<svg viewBox=\\"0 0 18 18\\"><path class=\\"ql-fill\\" d=\\"M16.73975,13.81445v.43945a.54085.54085,0,0,1-.605.60547H11.855a.58392.58392,0,0,1-.64893-.60547V14.0127c0-2.90527,3.39941-3.42187,3.39941-4.55469a.77675.77675,0,0,0-.84717-.78125,1.17684,1.17684,0,0,0-.83594.38477c-.2749.26367-.561.374-.85791.13184l-.4292-.34082c-.30811-.24219-.38525-.51758-.1543-.81445a2.97155,2.97155,0,0,1,2.45361-1.17676,2.45393,2.45393,0,0,1,2.68408,2.40918c0,2.45312-3.1792,2.92676-3.27832,3.93848h2.79443A.54085.54085,0,0,1,16.73975,13.81445ZM9,3A.99974.99974,0,0,0,8,4V8H3V4A1,1,0,0,0,1,4V14a1,1,0,0,0,2,0V10H8v4a1,1,0,0,0,2,0V4A.99974.99974,0,0,0,9,3Z\\"/></svg>";\nconst header3Icon = "<svg viewBox=\\"0 0 18 18\\"><path class=\\"ql-fill\\" d=\\"M16.65186,12.30664a2.6742,2.6742,0,0,1-2.915,2.68457,3.96592,3.96592,0,0,1-2.25537-.6709.56007.56007,0,0,1-.13232-.83594L11.64648,13c.209-.34082.48389-.36328.82471-.1543a2.32654,2.32654,0,0,0,1.12256.33008c.71484,0,1.12207-.35156,1.12207-.78125,0-.61523-.61621-.86816-1.46338-.86816H13.2085a.65159.65159,0,0,1-.68213-.41895l-.05518-.10937a.67114.67114,0,0,1,.14307-.78125l.71533-.86914a8.55289,8.55289,0,0,1,.68213-.7373V8.58887a3.93913,3.93913,0,0,1-.748.05469H11.9873a.54085.54085,0,0,1-.605-.60547V7.59863a.54085.54085,0,0,1,.605-.60547h3.75146a.53773.53773,0,0,1,.60547.59375v.17676a1.03723,1.03723,0,0,1-.27539.748L14.74854,10.0293A2.31132,2.31132,0,0,1,16.65186,12.30664ZM9,3A.99974.99974,0,0,0,8,4V8H3V4A1,1,0,0,0,1,4V14a1,1,0,0,0,2,0V10H8v4a1,1,0,0,0,2,0V4A.99974.99974,0,0,0,9,3Z\\"/></svg>";\nconst header4Icon = "<svg viewBox=\\"0 0 18 18\\"><path class=\\"ql-fill\\" d=\\"M10,4V14a1,1,0,0,1-2,0V10H3v4a1,1,0,0,1-2,0V4A1,1,0,0,1,3,4V8H8V4a1,1,0,0,1,2,0Zm7.05371,7.96582v.38477c0,.39648-.165.60547-.46191.60547h-.47314v1.29785a.54085.54085,0,0,1-.605.60547h-.69336a.54085.54085,0,0,1-.605-.60547V12.95605H11.333a.5412.5412,0,0,1-.60547-.60547v-.15332a1.199,1.199,0,0,1,.22021-.748l2.56348-4.05957a.7819.7819,0,0,1,.72607-.39648h1.27637a.54085.54085,0,0,1,.605.60547v3.7627h.33008A.54055.54055,0,0,1,17.05371,11.96582ZM14.28125,8.7207h-.022a4.18969,4.18969,0,0,1-.38525.81348l-1.188,1.80469v.02246h1.5293V9.60059A7.04058,7.04058,0,0,1,14.28125,8.7207Z\\"/></svg>";\nconst header5Icon = "<svg viewBox=\\"0 0 18 18\\"><path class=\\"ql-fill\\" d=\\"M16.74023,12.18555a2.75131,2.75131,0,0,1-2.91553,2.80566,3.908,3.908,0,0,1-2.25537-.68164.54809.54809,0,0,1-.13184-.8252L11.73438,13c.209-.34082.48389-.36328.8252-.1543a2.23757,2.23757,0,0,0,1.1001.33008,1.01827,1.01827,0,0,0,1.1001-.96777c0-.61621-.53906-.97949-1.25439-.97949a2.15554,2.15554,0,0,0-.64893.09961,1.15209,1.15209,0,0,1-.814.01074l-.12109-.04395a.64116.64116,0,0,1-.45117-.71484l.231-3.00391a.56666.56666,0,0,1,.62744-.583H15.541a.54085.54085,0,0,1,.605.60547v.43945a.54085.54085,0,0,1-.605.60547H13.41748l-.04395.72559a1.29306,1.29306,0,0,1-.04395.30859h.022a2.39776,2.39776,0,0,1,.57227-.07715A2.53266,2.53266,0,0,1,16.74023,12.18555ZM9,3A.99974.99974,0,0,0,8,4V8H3V4A1,1,0,0,0,1,4V14a1,1,0,0,0,2,0V10H8v4a1,1,0,0,0,2,0V4A.99974.99974,0,0,0,9,3Z\\"/></svg>";\nconst header6Icon = "<svg viewBox=\\"0 0 18 18\\"><path class=\\"ql-fill\\" d=\\"M14.51758,9.64453a1.85627,1.85627,0,0,0-1.24316.38477H13.252a1.73532,1.73532,0,0,1,1.72754-1.4082,2.66491,2.66491,0,0,1,.5498.06641c.35254.05469.57227.01074.70508-.40723l.16406-.5166a.53393.53393,0,0,0-.373-.75977,4.83723,4.83723,0,0,0-1.17773-.14258c-2.43164,0-3.7627,2.17773-3.7627,4.43359,0,2.47559,1.60645,3.69629,3.19043,3.69629A2.70585,2.70585,0,0,0,16.96,12.19727,2.43861,2.43861,0,0,0,14.51758,9.64453Zm-.23047,3.58691c-.67187,0-1.22168-.81445-1.22168-1.45215,0-.47363.30762-.583.72559-.583.96875,0,1.27734.59375,1.27734,1.12207A.82182.82182,0,0,1,14.28711,13.23145ZM10,4V14a1,1,0,0,1-2,0V10H3v4a1,1,0,0,1-2,0V4A1,1,0,0,1,3,4V8H8V4a1,1,0,0,1,2,0Z\\"/></svg>";\nconst italicIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"7\\" x2=\\"13\\" y1=\\"4\\" y2=\\"4\\"/><line class=\\"ql-stroke\\" x1=\\"5\\" x2=\\"11\\" y1=\\"14\\" y2=\\"14\\"/><line class=\\"ql-stroke\\" x1=\\"8\\" x2=\\"10\\" y1=\\"14\\" y2=\\"4\\"/></svg>";\nconst imageIcon = "<svg viewbox=\\"0 0 18 18\\"><rect class=\\"ql-stroke\\" height=\\"10\\" width=\\"12\\" x=\\"3\\" y=\\"4\\"/><circle class=\\"ql-fill\\" cx=\\"6\\" cy=\\"7\\" r=\\"1\\"/><polyline class=\\"ql-even ql-fill\\" points=\\"5 12 5 11 7 9 8 10 11 7 13 9 13 12 5 12\\"/></svg>";\nconst indentIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"3\\" x2=\\"15\\" y1=\\"14\\" y2=\\"14\\"/><line class=\\"ql-stroke\\" x1=\\"3\\" x2=\\"15\\" y1=\\"4\\" y2=\\"4\\"/><line class=\\"ql-stroke\\" x1=\\"9\\" x2=\\"15\\" y1=\\"9\\" y2=\\"9\\"/><polyline class=\\"ql-fill ql-stroke\\" points=\\"3 7 3 11 5 9 3 7\\"/></svg>";\nconst outdentIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"3\\" x2=\\"15\\" y1=\\"14\\" y2=\\"14\\"/><line class=\\"ql-stroke\\" x1=\\"3\\" x2=\\"15\\" y1=\\"4\\" y2=\\"4\\"/><line class=\\"ql-stroke\\" x1=\\"9\\" x2=\\"15\\" y1=\\"9\\" y2=\\"9\\"/><polyline class=\\"ql-stroke\\" points=\\"5 7 5 11 3 9 5 7\\"/></svg>";\nconst linkIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"7\\" x2=\\"11\\" y1=\\"7\\" y2=\\"11\\"/><path class=\\"ql-even ql-stroke\\" d=\\"M8.9,4.577a3.476,3.476,0,0,1,.36,4.679A3.476,3.476,0,0,1,4.577,8.9C3.185,7.5,2.035,6.4,4.217,4.217S7.5,3.185,8.9,4.577Z\\"/><path class=\\"ql-even ql-stroke\\" d=\\"M13.423,9.1a3.476,3.476,0,0,0-4.679-.36,3.476,3.476,0,0,0,.36,4.679c1.392,1.392,2.5,2.542,4.679.36S14.815,10.5,13.423,9.1Z\\"/></svg>";\nconst listBulletIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"6\\" x2=\\"15\\" y1=\\"4\\" y2=\\"4\\"/><line class=\\"ql-stroke\\" x1=\\"6\\" x2=\\"15\\" y1=\\"9\\" y2=\\"9\\"/><line class=\\"ql-stroke\\" x1=\\"6\\" x2=\\"15\\" y1=\\"14\\" y2=\\"14\\"/><line class=\\"ql-stroke\\" x1=\\"3\\" x2=\\"3\\" y1=\\"4\\" y2=\\"4\\"/><line class=\\"ql-stroke\\" x1=\\"3\\" x2=\\"3\\" y1=\\"9\\" y2=\\"9\\"/><line class=\\"ql-stroke\\" x1=\\"3\\" x2=\\"3\\" y1=\\"14\\" y2=\\"14\\"/></svg>";\nconst listCheckIcon = "<svg class=\\"\\" viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"9\\" x2=\\"15\\" y1=\\"4\\" y2=\\"4\\"/><polyline class=\\"ql-stroke\\" points=\\"3 4 4 5 6 3\\"/><line class=\\"ql-stroke\\" x1=\\"9\\" x2=\\"15\\" y1=\\"14\\" y2=\\"14\\"/><polyline class=\\"ql-stroke\\" points=\\"3 14 4 15 6 13\\"/><line class=\\"ql-stroke\\" x1=\\"9\\" x2=\\"15\\" y1=\\"9\\" y2=\\"9\\"/><polyline class=\\"ql-stroke\\" points=\\"3 9 4 10 6 8\\"/></svg>";\nconst listOrderedIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke\\" x1=\\"7\\" x2=\\"15\\" y1=\\"4\\" y2=\\"4\\"/><line class=\\"ql-stroke\\" x1=\\"7\\" x2=\\"15\\" y1=\\"9\\" y2=\\"9\\"/><line class=\\"ql-stroke\\" x1=\\"7\\" x2=\\"15\\" y1=\\"14\\" y2=\\"14\\"/><line class=\\"ql-stroke ql-thin\\" x1=\\"2.5\\" x2=\\"4.5\\" y1=\\"5.5\\" y2=\\"5.5\\"/><path class=\\"ql-fill\\" d=\\"M3.5,6A0.5,0.5,0,0,1,3,5.5V3.085l-0.276.138A0.5,0.5,0,0,1,2.053,3c-0.124-.247-0.023-0.324.224-0.447l1-.5A0.5,0.5,0,0,1,4,2.5v3A0.5,0.5,0,0,1,3.5,6Z\\"/><path class=\\"ql-stroke ql-thin\\" d=\\"M4.5,10.5h-2c0-.234,1.85-1.076,1.85-2.234A0.959,0.959,0,0,0,2.5,8.156\\"/><path class=\\"ql-stroke ql-thin\\" d=\\"M2.5,14.846a0.959,0.959,0,0,0,1.85-.109A0.7,0.7,0,0,0,3.75,14a0.688,0.688,0,0,0,.6-0.736,0.959,0.959,0,0,0-1.85-.109\\"/></svg>";\nconst subscriptIcon = "<svg viewbox=\\"0 0 18 18\\"><path class=\\"ql-fill\\" d=\\"M15.5,15H13.861a3.858,3.858,0,0,0,1.914-2.975,1.8,1.8,0,0,0-1.6-1.751A1.921,1.921,0,0,0,12.021,11.7a0.50013,0.50013,0,1,0,.957.291h0a0.914,0.914,0,0,1,1.053-.725,0.81,0.81,0,0,1,.744.762c0,1.076-1.16971,1.86982-1.93971,2.43082A1.45639,1.45639,0,0,0,12,15.5a0.5,0.5,0,0,0,.5.5h3A0.5,0.5,0,0,0,15.5,15Z\\"/><path class=\\"ql-fill\\" d=\\"M9.65,5.241a1,1,0,0,0-1.409.108L6,7.964,3.759,5.349A1,1,0,0,0,2.192,6.59178Q2.21541,6.6213,2.241,6.649L4.684,9.5,2.241,12.35A1,1,0,0,0,3.71,13.70722q0.02557-.02768.049-0.05722L6,11.036,8.241,13.65a1,1,0,1,0,1.567-1.24277Q9.78459,12.3777,9.759,12.35L7.316,9.5,9.759,6.651A1,1,0,0,0,9.65,5.241Z\\"/></svg>";\nconst superscriptIcon = "<svg viewbox=\\"0 0 18 18\\"><path class=\\"ql-fill\\" d=\\"M15.5,7H13.861a4.015,4.015,0,0,0,1.914-2.975,1.8,1.8,0,0,0-1.6-1.751A1.922,1.922,0,0,0,12.021,3.7a0.5,0.5,0,1,0,.957.291,0.917,0.917,0,0,1,1.053-.725,0.81,0.81,0,0,1,.744.762c0,1.077-1.164,1.925-1.934,2.486A1.423,1.423,0,0,0,12,7.5a0.5,0.5,0,0,0,.5.5h3A0.5,0.5,0,0,0,15.5,7Z\\"/><path class=\\"ql-fill\\" d=\\"M9.651,5.241a1,1,0,0,0-1.41.108L6,7.964,3.759,5.349a1,1,0,1,0-1.519,1.3L4.683,9.5,2.241,12.35a1,1,0,1,0,1.519,1.3L6,11.036,8.241,13.65a1,1,0,0,0,1.519-1.3L7.317,9.5,9.759,6.651A1,1,0,0,0,9.651,5.241Z\\"/></svg>";\nconst strikeIcon = "<svg viewbox=\\"0 0 18 18\\"><line class=\\"ql-stroke ql-thin\\" x1=\\"15.5\\" x2=\\"2.5\\" y1=\\"8.5\\" y2=\\"9.5\\"/><path class=\\"ql-fill\\" d=\\"M9.007,8C6.542,7.791,6,7.519,6,6.5,6,5.792,7.283,5,9,5c1.571,0,2.765.679,2.969,1.309a1,1,0,0,0,1.9-.617C13.356,4.106,11.354,3,9,3,6.2,3,4,4.538,4,6.5a3.2,3.2,0,0,0,.5,1.843Z\\"/><path class=\\"ql-fill\\" d=\\"M8.984,10C11.457,10.208,12,10.479,12,11.5c0,0.708-1.283,1.5-3,1.5-1.571,0-2.765-.679-2.969-1.309a1,1,0,1,0-1.9.617C4.644,13.894,6.646,15,9,15c2.8,0,5-1.538,5-3.5a3.2,3.2,0,0,0-.5-1.843Z\\"/></svg>";\nconst tableIcon = "<svg viewbox=\\"0 0 18 18\\"><rect class=\\"ql-stroke\\" height=\\"12\\" width=\\"12\\" x=\\"3\\" y=\\"3\\"/><rect class=\\"ql-fill\\" height=\\"2\\" width=\\"3\\" x=\\"5\\" y=\\"5\\"/><rect class=\\"ql-fill\\" height=\\"2\\" width=\\"4\\" x=\\"9\\" y=\\"5\\"/><g class=\\"ql-fill ql-transparent\\"><rect height=\\"2\\" width=\\"3\\" x=\\"5\\" y=\\"8\\"/><rect height=\\"2\\" width=\\"4\\" x=\\"9\\" y=\\"8\\"/><rect height=\\"2\\" width=\\"3\\" x=\\"5\\" y=\\"11\\"/><rect height=\\"2\\" width=\\"4\\" x=\\"9\\" y=\\"11\\"/></g></svg>";\nconst underlineIcon = "<svg viewbox=\\"0 0 18 18\\"><path class=\\"ql-stroke\\" d=\\"M5,3V9a4.012,4.012,0,0,0,4,4H9a4.012,4.012,0,0,0,4-4V3\\"/><rect class=\\"ql-fill\\" height=\\"1\\" rx=\\"0.5\\" ry=\\"0.5\\" width=\\"12\\" x=\\"3\\" y=\\"15\\"/></svg>";\nconst videoIcon = "<svg viewbox=\\"0 0 18 18\\"><rect class=\\"ql-stroke\\" height=\\"12\\" width=\\"12\\" x=\\"3\\" y=\\"3\\"/><rect class=\\"ql-fill\\" height=\\"12\\" width=\\"1\\" x=\\"5\\" y=\\"3\\"/><rect class=\\"ql-fill\\" height=\\"12\\" width=\\"1\\" x=\\"12\\" y=\\"3\\"/><rect class=\\"ql-fill\\" height=\\"2\\" width=\\"8\\" x=\\"5\\" y=\\"8\\"/><rect class=\\"ql-fill\\" height=\\"1\\" width=\\"3\\" x=\\"3\\" y=\\"5\\"/><rect class=\\"ql-fill\\" height=\\"1\\" width=\\"3\\" x=\\"3\\" y=\\"7\\"/><rect class=\\"ql-fill\\" height=\\"1\\" width=\\"3\\" x=\\"3\\" y=\\"10\\"/><rect class=\\"ql-fill\\" height=\\"1\\" width=\\"3\\" x=\\"3\\" y=\\"12\\"/><rect class=\\"ql-fill\\" height=\\"1\\" width=\\"3\\" x=\\"12\\" y=\\"5\\"/><rect class=\\"ql-fill\\" height=\\"1\\" width=\\"3\\" x=\\"12\\" y=\\"7\\"/><rect class=\\"ql-fill\\" height=\\"1\\" width=\\"3\\" x=\\"12\\" y=\\"10\\"/><rect class=\\"ql-fill\\" height=\\"1\\" width=\\"3\\" x=\\"12\\" y=\\"12\\"/></svg>";\n/* harmony default export */ __webpack_exports__["default"] = ({\n  align: {\n    \'\': alignLeftIcon,\n    center: alignCenterIcon,\n    right: alignRightIcon,\n    justify: alignJustifyIcon\n  },\n  background: backgroundIcon,\n  blockquote: blockquoteIcon,\n  bold: boldIcon,\n  clean: cleanIcon,\n  code: codeIcon,\n  \'code-block\': codeIcon,\n  color: colorIcon,\n  direction: {\n    \'\': directionLeftToRightIcon,\n    rtl: directionRightToLeftIcon\n  },\n  formula: formulaIcon,\n  header: {\n    \'1\': headerIcon,\n    \'2\': header2Icon,\n    \'3\': header3Icon,\n    \'4\': header4Icon,\n    \'5\': header5Icon,\n    \'6\': header6Icon\n  },\n  italic: italicIcon,\n  image: imageIcon,\n  indent: {\n    \'+1\': indentIcon,\n    \'-1\': outdentIcon\n  },\n  link: linkIcon,\n  list: {\n    bullet: listBulletIcon,\n    check: listCheckIcon,\n    ordered: listOrderedIcon\n  },\n  script: {\n    sub: subscriptIcon,\n    super: superscriptIcon\n  },\n  strike: strikeIcon,\n  table: tableIcon,\n  underline: underlineIcon,\n  video: videoIcon\n});\n//# sourceMappingURL=icons.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/ui/icons.js?')},"./node_modules/quill/ui/picker.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\nconst DropdownIcon = \"<svg viewbox=\\\"0 0 18 18\\\"><polygon class=\\\"ql-stroke\\\" points=\\\"7 11 9 13 11 11 7 11\\\"/><polygon class=\\\"ql-stroke\\\" points=\\\"7 7 9 5 11 7 7 7\\\"/></svg>\";\nlet optionsCounter = 0;\nfunction toggleAriaAttribute(element, attribute) {\n  element.setAttribute(attribute, `${!(element.getAttribute(attribute) === 'true')}`);\n}\nclass Picker {\n  constructor(select) {\n    this.select = select;\n    this.container = document.createElement('span');\n    this.buildPicker();\n    this.select.style.display = 'none';\n    // @ts-expect-error Fix me later\n    this.select.parentNode.insertBefore(this.container, this.select);\n    this.label.addEventListener('mousedown', () => {\n      this.togglePicker();\n    });\n    this.label.addEventListener('keydown', event => {\n      switch (event.key) {\n        case 'Enter':\n          this.togglePicker();\n          break;\n        case 'Escape':\n          this.escape();\n          event.preventDefault();\n          break;\n        default:\n      }\n    });\n    this.select.addEventListener('change', this.update.bind(this));\n  }\n  togglePicker() {\n    this.container.classList.toggle('ql-expanded');\n    // Toggle aria-expanded and aria-hidden to make the picker accessible\n    toggleAriaAttribute(this.label, 'aria-expanded');\n    // @ts-expect-error\n    toggleAriaAttribute(this.options, 'aria-hidden');\n  }\n  buildItem(option) {\n    const item = document.createElement('span');\n    // @ts-expect-error\n    item.tabIndex = '0';\n    item.setAttribute('role', 'button');\n    item.classList.add('ql-picker-item');\n    const value = option.getAttribute('value');\n    if (value) {\n      item.setAttribute('data-value', value);\n    }\n    if (option.textContent) {\n      item.setAttribute('data-label', option.textContent);\n    }\n    item.addEventListener('click', () => {\n      this.selectItem(item, true);\n    });\n    item.addEventListener('keydown', event => {\n      switch (event.key) {\n        case 'Enter':\n          this.selectItem(item, true);\n          event.preventDefault();\n          break;\n        case 'Escape':\n          this.escape();\n          event.preventDefault();\n          break;\n        default:\n      }\n    });\n    return item;\n  }\n  buildLabel() {\n    const label = document.createElement('span');\n    label.classList.add('ql-picker-label');\n    label.innerHTML = DropdownIcon;\n    // @ts-expect-error\n    label.tabIndex = '0';\n    label.setAttribute('role', 'button');\n    label.setAttribute('aria-expanded', 'false');\n    this.container.appendChild(label);\n    return label;\n  }\n  buildOptions() {\n    const options = document.createElement('span');\n    options.classList.add('ql-picker-options');\n\n    // Don't want screen readers to read this until options are visible\n    options.setAttribute('aria-hidden', 'true');\n    // @ts-expect-error\n    options.tabIndex = '-1';\n\n    // Need a unique id for aria-controls\n    options.id = `ql-picker-options-${optionsCounter}`;\n    optionsCounter += 1;\n    this.label.setAttribute('aria-controls', options.id);\n\n    // @ts-expect-error\n    this.options = options;\n    Array.from(this.select.options).forEach(option => {\n      const item = this.buildItem(option);\n      options.appendChild(item);\n      if (option.selected === true) {\n        this.selectItem(item);\n      }\n    });\n    this.container.appendChild(options);\n  }\n  buildPicker() {\n    Array.from(this.select.attributes).forEach(item => {\n      this.container.setAttribute(item.name, item.value);\n    });\n    this.container.classList.add('ql-picker');\n    this.label = this.buildLabel();\n    this.buildOptions();\n  }\n  escape() {\n    // Close menu and return focus to trigger label\n    this.close();\n    // Need setTimeout for accessibility to ensure that the browser executes\n    // focus on the next process thread and after any DOM content changes\n    setTimeout(() => this.label.focus(), 1);\n  }\n  close() {\n    this.container.classList.remove('ql-expanded');\n    this.label.setAttribute('aria-expanded', 'false');\n    // @ts-expect-error\n    this.options.setAttribute('aria-hidden', 'true');\n  }\n  selectItem(item) {\n    let trigger = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;\n    const selected = this.container.querySelector('.ql-selected');\n    if (item === selected) return;\n    if (selected != null) {\n      selected.classList.remove('ql-selected');\n    }\n    if (item == null) return;\n    item.classList.add('ql-selected');\n    // @ts-expect-error Fix me later\n    this.select.selectedIndex = Array.from(item.parentNode.children).indexOf(item);\n    if (item.hasAttribute('data-value')) {\n      // @ts-expect-error Fix me later\n      this.label.setAttribute('data-value', item.getAttribute('data-value'));\n    } else {\n      this.label.removeAttribute('data-value');\n    }\n    if (item.hasAttribute('data-label')) {\n      // @ts-expect-error Fix me later\n      this.label.setAttribute('data-label', item.getAttribute('data-label'));\n    } else {\n      this.label.removeAttribute('data-label');\n    }\n    if (trigger) {\n      this.select.dispatchEvent(new Event('change'));\n      this.close();\n    }\n  }\n  update() {\n    let option;\n    if (this.select.selectedIndex > -1) {\n      const item =\n      // @ts-expect-error Fix me later\n      this.container.querySelector('.ql-picker-options').children[this.select.selectedIndex];\n      option = this.select.options[this.select.selectedIndex];\n      // @ts-expect-error\n      this.selectItem(item);\n    } else {\n      this.selectItem(null);\n    }\n    const isActive = option != null && option !== this.select.querySelector('option[selected]');\n    this.label.classList.toggle('ql-active', isActive);\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Picker);\n//# sourceMappingURL=picker.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/ui/picker.js?")},"./node_modules/quill/ui/tooltip.js":function(__unused_webpack___webpack_module__,__webpack_exports__,__webpack_require__){"use strict";eval("__webpack_require__.r(__webpack_exports__);\nconst isScrollable = el => {\n  const {\n    overflowY\n  } = getComputedStyle(el, null);\n  return overflowY !== 'visible' && overflowY !== 'clip';\n};\nclass Tooltip {\n  constructor(quill, boundsContainer) {\n    this.quill = quill;\n    this.boundsContainer = boundsContainer || document.body;\n    this.root = quill.addContainer('ql-tooltip');\n    // @ts-expect-error\n    this.root.innerHTML = this.constructor.TEMPLATE;\n    if (isScrollable(this.quill.root)) {\n      this.quill.root.addEventListener('scroll', () => {\n        this.root.style.marginTop = `${-1 * this.quill.root.scrollTop}px`;\n      });\n    }\n    this.hide();\n  }\n  hide() {\n    this.root.classList.add('ql-hidden');\n  }\n  position(reference) {\n    const left = reference.left + reference.width / 2 - this.root.offsetWidth / 2;\n    // root.scrollTop should be 0 if scrollContainer !== root\n    const top = reference.bottom + this.quill.root.scrollTop;\n    this.root.style.left = `${left}px`;\n    this.root.style.top = `${top}px`;\n    this.root.classList.remove('ql-flip');\n    const containerBounds = this.boundsContainer.getBoundingClientRect();\n    const rootBounds = this.root.getBoundingClientRect();\n    let shift = 0;\n    if (rootBounds.right > containerBounds.right) {\n      shift = containerBounds.right - rootBounds.right;\n      this.root.style.left = `${left + shift}px`;\n    }\n    if (rootBounds.left < containerBounds.left) {\n      shift = containerBounds.left - rootBounds.left;\n      this.root.style.left = `${left + shift}px`;\n    }\n    if (rootBounds.bottom > containerBounds.bottom) {\n      const height = rootBounds.bottom - rootBounds.top;\n      const verticalShift = reference.bottom - reference.top + height;\n      this.root.style.top = `${top - verticalShift}px`;\n      this.root.classList.add('ql-flip');\n    }\n    return shift;\n  }\n  show() {\n    this.root.classList.remove('ql-editing');\n    this.root.classList.remove('ql-hidden');\n  }\n}\n/* harmony default export */ __webpack_exports__[\"default\"] = (Tooltip);\n//# sourceMappingURL=tooltip.js.map\n\n//# sourceURL=webpack://Vuexy/./node_modules/quill/ui/tooltip.js?")}},__webpack_module_cache__={};function __webpack_require__(e){var n=__webpack_module_cache__[e];if(void 0!==n)return n.exports;var t=__webpack_module_cache__[e]={id:e,loaded:!1,exports:{}};return __webpack_modules__[e](t,t.exports,__webpack_require__),t.loaded=!0,t.exports}__webpack_require__.d=function(e,n){for(var t in n)__webpack_require__.o(n,t)&&!__webpack_require__.o(e,t)&&Object.defineProperty(e,t,{enumerable:!0,get:n[t]})},__webpack_require__.g=function(){if("object"==typeof globalThis)return globalThis;try{return this||new Function("return this")()}catch(e){if("object"==typeof window)return window}}(),__webpack_require__.o=function(e,n){return Object.prototype.hasOwnProperty.call(e,n)},__webpack_require__.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},__webpack_require__.nmd=function(e){return e.paths=[],e.children||(e.children=[]),e};var __webpack_exports__=__webpack_require__("./libs/quill/quill.js");return __webpack_exports__}()}));